/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.longLine;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.longLine.LongLineInspectionPolicy;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongLineInspection
extends LocalInspectionTool {
    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane(OptPane.settingLink(LangBundle.message("link.label.edit.code.style.settings", new Object[0]), "preferences.sourceCode"));
        if (optPane == null) {
            LongLineInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            LongLineInspection.$$$reportNull$$$0(1);
        }
        PsiFile file2 = holder.getFile();
        final int codeStyleRightMargin = CodeStyle.getSettings((PsiFile)file2).getRightMargin(file2.getLanguage());
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile instanceof VirtualFileWindow) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                LongLineInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        final Document document = FileDocumentManager.getInstance().getDocument(vFile);
        if (document == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                LongLineInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        return new PsiElementVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                int length = element.getTextLength();
                if (element.getTextLength() != 0 && element.getFirstChild() == null && !LongLineInspection.ignoreFor(element)) {
                    int offset2 = element.getTextOffset();
                    int endOffset = offset2 + length;
                    int startLine = document.getLineNumber(offset2);
                    if (offset2 > document.getLineStartOffset(startLine) + codeStyleRightMargin) {
                        ++startLine;
                    }
                    int endLine = document.getLineNumber(endOffset - 1);
                    for (int l = startLine; l <= endLine; ++l) {
                        int highlightingEndOffset;
                        int highlightingStartOffset;
                        int lineMarginOffset;
                        int lineEndOffset = document.getLineEndOffset(l);
                        if (lineEndOffset <= (lineMarginOffset = document.getLineStartOffset(l) + codeStyleRightMargin) || (highlightingStartOffset = lineMarginOffset - offset2) >= (highlightingEndOffset = Math.min(endOffset, lineEndOffset) - offset2)) continue;
                        TextRange exceedingRange = new TextRange(highlightingStartOffset, highlightingEndOffset);
                        holder.registerProblem(element, exceedingRange, LangBundle.message("inspection.message.line.longer.than.allowed.by.code.style.columns", codeStyleRightMargin), new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/longLine/LongLineInspection$1", "visitElement"));
            }
        };
    }

    private static boolean ignoreFor(@Nullable PsiElement element) {
        return element != null && LongLineInspectionPolicy.EP_NAME.getExtensionList().stream().anyMatch(policy -> policy.ignoreLongLineFor(element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/longLine/LongLineInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/longLine/LongLineInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1 -> new IllegalArgumentException(string2);
        };
    }
}

