/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.naming;

import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.codeInspection.naming.NamingConventionWithFallbackBean;
import com.intellij.codeInspection.options.OptCheckboxPanel;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.SyntheticElement;
import com.intellij.serialization.SerializationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNamingConventionInspection<T extends PsiNameIdentifierOwner>
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(AbstractNamingConventionInspection.class);
    private final Map<String, NamingConvention<T>> myNamingConventions = new LinkedHashMap<String, NamingConvention<T>>();
    private final Map<String, NamingConventionBean> myNamingConventionBeans = new LinkedHashMap<String, NamingConventionBean>();
    private final Map<String, Element> myUnloadedElements = new LinkedHashMap<String, Element>();
    private final Set<String> myDisabledShortNames = new HashSet<String>();
    @Nullable
    private final String myDefaultConventionShortName;

    protected AbstractNamingConventionInspection(Iterable<? extends NamingConvention<T>> extensions2, @Nullable String defaultConventionShortName) {
        for (NamingConvention<T> convention : extensions2) {
            this.registerConvention(convention);
        }
        this.myDefaultConventionShortName = defaultConventionShortName;
    }

    protected void registerConvention(NamingConvention<T> convention) {
        String shortName = convention.getShortName();
        NamingConvention<T> oldConvention = this.myNamingConventions.put(shortName, convention);
        if (oldConvention != null) {
            LOG.error("Duplicated short names: " + shortName + " first: " + oldConvention + "; second: " + convention);
        }
        this.myNamingConventionBeans.put(shortName, convention.createDefaultBean());
        if (!convention.isEnabledByDefault()) {
            this.myDisabledShortNames.add(shortName);
        }
    }

    protected void unregisterConvention(@NotNull NamingConvention<T> extension2) {
        String shortName;
        Element element;
        if (extension2 == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(0);
        }
        if ((element = this.writeConvention(shortName = extension2.getShortName(), extension2)) != null) {
            this.myUnloadedElements.put(shortName, element);
        }
        this.myNamingConventionBeans.remove(shortName);
        this.myNamingConventions.remove(shortName);
        this.myDisabledShortNames.remove(shortName);
    }

    protected void registerConventionsListener(@NotNull ExtensionPointName<NamingConvention<T>> epName) {
        if (epName == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(1);
        }
        Disposable disposable = ExtensionPointUtil.createExtensionDisposable(this, LocalInspectionEP.LOCAL_INSPECTION.getPoint(), inspectionEP -> this.getClass().getName().equals(inspectionEP.implementationClass));
        epName.addExtensionPointListener(new ExtensionPointListener<NamingConvention<T>>(){

            @Override
            public void extensionAdded(@NotNull NamingConvention<T> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                AbstractNamingConventionInspection.this.registerConvention(extension2);
            }

            @Override
            public void extensionRemoved(@NotNull NamingConvention<T> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                AbstractNamingConventionInspection.this.unregisterConvention(extension2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/naming/AbstractNamingConventionInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
    }

    @Nullable
    protected abstract LocalQuickFix createRenameFix();

    private void initDisabledState() {
        this.myDisabledShortNames.clear();
        for (NamingConvention<T> convention : this.myNamingConventions.values()) {
            if (convention.isEnabledByDefault()) continue;
            this.myDisabledShortNames.add(convention.getShortName());
        }
    }

    public NamingConventionBean getNamingConventionBean(String shortName) {
        return this.myNamingConventionBeans.get(shortName);
    }

    public Set<String> getOldToolNames() {
        return this.myNamingConventions.keySet();
    }

    @NotNull
    @InspectionMessage
    protected String createErrorMessage(String name, String shortName) {
        String string2 = this.myNamingConventions.get(shortName).createErrorMessage(name, this.myNamingConventionBeans.get(shortName));
        if (string2 == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    public void readSettings(@NotNull Element node2) {
        if (node2 == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(3);
        }
        this.initDisabledState();
        for (Element extension2 : node2.getChildren("extension")) {
            String shortName = extension2.getAttributeValue("name");
            if (shortName == null) continue;
            NamingConventionBean conventionBean = this.myNamingConventionBeans.get(shortName);
            if (conventionBean == null) {
                this.myUnloadedElements.put(shortName, extension2);
                continue;
            }
            try {
                XmlSerializer.deserializeInto(conventionBean, extension2);
                conventionBean.initPattern();
            }
            catch (SerializationException e) {
                throw new InvalidDataException(e);
            }
            if (Boolean.parseBoolean(extension2.getAttributeValue("enabled"))) {
                this.myDisabledShortNames.remove(shortName);
                continue;
            }
            this.myDisabledShortNames.add(shortName);
        }
    }

    @Override
    public void writeSettings(@NotNull Element node2) {
        if (node2 == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(4);
        }
        TreeSet<String> shortNames = new TreeSet<String>(this.myNamingConventions.keySet());
        shortNames.addAll(this.myUnloadedElements.keySet());
        for (String shortName : shortNames) {
            Element element;
            NamingConvention<T> convention = this.myNamingConventions.get(shortName);
            if (convention == null) {
                element = this.myUnloadedElements.get(shortName);
                if (element == null) continue;
                node2.addContent(element.clone());
                continue;
            }
            element = this.writeConvention(shortName, convention);
            if (element == null) continue;
            node2.addContent(element);
        }
    }

    private Element writeConvention(String shortName, NamingConvention<T> convention) {
        boolean disabled = this.myDisabledShortNames.contains(shortName);
        Element element = new Element("extension").setAttribute("name", shortName).setAttribute("enabled", disabled ? "false" : "true");
        NamingConventionBean conventionBean = this.myNamingConventionBeans.get(shortName);
        if (!convention.createDefaultBean().equals(conventionBean)) {
            XmlSerializer.serializeInto(conventionBean, element);
        } else if (disabled != convention.isEnabledByDefault()) {
            return null;
        }
        return element;
    }

    public boolean isConventionEnabled(String shortName) {
        return !this.myDisabledShortNames.contains(shortName);
    }

    protected void checkName(@NotNull T member, @NotNull String name, @NotNull ProblemsHolder holder) {
        if (member == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(5);
        }
        if (name == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(7);
        }
        if (member instanceof SyntheticElement) {
            return;
        }
        this.checkName(member, shortName -> {
            LocalQuickFix[] fixes;
            if (holder.isOnTheFly()) {
                LocalQuickFix[] localQuickFixArray;
                LocalQuickFix fix2 = this.createRenameFix();
                if (fix2 != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = fix2;
                } else {
                    localQuickFixArray = null;
                }
                fixes = localQuickFixArray;
            } else {
                fixes = null;
            }
            PsiElement element = ObjectUtils.notNull(member.getNameIdentifier(), member);
            if (!element.isPhysical()) {
                element = element.getNavigationElement();
            }
            holder.registerProblem(element, this.createErrorMessage(name, (String)shortName), fixes);
        });
    }

    protected void checkName(@NotNull T member, @NotNull Consumer<? super String> errorRegister) {
        if (member == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(8);
        }
        if (errorRegister == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(9);
        }
        for (NamingConvention<T> namingConvention : this.myNamingConventions.values()) {
            if (!namingConvention.isApplicable(member)) continue;
            String shortName = namingConvention.getShortName();
            if (this.myDisabledShortNames.contains(shortName)) break;
            NamingConventionBean activeBean = this.myNamingConventionBeans.get(shortName);
            if (activeBean instanceof NamingConventionWithFallbackBean && ((NamingConventionWithFallbackBean)activeBean).isInheritDefaultSettings()) {
                LOG.assertTrue(this.myDefaultConventionShortName != null, activeBean + " expects that default conversion is configured");
                shortName = this.myDefaultConventionShortName;
                if (this.myDisabledShortNames.contains(shortName)) break;
                activeBean = this.myNamingConventionBeans.get(shortName);
                namingConvention = this.myNamingConventions.get(shortName);
            }
            if (namingConvention.isValid(member, activeBean)) break;
            errorRegister.accept(shortName);
            break;
        }
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        ArrayList<NamingConvention<T>> values2 = new ArrayList<NamingConvention<T>>(this.myNamingConventions.values());
        Collections.reverse(values2);
        OptPane optPane = OptPane.pane(new OptCheckboxPanel(ContainerUtil.map(values2, convention -> {
            String shortName = convention.getShortName();
            NamingConventionBean bean = this.myNamingConventionBeans.get(shortName);
            return bean.getOptionsPane().prefix(shortName).asCheckbox(shortName, convention.getElementDescription());
        })));
        if (optPane == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(10);
        }
        return optPane;
    }

    @Override
    @NotNull
    public OptionController getOptionController() {
        OptionController controller = OptionController.of(shortName -> !this.myDisabledShortNames.contains(shortName), (shortName, value) -> this.setEnabled((Boolean)value, (String)shortName));
        for (Map.Entry<String, NamingConventionBean> entry : this.myNamingConventionBeans.entrySet()) {
            controller = controller.onPrefix(entry.getKey(), entry.getValue().getOptionController());
        }
        OptionController optionController = controller;
        if (optionController == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(11);
        }
        return optionController;
    }

    public void setEnabled(boolean value, String conventionShortName) {
        if (value) {
            this.myDisabledShortNames.remove(conventionShortName);
        } else {
            this.myDisabledShortNames.add(conventionShortName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/naming/AbstractNamingConventionInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorRegister";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/naming/AbstractNamingConventionInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unregisterConvention";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerConventionsListener";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 10, 11 -> new IllegalStateException(string2);
        };
    }
}

