/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.naming;

import com.intellij.codeInspection.options.CommonOptionPanes;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NamingConventionBean {
    public String m_regex;
    public int m_minLength;
    public int m_maxLength;
    private final Set<String> myPredefinedNames = new HashSet<String>();
    protected Pattern m_regexPattern;

    public NamingConventionBean(@NonNls @RegExp String regex, int minLength, int maxLength, String ... predefinedNames2Ignore) {
        this.m_regex = regex;
        this.m_minLength = minLength;
        this.m_maxLength = maxLength;
        this.myPredefinedNames.addAll(Arrays.asList(predefinedNames2Ignore));
        this.initPattern();
    }

    public boolean isValid(String name) {
        int length = name.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (this.m_maxLength > 0 && length > this.m_maxLength) {
            return false;
        }
        if (this.myPredefinedNames.contains(name)) {
            return true;
        }
        Matcher matcher = this.m_regexPattern.matcher(name);
        return matcher.matches();
    }

    public void initPattern() {
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = CommonOptionPanes.conventions("m_minLength", "m_maxLength", "m_regex", new OptRegularComponent[0]);
        if (optPane == null) {
            NamingConventionBean.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = OptionController.fieldsOf(this).onValue("m_regex", () -> this.m_regex, val -> {
            this.m_regex = val;
            try {
                this.initPattern();
            }
            catch (PatternSyntaxException ex) {
                this.m_regex = this.m_regexPattern != null ? this.m_regexPattern.pattern() : "";
            }
        });
        if (optionController == null) {
            NamingConventionBean.$$$reportNull$$$0(1);
        }
        return optionController;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamingConventionBean bean = (NamingConventionBean)o;
        return this.m_minLength == bean.m_minLength && this.m_maxLength == bean.m_maxLength && Objects.equals(this.m_regex, bean.m_regex);
    }

    public int hashCode() {
        return Objects.hash(this.m_regex, this.m_minLength, this.m_maxLength);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/naming/NamingConventionBean";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

