/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.options;

import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptCheckboxPanel;
import com.intellij.codeInspection.options.OptComponent;
import com.intellij.codeInspection.options.OptControl;
import com.intellij.codeInspection.options.OptDropdown;
import com.intellij.codeInspection.options.OptGroup;
import com.intellij.codeInspection.options.OptHorizontalStack;
import com.intellij.codeInspection.options.OptNumber;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptSeparator;
import com.intellij.codeInspection.options.OptSettingLink;
import com.intellij.codeInspection.options.OptString;
import com.intellij.codeInspection.options.OptStringList;
import com.intellij.codeInspection.options.OptTab;
import com.intellij.codeInspection.options.OptTabSet;
import com.intellij.codeInspection.options.OptTable;
import com.intellij.codeInspection.options.OptTableColumn;
import com.intellij.codeInspection.options.PlainMessage;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record OptPane(@NotNull @NotNull List<@NotNull OptRegularComponent> components) {
    @NotNull
    private final @NotNull List<@NotNull OptRegularComponent> components;
    public static final OptPane EMPTY = new OptPane(List.of());

    public OptPane(@NotNull List<OptRegularComponent> components) {
        if (components == null) {
            OptPane.$$$reportNull$$$0(0);
        }
        HashSet ids = new HashSet();
        OptPane.traverse(components, comp -> {
            OptControl ctl;
            if (comp instanceof OptControl && !ids.add((ctl = (OptControl)comp).bindId())) {
                throw new IllegalArgumentException("Repeating control identifier inside the pane: " + ctl.bindId());
            }
            return true;
        });
    }

    @Nullable
    public OptControl findControl(final @NotNull String bindId) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(1);
        }
        var processor = new Predicate<OptComponent>(){
            OptControl found = null;

            @Override
            public boolean test(OptComponent cmp) {
                OptControl ctl;
                if (cmp instanceof OptControl && (ctl = (OptControl)cmp).bindId().equals(bindId)) {
                    this.found = ctl;
                    return false;
                }
                return true;
            }
        };
        OptPane.traverse(this.components, processor);
        return processor.found;
    }

    private static boolean traverse(@NotNull @NotNull List<? extends @NotNull OptComponent> components, @NotNull @NotNull Predicate<@NotNull OptComponent> processor) {
        if (components == null) {
            OptPane.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            OptPane.$$$reportNull$$$0(3);
        }
        for (OptComponent optComponent : components) {
            if (processor.test(optComponent) && OptPane.traverse(optComponent.children(), processor)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public OptTab asTab(@NotNull @NlsContexts.TabTitle String label2) {
        if (label2 == null) {
            OptPane.$$$reportNull$$$0(4);
        }
        return new OptTab(new PlainMessage(label2), this.components());
    }

    @Contract(pure=true)
    @NotNull
    public OptCheckbox asCheckbox(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull @NlsContexts.Label String label2) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(5);
        }
        if (label2 == null) {
            OptPane.$$$reportNull$$$0(6);
        }
        return new OptCheckbox(bindId, new PlainMessage(label2), this.components(), null);
    }

    @Contract(pure=true)
    @NotNull
    public OptPane prefix(@NotNull String bindPrefix) {
        if (bindPrefix == null) {
            OptPane.$$$reportNull$$$0(7);
        }
        return new OptPane(ContainerUtil.map(this.components(), c2 -> c2.prefix(bindPrefix)));
    }

    @Contract(pure=true)
    @NotNull
    public OptPane prepend(OptRegularComponent ... components) {
        if (components == null) {
            OptPane.$$$reportNull$$$0(8);
        }
        ArrayList<OptRegularComponent> newComponents = new ArrayList<OptRegularComponent>(Arrays.asList(components));
        newComponents.addAll(this.components());
        return new OptPane(newComponents);
    }

    @Contract(pure=true)
    @NotNull
    public OptPane append(OptRegularComponent ... components) {
        if (components == null) {
            OptPane.$$$reportNull$$$0(9);
        }
        ArrayList<OptRegularComponent> newComponents = new ArrayList<OptRegularComponent>(this.components());
        ContainerUtil.addAll(newComponents, components);
        return new OptPane(newComponents);
    }

    @Contract(pure=true)
    @NotNull
    public static OptPane pane(OptRegularComponent ... components) {
        if (components == null) {
            OptPane.$$$reportNull$$$0(10);
        }
        return new OptPane(List.of(components));
    }

    @Contract(pure=true)
    @NotNull
    public static OptCheckbox checkbox(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull @NlsContexts.Label String label2, OptRegularComponent ... children2) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(11);
        }
        if (label2 == null) {
            OptPane.$$$reportNull$$$0(12);
        }
        if (children2 == null) {
            OptPane.$$$reportNull$$$0(13);
        }
        return new OptCheckbox(bindId, new PlainMessage(label2), List.of(children2), null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptCheckboxPanel checkboxPanel(OptCheckbox ... checkboxes) {
        if (checkboxes == null) {
            OptPane.$$$reportNull$$$0(14);
        }
        return new OptCheckboxPanel(List.of(checkboxes));
    }

    @Contract(pure=true)
    @NotNull
    public static OptNumber number(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull @NlsContexts.Label String splitLabel, int minValue, int maxValue) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(15);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(16);
        }
        return new OptNumber(bindId, new PlainMessage(splitLabel), minValue, maxValue, null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptString string(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull @NlsContexts.Label String splitLabel) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(17);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(18);
        }
        return new OptString(bindId, new PlainMessage(splitLabel), null, -1, null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptString string(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull @NlsContexts.Label String splitLabel, int width) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(19);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(20);
        }
        return new OptString(bindId, new PlainMessage(splitLabel), null, width, null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptString string(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull @NlsContexts.Label String splitLabel, @NotNull StringValidator validator2) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(21);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(22);
        }
        if (validator2 == null) {
            OptPane.$$$reportNull$$$0(23);
        }
        return new OptString(bindId, new PlainMessage(splitLabel), validator2, -1, null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptString string(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull @NlsContexts.Label String splitLabel, int width, @NotNull StringValidator validator2) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(24);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(25);
        }
        if (validator2 == null) {
            OptPane.$$$reportNull$$$0(26);
        }
        return new OptString(bindId, new PlainMessage(splitLabel), validator2, width, null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptDropdown dropdown(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull @NlsContexts.Label String splitLabel, OptDropdown.Option ... options2) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(27);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(28);
        }
        if (options2 == null) {
            OptPane.$$$reportNull$$$0(29);
        }
        return new OptDropdown(bindId, new PlainMessage(splitLabel), List.of(options2));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> OptDropdown dropdown(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull @NlsContexts.Label String splitLabel, @NotNull Collection<T> values2, @NotNull @NotNull Function<? super T, @NotNull @NonNls String> keyExtractor, @NotNull @NotNull Function<? super T, @NotNull @Nls String> presentableTextExtractor) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(30);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(31);
        }
        if (values2 == null) {
            OptPane.$$$reportNull$$$0(32);
        }
        if (keyExtractor == null) {
            OptPane.$$$reportNull$$$0(33);
        }
        if (presentableTextExtractor == null) {
            OptPane.$$$reportNull$$$0(34);
        }
        return new OptDropdown(bindId, new PlainMessage(splitLabel), ContainerUtil.map(values2, c2 -> OptPane.option((String)keyExtractor.apply(c2), (String)presentableTextExtractor.apply(c2))));
    }

    @Contract(pure=true)
    @NotNull
    public static <T extends Enum<T>> OptDropdown dropdown(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull @NlsContexts.Label String splitLabel, @NotNull Class<T> enumClass, @NotNull @NotNull Function<@NotNull T, @NotNull @Nls String> presentableTextExtractor) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(35);
        }
        if (splitLabel == null) {
            OptPane.$$$reportNull$$$0(36);
        }
        if (enumClass == null) {
            OptPane.$$$reportNull$$$0(37);
        }
        if (presentableTextExtractor == null) {
            OptPane.$$$reportNull$$$0(38);
        }
        return new OptDropdown(bindId, new PlainMessage(splitLabel), ContainerUtil.map((Enum[])enumClass.getEnumConstants(), c2 -> OptPane.option(c2, (String)presentableTextExtractor.apply(c2))));
    }

    @Contract(pure=true)
    @NotNull
    public static OptDropdown.Option option(@NotNull String key, @NotNull @Nls String label2) {
        if (key == null) {
            OptPane.$$$reportNull$$$0(39);
        }
        if (label2 == null) {
            OptPane.$$$reportNull$$$0(40);
        }
        return new OptDropdown.Option(key, new PlainMessage(label2));
    }

    @Contract(pure=true)
    @NotNull
    public static OptDropdown.Option option(@NotNull Enum<?> key, @NotNull @Nls String label2) {
        if (key == null) {
            OptPane.$$$reportNull$$$0(41);
        }
        if (label2 == null) {
            OptPane.$$$reportNull$$$0(42);
        }
        return new OptDropdown.Option(key.name(), new PlainMessage(label2));
    }

    @Contract(pure=true)
    @NotNull
    public static OptStringList stringList(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull @NlsContexts.Label String label2) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(43);
        }
        if (label2 == null) {
            OptPane.$$$reportNull$$$0(44);
        }
        return new OptStringList(bindId, new PlainMessage(label2), null, null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptStringList stringList(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull @NlsContexts.Label String label2, @NotNull StringValidator validator2) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(45);
        }
        if (label2 == null) {
            OptPane.$$$reportNull$$$0(46);
        }
        if (validator2 == null) {
            OptPane.$$$reportNull$$$0(47);
        }
        return new OptStringList(bindId, new PlainMessage(label2), validator2, null);
    }

    @NotNull
    public static OptTable table(@NotNull @NlsContexts.Label String label2, OptTableColumn ... columns2) {
        if (label2 == null) {
            OptPane.$$$reportNull$$$0(48);
        }
        if (columns2 == null) {
            OptPane.$$$reportNull$$$0(49);
        }
        return new OptTable(new PlainMessage(label2), List.of(columns2), null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptTableColumn column(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull @NlsContexts.ColumnName String name) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(50);
        }
        if (name == null) {
            OptPane.$$$reportNull$$$0(51);
        }
        return new OptTableColumn(bindId, new PlainMessage(name), null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptTableColumn column(@Language(value="jvm-field-name") @NotNull String bindId, @NotNull @NlsContexts.ColumnName String name, @NotNull StringValidator validator2) {
        if (bindId == null) {
            OptPane.$$$reportNull$$$0(52);
        }
        if (name == null) {
            OptPane.$$$reportNull$$$0(53);
        }
        if (validator2 == null) {
            OptPane.$$$reportNull$$$0(54);
        }
        return new OptTableColumn(bindId, new PlainMessage(name), validator2);
    }

    @Contract(pure=true)
    @NotNull
    public static OptGroup group(@NotNull @NlsContexts.Label String label2, OptRegularComponent ... children2) {
        if (label2 == null) {
            OptPane.$$$reportNull$$$0(55);
        }
        if (children2 == null) {
            OptPane.$$$reportNull$$$0(56);
        }
        return new OptGroup(new PlainMessage(label2), List.of(children2));
    }

    @Contract(pure=true)
    @NotNull
    public static OptHorizontalStack horizontalStack(OptRegularComponent ... children2) {
        if (children2 == null) {
            OptPane.$$$reportNull$$$0(57);
        }
        return new OptHorizontalStack(List.of(children2));
    }

    @Contract(pure=true)
    @NotNull
    public static OptSeparator separator() {
        return new OptSeparator(null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptSeparator separator(@NotNull @NlsContexts.Label String label2) {
        if (label2 == null) {
            OptPane.$$$reportNull$$$0(58);
        }
        return new OptSeparator(new PlainMessage(label2));
    }

    @Contract(pure=true)
    @NotNull
    public static OptTabSet tabs(OptTab ... tabs) {
        if (tabs == null) {
            OptPane.$$$reportNull$$$0(59);
        }
        return new OptTabSet(List.of(tabs));
    }

    @Contract(pure=true)
    @NotNull
    public static OptTab tab(@NotNull @NlsContexts.TabTitle String label2, OptRegularComponent ... children2) {
        if (label2 == null) {
            OptPane.$$$reportNull$$$0(60);
        }
        if (children2 == null) {
            OptPane.$$$reportNull$$$0(61);
        }
        return new OptTab(new PlainMessage(label2), List.of(children2));
    }

    @Contract(pure=true)
    @NotNull
    public static OptSettingLink settingLink(@NotNull @NlsContexts.Label String displayName, @NotNull @NonNls String configurableID) {
        if (displayName == null) {
            OptPane.$$$reportNull$$$0(62);
        }
        if (configurableID == null) {
            OptPane.$$$reportNull$$$0(63);
        }
        return new OptSettingLink(new PlainMessage(displayName), configurableID, null);
    }

    @Contract(pure=true)
    @NotNull
    public static OptSettingLink settingLink(@NotNull @NlsContexts.Label String displayName, @NotNull @NonNls String configurableID, @NotNull @Nls String controlLabel) {
        if (displayName == null) {
            OptPane.$$$reportNull$$$0(64);
        }
        if (configurableID == null) {
            OptPane.$$$reportNull$$$0(65);
        }
        if (controlLabel == null) {
            OptPane.$$$reportNull$$$0(66);
        }
        return new OptSettingLink(new PlainMessage(displayName), configurableID, controlLabel);
    }

    @NotNull
    public @NotNull List<@NotNull OptRegularComponent> components() {
        List<OptRegularComponent> list2 = this.components;
        if (list2 == null) {
            OptPane.$$$reportNull$$$0(67);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 67 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 35: 
            case 43: 
            case 45: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 55: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindPrefix";
                break;
            }
            case 13: 
            case 56: 
            case 57: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkboxes";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitLabel";
                break;
            }
            case 23: 
            case 26: 
            case 47: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyExtractor";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableTextExtractor";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumClass";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabs";
                break;
            }
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableID";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlLabel";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/options/OptPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/options/OptPane";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "components";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findControl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "asTab";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "asCheckbox";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prefix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "pane";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkbox";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkboxPanel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "number";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "string";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "dropdown";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "option";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "stringList";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "table";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "column";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "horizontalStack";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "separator";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "tabs";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "tab";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "settingLink";
                break;
            }
            case 67: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 67 -> new IllegalStateException(string2);
        };
    }
}

