/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefEntityImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefElementImpl
extends RefEntityImpl
implements RefElement,
WritableRefElement {
    protected static final Logger LOG = Logger.getInstance(RefElement.class);
    private static final int IS_DELETED_MASK = 16;
    private static final int IS_INITIALIZED_MASK = 32;
    private static final int IS_REACHABLE_MASK = 64;
    private static final int IS_ENTRY_MASK = 128;
    private static final int IS_PERMANENT_ENTRY_MASK = 256;
    private static final int REFERENCES_BUILT_MASK = 512;
    private final SmartPsiElementPointer<?> myID;
    private List<RefElement> myOutReferences;
    private List<RefElement> myInReferences;
    private String[] mySuppressions;

    protected RefElementImpl(@NotNull String name, @NotNull RefElement owner) {
        if (name == null) {
            RefElementImpl.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            RefElementImpl.$$$reportNull$$$0(1);
        }
        super(name, owner.getRefManager());
        this.myID = null;
    }

    protected RefElementImpl(PsiFile file2, RefManager manager) {
        this(file2.getName(), file2, manager);
    }

    protected RefElementImpl(@NotNull String name, @NotNull PsiElement element, @NotNull RefManager manager) {
        if (name == null) {
            RefElementImpl.$$$reportNull$$$0(2);
        }
        if (element == null) {
            RefElementImpl.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            RefElementImpl.$$$reportNull$$$0(4);
        }
        super(name, manager);
        this.myID = SmartPointerManager.getInstance(manager.getProject()).createSmartPsiElementPointer(element);
    }

    protected boolean isDeleted() {
        return this.checkFlag(16L);
    }

    @Override
    public boolean isValid() {
        if (this.isDeleted()) {
            return false;
        }
        return ReadAction.compute(() -> {
            if (this.getRefManager().getProject().isDisposed()) {
                return false;
            }
            PsiFile file2 = this.myID.getContainingFile();
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return file2 != null && file2.isPhysical();
            }
            PsiElement element = this.getPsiElement();
            return element != null && element.isPhysical();
        });
    }

    @Override
    @Nullable
    public Icon getIcon(boolean expanded) {
        PsiElement element = this.getPsiElement();
        if (element != null && element.isValid()) {
            return element.getIcon(3);
        }
        return null;
    }

    @Override
    public RefModule getModule() {
        WritableRefEntity owner = this.getOwner();
        return owner instanceof RefElement ? ((RefElement)((Object)owner)).getModule() : null;
    }

    @Override
    public String getExternalName() {
        return this.getName();
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return this.myID.getElement();
    }

    @Nullable
    public PsiFile getContainingFile() {
        return this.myID.getContainingFile();
    }

    public VirtualFile getVirtualFile() {
        return this.myID.getVirtualFile();
    }

    @Override
    public SmartPsiElementPointer<?> getPointer() {
        return this.myID;
    }

    @Override
    @NotNull
    public synchronized List<RefEntity> getChildren() {
        LOG.assertTrue(this.isInitialized());
        List<RefEntity> list2 = super.getChildren();
        if (list2 == null) {
            RefElementImpl.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Override
    public boolean isReachable() {
        return this.checkFlag(64L);
    }

    public void setReachable(boolean reachable) {
        this.setFlag(reachable, 64L);
    }

    @Override
    public synchronized boolean isReferenced() {
        return this.myInReferences != null;
    }

    public boolean hasSuspiciousCallers() {
        for (RefElement refCaller : this.getInReferences()) {
            if (!((RefElementImpl)refCaller).isSuspicious()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public synchronized Collection<RefElement> getOutReferences() {
        List<RefElement> list2 = this.myOutReferences == null ? ContainerUtil.emptyList() : Collections.unmodifiableList(this.myOutReferences);
        if (list2 == null) {
            RefElementImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public synchronized Collection<RefElement> getInReferences() {
        List<RefElement> list2 = this.myInReferences == null ? ContainerUtil.emptyList() : Collections.unmodifiableList(this.myInReferences);
        if (list2 == null) {
            RefElementImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    public synchronized void addInReference(RefElement refElement) {
        List<RefElement> inReferences = this.myInReferences;
        if (inReferences == null) {
            this.myInReferences = inReferences = new ArrayList<RefElement>(1);
        }
        if (!inReferences.contains(refElement)) {
            inReferences.add(refElement);
        }
    }

    private synchronized void removeInReference(RefElement refElement) {
        if (this.myInReferences == null) {
            return;
        }
        this.myInReferences.remove(refElement);
        if (this.myInReferences.isEmpty()) {
            this.myInReferences = null;
        }
    }

    @Override
    public synchronized void addOutReference(RefElement refElement) {
        List<RefElement> outReferences = this.myOutReferences;
        if (outReferences == null) {
            this.myOutReferences = outReferences = new ArrayList<RefElement>(1);
        }
        if (!outReferences.contains(refElement)) {
            outReferences.add(refElement);
        }
    }

    private synchronized void removeOutReference(RefElement refElement) {
        if (this.myOutReferences == null) {
            return;
        }
        this.myOutReferences.remove(refElement);
        if (this.myOutReferences.isEmpty()) {
            this.myOutReferences = null;
        }
    }

    public void setReferencesBuilt(boolean built) {
        this.setFlag(built, 512L);
    }

    @Override
    public boolean areReferencesBuilt() {
        return this.checkFlag(512L);
    }

    public void setEntry(boolean entry) {
        this.setFlag(entry, 128L);
    }

    @Override
    public boolean isEntry() {
        return this.checkFlag(128L);
    }

    @Override
    public boolean isPermanentEntry() {
        return this.checkFlag(256L);
    }

    @Override
    @NotNull
    public RefElement getContainingEntry() {
        RefElementImpl refElementImpl = this;
        if (refElementImpl == null) {
            RefElementImpl.$$$reportNull$$$0(8);
        }
        return refElementImpl;
    }

    public void setPermanentEntry(boolean permanentEntry) {
        this.setFlag(permanentEntry, 256L);
    }

    public boolean isSuspicious() {
        return !this.isReachable();
    }

    public void referenceRemoved() {
        this.setFlag(true, 16L);
        if (this.getOwner() != null) {
            this.getOwner().removeChild(this);
        }
        for (RefElement refCallee : this.getOutReferences()) {
            ((RefElementImpl)refCallee).removeInReference(this);
        }
        for (RefElement refCaller : this.getInReferences()) {
            ((RefElementImpl)refCaller).removeOutReference(this);
        }
    }

    @Nullable
    public String getURL() {
        PsiFileSystemItem containingFile;
        PsiElement element = this.getPsiElement();
        if (element == null || !element.isPhysical()) {
            return null;
        }
        PsiFileSystemItem psiFileSystemItem = containingFile = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = containingFile.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        return virtualFile2.getUrl() + "#" + element.getTextOffset();
    }

    protected abstract void initialize();

    @Override
    public boolean isInitialized() {
        return this.checkFlag(32L);
    }

    public synchronized void setInitialized(boolean initialized) {
        this.setFlag(initialized, 32L);
    }

    @Override
    public final synchronized void initializeIfNeeded() {
        if (this.isInitialized()) {
            return;
        }
        this.initialize();
        this.setInitialized(true);
        this.getRefManager().fireNodeInitialized(this);
    }

    @Override
    public void addSuppression(String text2) {
        this.mySuppressions = text2.split("[, ]");
    }

    public boolean isSuppressed(String ... toolIds) {
        WritableRefEntity entity;
        if (toolIds == null) {
            RefElementImpl.$$$reportNull$$$0(9);
        }
        if (this.mySuppressions != null) {
            for (String suppression : this.mySuppressions) {
                if (ArrayUtil.contains(suppression, toolIds)) {
                    return true;
                }
                if (!suppression.equalsIgnoreCase("ALL")) continue;
                return true;
            }
        }
        return (entity = this.getOwner()) instanceof RefElementImpl && ((RefElementImpl)entity).isSuppressed(toolIds);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefElementImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefElementImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutReferences";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInReferences";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6, 7, 8 -> new IllegalStateException(string2);
        };
    }
}

