/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.offlineViewer.OfflineInspectionRVContentProvider;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionNodeInfo;
import com.intellij.codeInspection.ui.InspectionOptionPaneRenderer;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsViewUtil;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeLoadingProgressAware;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionViewChangeAdapter;
import com.intellij.codeInspection.ui.InspectionViewNavigationPanel;
import com.intellij.codeInspection.ui.InspectionViewSuppressActionHolder;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.ProblemPreviewEditorPresentation;
import com.intellij.codeInspection.ui.QuickFixPreviewPanelFactory;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.RerunAction;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.codeInspection.ui.actions.InspectionResultsExportActionProvider;
import com.intellij.codeInspection.ui.actions.InvokeQuickFixAction;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class InspectionResultsView
extends JPanel
implements Disposable,
DataProvider,
OccurenceNavigator {
    private static final Logger LOG = Logger.getInstance(InspectionResultsView.class);
    public static final DataKey<InspectionResultsView> DATA_KEY = DataKey.create((String)"inspectionView");
    private static final Key<Boolean> PREVIEW_EDITOR_IS_REUSED_KEY = Key.create("inspection.tool.window.preview.editor.is.reused");
    @NotNull
    private final InspectionTree myTree;
    private volatile InspectionProfileImpl myInspectionProfile;
    private final boolean mySettingsEnabled;
    @NotNull
    private final AnalysisScope myScope;
    @NonNls
    public static final String HELP_ID = "reference.toolWindows.inspections";
    private final Splitter mySplitter;
    @NotNull
    private final GlobalInspectionContextImpl myGlobalInspectionContext;
    private boolean myRerun;
    private volatile boolean myDisposed;
    private boolean myApplyingFix;
    @NotNull
    private final InspectionRVContentProvider myProvider;
    @NotNull
    private final ExclusionHandler<InspectionTreeNode> myExclusionHandler;
    private EditorEx myPreviewEditor;
    private InspectionTreeLoadingProgressAware myLoadingProgressPreview;
    private final Alarm myLoadingProgressPreviewAlarm;
    private final InspectionViewSuppressActionHolder mySuppressActionHolder;
    private final Executor myTreeUpdater;
    private volatile boolean myUpdating;
    private volatile boolean myFixesAvailable;
    private ToolWindow myToolWindow;
    private ContentManagerListener myContentManagerListener;

    public InspectionResultsView(@NotNull GlobalInspectionContextImpl globalInspectionContext, @NotNull InspectionRVContentProvider provider2) {
        if (globalInspectionContext == null) {
            InspectionResultsView.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            InspectionResultsView.$$$reportNull$$$0(1);
        }
        this.myLoadingProgressPreviewAlarm = new Alarm((Disposable)this);
        this.mySuppressActionHolder = new InspectionViewSuppressActionHolder();
        this.myTreeUpdater = SequentialTaskExecutor.createSequentialApplicationPoolExecutor("Inspection-View-Tree-Updater");
        this.setLayout(new BorderLayout());
        this.myInspectionProfile = globalInspectionContext.getCurrentProfile();
        this.myScope = globalInspectionContext.getCurrentScope();
        this.myGlobalInspectionContext = globalInspectionContext;
        this.myProvider = provider2;
        this.myTree = new InspectionTree(this);
        this.mySplitter = new OnePixelSplitter(false, AnalysisUIOptions.getInstance((Project)globalInspectionContext.getProject()).SPLITTER_PROPORTION);
        this.mySplitter.setFirstComponent(ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (int)1));
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.mySplitter.addPropertyChangeListener(evt -> {
            if ("proportion".equals(evt.getPropertyName())) {
                this.myGlobalInspectionContext.setSplitterProportion(((Float)evt.getNewValue()).floatValue());
            }
        });
        this.add((Component)this.mySplitter, "Center");
        this.myExclusionHandler = new ExclusionHandler<InspectionTreeNode>(){

            public boolean isNodeExclusionAvailable(@NotNull InspectionTreeNode node2) {
                if (node2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            public boolean isNodeExcluded(@NotNull InspectionTreeNode node2) {
                if (node2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return node2.isExcluded();
            }

            public void excludeNode(@NotNull InspectionTreeNode node2) {
                if (node2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                node2.excludeElement();
                node2.dropProblemCountCaches();
            }

            public void includeNode(@NotNull InspectionTreeNode node2) {
                if (node2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                node2.amnestyElement();
                node2.dropProblemCountCaches();
            }

            public boolean isActionEnabled(boolean isExcludeAction) {
                return isExcludeAction || !InspectionResultsView.this.myGlobalInspectionContext.getUIOptions().FILTER_RESOLVED_ITEMS;
            }

            public void onDone(boolean isExcludeAction) {
                if (isExcludeAction) {
                    InspectionResultsView.this.myTree.removeSelectedProblems();
                } else {
                    InspectionResultsView.this.myTree.repaint();
                }
                InspectionResultsView.this.syncRightPanel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionResultsView$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNodeExclusionAvailable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNodeExcluded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "excludeNode";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "includeNode";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.createActionsToolbar();
        PsiManager.getInstance(this.getProject()).addPsiTreeChangeListener(new InspectionViewChangeAdapter(this), this);
        this.getProject().getMessageBus().connect(this).subscribe(ProfileChangeAdapter.TOPIC, new ProfileChangeAdapter(){

            @Override
            public void profileChanged(@NotNull InspectionProfile profile) {
                if (profile == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (profile == ProjectInspectionProfileManager.getInstance(InspectionResultsView.this.getProject()).getCurrentProfile()) {
                    InspectionResultsView.this.profileChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInspection/ui/InspectionResultsView$2", "profileChanged"));
            }
        });
        if (!this.isSingleInspectionRun()) {
            this.mySettingsEnabled = true;
        } else {
            InspectionProfileImpl profile = this.getCurrentProfile();
            String toolId = Objects.requireNonNull(profile.getSingleTool());
            InspectionToolWrapper<?, ?> tool = Objects.requireNonNull(profile.getInspectionTool(toolId, this.getProject()));
            this.mySettingsEnabled = InspectionOptionPaneRenderer.hasSettings(tool.getTool());
        }
    }

    void profileChanged() {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myTree.revalidate();
            this.myTree.repaint();
            this.syncRightPanel();
        });
    }

    public void initAdditionalGearActions(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            InspectionResultsView.$$$reportNull$$$0(2);
        }
        if (ExperimentalUI.isNewUI()) {
            this.myToolWindow = toolWindow;
            this.myContentManagerListener = new ContentManagerListener(){

                public void selectionChanged(@NotNull ContentManagerEvent event) {
                    boolean selected;
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    boolean bl = selected = ContentManagerEvent.ContentOperation.add == event.getOperation();
                    if (selected && event.getContent().getComponent() == InspectionResultsView.this) {
                        InspectionResultsView.this.setAdditionalGearActions();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ui/InspectionResultsView$3", "selectionChanged"));
                }
            };
            this.myToolWindow.getContentManager().addContentManagerListener(this.myContentManagerListener);
            this.setAdditionalGearActions();
        }
    }

    private void setAdditionalGearActions() {
        if (this.myToolWindow != null) {
            DefaultActionGroup group2 = new DefaultActionGroup(new AnAction[]{this.myGlobalInspectionContext.createToggleAutoscrollAction()});
            this.myToolWindow.setAdditionalGearActions((ActionGroup)group2);
        }
    }

    private void createActionsToolbar() {
        JComponent westComponent = ExperimentalUI.isNewUI() ? this.createNewActionsToolbar() : JBUI.Panels.simplePanel().addToLeft(this.createLeftActionsToolbar()).addToRight(this.createRightActionsToolbar());
        this.add((Component)westComponent, "West");
    }

    private static DefaultActionGroup createExportActions() {
        DefaultActionGroup result2 = new DefaultActionGroup(InspectionsBundle.message("inspection.action.export.html", new Object[0]), null, AllIcons.ToolbarDecorator.Export);
        result2.addAll(InspectionResultsExportActionProvider.Companion.getEP_NAME().getExtensionList());
        result2.setPopup(true);
        return result2;
    }

    private JComponent createNewActionsToolbar() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new RerunAction(this));
        group2.add(actionsManager.createPrevOccurenceAction(this.myTree.getOccurenceNavigator()));
        group2.add(actionsManager.createNextOccurenceAction(this.myTree.getOccurenceNavigator()));
        group2.add((AnAction)new InvokeQuickFixAction(this));
        group2.addSeparator();
        group2.add(ActionManager.getInstance().getAction("EditInspectionSettings"));
        DefaultActionGroup viewOptionsActions = new DefaultActionGroup(InspectionsBundle.message("inspection.action.view.options", new Object[0]), null, AllIcons.Actions.Show);
        viewOptionsActions.addSeparator(InspectionsBundle.message("inspection.action.view.options.group.by", new Object[0]));
        viewOptionsActions.add(this.myGlobalInspectionContext.getUIOptions().createGroupByDirectoryAction(this));
        viewOptionsActions.add(this.myGlobalInspectionContext.getUIOptions().createGroupBySeverityAction(this));
        viewOptionsActions.addSeparator();
        viewOptionsActions.add(this.myGlobalInspectionContext.getUIOptions().createFilterResolvedItemsAction(this));
        viewOptionsActions.setPopup(true);
        group2.add((AnAction)viewOptionsActions);
        group2.addSeparator();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)((Object)this.myTree));
        group2.add(actionsManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        group2.add(actionsManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        group2.addSeparator();
        group2.add((AnAction)InspectionResultsView.createExportActions());
        return this.createToolbar(group2);
    }

    private JComponent createRightActionsToolbar() {
        DefaultActionGroup specialGroup = new DefaultActionGroup();
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createGroupBySeverityAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createGroupByDirectoryAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createFilterResolvedItemsAction(this));
        specialGroup.add((AnAction)this.myGlobalInspectionContext.createToggleAutoscrollAction());
        specialGroup.add((AnAction)InspectionResultsView.createExportActions());
        specialGroup.add((AnAction)new InvokeQuickFixAction(this));
        return this.createToolbar(specialGroup);
    }

    private JComponent createLeftActionsToolbar() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new RerunAction(this));
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)((Object)this.myTree));
        group2.add(actionsManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        group2.add(actionsManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        group2.add(actionsManager.createPrevOccurenceAction(this.myTree.getOccurenceNavigator()));
        group2.add(actionsManager.createNextOccurenceAction(this.myTree.getOccurenceNavigator()));
        group2.add(ActionManager.getInstance().getAction("EditInspectionSettings"));
        return this.createToolbar(group2);
    }

    public boolean hasNextOccurence() {
        return this.myTree.getOccurenceNavigator().hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myTree.getOccurenceNavigator().hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myTree.getOccurenceNavigator().goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myTree.getOccurenceNavigator().goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string2 = this.myTree.getOccurenceNavigator().getNextOccurenceActionName();
        if (string2 == null) {
            InspectionResultsView.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string2 = this.myTree.getOccurenceNavigator().getPreviousOccurenceActionName();
        if (string2 == null) {
            InspectionResultsView.$$$reportNull$$$0(4);
        }
        return string2;
    }

    private JComponent createToolbar(DefaultActionGroup specialGroup) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CodeInspection", (ActionGroup)specialGroup, false);
        toolbar.setTargetComponent((JComponent)this);
        return toolbar.getComponent();
    }

    @Override
    public void dispose() {
        InspectionResultsViewUtil.releaseEditor((Editor)this.myPreviewEditor);
        this.mySplitter.dispose();
        this.myInspectionProfile = null;
        this.myDisposed = true;
        if (this.myLoadingProgressPreview != null) {
            Disposer.dispose(this.myLoadingProgressPreview);
            this.myLoadingProgressPreview = null;
        }
        if (this.myToolWindow != null && this.myContentManagerListener != null) {
            this.myToolWindow.getContentManager().removeContentManagerListener(this.myContentManagerListener);
        }
    }

    boolean isAutoScrollMode() {
        String activeToolWindowId = ToolWindowManager.getInstance((Project)this.getProject()).getActiveToolWindowId();
        return this.myGlobalInspectionContext.getUIOptions().AUTOSCROLL_TO_SOURCE && (activeToolWindowId == null || activeToolWindowId.equals("Problems View") || activeToolWindowId.equals("Inspection Results"));
    }

    public void setApplyingFix(boolean applyingFix) {
        this.myApplyingFix = applyingFix;
        this.syncRightPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncRightPanel() {
        this.myFixesAvailable = false;
        EditorEx oldEditor = this.myPreviewEditor;
        try {
            if (this.myLoadingProgressPreview != null) {
                Disposer.dispose(this.myLoadingProgressPreview);
                this.myLoadingProgressPreview = null;
            }
            if (this.myApplyingFix) {
                InspectionToolWrapper<?, ?> wrapper2 = this.myTree.getSelectedToolWrapper(true);
                LOG.assertTrue(wrapper2 != null);
                this.mySplitter.setSecondComponent(InspectionResultsViewUtil.getApplyingFixLabel(wrapper2));
            } else if (this.myTree.getSelectionModel().getSelectionCount() != 1) {
                if (this.myTree.getSelectedToolWrapper(true) == null) {
                    this.mySplitter.setSecondComponent(InspectionResultsViewUtil.getNothingToShowTextLabel());
                } else {
                    this.showInRightPanel(this.myTree.getCommonSelectedElement());
                }
            } else {
                TreePath pathSelected = this.myTree.getSelectionModel().getLeadSelectionPath();
                if (pathSelected != null) {
                    InspectionTreeNode node2 = (InspectionTreeNode)pathSelected.getLastPathComponent();
                    if (node2 instanceof ProblemDescriptionNode) {
                        ProblemDescriptionNode problemNode = (ProblemDescriptionNode)node2;
                        this.showInRightPanel(problemNode.getElement());
                    } else if (node2 instanceof InspectionPackageNode || node2 instanceof InspectionModuleNode || node2 instanceof RefElementNode || this.isSingleInspectionRun() && node2 instanceof InspectionSeverityGroupNode) {
                        this.showInRightPanel(node2.getContainingFileLocalEntity());
                    } else if (node2 instanceof InspectionNode) {
                        if (this.myGlobalInspectionContext.getPresentation(((InspectionNode)node2).getToolWrapper()).isDummy()) {
                            this.mySplitter.setSecondComponent(InspectionResultsViewUtil.getNothingToShowTextLabel());
                        } else {
                            this.showInRightPanel(null);
                        }
                    } else if (node2 instanceof InspectionGroupNode || node2 instanceof InspectionSeverityGroupNode) {
                        InspectionViewNavigationPanel panel2 = new InspectionViewNavigationPanel(node2, this.myTree);
                        this.myLoadingProgressPreview = panel2;
                        this.mySplitter.setSecondComponent(panel2);
                    } else if (node2 instanceof InspectionRootNode) {
                        this.mySplitter.setSecondComponent(InspectionResultsViewUtil.getNothingToShowTextLabel());
                    } else {
                        LOG.error("Unexpected node: " + node2.getClass());
                    }
                }
            }
        }
        finally {
            if (oldEditor != null) {
                if (Boolean.TRUE.equals(oldEditor.getUserData(PREVIEW_EDITOR_IS_REUSED_KEY))) {
                    oldEditor.putUserData(PREVIEW_EDITOR_IS_REUSED_KEY, null);
                } else {
                    InspectionResultsViewUtil.releaseEditor((Editor)oldEditor);
                    if (oldEditor == this.myPreviewEditor) {
                        this.myPreviewEditor = null;
                    }
                }
            }
        }
    }

    private void showInRightPanel(@Nullable RefEntity refEntity) {
        JPanel editorPanel = new JPanel();
        editorPanel.setLayout(new BorderLayout());
        JPanel actionsPanel = new JPanel(new BorderLayout());
        editorPanel.add((Component)actionsPanel, "North");
        int problemCount = this.myTree.getSelectedProblemCount();
        JComponent previewPanel = null;
        InspectionToolWrapper<?, ?> tool = this.myTree.getSelectedToolWrapper(true);
        if (tool != null) {
            InspectionToolResultExporter presentation2 = this.myGlobalInspectionContext.getPresentation((InspectionToolWrapper)tool);
            TreePath path2 = this.myTree.getSelectionPath();
            if (path2 != null) {
                TreePath[] last2 = path2.getLastPathComponent();
                if (last2 instanceof ProblemDescriptionNode) {
                    CommonProblemDescriptor descriptor2 = ((ProblemDescriptionNode)last2).getDescriptor();
                    if (descriptor2 != null) {
                        previewPanel = presentation2.getCustomPreviewPanel(descriptor2, this);
                        JComponent customActions = presentation2.getCustomActionsPanel(descriptor2, this);
                        if (customActions != null) {
                            actionsPanel.add((Component)customActions, "East");
                        }
                    }
                } else if (refEntity != null && refEntity.isValid()) {
                    previewPanel = presentation2.getCustomPreviewPanel(refEntity);
                }
            }
        }
        EditorEx previewEditor = null;
        if (previewPanel == null) {
            Pair<JComponent, EditorEx> panelAndEditor = this.createBaseRightComponentFor(problemCount, refEntity);
            previewPanel = panelAndEditor.getFirst();
            previewEditor = panelAndEditor.getSecond();
        }
        editorPanel.add(previewPanel, "Center");
        if (problemCount > 0) {
            JComponent fixToolbar;
            TreePath[] paths2 = this.myTree.getSelectionPaths();
            if (paths2 != null) {
                for (TreePath path3 : paths2) {
                    InspectionTreeNode node2 = (InspectionTreeNode)path3.getLastPathComponent();
                    if (!(node2 instanceof SuppressableInspectionTreeNode)) continue;
                    ((SuppressableInspectionTreeNode)node2).updateAvailableSuppressActions();
                }
            }
            if ((fixToolbar = QuickFixPreviewPanelFactory.create(this)) != null) {
                if (fixToolbar instanceof InspectionTreeLoadingProgressAware) {
                    this.myLoadingProgressPreview = (InspectionTreeLoadingProgressAware)((Object)fixToolbar);
                }
                if (previewEditor != null) {
                    previewPanel.setBorder(IdeBorderFactory.createBorder((int)2));
                }
                actionsPanel.add((Component)fixToolbar, "West");
            }
        }
        if (previewEditor != null) {
            ProblemPreviewEditorPresentation.setupFoldingsAndHighlightProblems(previewEditor, this);
        }
        this.mySplitter.setSecondComponent(editorPanel);
    }

    private Pair<JComponent, EditorEx> createBaseRightComponentFor(int problemCount, RefEntity selectedEntity) {
        if (selectedEntity instanceof RefElement && selectedEntity.isValid() && !(((RefElement)selectedEntity).getPsiElement() instanceof PsiDirectory)) {
            PsiFile file2;
            Document document;
            PsiElement element;
            CommonProblemDescriptor descriptor2;
            CommonProblemDescriptor[] descriptors;
            PsiElement selectedElement = ((RefElement)selectedEntity).getPsiElement();
            if (problemCount == 1 && (descriptors = this.myTree.getSelectedDescriptors()).length != 0 && (descriptor2 = descriptors[0]) instanceof ProblemDescriptorBase && (element = ((ProblemDescriptorBase)descriptor2).getPsiElement()) != null) {
                selectedElement = element;
            }
            if ((document = PsiDocumentManager.getInstance((file2 = InjectedLanguageManager.getInstance(this.getProject()).getTopLevelFile(selectedElement)).getProject()).getDocument(file2)) == null) {
                return Pair.create(InspectionResultsViewUtil.createLabelForText(InspectionsBundle.message("inspections.view.no.preview.label", file2.getName())), null);
            }
            if (this.reuseEditorFor(document)) {
                this.myPreviewEditor.putUserData(PREVIEW_EDITOR_IS_REUSED_KEY, (Object)true);
                this.myPreviewEditor.getFoldingModel().runBatchFoldingOperation(() -> this.myPreviewEditor.getFoldingModel().clearFoldRegions());
                this.myPreviewEditor.getMarkupModel().removeAllHighlighters();
            } else {
                this.myPreviewEditor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.getProject(), file2.getVirtualFile(), false, EditorKind.PREVIEW);
                DiffUtil.setFoldingModelSupport((EditorEx)this.myPreviewEditor);
                EditorSettings settings = this.myPreviewEditor.getSettings();
                settings.setFoldingOutlineShown(true);
                settings.setLineMarkerAreaShown(true);
                settings.setGutterIconsShown(false);
                settings.setAdditionalColumnsCount(0);
                settings.setAdditionalLinesCount(0);
                settings.setLeadingWhitespaceShown(true);
                this.myPreviewEditor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, this.myPreviewEditor.getColorsScheme().getDefaultBackground());
                this.myPreviewEditor.getScrollPane().setBorder(JBUI.Borders.empty());
            }
            if (problemCount == 0) {
                this.myPreviewEditor.getScrollingModel().scrollTo(this.myPreviewEditor.offsetToLogicalPosition(selectedElement.getTextOffset()), ScrollType.CENTER_UP);
            }
            this.myPreviewEditor.getComponent().setBorder(JBUI.Borders.empty());
            return Pair.create(this.myPreviewEditor.getComponent(), this.myPreviewEditor);
        }
        if (selectedEntity == null) {
            return Pair.create(new InspectionNodeInfo(this.myTree, this.getProject()), null);
        }
        if (selectedEntity.isValid()) {
            return Pair.create(InspectionResultsViewUtil.getPreviewIsNotAvailable(selectedEntity), null);
        }
        return Pair.create(InspectionResultsViewUtil.getInvalidEntityLabel(selectedEntity), null);
    }

    private boolean reuseEditorFor(Document document) {
        return this.myPreviewEditor != null && !this.myPreviewEditor.isDisposed() && this.myPreviewEditor.getDocument() == document;
    }

    private void addTool(@NotNull InspectionToolWrapper<?, ?> toolWrapper, HighlightDisplayLevel errorLevel, boolean groupedBySeverity, boolean isSingleInspectionRun) {
        if (toolWrapper == null) {
            InspectionResultsView.$$$reportNull$$$0(5);
        }
        InspectionTreeNode toolNode = this.myTree.getToolProblemsRootNode(toolWrapper, errorLevel, groupedBySeverity, isSingleInspectionRun);
        this.myProvider.appendToolNodeContent(this.myGlobalInspectionContext, toolWrapper, toolNode, this.myGlobalInspectionContext.getUIOptions().SHOW_STRUCTURE, groupedBySeverity);
        InspectionToolResultExporter presentation2 = this.myGlobalInspectionContext.getPresentation((InspectionToolWrapper)toolWrapper);
        presentation2.patchToolNode(toolNode, this.myProvider, this.myGlobalInspectionContext.getUIOptions().SHOW_STRUCTURE, groupedBySeverity);
        this.registerActionShortcuts((InspectionToolPresentation)presentation2);
    }

    private void registerActionShortcuts(@NotNull InspectionToolPresentation presentation2) {
        if (presentation2 == null) {
            InspectionResultsView.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            for (QuickFixAction fix2 : presentation2.getQuickFixes(RefEntity.EMPTY_ELEMENTS_ARRAY)) {
                fix2.registerCustomShortcutSet(fix2.getShortcutSet(), this);
            }
        });
    }

    public InspectionViewSuppressActionHolder getSuppressActionHolder() {
        return this.mySuppressActionHolder;
    }

    @Nullable
    private String getCurrentProfileName() {
        return this.myInspectionProfile == null ? null : this.myInspectionProfile.getDisplayName();
    }

    public InspectionProfileImpl getCurrentProfile() {
        return this.myInspectionProfile;
    }

    void addProblemDescriptors(InspectionToolWrapper<?, ?> wrapper2, RefEntity refElement, CommonProblemDescriptor[] descriptors) {
        this.updateTree(() -> ReadAction.run(() -> {
            if (!this.isDisposed()) {
                AnalysisUIOptions uiOptions = this.myGlobalInspectionContext.getUIOptions();
                InspectionToolResultExporter presentation2 = this.myGlobalInspectionContext.getPresentation((InspectionToolWrapper)wrapper2);
                HighlightSeverity severity = presentation2.getSeverity((RefElement)refElement);
                HighlightDisplayLevel level = HighlightDisplayLevel.find(severity == null ? HighlightSeverity.INFORMATION : severity);
                InspectionTreeNode toolNode = this.myTree.getToolProblemsRootNode(wrapper2, level, uiOptions.GROUP_BY_SEVERITY, this.isSingleInspectionRun());
                HashMap<RefEntity, CommonProblemDescriptor[]> problems = new HashMap<RefEntity, CommonProblemDescriptor[]>(1);
                problems.put(refElement, descriptors);
                HashMap<String, Set<RefEntity>> contents = new HashMap<String, Set<RefEntity>>();
                String groupName = refElement.getRefManager().getGroupName((RefElement)refElement);
                Set content2 = contents.computeIfAbsent(groupName, __ -> new HashSet());
                content2.add(refElement);
                this.getProvider().appendToolNodeContent(this.myGlobalInspectionContext, wrapper2, toolNode, uiOptions.SHOW_STRUCTURE, true, contents, problems::get);
                if (!this.myLoadingProgressPreviewAlarm.isDisposed()) {
                    this.myLoadingProgressPreviewAlarm.cancelAllRequests();
                    this.myLoadingProgressPreviewAlarm.addRequest(() -> {
                        if (this.myLoadingProgressPreview != null) {
                            this.myLoadingProgressPreview.updateLoadingProgress();
                        }
                    }, 200);
                }
            }
        }));
    }

    public void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<Tools> tools = new ArrayList<Tools>(this.myGlobalInspectionContext.getTools().values());
        this.updateTree(() -> this.updateResults(tools));
    }

    public void updateResults(@NotNull Collection<? extends Tools> tools) {
        if (tools == null) {
            InspectionResultsView.$$$reportNull$$$0(7);
        }
        try {
            this.setUpdating(true);
            this.myTree.removeAllNodes();
            this.addToolsSynchronously(tools);
        }
        finally {
            this.setUpdating(false);
        }
    }

    public void setUpdating(boolean isUpdating) {
        this.myUpdating = isUpdating;
        if (!isUpdating) {
            this.myLoadingProgressPreviewAlarm.cancelAllRequests();
            this.myLoadingProgressPreviewAlarm.addRequest(() -> {
                if (this.myLoadingProgressPreview != null) {
                    this.myLoadingProgressPreview.treeLoaded();
                }
            }, 200);
        }
        EdtInvocationManager.getInstance().invokeLater(() -> this.myTree.setPaintBusy(this.myUpdating));
    }

    public void addTools(Collection<? extends Tools> tools) {
        this.updateTree(() -> this.addToolsSynchronously(tools));
    }

    private void addToolsSynchronously(@NotNull Collection<? extends Tools> tools) {
        if (tools == null) {
            InspectionResultsView.$$$reportNull$$$0(8);
        }
        if (this.isDisposed()) {
            return;
        }
        InspectionProfileImpl profile = this.myInspectionProfile;
        boolean isGroupedBySeverity = this.myGlobalInspectionContext.getUIOptions().GROUP_BY_SEVERITY;
        boolean singleInspectionRun = this.isSingleInspectionRun();
        for (Tools tools2 : tools) {
            InspectionToolWrapper<?, ?> defaultToolWrapper = tools2.getDefaultState().getTool();
            HighlightDisplayKey key = HighlightDisplayKey.find(defaultToolWrapper.getShortName());
            for (ScopeToolState scopeToolState : this.myProvider.getTools(tools2)) {
                InspectionToolWrapper<?, ?> toolWrapper = scopeToolState.getTool();
                if (!ReadAction.compute(() -> this.myProvider.checkReportedProblems(this.myGlobalInspectionContext, toolWrapper)).booleanValue()) continue;
                this.addTool(toolWrapper, profile.getErrorLevel(key, scopeToolState.getScope(this.getProject()), this.getProject()), isGroupedBySeverity, singleInspectionRun);
            }
        }
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myGlobalInspectionContext.getProject();
        if (project2 == null) {
            InspectionResultsView.$$$reportNull$$$0(9);
        }
        return project2;
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            InspectionResultsView.$$$reportNull$$$0(10);
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        if (ExclusionHandler.EXCLUSION_HANDLER.is(dataId)) {
            return this.myExclusionHandler;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        TreePath[] paths2 = this.myTree.getSelectionPaths();
        if (paths2 == null || paths2.length == 0) {
            return null;
        }
        if (PlatformCoreDataKeys.SELECTED_ITEM.is(dataId)) {
            return paths2[0].getLastPathComponent();
        }
        if (PlatformCoreDataKeys.SELECTED_ITEMS.is(dataId)) {
            return ContainerUtil.map2Array(paths2, p -> p.getLastPathComponent());
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            return slowId -> this.getSlowData(slowId, paths2);
        }
        return null;
    }

    @Nullable
    private Object getSlowData(@NotNull String dataId, TreePath @NotNull [] paths2) {
        if (dataId == null) {
            InspectionResultsView.$$$reportNull$$$0(11);
        }
        if (paths2 == null) {
            InspectionResultsView.$$$reportNull$$$0(12);
        }
        if (paths2.length > 1) {
            if (PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                RefEntity[] refElements = this.myTree.getSelectedElements();
                ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
                for (RefEntity refElement : refElements) {
                    PsiElement psiElement;
                    PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getPsiElement() : null;
                    if (psiElement == null || !psiElement.isValid()) continue;
                    psiElements.add(psiElement);
                }
                return PsiUtilCore.toPsiElementArray(psiElements);
            }
            return null;
        }
        TreePath path2 = paths2[0];
        InspectionTreeNode selectedNode = (InspectionTreeNode)path2.getLastPathComponent();
        if (!CommonDataKeys.NAVIGATABLE.is(dataId) && !CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return null;
        }
        if (selectedNode instanceof RefElementNode) {
            PsiElement psiElement;
            RefElementNode refElementNode = (RefElementNode)selectedNode;
            RefEntity refElement = refElementNode.getElement();
            if (refElement == null || !refElement.isValid()) {
                return null;
            }
            RefEntity item = refElement.getRefManager().getRefinedElement(refElement);
            if (!item.isValid()) {
                return null;
            }
            PsiElement psiElement3 = psiElement = item instanceof RefElement ? ((RefElement)item).getPsiElement() : null;
            if (psiElement == null) {
                return null;
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return InspectionResultsView.getSelectedNavigatable(null, psiElement);
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return psiElement.isValid() ? psiElement : null;
            }
        } else if (selectedNode instanceof ProblemDescriptionNode) {
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                Navigatable navigatable = InspectionResultsView.getSelectedNavigatable(((ProblemDescriptionNode)selectedNode).getDescriptor());
                return navigatable == null ? InspectionResultsViewUtil.getNavigatableForInvalidNode((ProblemDescriptionNode)selectedNode) : navigatable;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                RefEntity item = ((ProblemDescriptionNode)selectedNode).getElement();
                return item instanceof RefElement ? ((RefElement)item).getPsiElement() : null;
            }
        }
        return null;
    }

    @NlsContexts.TabTitle
    public String getViewTitle() {
        if (ExperimentalUI.isNewUI()) {
            return InspectionsBundle.message("inspection.results.toolwindow.title", this.myScope.getShortenName());
        }
        return InspectionsBundle.message(this.isSingleInspectionRun() ? "inspection.results.for.inspection.toolwindow.title" : "inspection.results.for.profile.toolwindow.title", this.getCurrentProfileName(), this.myScope.getShortenName());
    }

    void setFixesAvailable(boolean available) {
        this.myFixesAvailable = available;
    }

    public boolean areFixesAvailable() {
        return this.myFixesAvailable;
    }

    @Nullable
    static Navigatable getSelectedNavigatable(CommonProblemDescriptor descriptor2) {
        return InspectionResultsView.getSelectedNavigatable(descriptor2, descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getPsiElement() : null);
    }

    @Nullable
    private static Navigatable getSelectedNavigatable(CommonProblemDescriptor descriptor2, PsiElement psiElement) {
        VirtualFile virtualFile2;
        Navigatable navigatable;
        if (descriptor2 instanceof ProblemDescriptorBase && (navigatable = ((ProblemDescriptorBase)descriptor2).getNavigatable()) != null) {
            return navigatable;
        }
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        VirtualFile virtualFile3 = virtualFile2 = containingFile == null ? null : containingFile.getVirtualFile();
        if (virtualFile2 != null) {
            TextRange textRange;
            int startOffset = psiElement.getTextOffset();
            if (descriptor2 instanceof ProblemDescriptorBase && (textRange = ((ProblemDescriptorBase)descriptor2).getTextRangeForNavigation()) != null) {
                if (virtualFile2 instanceof VirtualFileWindow) {
                    virtualFile2 = ((VirtualFileWindow)((Object)virtualFile2)).getDelegate();
                }
                startOffset = textRange.getStartOffset();
            }
            return PsiNavigationSupport.getInstance().createNavigatable(psiElement.getProject(), virtualFile2, startOffset);
        }
        return null;
    }

    @NotNull
    public InspectionTree getTree() {
        InspectionTree inspectionTree = this.myTree;
        if (inspectionTree == null) {
            InspectionResultsView.$$$reportNull$$$0(13);
        }
        return inspectionTree;
    }

    @NotNull
    public GlobalInspectionContextImpl getGlobalInspectionContext() {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.myGlobalInspectionContext;
        if (globalInspectionContextImpl == null) {
            InspectionResultsView.$$$reportNull$$$0(14);
        }
        return globalInspectionContextImpl;
    }

    @NotNull
    public InspectionRVContentProvider getProvider() {
        InspectionRVContentProvider inspectionRVContentProvider = this.myProvider;
        if (inspectionRVContentProvider == null) {
            InspectionResultsView.$$$reportNull$$$0(15);
        }
        return inspectionRVContentProvider;
    }

    public boolean isRerun() {
        boolean rerun = this.myRerun;
        this.myRerun = false;
        return rerun;
    }

    public boolean areSettingsEnabled() {
        return this.mySettingsEnabled;
    }

    public boolean isSingleInspectionRun() {
        return this.myInspectionProfile.getSingleTool() != null;
    }

    public static void showPopup(AnActionEvent e, JBPopup popup2) {
        InputEvent event = e.getInputEvent();
        if (event instanceof MouseEvent) {
            popup2.showUnderneathOf(event.getComponent());
        } else {
            popup2.showInBestPositionFor(e.getDataContext());
        }
    }

    @NotNull
    public AnalysisScope getScope() {
        AnalysisScope analysisScope = this.myScope;
        if (analysisScope == null) {
            InspectionResultsView.$$$reportNull$$$0(16);
        }
        return analysisScope;
    }

    public boolean isUpdating() {
        return this.myUpdating;
    }

    public boolean hasProblems() {
        return InspectionResultsView.hasProblems(this.myGlobalInspectionContext.getTools().values(), this.myGlobalInspectionContext, this.myProvider);
    }

    public static boolean hasProblems(@NotNull Collection<? extends Tools> tools, @NotNull GlobalInspectionContextImpl context2, @NotNull InspectionRVContentProvider contentProvider) {
        if (tools == null) {
            InspectionResultsView.$$$reportNull$$$0(17);
        }
        if (context2 == null) {
            InspectionResultsView.$$$reportNull$$$0(18);
        }
        if (contentProvider == null) {
            InspectionResultsView.$$$reportNull$$$0(19);
        }
        for (Tools tools2 : tools) {
            for (ScopeToolState scopeToolState : contentProvider.getTools(tools2)) {
                InspectionToolWrapper<?, ?> toolWrapper = scopeToolState.getTool();
                ThreeState hasReportedProblems = context2.getPresentation((InspectionToolWrapper)toolWrapper).hasReportedProblems();
                if (hasReportedProblems == ThreeState.NO || hasReportedProblems != ThreeState.YES && !ReadAction.compute(() -> contentProvider.checkReportedProblems(context2, toolWrapper)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public boolean isRerunAvailable() {
        return !(this.myProvider instanceof OfflineInspectionRVContentProvider) && this.myScope.isValid();
    }

    public void rerun() {
        this.myRerun = true;
        if (this.myScope.isValid()) {
            this.myGlobalInspectionContext.doInspections(this.myScope);
        } else {
            GlobalInspectionContextImpl.NOTIFICATION_GROUP.createNotification(InspectionsBundle.message("inspection.view.invalid.scope.message", new Object[0]), NotificationType.INFORMATION).notify(this.getProject());
        }
    }

    private void updateTree(@NotNull Runnable action2) {
        if (action2 == null) {
            InspectionResultsView.$$$reportNull$$$0(20);
        }
        this.myTreeUpdater.execute(() -> ProgressManager.getInstance().runProcess(action2, (ProgressIndicator)new EmptyProgressIndicator()));
    }

    @TestOnly
    public void dispatchTreeUpdate() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.myTreeUpdater.execute(() -> latch.countDown());
        latch.await();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 9, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionResultsView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentProvider";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionResultsView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalInspectionContext";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initAdditionalGearActions";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addTool";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerActionShortcuts";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateResults";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addToolsSynchronously";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasProblems";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateTree";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 9, 13, 14, 15, 16 -> new IllegalStateException(string2);
        };
    }
}

