/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionResultsViewUtil;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeCellRenderer;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.LevelAndCount;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.UIBundle;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.TreeCollector;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

public class InspectionTree
extends Tree {
    private static final Logger LOG = Logger.getInstance(InspectionTree.class);
    private final InspectionTreeModel myModel;
    private boolean myQueueUpdate;
    private final OccurenceNavigator myOccurenceNavigator;
    private final InspectionResultsView myView;
    private final Map<ProblemDescriptionNode, CancellablePromise<String>> scheduledTooltipTasks;

    public InspectionTree(@NotNull InspectionResultsView view) {
        if (view == null) {
            InspectionTree.$$$reportNull$$$0(0);
        }
        this.myOccurenceNavigator = new MyOccurrenceNavigator();
        this.scheduledTooltipTasks = new ConcurrentHashMap<ProblemDescriptionNode, CancellablePromise<String>>();
        this.myView = view;
        Disposer.register(this.myView, () -> {
            this.scheduledTooltipTasks.forEach((node2, promise) -> promise.cancel());
            this.scheduledTooltipTasks.clear();
        });
        this.myModel = new InspectionTreeModel();
        Disposer.register(view, (Disposable)((Object)this.myModel));
        this.setModel((TreeModel)new AsyncTreeModel((TreeModel)((Object)this.myModel), false, (Disposable)view));
        this.setCellRenderer((TreeCellRenderer)((Object)new InspectionTreeCellRenderer(view)));
        this.setRootVisible(true);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getSelectionModel().addTreeSelectionListener(e -> {
                if (this.isUnderQueueUpdate()) {
                    return;
                }
                if (!this.myView.isDisposed()) {
                    this.myView.syncRightPanel();
                    if (this.myView.isAutoScrollMode()) {
                        OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)((Object)this)), (boolean)false);
                    }
                }
            });
            EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
            EditSourceOnEnterKeyHandler.install((JTree)((Object)this));
            TreeUtil.installActions((JTree)((Object)this));
            PopupHandler.installPopupMenu((JComponent)((Object)this), (String)"InspectionToolWindow.TreePopup", (String)"CodeInspection");
            new TreeSpeedSearch((JTree)((Object)this), false, o -> InspectionsConfigTreeComparator.getDisplayTextToSort(o.getLastPathComponent().toString()));
        }
        this.getModel().addTreeModelListener(new TreeModelAdapter(){
            boolean myAlreadyDone;

            @Override
            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!this.myAlreadyDone && InspectionTree.this.getSelectionCount() == 0) {
                    this.myAlreadyDone = true;
                    EdtInvocationManager.getInstance().invokeLater(() -> {
                        InspectionTree.this.expandPath(new TreePath(InspectionTree.this.myModel.getRoot()));
                        SmartExpander.installOn((JTree)((Object)InspectionTree.this));
                        if (!InspectionTree.this.myView.isDisposed()) {
                            InspectionTree.this.myView.syncRightPanel();
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/ui/InspectionTree$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public InspectionTreeNode getRoot() {
        return this.myModel.getRoot();
    }

    public InspectionTreeModel getInspectionTreeModel() {
        return this.myModel;
    }

    public void setQueueUpdate(boolean queueUpdate) {
        this.myQueueUpdate = queueUpdate;
    }

    private boolean isUnderQueueUpdate() {
        return this.myQueueUpdate;
    }

    void removeAllNodes() {
        this.myModel.clearTree();
    }

    public String @Nullable [] getSelectedGroupPath() {
        TreePath commonPath = TreePathUtil.findCommonAncestor((TreePath[])this.getSelectionPaths());
        if (commonPath == null) {
            return null;
        }
        for (Object n : commonPath.getPath()) {
            if (!(n instanceof InspectionGroupNode)) continue;
            return InspectionTree.getGroupPath((InspectionGroupNode)n);
        }
        return null;
    }

    @Nullable
    public InspectionToolWrapper<?, ?> getSelectedToolWrapper(boolean allowDummy) {
        InspectionProfileImpl profile = this.myView.getCurrentProfile();
        if (profile == null) {
            return null;
        }
        String singleToolName = profile.getSingleTool();
        TreePath[] paths2 = this.getSelectionPaths();
        if (paths2 == null) {
            if (singleToolName != null) {
                InspectionToolWrapper<?, ?> tool = profile.getInspectionTool(singleToolName, this.myView.getProject());
                LOG.assertTrue(tool != null);
                return tool;
            }
            return null;
        }
        InspectionToolWrapper<?, ?> resultWrapper = null;
        block0: for (TreePath path2 : paths2) {
            Object[] nodes2 = path2.getPath();
            for (int j = nodes2.length - 1; j >= 0; --j) {
                Object node2 = nodes2[j];
                if (node2 instanceof InspectionGroupNode) {
                    return null;
                }
                InspectionToolWrapper<?, ?> wrapper2 = null;
                if (node2 instanceof InspectionNode) {
                    wrapper2 = ((InspectionNode)node2).getToolWrapper();
                } else if (node2 instanceof SuppressableInspectionTreeNode) {
                    wrapper2 = ((SuppressableInspectionTreeNode)node2).getPresentation().getToolWrapper();
                }
                if (wrapper2 == null || !allowDummy && this.getContext().getPresentation((InspectionToolWrapper)wrapper2).isDummy()) continue;
                if (resultWrapper == null) {
                    resultWrapper = wrapper2;
                    continue block0;
                }
                if (resultWrapper == wrapper2) continue block0;
                return null;
            }
        }
        if (resultWrapper == null && singleToolName != null) {
            InspectionToolWrapper<?, ?> tool = profile.getInspectionTool(singleToolName, this.myView.getProject());
            LOG.assertTrue(tool != null);
            return tool;
        }
        return resultWrapper;
    }

    @Nullable
    public static InspectionToolWrapper<?, ?> findWrapper(Object[] selectedNode) {
        InspectionToolWrapper<?, ?> resultWrapper = null;
        for (Object node2 : selectedNode) {
            if (node2 instanceof InspectionGroupNode) {
                return null;
            }
            InspectionToolWrapper<?, ?> wrapper2 = null;
            if (node2 instanceof InspectionNode) {
                wrapper2 = ((InspectionNode)node2).getToolWrapper();
            } else if (node2 instanceof SuppressableInspectionTreeNode) {
                wrapper2 = ((SuppressableInspectionTreeNode)node2).getPresentation().getToolWrapper();
            }
            if (wrapper2 == null) continue;
            if (resultWrapper == null) {
                resultWrapper = wrapper2;
                continue;
            }
            if (resultWrapper == wrapper2) continue;
            return null;
        }
        return resultWrapper;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public String getToolTipText(MouseEvent e) {
        TreePath path2 = this.getPathForLocation(e.getX(), e.getY());
        if (path2 == null) {
            return null;
        }
        Object lastComponent = path2.getLastPathComponent();
        if (!(lastComponent instanceof ProblemDescriptionNode)) {
            return null;
        }
        ProblemDescriptionNode node2 = (ProblemDescriptionNode)lastComponent;
        if (!node2.needCalculateTooltip()) {
            return node2.getToolTipText();
        }
        @NlsContexts.Tooltip Promise tooltipLazy = this.scheduledTooltipTasks.computeIfAbsent(node2, key -> {
            IdeTooltipManager tooltipManager = IdeTooltipManager.getInstance();
            Component component2 = e.getComponent();
            return ReadAction.nonBlocking(() -> node2.getToolTipText()).finishOnUiThread(ModalityState.any(), tooltipText -> tooltipManager.updateShownTooltip(component2)).submit(AppExecutorUtil.getAppExecutorService()).onError(throwable -> {
                if (!(throwable instanceof CancellationException)) {
                    LOG.error("Exception in ProblemDescriptionNode#getToolTipText", (Throwable)throwable);
                }
                this.scheduledTooltipTasks.remove(node2);
            }).onSuccess(tooltipText -> this.scheduledTooltipTasks.remove(node2));
        });
        if (tooltipLazy.isSucceeded()) {
            try {
                return (String)tooltipLazy.blockingGet(0);
            }
            catch (ExecutionException | TimeoutException error2) {
                LOG.error(error2);
            }
        }
        return UIBundle.message((String)"crumbs.calculating.tooltip", (Object[])new Object[0]);
    }

    @Nullable
    RefEntity getCommonSelectedElement() {
        TreePath[] paths2 = this.getSelectionPaths();
        TreePath ancestor = TreePathUtil.findCommonAncestor((TreePath[])paths2);
        if (ancestor == null) {
            return null;
        }
        Object node2 = ancestor.getLastPathComponent();
        return node2 instanceof RefElementNode ? ((RefElementNode)node2).getElement() : null;
    }

    public RefEntity @NotNull [] getSelectedElements() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            InspectionToolWrapper<?, ?> toolWrapper = this.getSelectedToolWrapper(true);
            if (toolWrapper == null) {
                if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
                    InspectionTree.$$$reportNull$$$0(1);
                }
                return RefEntity.EMPTY_ELEMENTS_ARRAY;
            }
            LinkedHashSet result2 = new LinkedHashSet();
            for (TreePath selectionPath : selectionPaths) {
                InspectionTreeNode node2 = (InspectionTreeNode)selectionPath.getLastPathComponent();
                InspectionTree.addElementsInNode(node2, result2);
            }
            RefEntity[] refEntityArray = ArrayUtil.reverseArray(result2.toArray(RefEntity.EMPTY_ELEMENTS_ARRAY));
            if (refEntityArray == null) {
                InspectionTree.$$$reportNull$$$0(2);
            }
            return refEntityArray;
        }
        if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
            InspectionTree.$$$reportNull$$$0(3);
        }
        return RefEntity.EMPTY_ELEMENTS_ARRAY;
    }

    @NotNull
    OccurenceNavigator getOccurenceNavigator() {
        OccurenceNavigator occurenceNavigator = this.myOccurenceNavigator;
        if (occurenceNavigator == null) {
            InspectionTree.$$$reportNull$$$0(4);
        }
        return occurenceNavigator;
    }

    public void selectNode(InspectionTreeNode node2) {
        TreePath path2 = TreePathUtil.pathToTreeNode((TreeNode)node2);
        if (path2 != null) {
            TreeUtil.promiseSelect((JTree)((Object)this), (TreePath)path2);
        }
    }

    private static void addElementsInNode(@NotNull InspectionTreeNode node2, @NotNull Set<? super RefEntity> out) {
        RefEntity element;
        if (node2 == null) {
            InspectionTree.$$$reportNull$$$0(5);
        }
        if (out == null) {
            InspectionTree.$$$reportNull$$$0(6);
        }
        if (!node2.isValid()) {
            return;
        }
        if (node2 instanceof RefElementNode) {
            element = ((RefElementNode)node2).getElement();
            out.add(element);
        }
        if (node2 instanceof ProblemDescriptionNode) {
            element = ((ProblemDescriptionNode)node2).getElement();
            out.add(element);
        }
        for (InspectionTreeNode inspectionTreeNode : node2.getChildren()) {
            InspectionTree.addElementsInNode(inspectionTreeNode, out);
        }
    }

    CommonProblemDescriptor @NotNull [] getAllValidSelectedDescriptors() {
        CommonProblemDescriptor[] commonProblemDescriptorArray = BatchModeDescriptorsUtil.flattenDescriptors(this.getSelectedDescriptorPacks(false, null, true, null));
        if (commonProblemDescriptorArray == null) {
            InspectionTree.$$$reportNull$$$0(7);
        }
        return commonProblemDescriptorArray;
    }

    CommonProblemDescriptor @NotNull [] getSelectedDescriptors() {
        CommonProblemDescriptor[] commonProblemDescriptorArray = BatchModeDescriptorsUtil.flattenDescriptors(this.getSelectedDescriptorPacks(false, null, false, null));
        if (commonProblemDescriptorArray == null) {
            InspectionTree.$$$reportNull$$$0(8);
        }
        return commonProblemDescriptorArray;
    }

    @NotNull
    public List<CommonProblemDescriptor[]> getSelectedDescriptorPacks(boolean sortedByPosition, @Nullable Set<? super VirtualFile> readOnlyFilesSink, boolean allowResolved, TreePath[] paths2) {
        if (paths2 == null) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            paths2 = this.getSelectionPaths();
        }
        if (paths2 == null) {
            List<CommonProblemDescriptor[]> list2 = Collections.emptyList();
            if (list2 == null) {
                InspectionTree.$$$reportNull$$$0(9);
            }
            return list2;
        }
        List<InspectionTreeNode> nodes2 = ContainerUtil.map(paths2, p -> (InspectionTreeNode)p.getLastPathComponent());
        return this.getSelectedDescriptors(sortedByPosition, readOnlyFilesSink, allowResolved, nodes2);
    }

    public CommonProblemDescriptor @NotNull [] getSelectedDescriptors(AnActionEvent e) {
        Object[] selectedNodes = (Object[])e.getData(PlatformCoreDataKeys.SELECTED_ITEMS);
        if (selectedNodes == null) {
            if (CommonProblemDescriptor.EMPTY_ARRAY == null) {
                InspectionTree.$$$reportNull$$$0(10);
            }
            return CommonProblemDescriptor.EMPTY_ARRAY;
        }
        List<CommonProblemDescriptor[]> descriptors = this.getSelectedDescriptors(false, null, false, ContainerUtil.map(selectedNodes, o -> (InspectionTreeNode)o));
        CommonProblemDescriptor[] commonProblemDescriptorArray = BatchModeDescriptorsUtil.flattenDescriptors(descriptors);
        if (commonProblemDescriptorArray == null) {
            InspectionTree.$$$reportNull$$$0(11);
        }
        return commonProblemDescriptorArray;
    }

    @NotNull
    private List<CommonProblemDescriptor[]> getSelectedDescriptors(boolean sortedByPosition, @Nullable Set<? super VirtualFile> readOnlyFilesSink, boolean allowResolved, @NotNull List<? extends InspectionTreeNode> nodes2) {
        if (nodes2 == null) {
            InspectionTree.$$$reportNull$$$0(12);
        }
        MultiMap parentToChildNode = new MultiMap();
        TreeTraversal.PLAIN_BFS.traversal(nodes2, n -> this.myModel.getChildren(n)).filter(ProblemDescriptionNode.class).filter(node2 -> node2.getDescriptor() != null && InspectionTree.isNodeValidAndIncluded(node2, allowResolved)).consumeEach(node2 -> {
            Object key = InspectionTree.getVirtualFileOrEntity(node2.getElement());
            parentToChildNode.putValue(key, node2.getDescriptor());
        });
        ArrayList<CommonProblemDescriptor[]> descriptors = new ArrayList<CommonProblemDescriptor[]>();
        for (Map.Entry entry : parentToChildNode.entrySet()) {
            Object key = entry.getKey();
            if (readOnlyFilesSink != null && key instanceof VirtualFile && !((VirtualFile)key).isWritable()) {
                readOnlyFilesSink.add((VirtualFile)key);
            }
            Stream<Object> stream = entry.getValue().stream();
            if (sortedByPosition) {
                stream = stream.sorted(CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
            }
            descriptors.add((CommonProblemDescriptor[])stream.distinct().toArray(CommonProblemDescriptor.ARRAY_FACTORY::create));
        }
        ArrayList<CommonProblemDescriptor[]> arrayList = descriptors;
        if (arrayList == null) {
            InspectionTree.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public TreePath @Nullable [] getSelectionPaths() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return super.getSelectionPaths();
    }

    @NotNull
    InspectionTreeNode getToolProblemsRootNode(@NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull HighlightDisplayLevel errorLevel, boolean groupedBySeverity, boolean isSingleInspectionRun) {
        if (toolWrapper == null) {
            InspectionTree.$$$reportNull$$$0(14);
        }
        if (errorLevel == null) {
            InspectionTree.$$$reportNull$$$0(15);
        }
        InspectionTreeNode parent2 = this.getToolParentNode(toolWrapper, errorLevel, groupedBySeverity, isSingleInspectionRun);
        if (isSingleInspectionRun) {
            InspectionTreeNode inspectionTreeNode = parent2;
            if (inspectionTreeNode == null) {
                InspectionTree.$$$reportNull$$$0(16);
            }
            return inspectionTreeNode;
        }
        InspectionNode inspectionNode = this.myModel.createInspectionNode(toolWrapper, this.myView.getCurrentProfile(), parent2);
        if (inspectionNode == null) {
            InspectionTree.$$$reportNull$$$0(17);
        }
        return inspectionNode;
    }

    @NotNull
    private InspectionTreeNode getToolParentNode(@NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull HighlightDisplayLevel errorLevel, boolean groupedBySeverity, boolean isSingleInspectionRun) {
        InspectionTreeNode currentNode;
        if (toolWrapper == null) {
            InspectionTree.$$$reportNull$$$0(18);
        }
        if (errorLevel == null) {
            InspectionTree.$$$reportNull$$$0(19);
        }
        if (!groupedBySeverity && isSingleInspectionRun) {
            InspectionRootNode inspectionRootNode = this.myModel.getRoot();
            if (inspectionRootNode == null) {
                InspectionTree.$$$reportNull$$$0(20);
            }
            return inspectionRootNode;
        }
        InspectionTreeNode inspectionTreeNode = currentNode = groupedBySeverity ? this.myModel.createSeverityGroupNode(this.myView.getCurrentProfile().getProfileManager().getSeverityRegistrar(), errorLevel, this.myModel.getRoot()) : this.myModel.getRoot();
        if (isSingleInspectionRun) {
            InspectionRootNode inspectionRootNode = currentNode;
            if (inspectionRootNode == null) {
                InspectionTree.$$$reportNull$$$0(21);
            }
            return inspectionRootNode;
        }
        String[] groupPath = toolWrapper.getGroupPath();
        if (groupPath.length == 0) {
            LOG.error("groupPath is empty for tool: " + toolWrapper.getShortName() + ", class: " + toolWrapper.getTool().getClass());
        }
        for (String subGroup : groupPath) {
            currentNode = this.myModel.createGroupNode(subGroup, currentNode);
        }
        InspectionRootNode inspectionRootNode = currentNode;
        if (inspectionRootNode == null) {
            InspectionTree.$$$reportNull$$$0(22);
        }
        return inspectionRootNode;
    }

    boolean areDescriptorNodesSelected() {
        TreePath[] paths2 = this.getSelectionPaths();
        if (paths2 == null) {
            return false;
        }
        for (TreePath path2 : paths2) {
            if (path2.getLastPathComponent() instanceof ProblemDescriptionNode) continue;
            return false;
        }
        return true;
    }

    int getSelectedProblemCount() {
        int count2 = 0;
        for (TreePath path2 : TreeCollector.TreePathRoots.collect((TreePath[])this.getSelectionPaths())) {
            LevelAndCount[] levels;
            for (LevelAndCount level : levels = ((InspectionTreeNode)path2.getLastPathComponent()).getProblemLevels()) {
                count2 += level.getCount();
            }
        }
        return count2;
    }

    private static boolean isNodeValidAndIncluded(ProblemDescriptionNode node2, boolean allowResolved) {
        return node2.isValid() && (allowResolved || !node2.isExcluded() && !node2.isAlreadySuppressedFromView() && !node2.isQuickFixAppliedFromView());
    }

    public void removeSelectedProblems() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TreePath[] selected = this.getSelectionPaths();
        if (selected == null) {
            return;
        }
        if (!this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS) {
            for (TreePath path2 : selected) {
                InspectionTreeNode node2 = (InspectionTreeNode)path2.getLastPathComponent();
                this.myModel.traverse(node2).forEach(InspectionTreeNode::dropProblemCountCaches);
            }
            return;
        }
        HashSet<InspectionTreeNode> processedNodes = new HashSet<InspectionTreeNode>();
        ArrayList<InspectionTreeNode> toRemove2 = new ArrayList<InspectionTreeNode>();
        block1: for (TreePath path3 : selected) {
            Object[] nodePath = path3.getPath();
            for (int i2 = 1; i2 < nodePath.length; ++i2) {
                InspectionTreeNode node3 = (InspectionTreeNode)nodePath[i2];
                if (!processedNodes.add(node3) || !this.shouldDelete(node3)) continue;
                toRemove2.add(node3);
                continue block1;
            }
        }
        if (toRemove2.isEmpty()) {
            return;
        }
        TreePath pathToSelect = null;
        if (selected.length == 1) {
            InspectionTreeNode nextNode = this.myModel.traverseFrom((InspectionTreeNode)selected[0].getLastPathComponent(), true).filter(n -> !this.shouldDelete((InspectionTreeNode)n)).first();
            if (nextNode != null) {
                pathToSelect = TreeUtil.getPathFromRoot((TreeNode)nextNode);
            }
        } else {
            TreePath commonAliveAncestorPath;
            for (commonAliveAncestorPath = TreePathUtil.findCommonAncestor((TreePath[])selected); commonAliveAncestorPath != null && this.shouldDelete((InspectionTreeNode)commonAliveAncestorPath.getLastPathComponent()); commonAliveAncestorPath = commonAliveAncestorPath.getParentPath()) {
            }
            if (commonAliveAncestorPath != null) {
                pathToSelect = commonAliveAncestorPath;
            }
        }
        HashSet<InspectionTreeNode> parents2 = new HashSet<InspectionTreeNode>();
        for (InspectionTreeNode node4 : toRemove2) {
            InspectionTreeNode parent2 = node4.getParent();
            if (parent2 == null) continue;
            this.myModel.remove(node4);
            parents2.add(parent2);
        }
        for (InspectionTreeNode parent3 : parents2) {
            parent3.dropProblemCountCaches();
        }
        TreeUtil.selectPath((JTree)((Object)this), (TreePath)pathToSelect);
        this.revalidate();
        this.repaint();
    }

    private boolean shouldDelete(InspectionTreeNode node2) {
        if (node2 instanceof RefElementNode) {
            RefElementNode refElementNode = (RefElementNode)node2;
            InspectionToolPresentation presentation2 = refElementNode.getPresentation();
            RefEntity element = refElementNode.getElement();
            if (element == null || presentation2.isProblemResolved(element) || presentation2.isExcluded(element) || presentation2.isSuppressed(element)) {
                return true;
            }
            List<? extends InspectionTreeNode> children2 = node2.getChildren();
            return !children2.isEmpty() && ContainerUtil.and(children2, this::shouldDelete);
        }
        if (node2 instanceof ProblemDescriptionNode) {
            ProblemDescriptionNode problemDescriptionNode = (ProblemDescriptionNode)node2;
            CommonProblemDescriptor descriptor2 = problemDescriptionNode.getDescriptor();
            InspectionToolPresentation presentation3 = problemDescriptionNode.getPresentation();
            return descriptor2 == null || presentation3.isExcluded(descriptor2) || presentation3.isProblemResolved(descriptor2);
        }
        if (node2 instanceof InspectionGroupNode || node2 instanceof InspectionSeverityGroupNode || node2 instanceof InspectionModuleNode || node2 instanceof InspectionPackageNode) {
            return ContainerUtil.and(node2.getChildren(), this::shouldDelete);
        }
        if (node2 instanceof InspectionNode) {
            InspectionToolResultExporter presentation4 = this.myView.getGlobalInspectionContext().getPresentation(((InspectionNode)node2).getToolWrapper());
            SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> problemElements = presentation4.getProblemElements();
            if (problemElements.isEmpty()) {
                return true;
            }
            return ContainerUtil.and(problemElements.keys(), entity -> presentation4.isExcluded((RefEntity)entity));
        }
        return false;
    }

    @NotNull
    public GlobalInspectionContextImpl getContext() {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.myView.getGlobalInspectionContext();
        if (globalInspectionContextImpl == null) {
            InspectionTree.$$$reportNull$$$0(23);
        }
        return globalInspectionContextImpl;
    }

    private static String @NotNull [] getGroupPath(@NotNull InspectionGroupNode node2) {
        InspectionTreeNode parent2;
        if (node2 == null) {
            InspectionTree.$$$reportNull$$$0(24);
        }
        ArrayList<String> path2 = new ArrayList<String>(2);
        while ((parent2 = node2.getParent()) instanceof InspectionGroupNode) {
            node2 = (InspectionGroupNode)parent2;
            path2.add(node2.getSubGroup());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(path2);
        if (stringArray == null) {
            InspectionTree.$$$reportNull$$$0(25);
        }
        return stringArray;
    }

    @Nullable
    private static Object getVirtualFileOrEntity(@Nullable RefEntity entity) {
        VirtualFile file2;
        SmartPsiElementPointer<?> pointer;
        if (entity instanceof RefElement && (pointer = ((RefElement)entity).getPointer()) != null && (file2 = pointer.getVirtualFile()) != null) {
            return file2;
        }
        return entity;
    }

    @Nullable
    public static PsiElement getSelectedElement(@NotNull AnActionEvent e) {
        PsiElement element;
        if (e == null) {
            InspectionTree.$$$reportNull$$$0(26);
        }
        if ((element = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT)) != null) {
            return element;
        }
        RefEntity[] entities2 = InspectionTree.getSelectedRefElements(e);
        RefEntity refEntity = ContainerUtil.find(entities2, entity -> entity instanceof RefElement);
        return refEntity != null ? ((RefElement)refEntity).getPsiElement() : null;
    }

    public static RefEntity @NotNull [] getSelectedRefElements(@NotNull AnActionEvent e) {
        Object[] nodes2;
        if (e == null) {
            InspectionTree.$$$reportNull$$$0(27);
        }
        if ((nodes2 = (Object[])e.getData(PlatformCoreDataKeys.SELECTED_ITEMS)) != null) {
            HashSet entities2 = new HashSet();
            for (Object node2 : nodes2) {
                InspectionTree.addElementsInNode((InspectionTreeNode)node2, entities2);
            }
            RefEntity[] refEntityArray = entities2.toArray(entities2.toArray(RefEntity.EMPTY_ELEMENTS_ARRAY));
            if (refEntityArray == null) {
                InspectionTree.$$$reportNull$$$0(28);
            }
            return refEntityArray;
        }
        if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
            InspectionTree.$$$reportNull$$$0(29);
        }
        return RefEntity.EMPTY_ELEMENTS_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 7, 8, 9, 10, 11, 13, 16, 17, 20, 21, 22, 23, 25, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionTree";
                break;
            }
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorLevel";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionTree";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurenceNavigator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValidSelectedDescriptors";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDescriptors";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDescriptorPacks";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolProblemsRootNode";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolParentNode";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRefElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addElementsInNode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedDescriptors";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getToolProblemsRootNode";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getToolParentNode";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getGroupPath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRefElements";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4, 7, 8, 9, 10, 11, 13, 16, 17, 20, 21, 22, 23, 25, 28, 29 -> new IllegalStateException(string2);
        };
    }

    private class MyOccurrenceNavigator
    implements OccurenceNavigator {
        private MyOccurrenceNavigator() {
        }

        public boolean hasNextOccurence() {
            return this.getNextNode(true) != null;
        }

        public boolean hasPreviousOccurence() {
            return this.getNextNode(false) != null;
        }

        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            InspectionTreeNode node2 = this.getNextNode(true);
            if (node2 == null) {
                return null;
            }
            InspectionTree.this.selectNode(node2);
            return new OccurenceNavigator.OccurenceInfo(MyOccurrenceNavigator.createDescriptorForNode(node2), -1, -1);
        }

        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            InspectionTreeNode node2 = this.getNextNode(false);
            InspectionTree.this.selectNode(node2);
            return node2 == null ? null : new OccurenceNavigator.OccurenceInfo(MyOccurrenceNavigator.createDescriptorForNode(node2), -1, -1);
        }

        @NotNull
        public String getNextOccurenceActionName() {
            String string2 = InspectionsBundle.message(ExperimentalUI.isNewUI() ? "inspection.action.go.next.new" : "inspection.action.go.next", new Object[0]);
            if (string2 == null) {
                MyOccurrenceNavigator.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            String string2 = InspectionsBundle.message(ExperimentalUI.isNewUI() ? "inspection.action.go.prev.new" : "inspection.action.go.prev", new Object[0]);
            if (string2 == null) {
                MyOccurrenceNavigator.$$$reportNull$$$0(1);
            }
            return string2;
        }

        private InspectionTreeNode getNextNode(boolean next2) {
            InspectionTreeNode node2 = this.getSelectedNode();
            if (node2 == null) {
                return null;
            }
            return InspectionTree.this.myModel.traverseFrom(node2, next2).filter(n -> n != node2).filter(n -> MyOccurrenceNavigator.isOccurrenceNode(n)).first();
        }

        private InspectionTreeNode getSelectedNode() {
            TreePath path2 = InspectionTree.this.getSelectionPath();
            if (path2 == null) {
                return null;
            }
            return (InspectionTreeNode)path2.getLastPathComponent();
        }

        private static boolean isOccurrenceNode(@NotNull InspectionTreeNode node2) {
            if (node2 == null) {
                MyOccurrenceNavigator.$$$reportNull$$$0(2);
            }
            if (node2.isExcluded()) {
                return false;
            }
            if (node2 instanceof RefElementNode) {
                RefElementNode refNode = (RefElementNode)node2;
                if (MyOccurrenceNavigator.hasDescriptorUnder(refNode)) {
                    return false;
                }
                RefEntity element = refNode.getElement();
                return element != null && element.isValid();
            }
            return node2 instanceof ProblemDescriptionNode;
        }

        @Nullable
        private static Navigatable createDescriptorForNode(@NotNull InspectionTreeNode node2) {
            if (node2 == null) {
                MyOccurrenceNavigator.$$$reportNull$$$0(3);
            }
            if (node2.isExcluded()) {
                return null;
            }
            if (node2 instanceof RefElementNode) {
                RefElementNode refNode = (RefElementNode)node2;
                if (MyOccurrenceNavigator.hasDescriptorUnder(refNode)) {
                    return null;
                }
                RefEntity element = refNode.getElement();
                if (element == null || !element.isValid()) {
                    return null;
                }
                if (element instanceof RefElement) {
                    return MyOccurrenceNavigator.getOpenFileDescriptor((RefElement)element);
                }
            } else if (node2 instanceof ProblemDescriptionNode) {
                ProblemDescriptionNode problemNode = (ProblemDescriptionNode)node2;
                boolean isValid = problemNode.isValid() && (!problemNode.isQuickFixAppliedFromView() || problemNode.calculateIsValid());
                return isValid ? MyOccurrenceNavigator.navigate(problemNode.getDescriptor()) : InspectionResultsViewUtil.getNavigatableForInvalidNode(problemNode);
            }
            return null;
        }

        @Nullable
        private static Navigatable navigate(CommonProblemDescriptor descriptor2) {
            return InspectionResultsView.getSelectedNavigatable(descriptor2);
        }

        @Nullable
        private static Navigatable getOpenFileDescriptor(@NotNull RefElement refElement) {
            PsiElement psiElement;
            if (refElement == null) {
                MyOccurrenceNavigator.$$$reportNull$$$0(4);
            }
            if ((psiElement = refElement.getPsiElement()) == null) {
                return null;
            }
            PsiFile containingFile = psiElement.getContainingFile();
            if (containingFile == null) {
                return null;
            }
            VirtualFile file2 = containingFile.getVirtualFile();
            if (file2 == null) {
                return null;
            }
            return PsiNavigationSupport.getInstance().createNavigatable(refElement.getRefManager().getProject(), file2, psiElement.getTextOffset());
        }

        private static boolean hasDescriptorUnder(@NotNull RefElementNode node2) {
            if (node2 == null) {
                MyOccurrenceNavigator.$$$reportNull$$$0(5);
            }
            InspectionTreeNode current = node2;
            while (current != null && current.getChildCount() != 0) {
                if (!((current = current.getChildAt(0)) instanceof ProblemDescriptionNode)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ui/InspectionTree$MyOccurrenceNavigator";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextOccurenceActionName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviousOccurenceActionName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ui/InspectionTree$MyOccurrenceNavigator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isOccurrenceNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescriptorForNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getOpenFileDescriptor";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "hasDescriptorUnder";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string2);
            };
        }
    }
}

