/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineDescriptorResolveResult;
import com.intellij.codeInspection.offlineViewer.OfflineProblemDescriptorNode;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionTreeModel
extends BaseTreeModel<InspectionTreeNode>
implements InvokerSupplier {
    private static final Logger LOG = Logger.getInstance(InspectionTreeModel.class);
    private final InspectionRootNode myRoot = new InspectionRootNode(this);
    private final Invoker myInvoker = Invoker.forBackgroundThreadWithReadAction((Disposable)((Object)this));

    public int getIndexOfChild(Object object, Object child) {
        return ((InspectionTreeNode)object).getIndex((TreeNode)child);
    }

    public void reload() {
        this.treeNodesChanged(null, null, null);
    }

    public List<? extends InspectionTreeNode> getChildren(Object parent2) {
        List<? extends InspectionTreeNode> children2 = ((InspectionTreeNode)parent2).getChildren();
        return children2;
    }

    public boolean isLeaf(Object object) {
        if (object == this.myRoot) {
            return false;
        }
        return super.isLeaf(object);
    }

    public int getChildCount(Object object) {
        return ((InspectionTreeNode)object).getChildren().size();
    }

    public InspectionRootNode getRoot() {
        return this.myRoot;
    }

    @Nullable
    public InspectionTreeNode getParent(InspectionTreeNode node2) {
        return node2.myParent;
    }

    public JBIterable<InspectionTreeNode> traverse(InspectionTreeNode node2) {
        return TreeTraversal.PRE_ORDER_DFS.traversal(node2, n -> this.getChildren(n));
    }

    @NotNull
    JBIterable<InspectionTreeNode> traverseFrom(InspectionTreeNode node2, boolean direction) {
        JBIterable<InspectionTreeNode> jBIterable = JBIterable.generate(node2, n -> this.getParent((InspectionTreeNode)n)).filter(n -> this.getParent((InspectionTreeNode)n) != null).flatMap(n1 -> {
            InspectionTreeNode p = this.getParent((InspectionTreeNode)n1);
            int idx = this.getIndexOfChild(p, n1);
            if (idx < 0) {
                return JBIterable.empty();
            }
            assert (p != null);
            InspectionTreeNode.Children children2 = p.myChildren;
            if (children2 == null) {
                return JBIterable.empty();
            }
            InspectionTreeNode[] arr = children2.myChildren;
            List<InspectionTreeNode> sublist = direction ? Arrays.asList(arr).subList(idx + (n1 == node2 ? 0 : 1), arr.length) : ContainerUtil.reverse(Arrays.asList(arr).subList(0, idx));
            return TreeTraversal.PRE_ORDER_DFS.traversal(sublist, n -> direction ? this.getChildren(n) : ContainerUtil.reverse(this.getChildren(n)));
        });
        if (jBIterable == null) {
            InspectionTreeModel.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    public void remove(@NotNull InspectionTreeNode node2) {
        if (node2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(1);
        }
        this.doRemove(node2, null);
        this.treeNodesChanged(null, null, null);
        this.treeStructureChanged(null, null, null);
    }

    private synchronized void doRemove(@NotNull InspectionTreeNode node2, @Nullable InspectionTreeNode skip) {
        InspectionTreeNode parent2;
        if (node2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(2);
        }
        for (InspectionTreeNode inspectionTreeNode : this.getChildren(node2)) {
            this.doRemove(inspectionTreeNode, skip);
        }
        if (node2 != skip && (parent2 = this.getParent(node2)) != null) {
            InspectionTreeNode.Children children2 = parent2.myChildren;
            assert (children2 != null);
            children2.myChildren = ArrayUtil.remove(children2.myChildren, node2);
            children2.myUserObject2Node.removeValue(node2);
        }
    }

    synchronized void clearTree() {
        InspectionTreeNode.Children children2 = this.myRoot.myChildren;
        if (children2 != null) {
            children2.clear();
        }
    }

    @NotNull
    public InspectionModuleNode createModuleNode(@NotNull Module module2, @NotNull InspectionTreeNode parent2) {
        if (module2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(3);
        }
        if (parent2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(4);
        }
        InspectionModuleNode inspectionModuleNode = this.getOrAdd(module2, parent2, () -> new InspectionModuleNode(module2, parent2));
        if (inspectionModuleNode == null) {
            InspectionTreeModel.$$$reportNull$$$0(5);
        }
        return inspectionModuleNode;
    }

    @NotNull
    public InspectionPackageNode createPackageNode(String packageName, @NotNull InspectionTreeNode parent2) {
        if (parent2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(6);
        }
        InspectionPackageNode inspectionPackageNode = this.getOrAdd(packageName, parent2, () -> new InspectionPackageNode(packageName, parent2));
        if (inspectionPackageNode == null) {
            InspectionTreeModel.$$$reportNull$$$0(7);
        }
        return inspectionPackageNode;
    }

    @NotNull
    InspectionGroupNode createGroupNode(@Nls String group2, @NotNull InspectionTreeNode parent2) {
        if (parent2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(8);
        }
        InspectionGroupNode inspectionGroupNode = this.getOrAdd(group2, parent2, () -> new InspectionGroupNode(group2, parent2));
        if (inspectionGroupNode == null) {
            InspectionTreeModel.$$$reportNull$$$0(9);
        }
        return inspectionGroupNode;
    }

    @NotNull
    InspectionSeverityGroupNode createSeverityGroupNode(SeverityRegistrar severityRegistrar, HighlightDisplayLevel level, @NotNull InspectionTreeNode parent2) {
        if (parent2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(10);
        }
        InspectionSeverityGroupNode inspectionSeverityGroupNode = this.getOrAdd(level, parent2, () -> new InspectionSeverityGroupNode(severityRegistrar, level, parent2));
        if (inspectionSeverityGroupNode == null) {
            InspectionTreeModel.$$$reportNull$$$0(11);
        }
        return inspectionSeverityGroupNode;
    }

    @NotNull
    public RefElementNode createRefElementNode(@Nullable RefEntity entity, @NotNull Supplier<? extends RefElementNode> supplier2, @NotNull InspectionTreeNode parent2) {
        if (supplier2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(12);
        }
        if (parent2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(13);
        }
        RefElementNode refElementNode = this.getOrAdd(entity, parent2, () -> ReadAction.compute(((Supplier)supplier2)::get));
        if (refElementNode == null) {
            InspectionTreeModel.$$$reportNull$$$0(14);
        }
        return refElementNode;
    }

    public <T extends InspectionTreeNode> T createCustomNode(@NotNull Object userObject, @NotNull Supplier<? extends T> supplier2, @NotNull InspectionTreeNode parent2) {
        if (userObject == null) {
            InspectionTreeModel.$$$reportNull$$$0(15);
        }
        if (supplier2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(16);
        }
        if (parent2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(17);
        }
        return this.getOrAdd(userObject, parent2, supplier2);
    }

    @NotNull
    InspectionNode createInspectionNode(@NotNull InspectionToolWrapper toolWrapper, InspectionProfileImpl profile, @NotNull InspectionTreeNode parent2) {
        if (toolWrapper == null) {
            InspectionTreeModel.$$$reportNull$$$0(18);
        }
        if (parent2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(19);
        }
        InspectionNode inspectionNode = this.getOrAdd(toolWrapper.getShortName(), parent2, () -> new InspectionNode(toolWrapper, profile, parent2));
        if (inspectionNode == null) {
            InspectionTreeModel.$$$reportNull$$$0(20);
        }
        return inspectionNode;
    }

    public void createProblemDescriptorNode(RefEntity element, @NotNull CommonProblemDescriptor descriptor2, @NotNull InspectionToolPresentation presentation2, @NotNull InspectionTreeNode parent2) {
        if (descriptor2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(21);
        }
        if (presentation2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(22);
        }
        if (parent2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(23);
        }
        this.getOrAdd(descriptor2, parent2, () -> ReadAction.compute(() -> new ProblemDescriptionNode(element, descriptor2, presentation2, parent2)));
    }

    public void createOfflineProblemDescriptorNode(@NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull OfflineDescriptorResolveResult resolveResult2, @NotNull InspectionToolPresentation presentation2, @NotNull InspectionTreeNode parent2) {
        if (offlineDescriptor == null) {
            InspectionTreeModel.$$$reportNull$$$0(24);
        }
        if (resolveResult2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(25);
        }
        if (presentation2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(26);
        }
        if (parent2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(27);
        }
        this.getOrAdd(offlineDescriptor, parent2, () -> ReadAction.compute(() -> new OfflineProblemDescriptorNode(resolveResult2, presentation2, offlineDescriptor, parent2)));
    }

    private synchronized <T extends InspectionTreeNode> T getOrAdd(Object userObject, InspectionTreeNode parent2, @NotNull @NotNull Supplier<? extends @NotNull T> supplier2) {
        InspectionTreeNode node2;
        InspectionTreeNode.Children children2;
        if (supplier2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(28);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (userObject == null) {
            userObject = ObjectUtils.NULL;
        }
        if ((children2 = parent2.myChildren) == null) {
            parent2.myChildren = children2 = new InspectionTreeNode.Children();
        }
        if ((node2 = children2.myUserObject2Node.get(userObject)) == null) {
            InspectionTreeNode.Children finalChildren = children2;
            node2 = (InspectionTreeNode)supplier2.get();
            InspectionTreeNode finalNode = node2;
            int idx = ReadAction.compute(() -> Arrays.binarySearch(finalChildren.myChildren, finalNode, InspectionResultsViewComparator.INSTANCE));
            int insertionPoint = idx >= 0 ? idx : -idx - 1;
            children2.myChildren = ArrayUtil.insert(children2.myChildren, insertionPoint, node2);
            children2.myUserObject2Node.put(userObject, node2);
            LOG.assertTrue(children2.myChildren.length == children2.myUserObject2Node.size());
            if (node2 instanceof SuppressableInspectionTreeNode) {
                ((SuppressableInspectionTreeNode)node2).nodeAdded();
            }
            TreePath path2 = TreePathUtil.pathToTreeNode((TreeNode)node2);
            TreePath parentPath = path2.getParentPath();
            this.treeNodesInserted(parentPath, null, null);
            while (parentPath != null) {
                this.treeStructureChanged(parentPath, null, null);
                if ((parentPath = parentPath.getParentPath()) != null && parentPath.getLastPathComponent() != this.myRoot) continue;
                break;
            }
        }
        return (T)node2;
    }

    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myInvoker;
        if (invoker == null) {
            InspectionTreeModel.$$$reportNull$$$0(29);
        }
        return invoker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 8, 10, 12, 13, 15, 16, 17, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionTreeModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 19: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offlineDescriptor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseFrom";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionTreeModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageNode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupNode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createSeverityGroupNode";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefElementNode";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createInspectionNode";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doRemove";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModuleNode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPackageNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createGroupNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createSeverityGroupNode";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createRefElementNode";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createCustomNode";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createInspectionNode";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptorNode";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createOfflineProblemDescriptorNode";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOrAdd";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 6, 8, 10, 12, 13, 15, 16, 17, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28 -> new IllegalArgumentException(string2);
        };
    }
}

