/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.LevelAndCount;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;

public abstract class InspectionTreeTailRenderer<E extends Exception> {
    private static final int MAX_LEVEL_TYPES = 5;
    private static final JBColor TREE_RED = new JBColor(new Color(184, 66, 55), new Color(204, 102, 102));
    private static final JBColor TREE_GRAY = new JBColor(Gray._153, (Color)Gray._117);
    private final GlobalInspectionContextImpl myContext;

    public InspectionTreeTailRenderer(GlobalInspectionContextImpl context2) {
        this.myContext = context2;
    }

    public void appendTailText(InspectionTreeNode node2) throws E {
        if (this.myContext.isViewClosed()) {
            return;
        }
        String customizedTailText = node2.getTailText();
        if (customizedTailText != null) {
            if (!customizedTailText.isEmpty()) {
                this.appendText("    ");
                this.appendText(customizedTailText, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else {
            String profile;
            if (ExperimentalUI.isNewUI() && node2 instanceof InspectionRootNode && !Strings.isEmpty(profile = this.myContext.getCurrentProfile().getDisplayName())) {
                this.appendText(" ");
                this.appendText(InspectionsBundle.message("inspection.results.profile", profile), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            this.appendText("  ");
            LevelAndCount[] problemLevels = node2.getProblemLevels();
            if (problemLevels.length > 5) {
                int sum = Arrays.stream(problemLevels).mapToInt(LevelAndCount::getCount).sum();
                this.appendText(InspectionsBundle.message("inspection.problem.descriptor.count", sum, SimpleTextAttributes.GRAYED_ATTRIBUTES));
            } else {
                for (LevelAndCount levelAndCount : problemLevels) {
                    SimpleTextAttributes attrs = SimpleTextAttributes.GRAY_ATTRIBUTES;
                    attrs = attrs.derive(-1, (Color)(levelAndCount.getLevel() == HighlightDisplayLevel.ERROR && !this.myContext.getUIOptions().GROUP_BY_SEVERITY ? TREE_RED : TREE_GRAY), null, null);
                    this.appendText(levelAndCount.getLevel().getSeverity().getCountMessage(levelAndCount.getCount()) + " ", attrs);
                }
            }
        }
    }

    protected abstract void appendText(@Nls String var1, SimpleTextAttributes var2) throws E;

    protected abstract void appendText(@Nls String var1) throws E;
}

