/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeLoadingProgressAware;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class InspectionViewNavigationPanel
extends JPanel
implements InspectionTreeLoadingProgressAware {
    private final InspectionTreeNode myNode;
    private final InspectionTree myTree;
    private final JPanel myLinks;
    private int myShownChildrenCount;

    public InspectionViewNavigationPanel(InspectionTreeNode node2, InspectionTree tree) {
        this.myNode = node2;
        this.myTree = tree;
        this.setLayout(new BorderLayout());
        this.setBorder(JBUI.Borders.empty(18, 12, 0, 0));
        String titleLabelText = InspectionViewNavigationPanel.getTitleText(true);
        this.add((Component)new JBLabel(titleLabelText), "North");
        this.myLinks = new JPanel();
        this.myLinks.setLayout(new BoxLayout(this.myLinks, 1));
        this.add("Center", this.myLinks);
        this.resetChildrenNavigation();
    }

    @Override
    public void updateLoadingProgress() {
        this.resetChildrenAndRepaint();
    }

    @Override
    public void treeLoaded() {
        this.resetChildrenAndRepaint();
    }

    @NotNull
    @Nls
    public static String getTitleText(boolean addColon) {
        if (addColon) {
            String string2 = InspectionsBundle.message("inspections.view.select.inspection.label", new Object[0]);
            if (string2 == null) {
                InspectionViewNavigationPanel.$$$reportNull$$$0(0);
            }
            return string2;
        }
        String string3 = InspectionsBundle.message("inspections.view.nothing.message", new Object[0]);
        if (string3 == null) {
            InspectionViewNavigationPanel.$$$reportNull$$$0(1);
        }
        return string3;
    }

    private void resetChildrenNavigation() {
        int currentChildrenCount = this.myNode.getChildCount();
        if (this.myShownChildrenCount != currentChildrenCount) {
            this.myLinks.removeAll();
            this.myLinks.add(Box.createVerticalStrut(JBUIScale.scale(10)));
            for (int i2 = 0; i2 < currentChildrenCount; ++i2) {
                final InspectionTreeNode child = this.myNode.getChildAt(i2);
                LinkLabel link = new LinkLabel(child.getPresentableText(), null){

                    public void doClick() {
                        InspectionViewNavigationPanel.this.myTree.selectNode(child);
                    }
                };
                link.setBorder((Border)JBUI.Borders.empty(1, 17, 3, 1));
                this.myLinks.add((Component)link);
            }
            this.myShownChildrenCount = currentChildrenCount;
        }
    }

    private void resetChildrenAndRepaint() {
        this.resetChildrenNavigation();
        this.revalidate();
        this.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionViewNavigationPanel", "getTitleText"));
    }
}

