/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ui.InspectionOptionsPanel;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListEditForm {
    JPanel contentPanel;
    ListTable table;
    @Nullable
    private final @Nullable Function<@NotNull Project, @Nullable String> myNewElementSupplier;

    public ListEditForm(@NlsContexts.ColumnName String title, List<String> stringList) {
        this.table = new ListTable(new ListWrappingTableModel(stringList, title));
        this.myNewElementSupplier = null;
        this.contentPanel = this.setupActions(ToolbarDecorator.createDecorator((JTable)((Object)this.table)), "").createPanel();
    }

    public ListEditForm(@NlsContexts.ColumnName String title, @NlsContexts.Label String label2, List<String> stringList) {
        this(title, label2, stringList, "");
    }

    public ListEditForm(@NlsContexts.ColumnName String title, @NlsContexts.Label String label2, List<String> stringList, @NotNull String defaultElement) {
        if (defaultElement == null) {
            ListEditForm.$$$reportNull$$$0(0);
        }
        this(title, label2, stringList, defaultElement, null);
    }

    public ListEditForm(@NlsContexts.ColumnName String title, @NlsContexts.Label String label2, List<String> stringList, @NotNull String defaultElement, @Nullable @Nullable Function<@NotNull Project, @Nullable String> newElementSupplier) {
        if (defaultElement == null) {
            ListEditForm.$$$reportNull$$$0(1);
        }
        this.table = new ListTable(new ListWrappingTableModel(stringList, title));
        this.myNewElementSupplier = newElementSupplier;
        this.table.setTableHeader(null);
        this.table.setShowHorizontalLines(false);
        this.contentPanel = this.setupActions(ToolbarDecorator.createDecorator((JTable)((Object)this.table)), defaultElement).setToolbarPosition(ActionToolbarPosition.LEFT).createPanel();
        this.contentPanel = UI.PanelFactory.panel((JComponent)this.contentPanel).withLabel(label2).moveLabelOnTop().resizeY(true).createPanel();
        this.contentPanel.setMinimumSize(InspectionOptionsPanel.getMinimumListSize());
    }

    @NotNull
    private ToolbarDecorator setupActions(@NotNull ToolbarDecorator decorator, final @NotNull String defaultElement) {
        if (decorator == null) {
            ListEditForm.$$$reportNull$$$0(2);
        }
        if (defaultElement == null) {
            ListEditForm.$$$reportNull$$$0(3);
        }
        ToolbarDecorator toolbarDecorator = decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                if (ListEditForm.this.myNewElementSupplier != null) {
                    DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)((Object)ListEditForm.this.table));
                    Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
                    ListWrappingTableModel tableModel = ListEditForm.this.table.getModel();
                    if (project2 != null) {
                        int rowIndex;
                        String newElement = ListEditForm.this.myNewElementSupplier.apply(project2);
                        if (newElement == null) {
                            return;
                        }
                        int index2 = tableModel.indexOf(newElement, 0);
                        if (index2 < 0) {
                            tableModel.addRow(newElement);
                            rowIndex = tableModel.getRowCount() - 1;
                        } else {
                            rowIndex = index2;
                        }
                        ListEditForm.this.table.setRowSelectionInterval(rowIndex, rowIndex);
                        return;
                    }
                }
                ListWrappingTableModel tableModel = ListEditForm.this.table.getModel();
                tableModel.addRow(defaultElement);
                EventQueue.invokeLater(() -> {
                    int lastRowIndex = tableModel.getRowCount() - 1;
                    Rectangle rectangle = ListEditForm.this.table.getCellRect(lastRowIndex, 0, true);
                    ListEditForm.this.table.scrollRectToVisible(rectangle);
                    ListEditForm.this.table.editCellAt(lastRowIndex, 0);
                    ListSelectionModel selectionModel = ListEditForm.this.table.getSelectionModel();
                    selectionModel.setSelectionInterval(lastRowIndex, lastRowIndex);
                    TableCellEditor editor2 = ListEditForm.this.table.getCellEditor();
                    Component component2 = editor2.getTableCellEditorComponent((JTable)((Object)ListEditForm.this.table), defaultElement, true, lastRowIndex, 0);
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(component2, true));
                });
            }
        }).setRemoveAction(button2 -> TableUtil.removeSelectedItems((JTable)((Object)this.table))).disableUpDownActions();
        if (toolbarDecorator == null) {
            ListEditForm.$$$reportNull$$$0(4);
        }
        return toolbarDecorator;
    }

    public JComponent getContentPanel() {
        return this.contentPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/ListEditForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/ListEditForm";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setupActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupActions";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }
}

