/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Interner;
import com.intellij.xml.util.XmlStringUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptionNode
extends SuppressableInspectionTreeNode {
    private final CommonProblemDescriptor myDescriptor;
    private final HighlightDisplayLevel myLevel;
    protected final int myLineNumber;
    protected final RefEntity myElement;
    @Nullable
    private String myMessage;
    private static final Interner<String> NAME_INTERNER = Interner.createWeakInterner();

    public ProblemDescriptionNode(RefEntity element, @NotNull CommonProblemDescriptor descriptor2, @NotNull InspectionToolPresentation presentation2, @NotNull InspectionTreeNode parent2) {
        if (descriptor2 == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(0);
        }
        if (presentation2 == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(1);
        }
        if (parent2 == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(2);
        }
        this(element, descriptor2, presentation2, null, parent2);
    }

    protected ProblemDescriptionNode(@Nullable RefEntity element, CommonProblemDescriptor descriptor2, @NotNull InspectionToolPresentation presentation2, @Nullable IntSupplier lineNumberCounter, @NotNull InspectionTreeNode parent2) {
        if (presentation2 == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(3);
        }
        if (parent2 == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(4);
        }
        super(presentation2, parent2);
        this.myMessage = null;
        this.myElement = element;
        this.myDescriptor = descriptor2;
        this.myLevel = ObjectUtils.notNull(ProblemDescriptionNode.calculatePreciseLevel(element, descriptor2, presentation2), () -> {
            String shortName = presentation2.getToolWrapper().getShortName();
            InspectionProfileImpl profile = presentation2.getContext().getCurrentProfile();
            return profile.getTools(shortName, presentation2.getContext().getProject()).getLevel();
        });
        this.myLineNumber = this.myDescriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)this.myDescriptor).getLineNumber() : (lineNumberCounter == null ? -1 : lineNumberCounter.getAsInt());
    }

    private static HighlightDisplayLevel calculatePreciseLevel(@Nullable RefEntity element, @Nullable CommonProblemDescriptor descriptor2, @NotNull InspectionToolPresentation presentation2) {
        if (presentation2 == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(5);
        }
        if (element == null) {
            return null;
        }
        InspectionProfileImpl profile = presentation2.getContext().getCurrentProfile();
        String shortName = presentation2.getToolWrapper().getShortName();
        if (descriptor2 instanceof ProblemDescriptor) {
            BaseInspectionProfileManager inspectionProfileManager = profile.getProfileManager();
            RefElement refElement = (RefElement)element;
            SeverityRegistrar severityRegistrar = inspectionProfileManager.getSeverityRegistrar();
            HighlightSeverity severity = presentation2.getSeverity(refElement);
            if (severity == null) {
                return null;
            }
            HighlightInfoType highlightInfoType = ProblemDescriptorUtil.highlightTypeFromDescriptor((ProblemDescriptor)descriptor2, severity, severityRegistrar);
            HighlightSeverity highlightSeverity = highlightInfoType.getSeverity(refElement.getPsiElement());
            return HighlightDisplayLevel.find(highlightSeverity);
        }
        return profile.getTools(shortName, presentation2.getContext().getProject()).getLevel();
    }

    public boolean needCalculateTooltip() {
        return this.myMessage == null;
    }

    @Nullable
    public String getToolTipText() {
        if (!this.isValid()) {
            return null;
        }
        if (this.myMessage != null) {
            return this.myMessage;
        }
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 == null) {
            return null;
        }
        PsiElement element = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getPsiElement() : null;
        String message = ProblemDescriptorUtil.renderDescriptor(descriptor2, element, 0).getTooltip();
        this.myMessage = XmlStringUtil.isWrappedInHtml(message) ? message : XmlStringUtil.wrapInHtml(XmlStringUtil.escapeString(message));
        return this.myMessage;
    }

    @Override
    public final boolean isAlreadySuppressedFromView() {
        return this.myDescriptor != null && this.getPresentation().isSuppressed(this.myDescriptor);
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    @Override
    public boolean canSuppress() {
        return super.canSuppress() && !this.isQuickFixAppliedFromView();
    }

    @NotNull
    public InspectionToolWrapper<?, ?> getToolWrapper() {
        InspectionToolWrapper<?, ?> inspectionToolWrapper = this.getPresentation().getToolWrapper();
        if (inspectionToolWrapper == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(6);
        }
        return inspectionToolWrapper;
    }

    @Override
    @Nullable
    public RefEntity getElement() {
        return this.myElement;
    }

    @Nullable
    public CommonProblemDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    public void excludeElement() {
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 != null) {
            this.getPresentation().exclude(descriptor2);
        }
    }

    @Override
    public void amnestyElement() {
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 != null) {
            this.getPresentation().amnesty(descriptor2);
        }
    }

    @Override
    protected void visitProblemSeverities(@NotNull Object2IntMap<HighlightDisplayLevel> counter) {
        if (counter == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(7);
        }
        if (this.isValid() && !this.isExcluded() && !this.isQuickFixAppliedFromView() && !this.isAlreadySuppressedFromView()) {
            counter.put(this.myLevel, counter.getInt(this.myLevel) + 1);
        }
    }

    @Override
    protected boolean calculateIsValid() {
        if (this.myDescriptor == null) {
            return false;
        }
        if (this.myElement == null || !this.myElement.isValid()) {
            return false;
        }
        if (this.myDescriptor instanceof ProblemDescriptor) {
            PsiElement psiElement = ((ProblemDescriptor)this.myDescriptor).getPsiElement();
            return psiElement != null && psiElement.isValid();
        }
        return true;
    }

    @Override
    public boolean isExcluded() {
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        return descriptor2 != null && this.getPresentation().isExcluded(descriptor2);
    }

    @Override
    @NotNull
    protected String calculatePresentableName() {
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 == null) {
            return "";
        }
        PsiElement element = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getPsiElement() : null;
        String name = ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element, 4);
        String string2 = NAME_INTERNER.intern(name);
        if (string2 == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Override
    public boolean isQuickFixAppliedFromView() {
        return this.myDescriptor != null && this.getPresentation().isProblemResolved(this.myDescriptor) && !this.isAlreadySuppressedFromView();
    }

    @Override
    @Nullable
    public String getTailText() {
        String text2 = super.getTailText();
        return text2 == null ? "" : text2;
    }

    @Override
    @NotNull
    public Pair<PsiElement, CommonProblemDescriptor> getSuppressContent() {
        RefEntity refElement = this.getElement();
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        PsiElement element = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getPsiElement() : (refElement instanceof RefElement ? ((RefElement)refElement).getPsiElement() : null);
        Pair<PsiElement, CommonProblemDescriptor> pair = Pair.create(element, descriptor2);
        if (pair == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(9);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/ProblemDescriptionNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/ProblemDescriptionNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWrapper";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePresentableName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculatePreciseLevel";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitProblemSeverities";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 8, 9 -> new IllegalStateException(string2);
        };
    }
}

