/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.PreviewEditorFoldingRegion;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class ProblemPreviewEditorPresentation {
    private static final int VIEW_ADDITIONAL_OFFSET = 4;
    private static final int SHOWN_LINES_COUNT = 2;

    static void setupFoldingsAndHighlightProblems(@NotNull EditorEx editor2, @NotNull InspectionResultsView view) {
        if (editor2 == null) {
            ProblemPreviewEditorPresentation.$$$reportNull$$$0(0);
        }
        if (view == null) {
            ProblemPreviewEditorPresentation.$$$reportNull$$$0(1);
        }
        List usages = Arrays.stream(view.getTree().getAllValidSelectedDescriptors()).filter(ProblemDescriptorBase.class::isInstance).map(ProblemDescriptorBase.class::cast).map(d -> {
            PsiElement psi = d.getPsiElement();
            if (psi == null) {
                return null;
            }
            TextRange range = d.getTextRangeInElement();
            return range == null ? new UsageInfo(psi) : new UsageInfo(psi, range.getStartOffset(), range.getEndOffset());
        }).collect(Collectors.toList());
        ProblemPreviewEditorPresentation.setupFoldingsAndHighlightProblems(editor2, view, usages, view.getProject());
    }

    public static void setupFoldingsAndHighlightProblems(@NotNull EditorEx editor2, @NotNull Container editorContainer, @NotNull List<? extends UsageInfo> usages, @NotNull Project project2) {
        if (editor2 == null) {
            ProblemPreviewEditorPresentation.$$$reportNull$$$0(2);
        }
        if (editorContainer == null) {
            ProblemPreviewEditorPresentation.$$$reportNull$$$0(3);
        }
        if (usages == null) {
            ProblemPreviewEditorPresentation.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            ProblemPreviewEditorPresentation.$$$reportNull$$$0(5);
        }
        DocumentEx doc = editor2.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(project2);
        if (documentManager.isUncommited(doc)) {
            WriteAction.run(() -> documentManager.commitDocument(doc));
        }
        if (usages.size() > 1) {
            TreeSet<PreviewEditorFoldingRegion> foldingRegions = new TreeSet<PreviewEditorFoldingRegion>();
            foldingRegions.add(new PreviewEditorFoldingRegion(0, doc.getLineCount()));
            boolean isUpdated = false;
            for (UsageInfo usageInfo : usages) {
                if (usageInfo == null) {
                    return;
                }
                PsiElement element = usageInfo.getElement();
                Segment segment = usageInfo.getSegment();
                assert (element != null);
                isUpdated |= ProblemPreviewEditorPresentation.makeVisible(foldingRegions, injectedLanguageManager.injectedToHost(element, segment != null ? TextRange.create(segment) : element.getTextRange()), doc);
            }
            if (isUpdated) {
                ProblemPreviewEditorPresentation.setupFoldings(editor2, foldingRegions);
            }
        }
        ProblemPreviewEditorPresentation.highlightProblems(editor2, editorContainer, usages, project2);
    }

    private static void highlightProblems(EditorEx editor2, Container editorContainer, List<? extends UsageInfo> usages, @NotNull Project project2) {
        if (project2 == null) {
            ProblemPreviewEditorPresentation.$$$reportNull$$$0(6);
        }
        List<UsageInfo> validUsages = ContainerUtil.filter(usages, Objects::nonNull);
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(project2);
        PsiDocumentManager.getInstance(project2).performLaterWhenAllCommitted(() -> {
            if (!editor2.isDisposed()) {
                editorContainer.invalidate();
                editorContainer.validate();
                UsagePreviewPanel.highlight((List)validUsages, (Editor)editor2, (Project)project2, (boolean)false, (int)6000);
                if (validUsages.size() == 1) {
                    UsageInfo usage2 = (UsageInfo)validUsages.get(0);
                    PsiElement element = usage2.getElement();
                    Segment range = usage2.getNavigationRange();
                    if (element != null && range != null) {
                        if (injectedLanguageManager.getInjectionHost(element) != null) {
                            range = injectedLanguageManager.injectedToHost(element, TextRange.create(range));
                        }
                        DocumentEx document = editor2.getDocument();
                        int offset2 = Math.min(range.getEndOffset() + 4, document.getLineEndOffset(document.getLineNumber(range.getEndOffset())));
                        editor2.getScrollingModel().scrollTo(editor2.offsetToLogicalPosition(offset2), ScrollType.CENTER);
                        return;
                    }
                }
                editor2.getScrollingModel().scrollTo(editor2.offsetToLogicalPosition(0), ScrollType.CENTER_UP);
            }
        });
    }

    public static void setupFoldings(EditorEx editor2, SortedSet<? extends PreviewEditorFoldingRegion> foldingRegions) {
        editor2.getFoldingModel().runBatchFoldingOperation(() -> {
            editor2.getFoldingModel().clearFoldRegions();
            editor2.getMarkupModel().removeAllHighlighters();
            for (PreviewEditorFoldingRegion region : foldingRegions) {
                FoldRegion currentRegion;
                if (region.getEndLine() - region.getStartLine() <= 1 || (currentRegion = FoldingModelSupport.addFolding((EditorEx)editor2, (int)region.getStartLine(), (int)region.getEndLine(), (boolean)false)) == null) continue;
                DiffDrawUtil.createLineSeparatorHighlighter((Editor)editor2, (int)editor2.getDocument().getLineStartOffset(region.getStartLine()), (int)editor2.getDocument().getLineEndOffset(region.getEndLine() - 1), () -> currentRegion.isValid() && !currentRegion.isExpanded());
            }
        });
    }

    private static boolean makeVisible(SortedSet<PreviewEditorFoldingRegion> foldingRegions, Segment toShowRange, Document document) {
        if (toShowRange == null) {
            return false;
        }
        boolean isUpdated = false;
        int startLine = Math.max(0, document.getLineNumber(toShowRange.getStartOffset()) - 2);
        int endLine = Math.min(document.getLineCount(), document.getLineNumber(toShowRange.getEndOffset()) + 2 + 1);
        for (PreviewEditorFoldingRegion range : new ArrayList<PreviewEditorFoldingRegion>(foldingRegions)) {
            boolean startInRegion = range.contain(startLine);
            boolean endInRegion = range.contain(endLine);
            if (startInRegion && endInRegion) {
                foldingRegions.remove(range);
                if (range.getStartLine() != startLine) {
                    foldingRegions.add(new PreviewEditorFoldingRegion(range.getStartLine(), startLine));
                }
                if (endLine != range.getEndLine()) {
                    foldingRegions.add(new PreviewEditorFoldingRegion(endLine, range.getEndLine()));
                }
                return true;
            }
            if (startInRegion) {
                foldingRegions.remove(range);
                if (range.getStartLine() != startLine) {
                    foldingRegions.add(new PreviewEditorFoldingRegion(range.getStartLine(), startLine));
                }
                isUpdated = true;
            }
            if (!endInRegion) continue;
            foldingRegions.remove(range);
            if (endLine != range.getEndLine()) {
                foldingRegions.add(new PreviewEditorFoldingRegion(endLine, range.getEndLine()));
            }
            return true;
        }
        return isUpdated;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorContainer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ui/ProblemPreviewEditorPresentation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupFoldingsAndHighlightProblems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightProblems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

