/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeLoadingProgressAware;
import com.intellij.codeInspection.ui.actions.suppress.SuppressActionWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DefaultCompactActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QuickFixPreviewPanelFactory {
    private static final Logger LOG = Logger.getInstance(QuickFixPreviewPanelFactory.class);
    private static final int MAX_FIX_COUNT = 3;

    @Nullable
    public static JComponent create(@NotNull InspectionResultsView view) {
        if (view == null) {
            QuickFixPreviewPanelFactory.$$$reportNull$$$0(0);
        }
        if (view.isUpdating() && !view.getTree().areDescriptorNodesSelected()) {
            return new LoadingInProgressPreview(view);
        }
        QuickFixReadyPanel panel2 = new QuickFixReadyPanel(view);
        return panel2.isEmpty() ? null : panel2;
    }

    @NotNull
    private static SimpleColoredComponent getLabel(int problemsCount) {
        SimpleColoredComponent label2 = new SimpleColoredComponent();
        QuickFixPreviewPanelFactory.appendTextToLabel(label2, problemsCount);
        label2.setBorder((Border)JBUI.Borders.emptyRight(2));
        SimpleColoredComponent simpleColoredComponent = label2;
        if (simpleColoredComponent == null) {
            QuickFixPreviewPanelFactory.$$$reportNull$$$0(1);
        }
        return simpleColoredComponent;
    }

    private static void appendTextToLabel(SimpleColoredComponent label2, int problemsCount) {
        label2.append(LangBundle.message("label.n.problems", problemsCount));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    private static final class LoadingInProgressPreview
    extends JPanel
    implements InspectionTreeLoadingProgressAware {
        private final InspectionResultsView myView;
        private final SimpleColoredComponent myWaitingLabel;

        private LoadingInProgressPreview(InspectionResultsView view) {
            this.myView = view;
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder(JBUI.Borders.empty(16, 9, 13, 0));
            AsyncProcessIcon waitingIcon = new AsyncProcessIcon("Inspection preview panel updating...");
            Disposer.register(this, (Disposable)waitingIcon);
            this.myWaitingLabel = QuickFixPreviewPanelFactory.getLabel(this.myView.getTree().getSelectedProblemCount());
            this.add((Component)this.myWaitingLabel);
            this.add((Component)waitingIcon);
        }

        @Override
        public void updateLoadingProgress() {
            if (this.myWaitingLabel != null) {
                this.myWaitingLabel.clear();
                InspectionTree tree = this.myView.getTree();
                QuickFixPreviewPanelFactory.appendTextToLabel(this.myWaitingLabel, tree.getSelectedProblemCount());
            }
        }

        @Override
        public void treeLoaded() {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myView.isDisposed()) {
                    this.myView.syncRightPanel();
                }
            });
        }
    }

    private static class QuickFixReadyPanel
    extends JPanel {
        @NotNull
        private final InspectionResultsView myView;
        private final InspectionToolWrapper myWrapper;
        private final boolean myEmpty;

        QuickFixReadyPanel(@NotNull InspectionResultsView view) {
            if (view == null) {
                QuickFixReadyPanel.$$$reportNull$$$0(0);
            }
            this.myView = view;
            InspectionTree tree = view.getTree();
            this.myWrapper = tree.getSelectedToolWrapper(true);
            LOG.assertTrue(this.myWrapper != null);
            QuickFixAction[] commonFixes = view.getProvider().getCommonQuickFixes(this.myWrapper, tree, tree.getSelectedDescriptors(), tree.getSelectedElements());
            boolean multipleDescriptors = this.myView.getTree().getSelectedDescriptors().length > 1;
            QuickFixAction[] partialFixes = QuickFixAction.EMPTY;
            if (multipleDescriptors && commonFixes.length == 0) {
                partialFixes = view.getProvider().getPartialQuickFixes(this.myWrapper, tree, tree.getSelectedDescriptors());
            }
            this.myEmpty = this.fillPanel(commonFixes, partialFixes, multipleDescriptors, view);
        }

        public boolean isEmpty() {
            return this.myEmpty;
        }

        private boolean fillPanel(QuickFixAction @NotNull [] fixes, QuickFixAction @NotNull [] partialFixes, boolean multipleDescriptors, @NotNull InspectionResultsView view) {
            AnAction suppressionCombo;
            int actualProblemCount;
            if (view == null) {
                QuickFixReadyPanel.$$$reportNull$$$0(1);
            }
            if (fixes == null) {
                QuickFixReadyPanel.$$$reportNull$$$0(2);
            }
            if (partialFixes == null) {
                QuickFixReadyPanel.$$$reportNull$$$0(3);
            }
            boolean hasFixes = fixes.length != 0;
            this.setLayout(new FlowLayout(0, 0, 0));
            boolean hasComponents = false;
            InspectionTree tree = this.myView.getTree();
            InspectionToolResultExporter presentation2 = tree.getContext().getPresentation(this.myWrapper);
            boolean showProblemCount = presentation2.showProblemCount();
            if (showProblemCount && ((actualProblemCount = tree.getSelectedProblemCount()) > 1 || actualProblemCount == 1 && multipleDescriptors)) {
                this.add((Component)QuickFixPreviewPanelFactory.getLabel(actualProblemCount));
                hasComponents = true;
            }
            DefaultActionGroup actions = new DefaultActionGroup();
            if (hasFixes) {
                actions.addAll(QuickFixReadyPanel.createFixActions(fixes, multipleDescriptors));
            }
            if ((suppressionCombo = QuickFixReadyPanel.createSuppressionCombo(this.myView)) != null) {
                actions.add(suppressionCombo);
            }
            if (partialFixes.length != 0) {
                actions.add(QuickFixReadyPanel.createPartialFixCombo(partialFixes));
            }
            if (actions.getChildrenCount() != 0) {
                view.setFixesAvailable(true);
                ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("inspection.view.quick.fix.preview", (ActionGroup)actions, true);
                JComponent component2 = toolbar.getComponent();
                toolbar.setTargetComponent((JComponent)view);
                this.add(component2);
                hasComponents = true;
            }
            if (hasComponents) {
                int top = hasFixes ? 2 : 9;
                int left = hasFixes || multipleDescriptors ? 8 : 5;
                int bottom = hasFixes ? 0 : 8;
                this.setBorder(JBUI.Borders.empty(top, left, bottom, 0));
            }
            return !hasComponents;
        }

        @NotNull
        private static AnAction createPartialFixCombo(QuickFixAction[] fixes) {
            final DefaultActionGroup group2 = new DefaultActionGroup();
            for (QuickFixAction fix2 : fixes) {
                group2.add((AnAction)fix2);
            }
            return new ComboBoxAction(){
                {
                    this.getTemplatePresentation().setText(CodeInsightBundle.messagePointer("action.presentation.QuickFixPreviewPanelFactory.text", new Object[0]));
                    this.setSmallVariant(false);
                }

                @NotNull
                protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2, @NotNull DataContext context2) {
                    if (button2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (context2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    DefaultActionGroup defaultActionGroup = group2;
                    if (defaultActionGroup == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return defaultActionGroup;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "button";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createPopupActionGroup";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createPopupActionGroup";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string2);
                        case 2 -> new IllegalStateException(string2);
                    };
                }
            };
        }

        @Nullable
        private static AnAction createSuppressionCombo(InspectionResultsView view) {
            AnActionEvent event = AnActionEvent.createFromDataContext((String)"CodeInspection", null, (DataContext)DataManager.getInstance().getDataContext((Component)view));
            AnAction[] suppressors = new SuppressActionWrapper().getChildren(event);
            final AnAction[] availableSuppressors = (AnAction[])Arrays.stream(suppressors).filter(s -> {
                event.getPresentation().setEnabled(false);
                s.update(event);
                return event.getPresentation().isEnabled();
            }).toArray(AnAction[]::new);
            if (availableSuppressors.length == 0) {
                return null;
            }
            ComboBoxAction action2 = new ComboBoxAction(){
                {
                    this.getTemplatePresentation().setText(CodeInsightBundle.messagePointer("action.presentation.QuickFixPreviewPanelFactory.text.suppress", new Object[0]));
                }

                @NotNull
                protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2, @NotNull DataContext context2) {
                    if (button2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (context2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    DefaultCompactActionGroup group2 = new DefaultCompactActionGroup();
                    group2.addAll(availableSuppressors);
                    DefaultCompactActionGroup defaultCompactActionGroup = group2;
                    if (defaultCompactActionGroup == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return defaultCompactActionGroup;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "button";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel$2";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createPopupActionGroup";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createPopupActionGroup";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string2);
                        case 2 -> new IllegalStateException(string2);
                    };
                }
            };
            action2.setSmallVariant(false);
            return action2;
        }

        private static AnAction @NotNull [] createFixActions(final QuickFixAction[] fixes, final boolean multipleDescriptors) {
            if (fixes.length > 3) {
                ComboBoxAction fixComboBox = new ComboBoxAction(){
                    {
                        if (multipleDescriptors) {
                            this.getTemplatePresentation().setText(InspectionsBundle.message("apply.quick.fixes.to.all.action.text", new Object[0]));
                        } else {
                            this.getTemplatePresentation().setText(InspectionsBundle.message("apply.quick.fixes.action.text", new Object[0]));
                        }
                        this.getTemplatePresentation().setIcon(AllIcons.Actions.IntentionBulb);
                        this.setSmallVariant(false);
                    }

                    @NotNull
                    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2, @NotNull DataContext context2) {
                        if (button2 == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (context2 == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
                        for (QuickFixAction fix2 : fixes) {
                            actionGroup2.add((AnAction)fix2);
                        }
                        DefaultActionGroup defaultActionGroup = actionGroup2;
                        if (defaultActionGroup == null) {
                            3.$$$reportNull$$$0(2);
                        }
                        return defaultActionGroup;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 2 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "button";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "context";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel$3";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel$3";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createPopupActionGroup";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "createPopupActionGroup";
                                break;
                            }
                            case 2: {
                                break;
                            }
                        }
                        String string2 = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string2);
                            case 2 -> new IllegalStateException(string2);
                        };
                    }
                };
                AnAction[] anActionArray = new AnAction[]{fixComboBox};
                if (anActionArray == null) {
                    QuickFixReadyPanel.$$$reportNull$$$0(4);
                }
                return anActionArray;
            }
            if (fixes == null) {
                QuickFixReadyPanel.$$$reportNull$$$0(5);
            }
            return fixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "partialFixes";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFixActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fillPanel";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4, 5 -> new IllegalStateException(string2);
            };
        }
    }
}

