/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefElementNode
extends SuppressableInspectionTreeNode {
    private final Icon myIcon;
    @Nullable
    private final RefEntity myRefEntity;

    public RefElementNode(@Nullable RefEntity refEntity, @NotNull InspectionToolPresentation presentation2, @NotNull InspectionTreeNode parent2) {
        if (presentation2 == null) {
            RefElementNode.$$$reportNull$$$0(0);
        }
        if (parent2 == null) {
            RefElementNode.$$$reportNull$$$0(1);
        }
        super(presentation2, parent2);
        this.myRefEntity = refEntity;
        this.myIcon = refEntity == null ? null : refEntity.getIcon(false);
    }

    @Override
    public final boolean isAlreadySuppressedFromView() {
        return this.getElement() != null && this.getPresentation().isSuppressed(this.getElement());
    }

    @Override
    @Nullable
    public RefEntity getElement() {
        return this.myRefEntity;
    }

    @Override
    @Nullable
    public Icon getIcon(boolean expanded) {
        return this.myIcon;
    }

    @Override
    protected String calculatePresentableName() {
        RefEntity element = this.getElement();
        if (element == null) {
            return AnalysisBundle.message("inspection.reference.invalid", new Object[0]);
        }
        return element.getRefManager().getRefinedElement(element).getName();
    }

    @Override
    protected boolean calculateIsValid() {
        RefEntity refEntity = this.getElement();
        return refEntity != null && refEntity.isValid();
    }

    @Override
    public boolean isExcluded() {
        RefEntity element = this.getElement();
        if (this.isLeaf() && element != null) {
            return this.getPresentation().isExcluded(element);
        }
        return super.isExcluded();
    }

    @Override
    public void excludeElement() {
        RefEntity element = this.getElement();
        if (this.isLeaf() && element != null) {
            this.getPresentation().exclude(element);
            return;
        }
        super.excludeElement();
    }

    @Override
    public void amnestyElement() {
        RefEntity element = this.getElement();
        if (this.isLeaf() && element != null) {
            this.getPresentation().amnesty(element);
            return;
        }
        super.amnestyElement();
    }

    @Override
    public RefEntity getContainingFileLocalEntity() {
        RefEntity element = this.getElement();
        return element instanceof RefElement && !(element instanceof RefDirectory) ? element : super.getContainingFileLocalEntity();
    }

    @Override
    public boolean isQuickFixAppliedFromView() {
        return this.isLeaf() && this.getPresentation().isProblemResolved(this.getElement());
    }

    @Override
    @Nullable
    public String getTailText() {
        if (this.getPresentation().isDummy()) {
            return "";
        }
        String customizedText = super.getTailText();
        if (customizedText != null) {
            return customizedText;
        }
        return this.isLeaf() ? "" : null;
    }

    @Override
    @NotNull
    public Pair<PsiElement, CommonProblemDescriptor> getSuppressContent() {
        RefEntity refElement = this.getElement();
        PsiElement element = refElement instanceof RefElement ? ((RefElement)refElement).getPsiElement() : null;
        Pair<PsiElement, Object> pair = Pair.create(element, null);
        if (pair == null) {
            RefElementNode.$$$reportNull$$$0(2);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/RefElementNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/RefElementNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

