/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.InspectionOptionsPanel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.DocumentAdapter;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.NumberFormatter;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SingleIntegerFieldOptionsPanel
extends InspectionOptionsPanel {
    public SingleIntegerFieldOptionsPanel(@NlsContexts.Label String labelString, InspectionProfileEntry owner, @Language(value="jvm-field-name") @NonNls String property) {
        this(labelString, owner, property, 4);
    }

    public SingleIntegerFieldOptionsPanel(@NlsContexts.Label String labelString, InspectionProfileEntry owner, @Language(value="jvm-field-name") @NonNls String property, int integerFieldColumns) {
        super(owner);
        JLabel label2 = new JLabel(labelString);
        JFormattedTextField valueField = SingleIntegerFieldOptionsPanel.createIntegerFieldTrackingValue(owner, property, integerFieldColumns);
        this.addRow(label2, valueField);
    }

    public static JFormattedTextField createIntegerFieldTrackingValue(@NotNull InspectionProfileEntry owner, @Language(value="jvm-field-name") @NotNull String property, int integerFieldColumns) {
        if (owner == null) {
            SingleIntegerFieldOptionsPanel.$$$reportNull$$$0(0);
        }
        if (property == null) {
            SingleIntegerFieldOptionsPanel.$$$reportNull$$$0(1);
        }
        JFormattedTextField valueField = new JFormattedTextField();
        valueField.setColumns(integerFieldColumns);
        SingleIntegerFieldOptionsPanel.setupIntegerFieldTrackingValue(valueField, owner, property);
        return valueField;
    }

    public static void setupIntegerFieldTrackingValue(final JFormattedTextField textField, final InspectionProfileEntry owner, final @Language(value="jvm-field-name") String property) {
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        formatter.setParseIntegerOnly(true);
        textField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(formatter)));
        textField.setValue(SingleIntegerFieldOptionsPanel.getPropertyValue(owner, property));
        Document document = textField.getDocument();
        document.addDocumentListener(new DocumentAdapter(){

            @Override
            public void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    textField.commitEdit();
                    SingleIntegerFieldOptionsPanel.setPropertyValue(owner, property, ((Number)textField.getValue()).intValue());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/ui/SingleIntegerFieldOptionsPanel$1", "textChanged"));
            }
        });
    }

    private static void setPropertyValue(InspectionProfileEntry owner, String property, int value) {
        try {
            owner.getClass().getField(property).setInt(owner, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int getPropertyValue(InspectionProfileEntry owner, String property) {
        try {
            return owner.getClass().getField(property).getInt(owner);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "owner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "property";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/ui/SingleIntegerFieldOptionsPanel";
        objectArray[2] = "createIntegerFieldTrackingValue";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

