/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionViewSuppressActionHolder;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.HashSetInterner;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.Interner;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SuppressableInspectionTreeNode
extends InspectionTreeNode {
    @NotNull
    private final InspectionToolPresentation myPresentation;
    private volatile Set<SuppressIntentionAction> myAvailableSuppressActions;
    @Nls
    private volatile String myPresentableName;
    private volatile Boolean myValid;
    private volatile NodeState myPreviousState;

    SuppressableInspectionTreeNode(@NotNull InspectionToolPresentation presentation2, @NotNull InspectionTreeNode parent2) {
        if (presentation2 == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(0);
        }
        if (parent2 == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(1);
        }
        super(parent2);
        this.myPresentation = presentation2;
    }

    void nodeAdded() {
        super.dropProblemCountCaches();
        ReadAction.run(() -> {
            this.myValid = this.calculateIsValid();
        });
        this.getProblemLevels();
    }

    @Override
    protected boolean doesNeedInternProblemLevels() {
        return true;
    }

    @NotNull
    public InspectionToolPresentation getPresentation() {
        InspectionToolPresentation inspectionToolPresentation = this.myPresentation;
        if (inspectionToolPresentation == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(2);
        }
        return inspectionToolPresentation;
    }

    public boolean canSuppress() {
        return this.getChildren().isEmpty();
    }

    public abstract boolean isAlreadySuppressedFromView();

    public abstract boolean isQuickFixAppliedFromView();

    @Override
    void dropProblemCountCaches() {
        super.dropProblemCountCaches();
        NodeState currentState = this.calculateState();
        if (!currentState.equals(this.myPreviousState)) {
            this.myPreviousState = currentState;
        }
    }

    @NotNull
    public synchronized Set<SuppressIntentionAction> getAvailableSuppressActions() {
        if (this.myAvailableSuppressActions == null) {
            this.updateAvailableSuppressActions();
        }
        Set<SuppressIntentionAction> set2 = this.myAvailableSuppressActions;
        if (set2 == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(3);
        }
        return set2;
    }

    public void updateAvailableSuppressActions() {
        this.myAvailableSuppressActions = this.calculateAvailableSuppressActions();
    }

    public void removeSuppressActionFromAvailable(@NotNull SuppressIntentionAction action2) {
        if (action2 == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(4);
        }
        this.myAvailableSuppressActions.remove(action2);
    }

    @Nullable
    public abstract RefEntity getElement();

    @Override
    public final synchronized boolean isValid() {
        Boolean valid = this.myValid;
        if (valid == null) {
            this.myValid = valid = ReadAction.compute(() -> this.calculateIsValid());
        }
        return valid;
    }

    @Override
    public final synchronized String getPresentableText() {
        String name = this.myPresentableName;
        if (name == null) {
            this.myPresentableName = name = this.calculatePresentableName();
        }
        return name;
    }

    @Override
    @Nullable
    public String getTailText() {
        if (this.isQuickFixAppliedFromView()) {
            return "";
        }
        if (this.isAlreadySuppressedFromView()) {
            return LangBundle.message("suppressed", new Object[0]);
        }
        return !this.isValid() ? LangBundle.message("no.longer.valid", new Object[0]) : null;
    }

    @NotNull
    private Set<SuppressIntentionAction> calculateAvailableSuppressActions() {
        return this.getElement() == null ? Collections.emptySet() : this.calculateAvailableSuppressActions(this.myPresentation.getContext().getProject());
    }

    @NotNull
    public abstract Pair<PsiElement, CommonProblemDescriptor> getSuppressContent();

    @NotNull
    private Set<SuppressIntentionAction> calculateAvailableSuppressActions(@NotNull Project project2) {
        if (project2 == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(5);
        }
        if (this.myPresentation.isDummy()) {
            Set<SuppressIntentionAction> set2 = Collections.emptySet();
            if (set2 == null) {
                SuppressableInspectionTreeNode.$$$reportNull$$$0(6);
            }
            return set2;
        }
        Pair<PsiElement, CommonProblemDescriptor> suppressContent = this.getSuppressContent();
        PsiElement element = suppressContent.getFirst();
        if (element == null) {
            Set<SuppressIntentionAction> set3 = Collections.emptySet();
            if (set3 == null) {
                SuppressableInspectionTreeNode.$$$reportNull$$$0(7);
            }
            return set3;
        }
        InspectionResultsView view = this.myPresentation.getContext().getView();
        if (view == null) {
            Set<SuppressIntentionAction> set4 = Collections.emptySet();
            if (set4 == null) {
                SuppressableInspectionTreeNode.$$$reportNull$$$0(8);
            }
            return set4;
        }
        InspectionViewSuppressActionHolder suppressActionHolder = view.getSuppressActionHolder();
        SuppressIntentionAction[] actions = suppressActionHolder.getSuppressActions(this.myPresentation.getToolWrapper(), element);
        if (actions.length == 0) {
            Set<SuppressIntentionAction> set5 = Collections.emptySet();
            if (set5 == null) {
                SuppressableInspectionTreeNode.$$$reportNull$$$0(9);
            }
            return set5;
        }
        Set<SuppressIntentionAction> set6 = suppressActionHolder.internSuppressActions(Arrays.stream(actions).filter(action2 -> action2.isAvailable(project2, null, element)).collect(Collectors.toCollection(() -> ConcurrentCollectionFactory.createConcurrentSet(HashingStrategy.identity()))));
        if (set6 == null) {
            SuppressableInspectionTreeNode.$$$reportNull$$$0(10);
        }
        return set6;
    }

    @Nls
    protected abstract String calculatePresentableName();

    protected abstract boolean calculateIsValid();

    protected void dropCaches() {
        this.doDropCache();
        this.dropProblemCountCaches();
    }

    private void doDropCache() {
        this.myProblemLevels.drop();
        if (this.isQuickFixAppliedFromView() || this.isAlreadySuppressedFromView()) {
            return;
        }
        ReadAction.run(() -> {
            this.myValid = this.calculateIsValid();
            this.myPresentableName = this.calculatePresentableName();
        });
        for (InspectionTreeNode inspectionTreeNode : this.getChildren()) {
            if (!(inspectionTreeNode instanceof SuppressableInspectionTreeNode)) continue;
            ((SuppressableInspectionTreeNode)inspectionTreeNode).doDropCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeState calculateState() {
        NodeState state = new NodeState(this.isValid(), this.isAlreadySuppressedFromView(), this.isQuickFixAppliedFromView(), this.isExcluded());
        Interner<NodeState> interner = NodeState.INTERNER;
        synchronized (interner) {
            return NodeState.INTERNER.intern(state);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableSuppressActions";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateAvailableSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeSuppressActionFromAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateAvailableSuppressActions";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 6, 7, 8, 9, 10 -> new IllegalStateException(string2);
        };
    }

    private record NodeState(boolean isValid, boolean isSuppressed, boolean isFixApplied, boolean isExcluded) {
        private static final Interner<NodeState> INTERNER = new HashSetInterner<NodeState>();
    }
}

