/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.options.StringValidator;
import com.intellij.codeInspection.ui.BackgroundValidationsHolder;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ValidationResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.cellvalidators.CellComponentProvider;
import com.intellij.openapi.ui.cellvalidators.CellTooltipManager;
import com.intellij.openapi.ui.cellvalidators.TableCellValidator;
import com.intellij.openapi.ui.cellvalidators.ValidatingTableCellRendererWrapper;
import com.intellij.openapi.ui.cellvalidators.ValidationUtils;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u00a8\u0006\u000b"}, d2={"addColumnValidators", "", "table", "Lcom/intellij/codeInspection/ui/ListTable;", "components", "", "Lcom/intellij/codeInspection/options/StringValidator;", "parent", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lang.impl"})
public final class TableValidatorsKt {
    public static final void addColumnValidators(@NotNull ListTable table, @NotNull List<? extends StringValidator> components, @Nullable Disposable parent2, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        if (project2 == null || parent2 == null) {
            return;
        }
        boolean hasInstalledValidators = false;
        BackgroundValidationsHolder validationHolder = new BackgroundValidationsHolder(parent2, project2, table);
        Iterator<? extends StringValidator> iterator2 = components.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            StringValidator validator2 = iterator2.next();
            if (validator2 == null) continue;
            hasInstalledValidators = true;
            validationHolder.setValidator(index2, validator2);
            ExtendableTextField cellEditor = new ExtendableTextField();
            cellEditor.putClientProperty((Object)"JComponent.compactHeight", (Object)true);
            TableColumn column = table.getColumnModel().getColumn(index2);
            new ComponentValidator(parent2).withValidator(() -> TableValidatorsKt.addColumnValidators$lambda$0(cellEditor, validator2, project2)).andRegisterOnDocumentListener((JTextComponent)cellEditor).installOn((JComponent)cellEditor);
            column.setCellEditor(new DefaultCellEditor((JTextField)cellEditor));
            column.setCellRenderer((TableCellRenderer)new ValidatingTableCellRendererWrapper((TableCellRenderer)new DefaultTableCellRenderer()).bindToEditorSize(() -> TableValidatorsKt.addColumnValidators$lambda$1(cellEditor)).withCellValidator(new TableCellValidator(project2, validationHolder){
                final /* synthetic */ Project $project;
                final /* synthetic */ BackgroundValidationsHolder $validationHolder;
                {
                    this.$project = $project;
                    this.$validationHolder = $validationHolder;
                }

                @Nullable
                public ValidationInfo validate(@Nullable Object value, int row, int column) {
                    boolean dumb;
                    ValidationResult previous;
                    String stringValue;
                    String string2 = value instanceof String ? (String)value : null;
                    if (string2 == null) {
                        string2 = stringValue = "";
                    }
                    if ((previous = this.$validationHolder.getResult(row, column, dumb = DumbService.isDumb(this.$project))) != null && Intrinsics.areEqual((Object)stringValue, (Object)previous.getValue()) && dumb == previous.isDumbMode()) {
                        String string3 = previous.getErrorMessage();
                        if (string3 == null) {
                            return null;
                        }
                        String previousResult = string3;
                        return new ValidationInfo(previousResult, null).asWarning();
                    }
                    return null;
                }
            }));
        }
        if (hasInstalledValidators) {
            table.getModel().addTableModelListener(arg_0 -> TableValidatorsKt.addColumnValidators$lambda$2(validationHolder, arg_0));
            validationHolder.init();
            new CellTooltipManager(parent2).withCellComponentProvider(CellComponentProvider.forTable((JTable)((JTable)((Object)table)))).installOn((JComponent)((Object)table));
        }
    }

    private static final ValidationInfo addColumnValidators$lambda$0(ExtendableTextField $cellEditor, StringValidator $validator, Project $project) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$cellEditor, (String)"$cellEditor");
        String string2 = $cellEditor.getText();
        if (string2 == null) {
            return null;
        }
        String text2 = string2;
        String errorMessage = $validator.getErrorMessage($project, text2);
        if (errorMessage != null) {
            ValidationUtils.setExtension((ExtendableTextComponent)((ExtendableTextComponent)$cellEditor), (ExtendableTextComponent.Extension)ValidationUtils.WARNING_EXTENSION, (boolean)true);
            validationInfo = new ValidationInfo(errorMessage, (JComponent)$cellEditor).asWarning();
        } else {
            ValidationUtils.setExtension((ExtendableTextComponent)((ExtendableTextComponent)$cellEditor), (ExtendableTextComponent.Extension)ValidationUtils.WARNING_EXTENSION, (boolean)false);
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final Dimension addColumnValidators$lambda$1(ExtendableTextField $cellEditor) {
        Intrinsics.checkNotNullParameter((Object)$cellEditor, (String)"$cellEditor");
        return $cellEditor.getPreferredSize();
    }

    private static final void addColumnValidators$lambda$2(BackgroundValidationsHolder $validationHolder, TableModelEvent it) {
        Intrinsics.checkNotNullParameter((Object)$validationHolder, (String)"$validationHolder");
        if (it == null) {
            return;
        }
        if (it.getType() == -1) {
            $validationHolder.delete(it.getColumn(), it.getFirstRow(), it.getLastRow());
        }
        if (it.getType() == 1 || it.getType() == 0) {
            $validationHolder.check(it.getColumn(), it.getFirstRow(), it.getLastRow());
        }
    }
}

