/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.actions.InspectionResultsExportActionProviderKt;
import com.intellij.codeInspection.ui.actions.InspectionViewActionBase;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.nio.file.Path;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 #2\u00020\u0001:\u0002#$B/\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0017J0\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H'R\u0017\u0010\t\u001a\u00070\u0004\u00a2\u0006\u0002\b\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lcom/intellij/codeInspection/ui/actions/InspectionResultsExportActionProvider;", "Lcom/intellij/codeInspection/ui/actions/InspectionViewActionBase;", "text", "Ljava/util/function/Supplier;", "", "description", "icon", "Ljavax/swing/Icon;", "(Ljava/util/function/Supplier;Ljava/util/function/Supplier;Ljavax/swing/Icon;)V", "progressTitle", "Lcom/intellij/openapi/util/NlsContexts$ProgressTitle;", "getProgressTitle", "()Ljava/lang/String;", "propertyGraph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "getPropertyGraph", "()Lcom/intellij/openapi/observable/properties/PropertyGraph;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "additionalSettings", "Ljavax/swing/JPanel;", "onExportSuccessful", "writeResults", "tree", "Lcom/intellij/codeInspection/ui/InspectionTree;", "profile", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "globalInspectionContext", "Lcom/intellij/codeInspection/ex/GlobalInspectionContextImpl;", "project", "Lcom/intellij/openapi/project/Project;", "outputPath", "Ljava/nio/file/Path;", "Companion", "ExportDialog", "intellij.platform.lang.impl"})
public abstract class InspectionResultsExportActionProvider
extends InspectionViewActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PropertyGraph propertyGraph;
    @NotNull
    private static final ExtensionPointName<InspectionResultsExportActionProvider> EP_NAME = ExtensionPointName.Companion.create("com.intellij.inspectionResultsExportActionProvider");
    @NotNull
    public static final String LOCATION_KEY = "com.intellij.codeInspection.ui.actions.InspectionResultsExportActionProvider.location";

    public InspectionResultsExportActionProvider(@NotNull Supplier<String> text2, @NotNull Supplier<String> description, @Nullable Icon icon2) {
        Intrinsics.checkNotNullParameter(text2, (String)"text");
        Intrinsics.checkNotNullParameter(description, (String)"description");
        super(text2, description, icon2);
        this.propertyGraph = new PropertyGraph(null, false, 3, null);
    }

    @NotNull
    public final PropertyGraph getPropertyGraph() {
        return this.propertyGraph;
    }

    @NotNull
    public abstract String getProgressTitle();

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        InspectionResultsView inspectionResultsView = InspectionViewActionBase.getView(e);
        if (inspectionResultsView == null) {
            return;
        }
        InspectionResultsView view = inspectionResultsView;
        ExportDialog dialog = new ExportDialog(view);
        if (!dialog.showAndGet()) {
            return;
        }
        Path path2 = dialog.getPath();
        Project project2 = view.getProject();
        String string2 = this.getProgressTitle();
        ProgressManager.getInstance().run(new Task.Backgroundable(view, this, path2, project2, string2){
            final /* synthetic */ InspectionResultsView $view;
            final /* synthetic */ InspectionResultsExportActionProvider this$0;
            final /* synthetic */ Path $path;
            {
                this.$view = $view;
                this.this$0 = $receiver;
                this.$path = $path;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    ActionsKt.runReadAction((Function0)new Function0<Unit>(this.$view, this.this$0, this.$path){
                        final /* synthetic */ InspectionResultsView $view;
                        final /* synthetic */ InspectionResultsExportActionProvider this$0;
                        final /* synthetic */ Path $path;
                        {
                            this.$view = $view;
                            this.this$0 = $receiver;
                            this.$path = $path;
                            super(0);
                        }

                        public final void invoke() {
                            if (this.$view.getCurrentProfile() == null) {
                                throw new NullPointerException("Failed to export inspection results.");
                            }
                            InspectionTree inspectionTree = this.$view.getTree();
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)inspectionTree), (String)"view.tree");
                            InspectionProfileImpl inspectionProfileImpl = this.$view.getCurrentProfile();
                            Intrinsics.checkNotNull((Object)inspectionProfileImpl);
                            GlobalInspectionContextImpl globalInspectionContextImpl = this.$view.getGlobalInspectionContext();
                            Intrinsics.checkNotNullExpressionValue((Object)globalInspectionContextImpl, (String)"view.globalInspectionContext");
                            Project project2 = this.$view.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"view.project");
                            this.this$0.writeResults(inspectionTree, inspectionProfileImpl, globalInspectionContextImpl, project2, this.$path);
                        }
                    });
                }
                catch (ProcessCanceledException p) {
                    throw p;
                }
                catch (Throwable t) {
                    InspectionResultsExportActionProviderKt.getLOG().error(t);
                    ActionsKt.invokeLater$default(null, (Function0)new Function0<Unit>(this.$view, t){
                        final /* synthetic */ InspectionResultsView $view;
                        final /* synthetic */ Throwable $t;
                        {
                            this.$view = $view;
                            this.$t = $t;
                            super(0);
                        }

                        public final void invoke() {
                            Messages.showErrorDialog((Component)this.$view, (String)this.$t.getMessage());
                        }
                    }, 1, null);
                    return;
                }
                ActionsKt.invokeLater$default(null, (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ InspectionResultsExportActionProvider this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.onExportSuccessful();
                    }
                }, 1, null);
            }
        });
    }

    @RequiresBackgroundThread
    public abstract void writeResults(@NotNull InspectionTree var1, @NotNull InspectionProfileImpl var2, @NotNull GlobalInspectionContextImpl var3, @NotNull Project var4, @NotNull Path var5);

    @RequiresEdt
    public void onExportSuccessful() {
    }

    @Nullable
    public JPanel additionalSettings() {
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r*\u0004\b\b\u0010\tR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lcom/intellij/codeInspection/ui/actions/InspectionResultsExportActionProvider$ExportDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "view", "Lcom/intellij/codeInspection/ui/InspectionResultsView;", "(Lcom/intellij/codeInspection/ui/actions/InspectionResultsExportActionProvider;Lcom/intellij/codeInspection/ui/InspectionResultsView;)V", "<set-?>", "", "location", "getLocation$delegate", "(Lcom/intellij/codeInspection/ui/actions/InspectionResultsExportActionProvider$ExportDialog;)Ljava/lang/Object;", "getLocation", "()Ljava/lang/String;", "setLocation", "(Ljava/lang/String;)V", "locationProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "getView", "()Lcom/intellij/codeInspection/ui/InspectionResultsView;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "intellij.platform.lang.impl"})
    public final class ExportDialog
    extends DialogWrapper {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final InspectionResultsView view;
        @NotNull
        private final GraphProperty<String> locationProperty;

        public ExportDialog(InspectionResultsView view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super(view.getProject(), true);
            this.view = view;
            this.locationProperty = InspectionResultsExportActionProvider.this.getPropertyGraph().property((Object)"");
            this.setOKButtonText(InspectionsBundle.message("inspection.export.save.button", new Object[0]));
            this.setTitle(InspectionsBundle.message("inspection.export.results.title", new Object[0]));
            this.setResizable(false);
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance(this.view.getProject());
            Project project2 = this.view.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"view.project");
            Object object = ProjectUtil.guessProjectDir((Project)project2);
            if (object == null || (object = ((VirtualFile)object).getPath()) == null) {
                object = "";
            }
            String string2 = propertiesComponent.getValue(InspectionResultsExportActionProvider.LOCATION_KEY, (String)object);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInstance(view.project\u2026ProjectDir()?.path ?: \"\")");
            this.setLocation(string2);
            this.init();
        }

        @NotNull
        public final InspectionResultsView getView() {
            return this.view;
        }

        @NotNull
        public final String getLocation() {
            return (String)this.locationProperty.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setLocation(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.locationProperty.setValue((Object)this, $$delegatedProperties[0], (Object)string2);
        }

        private static Object getLocation$delegate(ExportDialog exportDialog) {
            return exportDialog.locationProperty;
        }

        @NotNull
        public final Path getPath() {
            Path path2 = Path.of(this.getLocation(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(location)");
            return path2;
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(InspectionResultsExportActionProvider.this, this){
                final /* synthetic */ InspectionResultsExportActionProvider this$0;
                final /* synthetic */ ExportDialog this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                public final void invoke(@NotNull Panel $this$panel) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$1){
                            final /* synthetic */ ExportDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string2 = this.this$0.getView().getViewTitle();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"view.viewTitle");
                                $this$row.label(string2).bold();
                            }
                        }), (int)1, null).bottomGap(BottomGap.SMALL);
                        String string2 = EditorBundle.message((String)"export.to.html.output.directory.label", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"export.to.html.output.directory.label\")");
                        $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$1){
                            final /* synthetic */ ExportDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string2 = EditorBundle.message((String)"export.to.html.select.output.directory.title", (Object[])new Object[0]);
                                Project project2 = this.this$0.getView().getProject();
                                FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                                Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"createSingleFolderDescriptor()");
                                TextFieldWithBrowseButtonKt.bindText((Cell)TextFieldWithBrowseButtonKt.columns((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (String)string2, (Project)project2, (FileChooserDescriptor)fileChooserDescriptor, null, (int)8, null), (int)36), (ObservableMutableProperty)((ObservableMutableProperty)ExportDialog.access$getLocationProperty$p(this.this$0))).validationOnApply((Function2)new Function2<ValidationInfoBuilder, TextFieldWithBrowseButton, ValidationInfo>(this.this$0){
                                    final /* synthetic */ ExportDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2);
                                    }

                                    @Nullable
                                    public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull TextFieldWithBrowseButton it) {
                                        ValidationInfo validationInfo;
                                        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        if (StringsKt.isBlank((CharSequence)this.this$0.getLocation())) {
                                            String string2 = InspectionsBundle.message("inspection.action.export.popup.error", new Object[0]);
                                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"inspection.action.export.popup.error\")");
                                            validationInfo = $this$validationOnApply.error(string2);
                                        } else {
                                            validationInfo = null;
                                        }
                                        return validationInfo;
                                    }
                                });
                            }
                        });
                        JPanel jPanel = this.this$0.additionalSettings();
                        if (jPanel == null) break block0;
                        JPanel it = jPanel;
                        boolean bl = false;
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(it){
                            final /* synthetic */ JPanel $it;
                            {
                                this.$it = $it;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.cell((JComponent)this.$it);
                            }
                        }), (int)1, null);
                    }
                }
            }));
        }

        protected void doOKAction() {
            PropertiesComponent.getInstance(this.view.getProject()).setValue(InspectionResultsExportActionProvider.LOCATION_KEY, this.getLocation());
            super.doOKAction();
        }

        public static final /* synthetic */ GraphProperty access$getLocationProperty$p(ExportDialog $this) {
            return $this.locationProperty;
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ExportDialog.class, "location", "getLocation()Ljava/lang/String;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInspection/ui/actions/InspectionResultsExportActionProvider$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/codeInspection/ui/actions/InspectionResultsExportActionProvider;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "LOCATION_KEY", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<InspectionResultsExportActionProvider> getEP_NAME() {
            return EP_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

