/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions.suppress;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.codeInspection.ui.actions.InspectionViewActionBase;
import com.intellij.codeInspection.ui.actions.KeyAwareInspectionViewAction;
import com.intellij.codeInspection.ui.actions.suppress.SuppressActionSequentialTask;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressActionWrapper
extends ActionGroup
implements CompactActionGroup {
    private static final Logger LOG = Logger.getInstance(SuppressActionWrapper.class);

    public SuppressActionWrapper() {
        super(InspectionsBundle.messagePointer("suppress.inspection.problem", new Object[0]), false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            SuppressActionWrapper.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        InspectionResultsView view = InspectionViewActionBase.getView(e);
        if (view == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                SuppressActionWrapper.$$$reportNull$$$0(1);
            }
            return AnAction.EMPTY_ARRAY;
        }
        InspectionToolWrapper<?, ?> wrapper2 = view.getTree().getSelectedToolWrapper(true);
        if (wrapper2 == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                SuppressActionWrapper.$$$reportNull$$$0(2);
            }
            return AnAction.EMPTY_ARRAY;
        }
        Set<SuppressIntentionAction> suppressActions = view.getSuppressActionHolder().getSuppressActions(wrapper2);
        if (suppressActions.isEmpty()) {
            if (AnAction.EMPTY_ARRAY == null) {
                SuppressActionWrapper.$$$reportNull$$$0(3);
            }
            return AnAction.EMPTY_ARRAY;
        }
        AnAction[] actions = new AnAction[suppressActions.size() + 1];
        int i2 = 0;
        for (SuppressIntentionAction action2 : suppressActions) {
            actions[i2++] = new SuppressTreeAction(action2);
        }
        actions[suppressActions.size()] = Separator.getInstance();
        Arrays.sort(actions, Comparator.comparingInt(a -> a instanceof Separator ? 0 : (((SuppressTreeAction)((Object)a)).isSuppressAll() ? 1 : -1)));
        if (actions == null) {
            SuppressActionWrapper.$$$reportNull$$$0(4);
        }
        return actions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/ui/actions/suppress/SuppressActionWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class SuppressTreeAction
    extends KeyAwareInspectionViewAction {
        @NotNull
        private final SuppressIntentionAction mySuppressAction;

        public SuppressTreeAction(@NotNull SuppressIntentionAction suppressAction) {
            if (suppressAction == null) {
                SuppressTreeAction.$$$reportNull$$$0(0);
            }
            super(suppressAction.getText());
            this.mySuppressAction = suppressAction;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SuppressTreeAction.$$$reportNull$$$0(1);
            }
            InspectionResultsView view = SuppressTreeAction.getView(e);
            InspectionToolWrapper<?, ?> wrapper2 = SuppressTreeAction.getToolWrapper(e);
            LOG.assertTrue(wrapper2 != null);
            Set<SuppressableInspectionTreeNode> nodesAsSet = this.getNodesToSuppress(e);
            Project project2 = e.getProject();
            ApplicationManager.getApplication().invokeLater(() -> {
                String templatePresentationText = this.getTemplatePresentation().getText();
                LOG.assertTrue(templatePresentationText != null);
                SuppressableInspectionTreeNode[] nodes2 = nodesAsSet.toArray(new SuppressableInspectionTreeNode[0]);
                CommandProcessor.getInstance().executeCommand(project2, () -> {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
                    SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project2, templatePresentationText, true);
                    progressTask.setMinIterationTime(200L);
                    progressTask.setTask(new SuppressActionSequentialTask(nodes2, this.mySuppressAction, wrapper2));
                    ProgressManager.getInstance().run(progressTask);
                }, templatePresentationText, null);
                Set<GlobalInspectionContextImpl> globalInspectionContexts = ((InspectionManagerEx)InspectionManager.getInstance(project2)).getRunningContexts();
                for (GlobalInspectionContextImpl context2 : globalInspectionContexts) {
                    context2.refreshViews();
                }
                view.syncRightPanel();
            });
        }

        @Override
        protected boolean isEnabled(@NotNull InspectionResultsView view, AnActionEvent e) {
            Set<SuppressableInspectionTreeNode> nodesToSuppress;
            if (view == null) {
                SuppressTreeAction.$$$reportNull$$$0(2);
            }
            if ((nodesToSuppress = this.getNodesToSuppress(e)).isEmpty()) {
                return false;
            }
            if (nodesToSuppress.size() == 1) {
                PsiElement element = Objects.requireNonNull(ContainerUtil.getFirstItem(nodesToSuppress)).getSuppressContent().getFirst();
                String text2 = this.mySuppressAction.getFamilyName();
                if (element != null) {
                    this.mySuppressAction.isAvailable(e.getProject(), null, element);
                    text2 = this.mySuppressAction.getText();
                }
                e.getPresentation().setText(text2);
            } else {
                e.getPresentation().setText(this.mySuppressAction.getFamilyName());
            }
            return true;
        }

        public boolean isSuppressAll() {
            return this.mySuppressAction.isSuppressAll();
        }

        private Set<SuppressableInspectionTreeNode> getNodesToSuppress(AnActionEvent e) {
            Object[] selectedNodes = (Object[])e.getData(PlatformCoreDataKeys.SELECTED_ITEMS);
            if (selectedNodes == null) {
                return Collections.emptySet();
            }
            HashSet<SuppressableInspectionTreeNode> result2 = new HashSet<SuppressableInspectionTreeNode>();
            for (Object selectedNode : selectedNodes) {
                if (TreeUtil.treeNodeTraverser((TreeNode)((TreeNode)selectedNode)).traverse().processEach(node1 -> {
                    InspectionTreeNode n = (InspectionTreeNode)node1;
                    if (n instanceof SuppressableInspectionTreeNode && ((SuppressableInspectionTreeNode)n).canSuppress() && n.isValid()) {
                        if (((SuppressableInspectionTreeNode)n).getAvailableSuppressActions().contains(this.mySuppressAction)) {
                            result2.add((SuppressableInspectionTreeNode)n);
                        } else {
                            return false;
                        }
                    }
                    return true;
                })) continue;
                return Collections.emptySet();
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suppressAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/ui/actions/suppress/SuppressActionWrapper$SuppressTreeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

