/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import java.util.concurrent.Callable;
import kotlin.coroutines.CoroutineContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ContextCallable<V>
implements Callable<V> {
    private final boolean myRoot;
    @NotNull
    private final CoroutineContext myParentContext;
    @NotNull
    private final Callable<? extends V> myCallable;

    public ContextCallable(boolean root, @NotNull Callable<? extends V> callable) {
        if (callable == null) {
            ContextCallable.$$$reportNull$$$0(0);
        }
        this.myRoot = root;
        this.myParentContext = ThreadContext.currentThreadContext();
        this.myCallable = callable;
    }

    @Override
    public V call() throws Exception {
        if (this.myRoot) {
            ThreadContext.checkUninitializedThreadContext();
        }
        try (AccessToken ignored = ThreadContext.replaceThreadContext(this.myParentContext);){
            V v = this.myCallable.call();
            return v;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/intellij/concurrency/ContextCallable", "<init>"));
    }
}

