/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import kotlin.coroutines.CoroutineContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ContextRunnable
implements Runnable {
    private final boolean myRoot;
    @NotNull
    private final CoroutineContext myParentContext;
    @NotNull
    private final Runnable myRunnable;

    public ContextRunnable(boolean root, @NotNull Runnable runnable) {
        if (runnable == null) {
            ContextRunnable.$$$reportNull$$$0(0);
        }
        this.myRoot = root;
        this.myParentContext = ThreadContext.currentThreadContext();
        this.myRunnable = runnable;
    }

    @Override
    public void run() {
        if (this.myRoot) {
            ThreadContext.checkUninitializedThreadContext();
        }
        try (AccessToken ignored = ThreadContext.replaceThreadContext(this.myParentContext);){
            this.myRunnable.run();
        }
    }

    public String toString() {
        return this.myRunnable.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/concurrency/ContextRunnable", "<init>"));
    }
}

