/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.configurationStore.BaseXmlOutputter;
import com.intellij.configurationStore.JbXmlOutputterKt;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SystemProperties;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u0000 ;2\u00020\u0001:\u0001;BK\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010$\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u0018\u0010(\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*H\u0002J6\u0010+\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0&2\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u00100\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u0003H\u0002J\u001e\u00102\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u00103\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u0003H\u0002J.\u00105\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0&2\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0019H\u0002J\u0010\u00106\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u00107\u001a\u00020\u00192\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0&2\u0006\u0010.\u001a\u00020\u0019H\u0002J\u001e\u00108\u001a\u00020\u00192\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0&2\u0006\u0010.\u001a\u00020\u0019H\u0002J \u00109\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010:\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/configurationStore/JbXmlOutputter;", "Lcom/intellij/configurationStore/BaseXmlOutputter;", "lineSeparator", "", "elementFilter", "Lcom/intellij/openapi/util/JDOMUtil$ElementOutputFilter;", "macroMap", "Lcom/intellij/application/options/ReplacePathToMacroMap;", "macroFilter", "Lcom/intellij/openapi/application/PathMacroFilter;", "isForbidSensitiveData", "", "storageFilePathForDebugPurposes", "(Ljava/lang/String;Lcom/intellij/openapi/util/JDOMUtil$ElementOutputFilter;Lcom/intellij/application/options/ReplacePathToMacroMap;Lcom/intellij/openapi/application/PathMacroFilter;ZLjava/lang/String;)V", "format", "Lorg/jdom/output/Format;", "Lorg/jetbrains/annotations/NotNull;", "checkIsElementContainsSensitiveInformation", "", "element", "Lorg/jdom/Element;", "indent", "out", "Ljava/io/Writer;", "level", "", "logSensitiveInformationError", "name", "elementKind", "parentElement", "newline", "output", "doctype", "Lorg/jdom/DocType;", "doc", "Lorg/jdom/Document;", "printAttributes", "attributes", "", "Lorg/jdom/Attribute;", "printCDATA", "cdata", "Lorg/jdom/CDATA;", "printContentRange", "content", "Lorg/jdom/Content;", "start", "end", "printDeclaration", "encoding", "printElement", "printString", "str", "printTextRange", "shouldCheckElement", "skipLeadingWhite", "skipTrailingWhite", "writeContent", "writeLineSeparator", "Companion", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nJbXmlOutputter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbXmlOutputter.kt\ncom/intellij/configurationStore/JbXmlOutputter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,588:1\n1#2:589\n*E\n"})
public class JbXmlOutputter
extends BaseXmlOutputter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final JDOMUtil.ElementOutputFilter elementFilter;
    @Nullable
    private final ReplacePathToMacroMap macroMap;
    @Nullable
    private final PathMacroFilter macroFilter;
    private final boolean isForbidSensitiveData;
    @Nullable
    private final String storageFilePathForDebugPurposes;
    @NotNull
    private final Format format;
    private static final Set<String> reportedSensitiveProblems = Collections.synchronizedSet(new HashSet());

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter, @Nullable ReplacePathToMacroMap macroMap, @Nullable PathMacroFilter macroFilter, boolean isForbidSensitiveData, @Nullable String storageFilePathForDebugPurposes) {
        Format format;
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        super(lineSeparator);
        this.elementFilter = elementFilter;
        this.macroMap = macroMap;
        this.macroFilter = macroFilter;
        this.isForbidSensitiveData = isForbidSensitiveData;
        this.storageFilePathForDebugPurposes = storageFilePathForDebugPurposes;
        if (Intrinsics.areEqual((Object)JbXmlOutputterKt.access$getDEFAULT_FORMAT$p().getLineSeparator(), (Object)lineSeparator)) {
            format = JbXmlOutputterKt.access$getDEFAULT_FORMAT$p();
        } else {
            Format format2 = JDOMUtil.createFormat(lineSeparator);
            format = format2;
            Intrinsics.checkNotNullExpressionValue((Object)format2, (String)"createFormat(lineSeparator)");
        }
        this.format = format;
    }

    public /* synthetic */ JbXmlOutputter(String string2, JDOMUtil.ElementOutputFilter elementOutputFilter, ReplacePathToMacroMap replacePathToMacroMap, PathMacroFilter pathMacroFilter, boolean bl, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = "\n";
        }
        if ((n & 2) != 0) {
            elementOutputFilter = null;
        }
        if ((n & 4) != 0) {
            replacePathToMacroMap = null;
        }
        if ((n & 8) != 0) {
            pathMacroFilter = null;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        this(string2, elementOutputFilter, replacePathToMacroMap, pathMacroFilter, bl, string3);
    }

    public final void output(@NotNull Document doc, @NotNull Writer out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        String string2 = this.format.getEncoding();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format.encoding");
        this.printDeclaration(out, string2);
        List<Content> content2 = doc.getContent();
        for (Content obj : content2) {
            Content content3 = obj;
            if (content3 instanceof Element) {
                Element element = doc.getRootElement();
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"doc.rootElement");
                this.printElement(out, element, 0);
            } else if (content3 instanceof DocType) {
                DocType docType = doc.getDocType();
                Intrinsics.checkNotNullExpressionValue((Object)docType, (String)"doc.docType");
                this.printDocType(out, docType);
                this.writeLineSeparator(out);
            }
            this.newline(out);
            this.indent(out, 0);
        }
        this.writeLineSeparator(out);
        out.flush();
    }

    private final void writeLineSeparator(Writer out) throws IOException {
        if (this.format.getLineSeparator() != null) {
            out.write(this.format.getLineSeparator());
        }
    }

    public final void output(@NotNull DocType doctype, @NotNull Writer out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)doctype, (String)"doctype");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.printDocType(out, doctype);
        out.flush();
    }

    public final void output(@NotNull Element element, @NotNull Writer out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.printElement(out, element, 0);
    }

    private final void printDeclaration(Writer out, String encoding) throws IOException {
        if (!this.format.getOmitDeclaration()) {
            out.write("<?xml version=\"1.0\"");
            if (!this.format.getOmitEncoding()) {
                out.write(" encoding=\"" + encoding + "\"");
            }
            out.write("?>");
            this.writeLineSeparator(out);
        }
    }

    private final void printCDATA(Writer out, CDATA cdata) throws IOException {
        String str = null;
        if (this.format.getTextMode() == Format.TextMode.NORMALIZE) {
            String string2 = cdata.getTextNormalize();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cdata.textNormalize");
            str = string2;
        } else {
            String string3 = cdata.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"cdata.text");
            str = string3;
            if (this.format.getTextMode() == Format.TextMode.TRIM) {
                str = ((Object)StringsKt.trim((CharSequence)str)).toString();
            }
        }
        out.write("<![CDATA[");
        out.write(str);
        out.write("]]>");
    }

    private final void printString(Writer out, String str) throws IOException {
        String normalizedString = str;
        if (this.format.getTextMode() == Format.TextMode.NORMALIZE) {
            String string2 = Text.normalizeString(normalizedString);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"normalizeString(normalizedString)");
            normalizedString = string2;
        } else if (this.format.getTextMode() == Format.TextMode.TRIM) {
            normalizedString = ((Object)StringsKt.trim((CharSequence)normalizedString)).toString();
        }
        if (this.macroMap != null) {
            String string3 = this.macroMap.substitute(normalizedString, SystemInfoRt.isFileSystemCaseSensitive);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"macroMap.substitute(norm\u2026sFileSystemCaseSensitive)");
            normalizedString = string3;
        }
        out.write(Companion.escapeElementEntities(normalizedString));
    }

    public final void printElement(@NotNull Writer out, @NotNull Element element, int level) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.elementFilter != null && !this.elementFilter.accept(element, level)) {
            return;
        }
        out.write(60);
        JbXmlOutputterKt.access$printQualifiedName(out, element);
        if (element.hasAttributes()) {
            List<Attribute> list2 = element.getAttributes();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"element.attributes");
            this.printAttributes(out, list2);
        }
        if (!this.writeContent(out, element, level)) {
            return;
        }
        out.write("</");
        JbXmlOutputterKt.access$printQualifiedName(out, element);
        out.write(62);
    }

    protected boolean writeContent(@NotNull Writer out, @NotNull Element element, int level) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.isForbidSensitiveData) {
            this.checkIsElementContainsSensitiveInformation(element);
        }
        List<Content> content2 = element.getContent();
        Intrinsics.checkNotNullExpressionValue(content2, (String)"content");
        int start = this.skipLeadingWhite(content2, 0);
        int size = content2.size();
        if (start >= size) {
            out.write(" />");
            return false;
        }
        out.write(62);
        if (JbXmlOutputterKt.access$nextNonText(content2, start) < size) {
            this.newline(out);
            this.printContentRange(out, content2, start, size, level + 1);
            this.newline(out);
            this.indent(out, level);
        } else {
            this.printTextRange(out, content2, start, size);
        }
        return true;
    }

    private final void printContentRange(Writer out, List<? extends Content> content2, int start, int end, int level) throws IOException {
        boolean firstNode = false;
        Content next2 = null;
        int first2 = 0;
        int index2 = 0;
        index2 = start;
        while (index2 < end) {
            firstNode = index2 == start;
            next2 = content2.get(index2);
            if (next2 instanceof Text || next2 instanceof EntityRef) {
                first2 = this.skipLeadingWhite(content2, index2);
                if (first2 >= (index2 = JbXmlOutputterKt.access$nextNonText(content2, first2))) continue;
                if (!firstNode) {
                    this.newline(out);
                }
                this.indent(out, level);
                this.printTextRange(out, content2, first2, index2);
                continue;
            }
            if (!firstNode) {
                this.newline(out);
            }
            this.indent(out, level);
            if (next2 instanceof Element) {
                this.printElement(out, (Element)next2, level);
            }
            ++index2;
        }
    }

    private final void printTextRange(Writer out, List<? extends Content> content2, int start, int end) throws IOException {
        int start2 = this.skipLeadingWhite(content2, start);
        if (start2 >= content2.size()) {
            return;
        }
        int end2 = this.skipTrailingWhite(content2, end);
        Object previous = null;
        for (int i2 = start2; i2 < end2; ++i2) {
            Content node2 = content2.get(i2);
            Object next2 = null;
            Object object = node2;
            if (object instanceof Text) {
                next2 = ((Text)node2).getText();
            } else if (object instanceof EntityRef) {
                next2 = "&" + node2.getValue() + ";";
            } else {
                throw new IllegalStateException("Should see only CDATA, Text, or EntityRef");
            }
            object = (CharSequence)next2;
            if (object == null || object.length() == 0) continue;
            if (previous != null && (this.format.getTextMode() == Format.TextMode.NORMALIZE || this.format.getTextMode() == Format.TextMode.TRIM) && (JbXmlOutputterKt.access$endsWithWhite(previous) || JbXmlOutputterKt.access$startsWithWhite((String)next2))) {
                out.write(32);
            }
            if ((object = node2) instanceof CDATA) {
                this.printCDATA(out, (CDATA)node2);
            } else if (object instanceof EntityRef) {
                JbXmlOutputterKt.access$printEntityRef(out, (EntityRef)node2);
            } else {
                this.printString(out, (String)next2);
            }
            previous = next2;
        }
    }

    private final void printAttributes(Writer out, List<? extends Attribute> attributes) throws IOException {
        for (Attribute attribute : attributes) {
            String value;
            out.write(32);
            JbXmlOutputterKt.access$printQualifiedName(out, attribute);
            out.write(61);
            out.write(34);
            String string2 = value = this.macroMap != null && (this.macroFilter == null || !this.macroFilter.skipPathMacros(attribute)) ? this.macroMap.getAttributeValue(attribute, this.macroFilter, SystemInfoRt.isFileSystemCaseSensitive, false) : attribute.getValue();
            if (this.isForbidSensitiveData) {
                String string3 = attribute.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"attribute.name");
                if (BaseXmlOutputter.Companion.doesNameSuggestSensitiveInformation(string3)) {
                    this.logSensitiveInformationError("@" + attribute.getName(), "Attribute", attribute.getParent());
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            out.write(JbXmlOutputterKt.access$escapeAttributeEntities(value));
            out.write(34);
        }
    }

    private final void newline(Writer out) throws IOException {
        if (this.format.getIndent() != null) {
            this.writeLineSeparator(out);
        }
    }

    private final void indent(Writer out, int level) throws IOException {
        CharSequence charSequence = this.format.getIndent();
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        for (int i2 = 0; i2 < level; ++i2) {
            out.write(this.format.getIndent());
        }
    }

    private final int skipLeadingWhite(List<? extends Content> content2, int start) {
        int index2 = start;
        if (index2 < 0) {
            index2 = 0;
        }
        int size = content2.size();
        Format.TextMode textMode = this.format.getTextMode();
        if (textMode == Format.TextMode.TRIM_FULL_WHITE || textMode == Format.TextMode.NORMALIZE || textMode == Format.TextMode.TRIM) {
            while (index2 < size) {
                if (!JbXmlOutputterKt.access$isAllWhitespace(content2.get(index2))) {
                    return index2;
                }
                ++index2;
            }
        }
        return index2;
    }

    private final int skipTrailingWhite(List<? extends Content> content2, int start) {
        Format.TextMode textMode;
        int index2 = start;
        int size = content2.size();
        if (index2 > size) {
            index2 = size;
        }
        if ((textMode = this.format.getTextMode()) == Format.TextMode.TRIM_FULL_WHITE || textMode == Format.TextMode.NORMALIZE || textMode == Format.TextMode.TRIM) {
            while (index2 >= 0 && JbXmlOutputterKt.access$isAllWhitespace(content2.get(index2 - 1))) {
                --index2;
            }
        }
        return index2;
    }

    private final void checkIsElementContainsSensitiveInformation(Element element) {
        String name = element.getName();
        if (!this.shouldCheckElement(element)) {
            return;
        }
        String string2 = name;
        Intrinsics.checkNotNull((Object)string2);
        if (BaseXmlOutputter.Companion.doesNameSuggestSensitiveInformation(string2)) {
            this.logSensitiveInformationError(name, "Element", element.getParentElement());
        }
        if ((name = element.getAttributeValue("name")) != null && BaseXmlOutputter.Companion.doesNameSuggestSensitiveInformation(name) && element.getAttribute("value") != null) {
            this.logSensitiveInformationError("@name=" + name, "Element", element);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldCheckElement(Element element) {
        if (!Intrinsics.areEqual((Object)"property", (Object)element.getName())) return true;
        Element element2 = element.getParentElement();
        String it = element2 != null ? element2.getName() : null;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)it, (Object)"driver-properties")) return false;
        if (!Intrinsics.areEqual((Object)it, (Object)"driver")) return true;
        return false;
    }

    private final void logSensitiveInformationError(String name, String elementKind, Element parentElement) {
        String parentPath = null;
        if (parentElement == null) {
            parentPath = null;
        } else {
            ArrayList<String> ids = new ArrayList<String>();
            for (Element parent2 = parentElement; parent2 != null; parent2 = parent2.getParentElement()) {
                String componentName;
                Object parentId = parent2.getName();
                if (Intrinsics.areEqual((Object)parentId, (Object)"component") && (componentName = parent2.getAttributeValue("name")) != null) {
                    parentId = (String)parentId + "@" + componentName;
                }
                ids.add((String)parentId);
            }
            if (ids.isEmpty()) {
                parentPath = null;
            } else {
                CollectionsKt.reverse((List)ids);
                parentPath = CollectionsKt.joinToString$default((Iterable)ids, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            }
        }
        String string2 = parentPath;
        String message = elementKind + " " + (String)(string2 == null ? "" : string2 + ".") + name + " probably contains sensitive information";
        if (this.storageFilePathForDebugPurposes != null) {
            String string3 = FileUtilRt.toSystemIndependentName(SystemProperties.getUserHome());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemIndependentName(\u2026Properties.getUserHome())");
            message = message + " (file: " + StringsKt.replace$default((String)this.storageFilePathForDebugPurposes, (String)string3, (String)"~", (boolean)false, (int)4, null) + ")";
        }
        if (reportedSensitiveProblems.add(message)) {
            Logger.getInstance(JbXmlOutputter.class).error(message);
        }
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter, @Nullable ReplacePathToMacroMap macroMap, @Nullable PathMacroFilter macroFilter, boolean isForbidSensitiveData) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this(lineSeparator, elementFilter, macroMap, macroFilter, isForbidSensitiveData, null, 32, null);
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter, @Nullable ReplacePathToMacroMap macroMap, @Nullable PathMacroFilter macroFilter) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this(lineSeparator, elementFilter, macroMap, macroFilter, false, null, 48, null);
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter, @Nullable ReplacePathToMacroMap macroMap) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this(lineSeparator, elementFilter, macroMap, null, false, null, 56, null);
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this(lineSeparator, elementFilter, null, null, false, null, 60, null);
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this(lineSeparator, null, null, null, false, null, 62, null);
    }

    @JvmOverloads
    public JbXmlOutputter() {
        this(null, null, null, null, false, null, 63, null);
    }

    @JvmStatic
    public static final void collapseMacrosAndWrite(@NotNull Element element, @NotNull ComponentManager project2, @NotNull Writer writer) throws IOException {
        Companion.collapseMacrosAndWrite(element, project2, writer);
    }

    @JvmStatic
    @NotNull
    public static final JbXmlOutputter createOutputter(@NotNull ComponentManager project2) {
        return Companion.createOutputter(project2);
    }

    @JvmStatic
    @NotNull
    public static final String collapseMacrosAndWrite(@NotNull Element element, @NotNull ComponentManager project2) throws IOException {
        return Companion.collapseMacrosAndWrite(element, project2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\b\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/configurationStore/JbXmlOutputter$Companion;", "", "()V", "reportedSensitiveProblems", "", "", "kotlin.jvm.PlatformType", "", "collapseMacrosAndWrite", "element", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/components/ComponentManager;", "", "writer", "Ljava/io/Writer;", "createOutputter", "Lcom/intellij/configurationStore/JbXmlOutputter;", "escapeElementEntities", "str", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void collapseMacrosAndWrite(@NotNull Element element, @NotNull ComponentManager project2, @NotNull Writer writer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            this.createOutputter(project2).output(element, writer);
        }

        @JvmStatic
        @NotNull
        public final JbXmlOutputter createOutputter(@NotNull ComponentManager project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            PathMacroManager pathMacroManager = PathMacroManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(project)");
            PathMacroManager macroManager = pathMacroManager;
            return new JbXmlOutputter(null, null, macroManager.getReplacePathMap(), macroManager.getMacroFilter(), false, null, 51, null);
        }

        @JvmStatic
        @NotNull
        public final String collapseMacrosAndWrite(@NotNull Element element, @NotNull ComponentManager project2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            StringWriter writer = new StringWriter();
            this.collapseMacrosAndWrite(element, project2, writer);
            String string2 = writer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"writer.toString()");
            return string2;
        }

        @NotNull
        public final String escapeElementEntities(@Nullable String str) {
            String string2 = str;
            Intrinsics.checkNotNull((Object)string2);
            String string3 = JDOMUtil.escapeText(string2, false, false);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"escapeText(str!!, false, false)");
            return string3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

