/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.DefaultStateSerializerKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.text.UniqueNameGenerator;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u001c\b\u0002\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001`\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0016\b\u0002\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001dJL\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\u001d2\u001e\u0010!\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\"H\u0016J.\u0010$\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0014\u0010%\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010#\u0012\u0004\u0012\u00020\u00130\u001dH\u0016J \u0010&\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010(\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bR\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000fj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/configurationStore/SchemeManagerIprProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "subStateTagName", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/lang/String;Ljava/util/Comparator;)V", "isExclusive", "", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "nameToData", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "copyIfNotExists", "", "provider", "delete", "fileSpec", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "load", "state", "Lorg/jdom/Element;", "keyGetter", "Lkotlin/Function1;", "processChildren", "path", "filter", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "read", "consumer", "write", "content", "writeState", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nSchemeManagerIprProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemeManagerIprProvider.kt\ncom/intellij/configurationStore/SchemeManagerIprProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,136:1\n1#2:137\n37#3,2:138\n*S KotlinDebug\n*F\n+ 1 SchemeManagerIprProvider.kt\ncom/intellij/configurationStore/SchemeManagerIprProvider\n*L\n110#1:138,2\n*E\n"})
public final class SchemeManagerIprProvider
extends SimpleModificationTracker
implements StreamProvider {
    @NotNull
    private final String subStateTagName;
    @Nullable
    private final Comparator<String> comparator;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private LinkedHashMap<String, byte[]> nameToData;
    private final boolean isExclusive;

    public SchemeManagerIprProvider(@NotNull String subStateTagName, @Nullable Comparator<String> comparator) {
        Intrinsics.checkNotNullParameter((Object)subStateTagName, (String)"subStateTagName");
        this.subStateTagName = subStateTagName;
        this.comparator = comparator;
        this.lock = new ReentrantReadWriteLock();
        this.nameToData = new LinkedHashMap();
    }

    public /* synthetic */ SchemeManagerIprProvider(String string2, Comparator comparator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            comparator = null;
        }
        this(string2, comparator);
    }

    @Override
    public boolean isExclusive() {
        return this.isExclusive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean read(@NotNull String fileSpec, @NotNull RoamingType roamingType, @NotNull Function1<? super InputStream, Unit> consumer2) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)((Object)roamingType), (String)"roamingType");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            ByteArrayInputStream byteArrayInputStream;
            byte[] byArray;
            boolean bl = false;
            Function1<? super InputStream, Unit> function1 = consumer2;
            if (byArray != null) {
                void p0;
                byArray = this.nameToData.get(PathUtilRt.getFileName(fileSpec));
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"get(PathUtilRt.getFileName(fileSpec))");
                byte[] byArray2 = byArray;
                Function1<? super InputStream, Unit> function12 = function1;
                boolean bl2 = false;
                byteArrayInputStream = new ByteArrayInputStream((byte[])p0);
                function1 = function12;
            } else {
                byteArrayInputStream = null;
            }
            function1.invoke(byteArrayInputStream);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)((Object)roamingType), (String)"roamingType");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            byte[] byArray = (byte[])this.nameToData.remove(PathUtilRt.getFileName(fileSpec));
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.incModificationCount();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processChildren(@NotNull String path2, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter2, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)roamingType), (String)"roamingType");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            for (Map.Entry entry : ((Map)this.nameToData).entrySet()) {
                boolean bl2;
                String name = (String)entry.getKey();
                byte[] data2 = (byte[])entry.getValue();
                if (!((Boolean)filter2.invoke((Object)name)).booleanValue()) continue;
                Closeable closeable = new ByteArrayInputStream(data2);
                Throwable throwable = null;
                try {
                    ByteArrayInputStream it = (ByteArrayInputStream)closeable;
                    boolean bl3 = false;
                    bl2 = (Boolean)processor.invoke((Object)name, (Object)it, (Object)false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                if (bl2) continue;
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull String fileSpec, @NotNull byte[] content2, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)roamingType), (String)"roamingType");
        DefaultStateSerializerKt.getLOG().assertTrue(!(content2.length == 0));
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            byte[] byArray = this.nameToData.put(PathUtilRt.getFileName(fileSpec), content2);
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.incModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(@Nullable Element state, @Nullable Function1<? super Element, String> keyGetter) {
        if (state == null) {
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            for (int j = 0; j < n; ++j) {
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean $i$a$-write-SchemeManagerIprProvider$load$32 = false;
                this.nameToData.clear();
                Unit $i$a$-write-SchemeManagerIprProvider$load$32 = Unit.INSTANCE;
            }
            finally {
                for (int j = 0; j < n; ++j) {
                    readLock.lock();
                }
                writeLock.unlock();
            }
            this.incModificationCount();
            return;
        }
        LinkedHashMap<String, byte[]> nameToData = new LinkedHashMap<String, byte[]>();
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        for (Element child : state.getChildren(this.subStateTagName)) {
            Object object;
            Object name;
            Object object2;
            block23: {
                block22: {
                    if (JDOMUtil.isEmpty(child)) continue;
                    object2 = keyGetter;
                    if (object2 == null) break block22;
                    Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                    if ((object2 = (String)object2.invoke((Object)child)) != null) break block23;
                }
                object2 = child.getAttributeValue("name");
            }
            if ((name = object2) == null) {
                object = child.getChildren("option").iterator();
                while (object.hasNext()) {
                    Element optionElement = (Element)object.next();
                    if (!Intrinsics.areEqual((Object)optionElement.getAttributeValue("name"), (Object)"myName")) continue;
                    name = optionElement.getAttributeValue("value");
                }
            }
            if ((object = (CharSequence)name) == null || object.length() == 0) continue;
            String string2 = nameGenerator.generateUniqueName(FileUtil.sanitizeFileName(name, false) + ".xml");
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            nameToData.put(string2, JdomKt.toBufferExposingByteArray$default(child, null, 1, null).toByteArray());
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (this.comparator == null) {
                this.nameToData = nameToData;
            } else {
                this.nameToData.clear();
                this.nameToData.putAll(MapsKt.toSortedMap((Map)nameToData, this.comparator));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.incModificationCount();
    }

    public static /* synthetic */ void load$default(SchemeManagerIprProvider schemeManagerIprProvider, Element element, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        schemeManagerIprProvider.load(element, (Function1<? super Element, String>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Set<String> set2 = this.nameToData.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"nameToData.keys");
            Collection $this$toTypedArray$iv = set2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] names = thisCollection$iv.toArray(new String[0]);
            if (this.comparator == null) {
                ArraysKt.sort((Object[])((Comparable[])names));
            } else {
                ArraysKt.sortWith((Object[])names, this.comparator);
            }
            for (Object name : names) {
                byte[] it;
                if (this.nameToData.get(name) == null) continue;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                state.addContent(JDOMUtil.load(new ByteArrayInputStream(it)));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyIfNotExists(@NotNull SchemeManagerIprProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            ReentrantReadWriteLock reentrantReadWriteLock = provider2.lock;
            ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            for (int j = 0; j < n; ++j) {
                readLock2.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl2 = false;
                for (String key : this.nameToData.keySet()) {
                    if (provider2.nameToData.containsKey(key)) continue;
                    LinkedHashMap<String, byte[]> linkedHashMap = provider2.nameToData;
                    byte[] byArray = this.nameToData.get(key);
                    Intrinsics.checkNotNull((Object)byArray);
                    linkedHashMap.put(key, byArray);
                    provider2.incModificationCount();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                for (int j = 0; j < n; ++j) {
                    readLock2.lock();
                }
                writeLock.unlock();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }
}

