/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.MultiFilesSettings;
import com.intellij.conversion.impl.SettingsXmlFile;
import com.intellij.openapi.util.JDOMUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RunManagerSettingsImpl
implements RunManagerSettings {
    private static final String RUN_MANAGER_COMPONENT_NAME = "RunManager";
    private static final String CONFIGURATION_ELEMENT = "configuration";
    private final SettingsXmlFile myWorkspaceFile;
    @Nullable
    private final SettingsXmlFile myProjectFile;
    private final Path dir;
    private final ConversionContextImpl context;
    @Nullable
    private List<Path> sharedConfigurationFiles;

    RunManagerSettingsImpl(@NotNull SettingsXmlFile workspaceFile, @Nullable SettingsXmlFile projectFile, @Nullable Path dir, @NotNull ConversionContextImpl context2) throws CannotConvertException {
        if (workspaceFile == null) {
            RunManagerSettingsImpl.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            RunManagerSettingsImpl.$$$reportNull$$$0(1);
        }
        this.myWorkspaceFile = workspaceFile;
        this.myProjectFile = projectFile;
        this.dir = dir;
        this.context = context2;
    }

    @NotNull
    private List<Path> getSharedConfigurationFiles() {
        if (this.sharedConfigurationFiles == null) {
            this.sharedConfigurationFiles = this.dir == null ? Collections.emptyList() : MultiFilesSettings.getSettingsXmlFiles(this.dir);
        }
        List<Path> list2 = this.sharedConfigurationFiles;
        if (list2 == null) {
            RunManagerSettingsImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public Collection<Element> getRunConfigurations() {
        ArrayList<Element> result2 = new ArrayList<Element>();
        result2.addAll(JDOMUtil.getChildren(this.myWorkspaceFile.findComponent(RUN_MANAGER_COMPONENT_NAME), CONFIGURATION_ELEMENT));
        if (this.myProjectFile != null) {
            result2.addAll(JDOMUtil.getChildren(this.myProjectFile.findComponent("ProjectRunConfigurationManager"), CONFIGURATION_ELEMENT));
        }
        for (Path file2 : this.getSharedConfigurationFiles()) {
            result2.addAll(JDOMUtil.getChildren(this.context.getOrCreateFile(file2).getRootElement(), CONFIGURATION_ELEMENT));
        }
        ArrayList<Element> arrayList = result2;
        if (arrayList == null) {
            RunManagerSettingsImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void collectAffectedFiles(@NotNull Collection<? super Path> files2) {
        if (files2 == null) {
            RunManagerSettingsImpl.$$$reportNull$$$0(4);
        }
        files2.add(this.myWorkspaceFile.getFile());
        if (this.myProjectFile != null) {
            files2.add(this.myProjectFile.getFile());
        }
        files2.addAll(this.getSharedConfigurationFiles());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/RunManagerSettingsImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/RunManagerSettingsImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedConfigurationFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedFiles";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

