/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editor;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoIndexPatternProvider;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoAttributes;
import com.intellij.psi.search.TodoPattern;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.StorageException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class TodoItemsTestCase
extends LightPlatformCodeInsightTestCase {
    protected abstract String getFileExtension();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWithPattern(@NotNull String pattern, @NotNull Runnable runnable) {
        if (pattern == null) {
            TodoItemsTestCase.$$$reportNull$$$0(0);
        }
        if (runnable == null) {
            TodoItemsTestCase.$$$reportNull$$$0(1);
        }
        TodoConfiguration todoConfiguration = TodoConfiguration.getInstance();
        TodoPattern[] originalPatterns = todoConfiguration.getTodoPatterns();
        try {
            TodoPattern todoPattern = new TodoPattern(pattern, new TodoAttributes(new TextAttributes()), false);
            todoConfiguration.setTodoPatterns(new TodoPattern[]{todoPattern});
            PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
            runnable.run();
        }
        finally {
            todoConfiguration.setTodoPatterns(originalPatterns);
            PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
        }
    }

    @NotNull
    protected List<HighlightInfo> doHighlighting() {
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        int[] toIgnore = new int[]{1, 7, 12};
        Editor editor2 = this.getEditor();
        PsiFile file2 = this.getFile();
        if (editor2 instanceof EditorWindow) {
            editor2 = ((EditorWindow)editor2).getDelegate();
            file2 = InjectedLanguageManager.getInstance(file2.getProject()).getTopLevelFile(file2);
        }
        List<HighlightInfo> list2 = CodeInsightTestFixtureImpl.instantiateAndRun(file2, editor2, toIgnore, false);
        if (list2 == null) {
            TodoItemsTestCase.$$$reportNull$$$0(2);
        }
        return list2;
    }

    protected void testTodos(String text2) {
        this.configureFromFileText("Foo." + this.getFileExtension(), text2);
        EditorTestUtil.setEditorVisibleSize(this.getEditor(), 1000, 1000);
        List<TextRange> expectedTodoRanges = this.extractExpectedTodoRanges(this.getEditor().getDocument());
        List<HighlightInfo> highlightInfos = this.doHighlighting();
        List<TextRange> actualTodoRanges = TodoItemsTestCase.getActualTodoRanges(highlightInfos);
        this.assertTodoRanges(expectedTodoRanges, actualTodoRanges);
        this.assertSameTodoCountInIndexAndHighlighting();
    }

    private void assertSameTodoCountInIndexAndHighlighting() {
        int todosInIndex = TodoCacheManager.getInstance((Project)this.getProject()).getTodoCount(this.getVFile(), (IndexPatternProvider)TodoIndexPatternProvider.getInstance());
        int todosInHighlighting = PsiTodoSearchHelper.getInstance((Project)this.getProject()).findTodoItems(this.getFile()).length;
        TodoItemsTestCase.assertEquals((String)"Mismatch between todos in index and highlighting", (int)todosInIndex, (int)todosInHighlighting);
    }

    protected void checkTodos(String text2) {
        DocumentImpl document = new DocumentImpl(text2);
        List<TextRange> expectedTodoRanges = this.extractExpectedTodoRanges(document);
        List<HighlightInfo> highlightInfos = this.doHighlighting();
        this.checkResultByText(document.getText());
        List<TextRange> actualTodoRanges = TodoItemsTestCase.getActualTodoRanges(highlightInfos);
        this.assertTodoRanges(expectedTodoRanges, actualTodoRanges);
    }

    private List<TextRange> extractExpectedTodoRanges(Document document) {
        int startPos;
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        int offset2 = 0;
        while ((startPos = document.getText().indexOf(91, offset2)) != -1) {
            int finalStartPos = startPos;
            WriteCommandAction.runWriteCommandAction(this.getProject(), () -> document.deleteString(finalStartPos, finalStartPos + 1));
            int endPos = document.getText().indexOf(93, startPos);
            if (endPos == -1) break;
            WriteCommandAction.runWriteCommandAction(this.getProject(), () -> document.deleteString(endPos, endPos + 1));
            result2.add(new TextRange(startPos, endPos));
        }
        return result2;
    }

    private static List<TextRange> getActualTodoRanges(List<? extends HighlightInfo> highlightInfos) {
        return highlightInfos.stream().filter(info2 -> info2.type == HighlightInfoType.TODO).map(info2 -> info2.getHighlighter().getTextRange()).sorted(Segment.BY_START_OFFSET_THEN_END_OFFSET).collect(Collectors.toList());
    }

    private void assertTodoRanges(List<? extends TextRange> expectedTodoRanges, List<? extends TextRange> actualTodoRanges) {
        TodoItemsTestCase.assertEquals((String)"Unexpected todos highlighting", (String)this.generatePresentation(expectedTodoRanges), (String)this.generatePresentation(actualTodoRanges));
    }

    private String generatePresentation(List<? extends TextRange> ranges2) {
        StringBuilder b = new StringBuilder(this.getEditor().getDocument().getText());
        int prevStart = Integer.MAX_VALUE;
        for (int i2 = ranges2.size() - 1; i2 >= 0; --i2) {
            TextRange r = ranges2.get(i2);
            TodoItemsTestCase.assertTrue((r.getEndOffset() <= prevStart ? 1 : 0) != 0);
            b.insert(r.getEndOffset(), ']');
            prevStart = r.getStartOffset();
            b.insert(prevStart, '[');
        }
        return b.toString();
    }

    protected abstract boolean supportsCStyleSingleLineComments();

    protected abstract boolean supportsCStyleMultiLineComments();

    public void testSuccessiveLineComments() {
        if (!this.supportsCStyleSingleLineComments()) {
            return;
        }
        this.testTodos("// [TODO first line]\n//      [second line]");
    }

    public void testSuccessiveLineCommentsAfterEditing() {
        if (!this.supportsCStyleSingleLineComments()) {
            return;
        }
        this.testTodos("// [TODO first line]\n// <caret>second line");
        this.type("     ");
        this.checkTodos("// [TODO first line]\n//      [second line]");
    }

    public void testNewTodoAfterUnsavedEditing() {
        if (!this.supportsCStyleSingleLineComments()) {
            return;
        }
        this.testTodos("// [TODO first]\nwords\n<caret>");
        Document document = this.getEditor().getDocument();
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        PsiTodoSearchHelper todoSearchHelper = PsiTodoSearchHelper.getInstance((Project)this.getProject());
        this.assertTodoCountInIndexStorage(0);
        documentManager.saveDocument(document);
        TodoItemsTestCase.assertFalse((String)"saved doc expected", (boolean)documentManager.isDocumentUnsaved(document));
        TodoItemsTestCase.assertEquals((int)1, (int)todoSearchHelper.getTodoItemsCount(this.getFile()));
        this.assertSameTodoCountInIndexAndHighlighting();
        this.assertTodoCountInIndexStorage(1);
        this.type("// TODO second");
        TodoItemsTestCase.assertTrue((String)"unsaved doc expected", (boolean)documentManager.isDocumentUnsaved(document));
        TodoItemsTestCase.assertEquals((int)2, (int)todoSearchHelper.getTodoItemsCount(this.getFile()));
        this.checkTodos("// [TODO first]\nwords\n// [TODO second]");
        this.assertSameTodoCountInIndexAndHighlighting();
        this.assertTodoCountInIndexStorage(1);
    }

    private void assertTodoCountInIndexStorage(int count2) {
        try {
            Map map2 = (Map)ContainerUtil.getFirstItem(((FileBasedIndexEx)FileBasedIndex.getInstance()).getIndex(TodoIndex.NAME).getIndexedFileData(FileBasedIndex.getFileId((VirtualFile)this.getVFile())).values());
            int result2 = map2 == null ? 0 : map2.values().stream().mapToInt(o -> o).sum();
            TodoItemsTestCase.assertEquals((int)count2, (int)result2);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    public void testAllLinesLoseHighlightingWithFirstLine() {
        if (!this.supportsCStyleSingleLineComments()) {
            return;
        }
        this.testTodos("// [TO<caret>DO first line]\n//      [second line]");
        this.delete();
        this.checkTodos("// TOO first line\n//      second line");
    }

    public void testContinuationIsNotOverlappedWithFollowingTodo() {
        if (!this.supportsCStyleSingleLineComments()) {
            return;
        }
        this.testTodos("// [TODO first line]\n//  [TODO second line]");
    }

    public void testContinuationInBlockCommentWithStars() {
        if (!this.supportsCStyleMultiLineComments()) {
            return;
        }
        this.testTodos("/*\n * [TODO first line]\n *  [second line]\n */");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/editor/TodoItemsTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/editor/TodoItemsTestCase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doHighlighting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doWithPattern";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

