/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingReference;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleListCellRenderer;
import java.awt.Component;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\r\u000e\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/execution/console/ConsoleEncodingComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/execution/console/ConsoleEncodingComboBox$EncodingItem;", "()V", "listModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "getListModel", "()Lcom/intellij/ui/CollectionComboBoxModel;", "getSelectedEncodingReference", "Lcom/intellij/openapi/vfs/encoding/EncodingReference;", "reset", "", "reference", "CharsetItem", "Companion", "EncodingItem", "LabelItem", "SelectableItem", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nConsoleEncodingComboBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleEncodingComboBox.kt\ncom/intellij/execution/console/ConsoleEncodingComboBox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1549#2:129\n1620#2,3:130\n1549#2:133\n1620#2,3:134\n*S KotlinDebug\n*F\n+ 1 ConsoleEncodingComboBox.kt\ncom/intellij/execution/console/ConsoleEncodingComboBox\n*L\n101#1:129\n101#1:130,3\n102#1:133\n102#1:134,3\n*E\n"})
public final class ConsoleEncodingComboBox
extends ComboBox<EncodingItem> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public ConsoleEncodingComboBox() {
        this.setModel(new CollectionComboBoxModel<EncodingItem>(){

            @Override
            public void setSelectedItem(@Nullable Object item) {
                if (!(item instanceof SelectableItem)) {
                    return;
                }
                super.setSelectedItem(item);
            }
        });
        this.renderer = (ListCellRenderer)new SimpleListCellRenderer<EncodingItem>(){

            @NotNull
            public Component getListCellRendererComponent(@Nullable JList<? extends EncodingItem> list2, @NotNull EncodingItem value, int index2, boolean selected, boolean hasFocus) {
                Component component2;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (value instanceof LabelItem) {
                    SeparatorWithText separator = new SeparatorWithText();
                    separator.setCaption(StringUtil.shortenTextWithEllipsis(((LabelItem)value).getLabel(), 40, 3));
                    separator.setCaptionCentered(false);
                    component2 = (Component)separator;
                } else {
                    Component component3 = super.getListCellRendererComponent(list2, (Object)value, index2, selected, hasFocus);
                    component2 = component3;
                    Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"{\n          super.getLis\u2026cted, hasFocus)\n        }");
                }
                return component2;
            }

            public void customize(@NotNull JList<? extends EncodingItem> list2, @NotNull EncodingItem value, int index2, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.setText(value.toString());
            }
        };
    }

    private final CollectionComboBoxModel<EncodingItem> getListModel() {
        ComboBoxModel comboBoxModel = this.getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.intellij.ui.CollectionComboBoxModel<com.intellij.execution.console.ConsoleEncodingComboBox.EncodingItem>");
        return (CollectionComboBoxModel)comboBoxModel;
    }

    /*
     * WARNING - void declaration
     */
    public final void reset(@NotNull EncodingReference reference2) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        EncodingManager encodingManager = EncodingManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)encodingManager, (String)"getInstance()");
        EncodingManager encodingManager2 = encodingManager;
        Collection<Charset> collection2 = encodingManager2.getFavorites();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"encodingManager.favorites");
        Iterable $this$map$iv = collection2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Charset charset = (Charset)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(new CharsetItem((Charset)it));
        }
        List favorites = (List)destination$iv$iv;
        Collection<Charset> collection3 = Charset.availableCharsets().values();
        Intrinsics.checkNotNullExpressionValue(collection3, (String)"availableCharsets().values");
        Iterable $this$map$iv2 = collection3;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Charset bl = (Charset)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(new CharsetItem((Charset)it));
        }
        List available = (List)destination$iv$iv2;
        this.getListModel().add(CharsetItem.Companion.getDEFAULT());
        CollectionComboBoxModel<EncodingItem> collectionComboBoxModel = this.getListModel();
        String string2 = ApplicationBundle.message((String)"combobox.console.favorites.separator.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"combobox.consol\u2026vorites.separator.label\")");
        collectionComboBoxModel.add(new LabelItem(string2));
        this.getListModel().add(favorites);
        CollectionComboBoxModel<EncodingItem> collectionComboBoxModel2 = this.getListModel();
        String string3 = ApplicationBundle.message((String)"combobox.console.more.separator.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"combobox.console.more.separator.label\")");
        collectionComboBoxModel2.add(new LabelItem(string3));
        this.getListModel().add(available);
        this.getListModel().setSelectedItem(new CharsetItem(reference2));
    }

    @NotNull
    public final EncodingReference getSelectedEncodingReference() {
        EncodingReference encodingReference;
        if (this.getSelectedItem() instanceof CharsetItem) {
            Object object = this.getSelectedItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.execution.console.ConsoleEncodingComboBox.CharsetItem");
            encodingReference = ((CharsetItem)object).getReference();
        } else {
            LOG.error("Encoding should be either DEFAULT or an actual Charset. Got " + this.getSelectedItem());
            encodingReference = EncodingReference.DEFAULT;
        }
        return encodingReference;
    }

    static {
        Logger logger = Logger.getInstance(ConsoleEncodingComboBox.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(ConsoleEncodingComboBox::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0002\u00c0\u0006\u0001"}, d2={"Lcom/intellij/execution/console/ConsoleEncodingComboBox$EncodingItem;", "", "intellij.platform.lang.impl"})
    public static interface EncodingItem {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\n\u001a\u00020\u0006H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/console/ConsoleEncodingComboBox$CharsetItem;", "Lcom/intellij/execution/console/ConsoleEncodingComboBox$SelectableItem;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "reference", "Lcom/intellij/openapi/vfs/encoding/EncodingReference;", "(Lcom/intellij/openapi/vfs/encoding/EncodingReference;)V", "getReference", "()Lcom/intellij/openapi/vfs/encoding/EncodingReference;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "intellij.platform.lang.impl"})
    private static final class CharsetItem
    implements SelectableItem {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final EncodingReference reference;
        @NotNull
        private static final CharsetItem DEFAULT = new CharsetItem(EncodingReference.DEFAULT);

        public CharsetItem(@NotNull EncodingReference reference2) {
            Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
            this.reference = reference2;
        }

        @NotNull
        public final EncodingReference getReference() {
            return this.reference;
        }

        public CharsetItem(@NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            this(new EncodingReference(charset));
        }

        @NotNull
        public String toString() {
            String string2;
            String string3;
            Charset charset = this.reference.getCharset();
            String string4 = string3 = charset != null ? charset.displayName() : null;
            if (string3 == null) {
                Object[] objectArray = new Object[]{CharsetToolkit.getDefaultSystemCharset().displayName()};
                String string5 = IdeBundle.message((String)"encoding.name.system.default", (Object[])objectArray);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"encoding.name.s\u2026mCharset().displayName())");
            } else {
                string2 = string3;
            }
            return string2;
        }

        @NotNull
        public final EncodingReference component1() {
            return this.reference;
        }

        @NotNull
        public final CharsetItem copy(@NotNull EncodingReference reference2) {
            Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
            return new CharsetItem(reference2);
        }

        public static /* synthetic */ CharsetItem copy$default(CharsetItem charsetItem, EncodingReference encodingReference, int n, Object object) {
            if ((n & 1) != 0) {
                encodingReference = charsetItem.reference;
            }
            return charsetItem.copy(encodingReference);
        }

        public int hashCode() {
            return this.reference.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CharsetItem)) {
                return false;
            }
            CharsetItem charsetItem = (CharsetItem)other;
            return Intrinsics.areEqual((Object)this.reference, (Object)charsetItem.reference);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/execution/console/ConsoleEncodingComboBox$CharsetItem$Companion;", "", "()V", "DEFAULT", "Lcom/intellij/execution/console/ConsoleEncodingComboBox$CharsetItem;", "getDEFAULT", "()Lcom/intellij/execution/console/ConsoleEncodingComboBox$CharsetItem;", "intellij.platform.lang.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CharsetItem getDEFAULT() {
                return DEFAULT;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/console/ConsoleEncodingComboBox$LabelItem;", "Lcom/intellij/execution/console/ConsoleEncodingComboBox$EncodingItem;", "label", "", "(Ljava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    private static final class LabelItem
    implements EncodingItem {
        @NotNull
        private final String label;

        public LabelItem(@NlsContexts.Separator @NotNull String label2) {
            Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
            this.label = label2;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final String component1() {
            return this.label;
        }

        @NotNull
        public final LabelItem copy(@NlsContexts.Separator @NotNull String label2) {
            Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
            return new LabelItem(label2);
        }

        public static /* synthetic */ LabelItem copy$default(LabelItem labelItem, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = labelItem.label;
            }
            return labelItem.copy(string2);
        }

        @NotNull
        public String toString() {
            return "LabelItem(label=" + this.label + ")";
        }

        public int hashCode() {
            return this.label.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LabelItem)) {
                return false;
            }
            LabelItem labelItem = (LabelItem)other;
            return Intrinsics.areEqual((Object)this.label, (Object)labelItem.label);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/execution/console/ConsoleEncodingComboBox$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0002\u00c0\u0006\u0001"}, d2={"Lcom/intellij/execution/console/ConsoleEncodingComboBox$SelectableItem;", "Lcom/intellij/execution/console/ConsoleEncodingComboBox$EncodingItem;", "intellij.platform.lang.impl"})
    private static interface SelectableItem
    extends EncodingItem {
    }
}

