/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/console/ConsoleHistoryCopyHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "originalHandler", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "getOriginalHandler", "()Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "doCopyWithoutPrompt", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "doExecute", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "Companion", "intellij.platform.lang.impl"})
public final class ConsoleHistoryCopyHandler
extends EditorActionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorActionHandler originalHandler;
    @JvmField
    @NotNull
    public static final Key<Integer> PROMPT_LENGTH_MARKER;

    public ConsoleHistoryCopyHandler(@NotNull EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
        this.originalHandler = originalHandler;
    }

    @NotNull
    public final EditorActionHandler getOriginalHandler() {
        return this.originalHandler;
    }

    protected void doExecute(@NotNull Editor editor2, @Nullable Caret caret, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        if (!RichCopySettings.getInstance().isEnabled()) {
            this.originalHandler.execute(editor2, null, dataContext2);
            return;
        }
        if (!Intrinsics.areEqual((Object)true, (Object)editor2.getUserData(ConsoleViewUtil.EDITOR_IS_CONSOLE_HISTORY_VIEW)) || editor2.getCaretModel().getAllCarets().size() != 1) {
            this.originalHandler.execute(editor2, null, dataContext2);
            return;
        }
        this.doCopyWithoutPrompt((EditorEx)editor2);
    }

    private final void doCopyWithoutPrompt(EditorEx editor2) {
        int start = editor2.getSelectionModel().getSelectionStart();
        int end = editor2.getSelectionModel().getSelectionEnd();
        DocumentEx documentEx = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        DocumentEx document = documentEx;
        int beginLine = document.getLineNumber(start);
        int endLine = document.getLineNumber(end);
        StringBuilder sb = new StringBuilder();
        int i2 = beginLine;
        if (i2 <= endLine) {
            while (true) {
                int rangeEnd;
                int rangeStart;
                Ref<Integer> r;
                int lineStart = document.getLineStartOffset(i2);
                Intrinsics.checkNotNullExpressionValue(Ref.create(), (String)"create<Int>()");
                editor2.getMarkupModel().processRangeHighlightersOverlappingWith(lineStart, lineStart, arg_0 -> ConsoleHistoryCopyHandler.doCopyWithoutPrompt$lambda$0((Function1)new Function1<RangeHighlighterEx, Boolean>(r){
                    final /* synthetic */ Ref<Integer> $r;
                    {
                        this.$r = $r;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(RangeHighlighterEx it) {
                        Integer n = (Integer)it.getUserData(ConsoleHistoryCopyHandler.PROMPT_LENGTH_MARKER);
                        if (n == null) {
                            return true;
                        }
                        int length = ((Number)n).intValue();
                        this.$r.set(length);
                        return false;
                    }
                }, arg_0));
                if (!r.isNull()) {
                    Integer n = r.get();
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"r.get()");
                    lineStart += ((Number)n).intValue();
                }
                if ((rangeStart = Math.max(lineStart, start)) < (rangeEnd = Math.min(document.getLineEndOffset(i2), end))) {
                    sb.append(document.getText(new TextRange(rangeStart, rangeEnd)));
                    if (rangeEnd < end) {
                        sb.append("\n");
                    }
                }
                if (i2 == endLine) break;
                ++i2;
            }
        }
        if (((CharSequence)sb).length() > 0) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb.toString()));
        }
    }

    private static final boolean doCopyWithoutPrompt$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Key key = Key.create("PROMPT_LENGTH_MARKER");
        Intrinsics.checkNotNullExpressionValue(key, (String)"create<Int>(\"PROMPT_LENGTH_MARKER\")");
        PROMPT_LENGTH_MARKER = key;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/execution/console/ConsoleHistoryCopyHandler$Companion;", "", "()V", "PROMPT_LENGTH_MARKER", "Lcom/intellij/openapi/util/Key;", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

