/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0018H\u0016J\u001a\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0006\u0010.\u001a\u00020-J\b\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007H\u0002R&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u00064"}, d2={"Lcom/intellij/execution/console/ConsolePromptDecorator;", "Lcom/intellij/openapi/editor/EditorLinePainter;", "Lcom/intellij/openapi/editor/TextAnnotationGutterProvider;", "myEditorEx", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "indentPrompt", "", "getIndentPrompt", "()Ljava/lang/String;", "setIndentPrompt", "(Ljava/lang/String;)V", "mainPrompt", "getMainPrompt", "setMainPrompt", "promptAttributes", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "getPromptAttributes", "()Lcom/intellij/execution/ui/ConsoleViewContentType;", "setPromptAttributes", "(Lcom/intellij/execution/ui/ConsoleViewContentType;)V", "getBgColor", "Ljava/awt/Color;", "line", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getColor", "Lcom/intellij/openapi/editor/colors/ColorKey;", "getLineExtensions", "", "Lcom/intellij/openapi/editor/LineExtensionInfo;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "lineNumber", "getLineText", "getPopupActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getStyle", "Lcom/intellij/openapi/editor/colors/EditorFontType;", "getToolTip", "gutterClosed", "", "update", "useMargin", "", "wrapPrompt", "prompt", "Companion", "intellij.platform.lang.impl"})
public final class ConsolePromptDecorator
extends EditorLinePainter
implements TextAnnotationGutterProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx myEditorEx;
    @NotNull
    private String mainPrompt;
    @NotNull
    private ConsoleViewContentType promptAttributes;
    @NotNull
    private String indentPrompt;
    @NotNull
    private static final ColorKey promptColor;

    public ConsolePromptDecorator(@NotNull EditorEx myEditorEx) {
        Intrinsics.checkNotNullParameter((Object)myEditorEx, (String)"myEditorEx");
        this.myEditorEx = myEditorEx;
        this.mainPrompt = "> ";
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.USER_INPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"USER_INPUT");
        this.promptAttributes = consoleViewContentType;
        this.indentPrompt = "";
        this.myEditorEx.getColorsScheme().setColor(promptColor, this.promptAttributes.getAttributes().getForegroundColor());
    }

    @NotNull
    public final String getMainPrompt() {
        return this.myEditorEx.isRendererMode() ? "" : this.mainPrompt;
    }

    public final void setMainPrompt(@NotNull String mainPrompt) {
        Intrinsics.checkNotNullParameter((Object)mainPrompt, (String)"mainPrompt");
        String mainPromptWrapped = this.wrapPrompt(mainPrompt);
        if (!Intrinsics.areEqual((Object)this.getMainPrompt(), (Object)mainPromptWrapped)) {
            this.setIndentPrompt("");
            this.mainPrompt = mainPromptWrapped;
            this.update();
        }
    }

    @NotNull
    public final ConsoleViewContentType getPromptAttributes() {
        return this.promptAttributes;
    }

    public final void setPromptAttributes(@NotNull ConsoleViewContentType promptAttributes) {
        Intrinsics.checkNotNullParameter((Object)promptAttributes, (String)"promptAttributes");
        this.promptAttributes = promptAttributes;
        this.myEditorEx.getColorsScheme().setColor(promptColor, promptAttributes.getAttributes().getForegroundColor());
        this.update();
    }

    @NotNull
    public final String getIndentPrompt() {
        return this.myEditorEx.isRendererMode() ? "" : this.indentPrompt;
    }

    public final void setIndentPrompt(@NotNull String indentPrompt) {
        String indentPromptWrapped;
        Intrinsics.checkNotNullParameter((Object)indentPrompt, (String)"indentPrompt");
        this.indentPrompt = indentPromptWrapped = this.wrapPrompt(indentPrompt);
        this.update();
    }

    private final String wrapPrompt(String prompt) {
        return !StringsKt.endsWith$default((String)prompt, (String)" ", (boolean)false, (int)2, null) ? prompt + " " : prompt;
    }

    @Nullable
    public Collection<LineExtensionInfo> getLineExtensions(@NotNull Project project2, @NotNull VirtualFile file2, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return null;
    }

    @Nullable
    public String getLineText(int line, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (line == 0) {
            return this.getMainPrompt();
        }
        if (line > 0) {
            return this.getIndentPrompt();
        }
        return null;
    }

    @Nullable
    public String getToolTip(int line, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return null;
    }

    @NotNull
    public EditorFontType getStyle(int line, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return EditorFontType.CONSOLE_PLAIN;
    }

    @NotNull
    public ColorKey getColor(int line, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return promptColor;
    }

    @NotNull
    public Color getBgColor(int line, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Color backgroundColor = this.promptAttributes.getAttributes().getBackgroundColor();
        if (backgroundColor == null) {
            backgroundColor = this.myEditorEx.getBackgroundColor();
        }
        return backgroundColor;
    }

    @Nullable
    public List<AnAction> getPopupActions(int line, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return null;
    }

    public void gutterClosed() {
    }

    public boolean useMargin() {
        return false;
    }

    public final void update() {
        UIUtil.invokeLaterIfNeeded(() -> ConsolePromptDecorator.update$lambda$0(this));
    }

    private static final void update$lambda$0(ConsolePromptDecorator this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (!this$0.myEditorEx.isDisposed()) {
            this$0.myEditorEx.getGutterComponentEx().revalidateMarkup();
        }
    }

    static {
        ColorKey colorKey = ColorKey.createColorKey("CONSOLE_PROMPT_COLOR");
        Intrinsics.checkNotNullExpressionValue((Object)colorKey, (String)"createColorKey(\"CONSOLE_PROMPT_COLOR\")");
        promptColor = colorKey;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/execution/console/ConsolePromptDecorator$Companion;", "", "()V", "promptColor", "Lcom/intellij/openapi/editor/colors/ColorKey;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

