/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import org.jetbrains.annotations.NotNull;

public class EditorMergedHorizontalScrollBarLayout
extends AbstractLayoutManager {
    private final JScrollBar myScrollBar;
    private final EditorEx myFirst;
    private final EditorEx mySecond;
    private final boolean myForceAdditionalColumnsUsage;
    private final int myMinLineCount;

    public EditorMergedHorizontalScrollBarLayout(@NotNull JScrollBar scrollBar, @NotNull EditorEx first2, @NotNull EditorEx second2, boolean forceAdditionalColumnsUsage, int minLineCount) {
        if (scrollBar == null) {
            EditorMergedHorizontalScrollBarLayout.$$$reportNull$$$0(0);
        }
        if (first2 == null) {
            EditorMergedHorizontalScrollBarLayout.$$$reportNull$$$0(1);
        }
        if (second2 == null) {
            EditorMergedHorizontalScrollBarLayout.$$$reportNull$$$0(2);
        }
        this.myScrollBar = scrollBar;
        this.myFirst = first2;
        this.mySecond = second2;
        this.myForceAdditionalColumnsUsage = forceAdditionalColumnsUsage;
        this.myMinLineCount = minLineCount;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent2) {
        return new Dimension(0, 0);
    }

    @Override
    public void layoutContainer(@NotNull Container parent2) {
        boolean scrollBarNeeded;
        int componentCount;
        if (parent2 == null) {
            EditorMergedHorizontalScrollBarLayout.$$$reportNull$$$0(3);
        }
        if ((componentCount = parent2.getComponentCount()) == 0) {
            return;
        }
        EditorEx history = this.myFirst;
        EditorEx input = this.mySecond;
        if (!input.getComponent().isVisible()) {
            parent2.getComponent(0).setBounds(parent2.getBounds());
            return;
        }
        Dimension panelSize = parent2.getSize();
        Dimension historySize = history.getContentSize();
        Dimension inputSize = input.getContentSize();
        boolean bl = scrollBarNeeded = historySize.width > panelSize.width || inputSize.width > panelSize.width;
        if (scrollBarNeeded && this.myScrollBar.isVisible()) {
            Dimension size = this.myScrollBar.getPreferredSize();
            if (panelSize.height < size.height) {
                return;
            }
            panelSize.height -= size.height;
            this.myScrollBar.setBounds(0, panelSize.height, panelSize.width, size.height);
        }
        if (panelSize.getHeight() <= 0.0) {
            return;
        }
        if (this.myForceAdditionalColumnsUsage && !history.isDisposed() && !input.isDisposed()) {
            history.getSoftWrapModel().forceAdditionalColumnsUsage();
            int minAdditionalColumns = 2;
            int historySpaceWidth = EditorUtil.getPlainSpaceWidth((Editor)history);
            historySize.width += historySpaceWidth * (minAdditionalColumns - history.getSettings().getAdditionalColumnsCount());
            int inputSpaceWidth = EditorUtil.getPlainSpaceWidth((Editor)input);
            inputSize.width += inputSpaceWidth * (minAdditionalColumns - input.getSettings().getAdditionalColumnsCount());
            int max = Math.max(historySize.width, inputSize.width);
            history.getSettings().setAdditionalColumnsCount(minAdditionalColumns + (max - historySize.width) / historySpaceWidth);
            input.getSettings().setAdditionalColumnsCount(minAdditionalColumns + (max - inputSize.width) / inputSpaceWidth);
        }
        if (history.getDocument().getLineCount() == 0) {
            historySize.height = 0;
        }
        int minHistoryHeight = historySize.height > 0 ? this.myMinLineCount * history.getLineHeight() : 0;
        int minInputHeight = input.isViewer() ? 0 : input.getLineHeight();
        int inputPreferredHeight = input.isViewer() ? 0 : Math.max(minInputHeight, inputSize.height);
        int historyPreferredHeight = Math.max(minHistoryHeight, historySize.height);
        int newInputHeight = panelSize.height < minInputHeight ? panelSize.height : (panelSize.height < inputPreferredHeight ? panelSize.height - minHistoryHeight : (panelSize.height < inputPreferredHeight + historyPreferredHeight || inputPreferredHeight == 0 ? inputPreferredHeight : panelSize.height - historyPreferredHeight));
        int oldHistoryHeight = history.getComponent().getHeight();
        int newHistoryHeight = panelSize.height - newInputHeight;
        HeightOfComponents normalizedHeights = this.normalizeHeights(newHistoryHeight, newInputHeight);
        newHistoryHeight = normalizedHeights.historyConsoleHeight;
        newInputHeight = normalizedHeights.inputConsoleHeight;
        input.getComponent().setBounds(0, newHistoryHeight, panelSize.width, newInputHeight);
        history.getComponent().setBounds(0, 0, panelSize.width, newHistoryHeight);
        input.getComponent().doLayout();
        history.getComponent().doLayout();
        if (newHistoryHeight < oldHistoryHeight) {
            JViewport viewport = history.getScrollPane().getViewport();
            Point position = viewport.getViewPosition();
            position.translate(0, oldHistoryHeight - newHistoryHeight);
            viewport.setViewPosition(position);
        }
    }

    protected HeightOfComponents normalizeHeights(int newHistoryHeight, int newInputHeight) {
        EditorEx history = this.myFirst;
        int delta = newHistoryHeight - newHistoryHeight / history.getLineHeight() * history.getLineHeight();
        return new HeightOfComponents(newHistoryHeight - delta, newInputHeight + delta);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollBar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/console/EditorMergedHorizontalScrollBarLayout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "layoutContainer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class HeightOfComponents {
        public int historyConsoleHeight;
        public int inputConsoleHeight;

        public HeightOfComponents(int historyHeight, int inputHeight) {
            this.historyConsoleHeight = historyHeight;
            this.inputConsoleHeight = inputHeight;
        }
    }
}

