/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleHistoryBaseModel;
import com.intellij.execution.console.ConsoleHistoryModel;
import com.intellij.execution.console.MasterModel;
import com.intellij.execution.console.PrefixHistoryModelKt;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\fH\u0016J5\u0010\u001d\u001a.\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00070\u0007 \u001f*\u0015\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00070\u00070\n\u00a2\u0006\u0002\b 0\u001e\u00a2\u0006\u0002\b H\u0097\u0001J\n\u0010!\u001a\u0004\u0018\u00010\u001aH\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u001aH\u0016J\t\u0010#\u001a\u00020\fH\u0096\u0001J\t\u0010$\u001a\u00020\fH\u0096\u0001J\t\u0010%\u001a\u00020&H\u0096\u0001J\b\u0010'\u001a\u00020(H\u0016J\t\u0010)\u001a\u00020(H\u0096\u0001J\b\u0010*\u001a\u00020(H\u0016J\u0012\u0010+\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0016J\u0016\u0010,\u001a\u00020\u00172\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070\u001eH\u0016J\b\u0010.\u001a\u00020\u0017H\u0002J\u0010\u0010/\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u00060"}, d2={"Lcom/intellij/execution/console/PrefixHistoryModel;", "Lcom/intellij/execution/console/ConsoleHistoryBaseModel;", "Lcom/intellij/execution/console/ConsoleHistoryModel;", "masterModel", "Lcom/intellij/execution/console/MasterModel;", "getPrefixFn", "Lkotlin/Function0;", "", "(Lcom/intellij/execution/console/MasterModel;Lkotlin/jvm/functions/Function0;)V", "currentEntries", "", "currentIndex", "", "Ljava/lang/Integer;", "historyPrefix", "prevEntries", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "userContent", "getUserContent", "()Ljava/lang/String;", "setUserContent", "(Ljava/lang/String;)V", "addToHistory", "", "statement", "createEntry", "Lcom/intellij/execution/console/ConsoleHistoryModel$Entry;", "prevEntry", "getCurrentIndex", "getEntries", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getHistoryNext", "getHistoryPrev", "getHistorySize", "getMaxHistorySize", "getModificationCount", "", "hasHistory", "", "isEmpty", "prevOnLastLine", "removeFromHistory", "resetEntries", "entries", "resetIndex", "setContent", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nPrefixHistoryModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrefixHistoryModel.kt\ncom/intellij/execution/console/PrefixHistoryModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
final class PrefixHistoryModel
implements ConsoleHistoryBaseModel,
ConsoleHistoryModel {
    @NotNull
    private final MasterModel masterModel;
    @NotNull
    private final Function0<String> getPrefixFn;
    @NotNull
    private String userContent;
    @Nullable
    private Integer currentIndex;
    @Nullable
    private List<String> currentEntries;
    @NotNull
    private IntArrayList prevEntries;
    @NotNull
    private String historyPrefix;

    public PrefixHistoryModel(@NotNull MasterModel masterModel, @NotNull Function0<String> getPrefixFn) {
        Intrinsics.checkNotNullParameter((Object)masterModel, (String)"masterModel");
        Intrinsics.checkNotNullParameter(getPrefixFn, (String)"getPrefixFn");
        this.masterModel = masterModel;
        this.getPrefixFn = getPrefixFn;
        this.userContent = "";
        this.prevEntries = new IntArrayList();
        this.historyPrefix = "";
        this.resetIndex();
    }

    @Override
    @NotNull
    public List<String> getEntries() {
        return this.masterModel.getEntries();
    }

    @Override
    public int getHistorySize() {
        return this.masterModel.getHistorySize();
    }

    @Override
    public int getMaxHistorySize() {
        return this.masterModel.getMaxHistorySize();
    }

    @Override
    public long getModificationCount() {
        return this.masterModel.getModificationCount();
    }

    @Override
    public boolean isEmpty() {
        return this.masterModel.isEmpty();
    }

    @NotNull
    public final String getUserContent() {
        return this.userContent;
    }

    public final void setUserContent(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.userContent = string2;
    }

    @Override
    public void setContent(@NotNull String userContent) {
        Intrinsics.checkNotNullParameter((Object)userContent, (String)"userContent");
        this.userContent = userContent;
    }

    @Override
    public void resetEntries(@NotNull List<String> entries2) {
        Intrinsics.checkNotNullParameter(entries2, (String)"entries");
        this.masterModel.resetEntries(entries2);
        this.resetIndex();
    }

    @Override
    public void addToHistory(@Nullable String statement2) {
        PrefixHistoryModelKt.access$assertWriteThread();
        CharSequence charSequence = statement2;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        this.masterModel.addToHistory(statement2);
        this.resetIndex();
    }

    @Override
    public void removeFromHistory(@Nullable String statement2) {
        PrefixHistoryModelKt.access$assertWriteThread();
        CharSequence charSequence = statement2;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        this.masterModel.removeFromHistory(statement2);
        this.resetIndex();
    }

    private final void resetIndex() {
        this.currentIndex = null;
        this.currentEntries = null;
        this.prevEntries.clear();
        this.historyPrefix = "";
    }

    @Override
    @Nullable
    public ConsoleHistoryModel.Entry getHistoryNext() {
        int offset2;
        List<String> list2 = this.currentEntries;
        if (list2 == null) {
            list2 = this.masterModel.getEntries();
        }
        List<String> entries2 = list2;
        Integer n = this.currentIndex;
        int n2 = offset2 = n != null ? n.intValue() : entries2.size();
        if (offset2 <= 0) {
            return null;
        }
        if (this.currentIndex == null) {
            this.historyPrefix = (String)this.getPrefixFn.invoke();
        }
        Iterable iterable = CollectionsKt.withIndex((Iterable)entries2);
        Object var5_5 = null;
        for (Object t : iterable) {
            IndexedValue it = (IndexedValue)t;
            boolean bl = false;
            if (!(it.getIndex() < offset2 && StringsKt.startsWith$default((String)((String)it.getValue()), (String)this.historyPrefix, (boolean)false, (int)2, null))) continue;
            var5_5 = t;
        }
        IndexedValue indexedValue = var5_5;
        if (indexedValue == null) {
            return null;
        }
        IndexedValue res = indexedValue;
        if (this.currentEntries == null) {
            this.currentEntries = entries2;
        }
        Integer n3 = this.currentIndex;
        if (n3 != null) {
            int it = ((Number)n3).intValue();
            boolean bl = false;
            this.prevEntries.push(it);
        }
        this.currentIndex = res.getIndex();
        return this.createEntry((String)res.getValue());
    }

    @Override
    @Nullable
    public ConsoleHistoryModel.Entry getHistoryPrev() {
        ConsoleHistoryModel.Entry entry;
        List<String> list2 = this.currentEntries;
        if (list2 == null) {
            return null;
        }
        List<String> entries2 = list2;
        if (this.prevEntries.size() > 0) {
            int index2 = this.prevEntries.popInt();
            this.currentIndex = index2;
            entry = this.createEntry(entries2.get(index2));
        } else {
            this.resetIndex();
            entry = this.createEntry(this.userContent);
        }
        return entry;
    }

    private final ConsoleHistoryModel.Entry createEntry(String prevEntry) {
        return new ConsoleHistoryModel.Entry(prevEntry, prevEntry.length());
    }

    @Override
    public int getCurrentIndex() {
        Integer n = this.currentIndex;
        return n != null ? n : this.getEntries().size() - 1;
    }

    @Override
    public boolean prevOnLastLine() {
        return true;
    }

    @Override
    public boolean hasHistory() {
        return this.currentEntries != null;
    }
}

