/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class UseConsoleInputAction
extends ToggleAction
implements DumbAware {
    private final String processInputStateKey;
    private boolean useProcessStdIn;

    UseConsoleInputAction(@NotNull String processInputStateKey) {
        if (processInputStateKey == null) {
            UseConsoleInputAction.$$$reportNull$$$0(0);
        }
        super(ExecutionBundle.message((String)"action.text.use.console.input", (Object[])new Object[0]), null, AllIcons.Debugger.Console);
        this.processInputStateKey = processInputStateKey;
        this.useProcessStdIn = PropertiesComponent.getInstance().getBoolean(processInputStateKey);
    }

    public boolean isSelected(@NotNull AnActionEvent event) {
        if (event == null) {
            UseConsoleInputAction.$$$reportNull$$$0(1);
        }
        return !this.useProcessStdIn;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            UseConsoleInputAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        if (event == null) {
            UseConsoleInputAction.$$$reportNull$$$0(3);
        }
        this.useProcessStdIn = !state;
        LanguageConsoleView consoleView = (LanguageConsoleView)event.getData(LangDataKeys.CONSOLE_VIEW);
        assert (consoleView != null);
        DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance(consoleView.getProject());
        PsiFile file2 = consoleView.getFile();
        daemonCodeAnalyzer.setHighlightingEnabled(file2, state);
        daemonCodeAnalyzer.restart(file2);
        PropertiesComponent.getInstance().setValue(this.processInputStateKey, this.useProcessStdIn);
        List actions = ActionUtil.getActions((JComponent)consoleView.getConsoleEditor().getComponent());
        ConsoleExecuteAction action2 = ContainerUtil.findInstance(actions, ConsoleExecuteAction.class);
        action2.myExecuteActionHandler.myUseProcessStdIn = !state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInputStateKey";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/UseConsoleInputAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/UseConsoleInputAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

