/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.UIBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class ConfigurationTypeRunDashboardAdvertiser
implements RunManagerListener,
Disposable {
    public static final String DASHBOARD_NOTIFICATION_GROUP_ID = "Services Tool Window";
    private static final String DASHBOARD_MULTIPLE_RUN_CONFIGURATIONS_NOTIFICATION_ID = "run.dashboard.multiple.run.configurations";
    private static final String SHOW_RUN_DASHBOARD_NOTIFICATION = "show.run.dashboard.notification";
    private final Project myProject;
    private final String myRunConfigurationTypeId;
    private Notification myNotification;
    private volatile boolean myDisposed;

    public ConfigurationTypeRunDashboardAdvertiser(@NotNull Project project2, String runConfigurationTypeId) {
        if (project2 == null) {
            ConfigurationTypeRunDashboardAdvertiser.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myRunConfigurationTypeId = runConfigurationTypeId;
    }

    @Override
    public void dispose() {
        if (this.myNotification != null) {
            this.myNotification.expire();
            this.myNotification = null;
        }
        this.myDisposed = true;
    }

    public void subscribe(Supplier<? extends Disposable> parentDisposableSupplier) {
        if (this.myProject.isDefault() || ApplicationManager.getApplication().isUnitTestMode() || this.myProject.isDisposed()) {
            return;
        }
        Disposable parentDisposable = parentDisposableSupplier.get();
        MessageBusConnection connection = this.myProject.getMessageBus().connect(parentDisposable);
        Disposer.register(parentDisposable, this);
        connection.subscribe(RunManagerListener.TOPIC, this);
        if (!ConfigurationTypeRunDashboardAdvertiser.migrateNotificationProperty(this.myProject) && ConfigurationTypeRunDashboardAdvertiser.isEnabled(this.myProject)) {
            this.checkRunDashboardAvailability();
        }
    }

    public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            ConfigurationTypeRunDashboardAdvertiser.$$$reportNull$$$0(1);
        }
        if (this.myRunConfigurationTypeId.equals(settings.getType().getId()) && ConfigurationTypeRunDashboardAdvertiser.isEnabled(this.myProject)) {
            ApplicationManager.getApplication().invokeLater(this::checkRunDashboardAvailability, o -> this.myDisposed);
        }
    }

    private void checkRunDashboardAvailability() {
        List<RunnerAndConfigurationSettings> settings = ContainerUtil.filter(RunManager.getInstance((Project)this.myProject).getAllSettings(), c2 -> this.myRunConfigurationTypeId.equals(c2.getType().getId()));
        if (settings.size() <= 1) {
            return;
        }
        if (RunDashboardManager.getInstance((Project)this.myProject).getTypes().contains(this.myRunConfigurationTypeId)) {
            return;
        }
        if (this.myNotification != null && !this.myNotification.isExpired()) {
            return;
        }
        this.myNotification = ConfigurationTypeRunDashboardAdvertiser.createNotification(this.myProject, this.myRunConfigurationTypeId, this.getRunConfigurationDisplayName());
        this.myNotification.notify(this.myProject);
    }

    private String getRunConfigurationDisplayName() {
        ConfigurationType configurationType = ContainerUtil.find((ConfigurationType[])ConfigurationType.CONFIGURATION_TYPE_EP.getExtensions(), c2 -> this.myRunConfigurationTypeId.equals(c2.getId()));
        assert (configurationType != null);
        return configurationType.getDisplayName();
    }

    private static Notification createNotification(final Project project2, final String typeId, String typeDisplayName) {
        String toolWindowName = UIBundle.message((String)"tool.window.name.services", (Object[])new Object[0]);
        return NotificationGroupManager.getInstance().getNotificationGroup(DASHBOARD_NOTIFICATION_GROUP_ID).createNotification(ExecutionBundle.message((String)"run.dashboard.multiple.run.config.notification", (Object[])new Object[]{typeDisplayName, toolWindowName}), NotificationType.INFORMATION).setDisplayId(DASHBOARD_MULTIPLE_RUN_CONFIGURATIONS_NOTIFICATION_ID).setSuggestionType(true).setIcon(AllIcons.Nodes.Services).addAction((AnAction)new NotificationAction(ExecutionBundle.message((String)"run.dashboard.use.services.action", (Object[])new Object[]{toolWindowName})){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                notification.hideBalloon();
                ConfigurationTypeRunDashboardAdvertiser.showInRunDashboard(project2, typeId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/dashboard/ConfigurationTypeRunDashboardAdvertiser$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).addAction((AnAction)new NotificationAction(IdeBundle.message((String)"notifications.toolwindow.dont.show.again", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    1.$$$reportNull$$$0(1);
                }
                notification.setDoNotAskFor(null);
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/dashboard/ConfigurationTypeRunDashboardAdvertiser$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean isEnabled(Project project2) {
        Notification notification = ConfigurationTypeRunDashboardAdvertiser.createNotification(project2, "", "");
        return notification.canShowFor(project2);
    }

    private static void showInRunDashboard(Project project2, String typeId) {
        RunDashboardManager dashboardManager = RunDashboardManager.getInstance((Project)project2);
        HashSet<String> types = new HashSet<String>(dashboardManager.getTypes());
        types.add(typeId);
        dashboardManager.setTypes(types);
    }

    private static boolean migrateNotificationProperty(Project project2) {
        boolean isEnabled = PropertiesComponent.getInstance(project2).getBoolean(SHOW_RUN_DASHBOARD_NOTIFICATION, true);
        if (isEnabled) {
            return false;
        }
        PropertiesComponent.getInstance(project2).setValue(SHOW_RUN_DASHBOARD_NOTIFICATION, true, true);
        Notification notification = ConfigurationTypeRunDashboardAdvertiser.createNotification(project2, "", "");
        notification.setDoNotAskFor(project2);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/dashboard/ConfigurationTypeRunDashboardAdvertiser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runConfigurationAdded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

