/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.execution.dashboard.tree.RunDashboardGroupImpl;
import com.intellij.execution.services.ServiceViewContributorDeleteProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class RunDashboardServiceViewDeleteProvider
implements ServiceViewContributorDeleteProvider {
    private DeleteProvider myDelegate;

    RunDashboardServiceViewDeleteProvider() {
    }

    @Override
    public void setFallbackProvider(DeleteProvider provider2) {
        this.myDelegate = provider2;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            RunDashboardServiceViewDeleteProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void deleteElement(@NotNull DataContext dataContext2) {
        List<ConfigurationType> targetTypes;
        if (dataContext2 == null) {
            RunDashboardServiceViewDeleteProvider.$$$reportNull$$$0(1);
        }
        if ((targetTypes = RunDashboardServiceViewDeleteProvider.getTargetTypes(dataContext2)).isEmpty()) {
            if (this.myDelegate != null) {
                this.myDelegate.deleteElement(dataContext2);
            }
            return;
        }
        Project project2 = (Project)dataContext2.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        ConfigurationType onlyType = ContainerUtil.getOnlyItem(targetTypes);
        String message = onlyType != null ? ExecutionBundle.message((String)"run.dashboard.remove.run.configuration.type.confirmation", (Object[])new Object[]{onlyType.getDisplayName()}) : ExecutionBundle.message((String)"run.dashboard.remove.run.configuration.types.confirmation", (Object[])new Object[]{targetTypes.size()});
        if (!((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)IdeBundle.message((String)"button.remove", (Object[])new Object[0]), (String)message).yesText(IdeBundle.message((String)"button.remove", (Object[])new Object[0]))).icon(Messages.getWarningIcon())).ask(project2)) {
            return;
        }
        RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)project2);
        HashSet types = new HashSet(runDashboardManager.getTypes());
        for (ConfigurationType type : targetTypes) {
            types.remove(type.getId());
        }
        runDashboardManager.setTypes(types);
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext2) {
        List<ConfigurationType> targetTypes;
        if (dataContext2 == null) {
            RunDashboardServiceViewDeleteProvider.$$$reportNull$$$0(2);
        }
        return !(targetTypes = RunDashboardServiceViewDeleteProvider.getTargetTypes(dataContext2)).isEmpty() || this.myDelegate != null && this.myDelegate.canDeleteElement(dataContext2);
    }

    private static List<ConfigurationType> getTargetTypes(DataContext dataContext2) {
        Object[] items2 = (Object[])dataContext2.getData(PlatformCoreDataKeys.SELECTED_ITEMS);
        if (items2 == null) {
            return Collections.emptyList();
        }
        SmartList<ConfigurationType> types = new SmartList<ConfigurationType>();
        for (Object item : items2) {
            RunDashboardGroup group2;
            ConfigurationType type;
            if (!(item instanceof GroupingNode) || (type = ObjectUtils.tryCast(((RunDashboardGroupImpl)(group2 = ((GroupingNode)item).getGroup())).getValue(), ConfigurationType.class)) == null) {
                return Collections.emptyList();
            }
            types.add(type);
        }
        return types;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/dashboard/RunDashboardServiceViewDeleteProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardServiceViewDeleteProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2 -> new IllegalArgumentException(string2);
        };
    }
}

