/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardServiceViewContributor;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.execution.dashboard.tree.RunDashboardGroupImpl;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class RestoreHiddenConfigurationsAction
extends DumbAwareAction {
    RestoreHiddenConfigurationsAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RestoreHiddenConfigurationsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RestoreHiddenConfigurationsAction.$$$reportNull$$$0(1);
        }
        Project project2 = e.getProject();
        Presentation presentation2 = e.getPresentation();
        if (project2 == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        if (ActionPlaces.getActionGroupPopupPlace((String)"ServicesToolbar").equals(e.getPlace())) {
            presentation2.setEnabledAndVisible(RestoreHiddenConfigurationsAction.hasHiddenConfiguration(project2));
            presentation2.setText(ExecutionBundle.message((String)"run.dashboard.restore.hidden.configurations.toolbar.action.name", (Object[])new Object[0]));
            return;
        }
        presentation2.setText(ExecutionBundle.message((String)"run.dashboard.restore.hidden.configurations.popup.action.name", (Object[])new Object[0]));
        RunDashboardServiceViewContributor root = ServiceViewActionUtils.getTarget(e, RunDashboardServiceViewContributor.class);
        if (root != null) {
            presentation2.setEnabledAndVisible(RestoreHiddenConfigurationsAction.hasHiddenConfiguration(project2));
            return;
        }
        if (!PropertiesComponent.getInstance(project2).getBoolean("ConfigurationTypeDashboardGroupingRule", true)) {
            List<RunDashboardNode> nodes2 = ServiceViewActionUtils.getTargets(e, RunDashboardNode.class);
            presentation2.setEnabledAndVisible(!nodes2.isEmpty() && RestoreHiddenConfigurationsAction.hasHiddenConfiguration(project2));
            return;
        }
        Set<ConfigurationType> types = RestoreHiddenConfigurationsAction.getTargetTypes(e);
        if (types.isEmpty()) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        Set<RunConfiguration> hiddenConfigurations = ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project2)).getHiddenConfigurations();
        List<RunConfiguration> configurations = ContainerUtil.filter(hiddenConfigurations, configuration -> types.contains(configuration.getType()));
        presentation2.setEnabledAndVisible(!configurations.isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            RestoreHiddenConfigurationsAction.$$$reportNull$$$0(2);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        RunDashboardServiceViewContributor root = ServiceViewActionUtils.getTarget(e, RunDashboardServiceViewContributor.class);
        if (ActionPlaces.getActionGroupPopupPlace((String)"ServicesToolbar").equals(e.getPlace()) || root != null || !PropertiesComponent.getInstance(project2).getBoolean("ConfigurationTypeDashboardGroupingRule", true)) {
            RunDashboardManagerImpl runDashboardManager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project2);
            runDashboardManager.restoreConfigurations(new HashSet<RunConfiguration>(runDashboardManager.getHiddenConfigurations()));
            return;
        }
        Set<ConfigurationType> types = RestoreHiddenConfigurationsAction.getTargetTypes(e);
        RunDashboardManagerImpl runDashboardManager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project2);
        List<RunConfiguration> configurations = ContainerUtil.filter(runDashboardManager.getHiddenConfigurations(), configuration -> types.contains(configuration.getType()));
        runDashboardManager.restoreConfigurations(configurations);
    }

    private static boolean hasHiddenConfiguration(Project project2) {
        return !((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project2)).getHiddenConfigurations().isEmpty();
    }

    private static Set<ConfigurationType> getTargetTypes(AnActionEvent e) {
        List<RunDashboardNode> targets2 = ServiceViewActionUtils.getTargets(e, RunDashboardNode.class);
        if (targets2.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ConfigurationType> types = new HashSet<ConfigurationType>();
        for (RunDashboardNode node2 : targets2) {
            if (node2 instanceof RunDashboardRunConfigurationNode) {
                types.add(((RunDashboardRunConfigurationNode)node2).getConfigurationSettings().getType());
                continue;
            }
            if (node2 instanceof GroupingNode) {
                RunDashboardGroupImpl group2 = (RunDashboardGroupImpl)((GroupingNode)node2).getGroup();
                ConfigurationType type = ObjectUtils.tryCast(group2.getValue(), ConfigurationType.class);
                if (type == null) {
                    return Collections.emptySet();
                }
                types.add(type);
                continue;
            }
            return Collections.emptySet();
        }
        return types;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/dashboard/actions/RestoreHiddenConfigurationsAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/dashboard/actions/RestoreHiddenConfigurationsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2 -> new IllegalArgumentException(string2);
        };
    }
}

