/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ)\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0014\u00a2\u0006\u0002\u0010\u0013J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/execution/filters/FileHyperlinkInfoBase;", "Lcom/intellij/execution/filters/FileHyperlinkInfo;", "myProject", "Lcom/intellij/openapi/project/Project;", "myDocumentLine", "", "myDocumentColumn", "myUseBrowser", "", "(Lcom/intellij/openapi/project/Project;IIZ)V", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "calculateOffset", "document", "Lcom/intellij/openapi/editor/Document;", "documentLine", "documentColumn", "(Lcom/intellij/openapi/editor/Document;II)Ljava/lang/Integer;", "getDescriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "navigate", "", "project", "intellij.platform.lang"})
public abstract class FileHyperlinkInfoBase
implements FileHyperlinkInfo {
    @NotNull
    private final Project myProject;
    private final int myDocumentLine;
    private final int myDocumentColumn;
    private final boolean myUseBrowser;

    @JvmOverloads
    public FileHyperlinkInfoBase(@NotNull Project myProject, int myDocumentLine, int myDocumentColumn, boolean myUseBrowser) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.myDocumentLine = myDocumentLine;
        this.myDocumentColumn = myDocumentColumn;
        this.myUseBrowser = myUseBrowser;
    }

    public /* synthetic */ FileHyperlinkInfoBase(Project project2, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            bl = true;
        }
        this(project2, n, n2, bl);
    }

    @Nullable
    protected abstract VirtualFile getVirtualFile();

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public OpenFileDescriptor getDescriptor() {
        file = this.getVirtualFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        document = FileDocumentManager.getInstance().getDocument(file);
        v0 = file.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY);
        if (v0 == null) ** GOTO lbl-1000
        mapping = v0;
        $i$a$-let-FileHyperlinkInfoBase$getDescriptor$line$1 = false;
        mappingLine = mapping.bytecodeToSource(this.myDocumentLine + 1) - 1;
        v1 = mappingLine < 0 ? null : Integer.valueOf(mappingLine);
        v0 = v1;
        if (v1 != null) {
            v2 = v0.intValue();
        } else lbl-1000:
        // 2 sources

        {
            v2 = this.myDocumentLine;
        }
        line = v2;
        offset = this.calculateOffset(document, line, this.myDocumentColumn);
        if (offset == null) {
            return new OpenFileDescriptor(this.myProject, file, line, this.myDocumentColumn);
        }
        return new OpenFileDescriptor(this.myProject, file, offset);
    }

    @Override
    public void navigate(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        OpenFileDescriptor openFileDescriptor = this.getDescriptor();
        if (openFileDescriptor == null) {
            return;
        }
        OpenFileDescriptor descriptor2 = openFileDescriptor;
        if (descriptor2.getFile().isDirectory()) {
            PsiManager psiManager = PsiManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(project)");
            PsiManager psiManager2 = psiManager;
            PsiDirectory psiDirectory = psiManager2.findDirectory(descriptor2.getFile());
            if (psiDirectory != null && psiManager2.isInProject(psiDirectory)) {
                psiDirectory.navigate(true);
            } else {
                PsiNavigationSupport.getInstance().openDirectoryInSystemFileManager(new File(descriptor2.getFile().getPath()));
            }
        } else if (FileEditorManager.getInstance(project2).openTextEditor(descriptor2, true) == null && this.myUseBrowser) {
            new BrowserHyperlinkInfo(descriptor2.getFile().getUrl()).navigate(project2);
        }
    }

    @Nullable
    protected Integer calculateOffset(@Nullable Document document, int documentLine, int documentColumn) {
        if (document == null) {
            return null;
        }
        if (documentLine < 0 || document.getLineCount() <= documentLine) {
            return null;
        }
        int lineStartOffset = document.getLineStartOffset(documentLine);
        int lineEndOffset = document.getLineEndOffset(documentLine);
        int fixedColumn = Math.min(Math.max(documentColumn, 0), lineEndOffset - lineStartOffset);
        return lineStartOffset + fixedColumn;
    }

    @JvmOverloads
    public FileHyperlinkInfoBase(@NotNull Project myProject, int myDocumentLine, int myDocumentColumn) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this(myProject, myDocumentLine, myDocumentColumn, false, 8, null);
    }
}

