/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public interface LineNumbersMapping {
    public static final Key<LineNumbersMapping> LINE_NUMBERS_MAPPING_KEY = Key.create("line.numbers.mapping.key");

    public int bytecodeToSource(int var1);

    public int sourceToBytecode(int var1);

    public static class ArrayBasedMapping
    implements LineNumbersMapping {
        private final int[] myMapping;

        public ArrayBasedMapping(int @NotNull [] mapping) {
            if (mapping == null) {
                ArrayBasedMapping.$$$reportNull$$$0(0);
            }
            this.myMapping = (int[])mapping.clone();
        }

        @Override
        public int bytecodeToSource(int line) {
            for (int i2 = 0; i2 < this.myMapping.length; i2 += 2) {
                if (this.myMapping[i2] != line) continue;
                return this.myMapping[i2 + 1];
            }
            return -1;
        }

        @Override
        public int sourceToBytecode(int line) {
            for (int i2 = 0; i2 < this.myMapping.length; i2 += 2) {
                if (this.myMapping[i2 + 1] != line) continue;
                return this.myMapping[i2];
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/execution/filters/LineNumbersMapping$ArrayBasedMapping", "<init>"));
        }
    }
}

