/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiPsiElementHyperlinkInfo
extends HyperlinkInfoBase {
    private final Map<VirtualFile, SmartPsiElementPointer<?>> myMap;

    public Collection<SmartPsiElementPointer<?>> getElementVariants() {
        return this.myMap.values();
    }

    MultiPsiElementHyperlinkInfo(Collection<? extends PsiElement> elements) {
        SmartPointerManager manager = null;
        this.myMap = new LinkedHashMap();
        for (PsiElement psiElement : elements) {
            if (manager == null) {
                manager = SmartPointerManager.getInstance(psiElement.getProject());
            }
            this.myMap.put(psiElement.getContainingFile().getVirtualFile(), manager.createSmartPsiElementPointer(psiElement));
        }
    }

    public void navigate(@NotNull Project project2, @Nullable RelativePoint hyperlinkLocationPoint) {
        if (project2 == null) {
            MultiPsiElementHyperlinkInfo.$$$reportNull$$$0(0);
        }
        if (this.myMap.isEmpty()) {
            return;
        }
        if (this.myMap.size() == 1) {
            Map.Entry<VirtualFile, SmartPsiElementPointer<?>> entry = this.myMap.entrySet().iterator().next();
            MultiPsiElementHyperlinkInfo.navigateTo(project2, entry.getKey(), entry.getValue());
            return;
        }
        JFrame frame = WindowManager.getInstance().getFrame(project2);
        int width = frame != null ? frame.getSize().width : 200;
        JBPopup popup2 = JBPopupFactory.getInstance().createPopupChooserBuilder(ContainerUtil.map(this.myMap.values(), ptr -> ptr.getContainingFile())).setTitle(ExecutionBundle.message((String)"popup.title.choose.target.file", (Object[])new Object[0])).setRenderer((ListCellRenderer)new GotoFileCellRenderer(width)).setItemChosenCallback(selectedValue -> {
            VirtualFile file2 = selectedValue.getVirtualFile();
            MultiPsiElementHyperlinkInfo.navigateTo(project2, file2, this.myMap.get(file2));
        }).createPopup();
        if (hyperlinkLocationPoint != null) {
            popup2.show(hyperlinkLocationPoint);
        } else {
            popup2.showInFocusCenter();
        }
    }

    private static void navigateTo(@NotNull Project project2, VirtualFile file2, SmartPsiElementPointer<?> pointer) {
        Document document;
        if (project2 == null) {
            MultiPsiElementHyperlinkInfo.$$$reportNull$$$0(1);
        }
        Object element = pointer.getElement();
        int line = 0;
        int column = 0;
        if (element != null && (document = element.getContainingFile().getViewProvider().getDocument()) != null) {
            int offset2 = element.getTextOffset();
            line = document.getLineNumber(offset2);
            column = offset2 - document.getLineStartOffset(line);
        }
        new OpenFileHyperlinkInfo(project2, file2, line, column).navigate(project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/execution/filters/impl/MultiPsiElementHyperlinkInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "navigate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

