/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.filters.HyperlinkInfoFactory;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class MultipleFilesHyperlinkInfo
extends HyperlinkInfoBase
implements FileHyperlinkInfo {
    private final List<? extends VirtualFile> myVirtualFiles;
    private final int myLineNumber;
    private final Project myProject;
    private final @Nullable HyperlinkInfoFactory.HyperlinkHandler myAction;

    MultipleFilesHyperlinkInfo(@NotNull List<? extends VirtualFile> virtualFiles, int lineNumber, @NotNull Project project2) {
        if (virtualFiles == null) {
            MultipleFilesHyperlinkInfo.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            MultipleFilesHyperlinkInfo.$$$reportNull$$$0(1);
        }
        this(virtualFiles, lineNumber, project2, null);
    }

    MultipleFilesHyperlinkInfo(@NotNull List<? extends VirtualFile> virtualFiles, int lineNumber, @NotNull Project project2, @Nullable HyperlinkInfoFactory.HyperlinkHandler action2) {
        if (virtualFiles == null) {
            MultipleFilesHyperlinkInfo.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            MultipleFilesHyperlinkInfo.$$$reportNull$$$0(3);
        }
        this.myVirtualFiles = virtualFiles;
        this.myLineNumber = lineNumber;
        this.myProject = project2;
        this.myAction = action2;
    }

    public void navigate(@NotNull Project project2, @Nullable RelativePoint hyperlinkLocationPoint) {
        Editor originalEditor;
        if (project2 == null) {
            MultipleFilesHyperlinkInfo.$$$reportNull$$$0(4);
        }
        ArrayList currentFiles = new ArrayList();
        if (hyperlinkLocationPoint != null) {
            DataManager dataManager = DataManager.getInstance();
            DataContext dataContext2 = dataManager.getDataContext(hyperlinkLocationPoint.getOriginalComponent());
            originalEditor = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        } else {
            originalEditor = null;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            for (VirtualFile virtualFile2 : this.myVirtualFiles) {
                PsiFile psiFile;
                if (!virtualFile2.isValid() || (psiFile = PsiManager.getInstance(project2).findFile(virtualFile2)) == null) continue;
                PsiElement navigationElement = psiFile.getNavigationElement();
                if (navigationElement instanceof PsiFile) {
                    currentFiles.add((PsiFile)navigationElement);
                    continue;
                }
                currentFiles.add(psiFile);
            }
        });
        if (currentFiles.isEmpty()) {
            return;
        }
        if (currentFiles.size() == 1) {
            this.open(((PsiFile)currentFiles.get(0)).getVirtualFile(), originalEditor);
        } else {
            JFrame frame = WindowManager.getInstance().getFrame(project2);
            int width = frame != null ? frame.getSize().width : 200;
            JBPopup popup2 = JBPopupFactory.getInstance().createPopupChooserBuilder(currentFiles).setRenderer((ListCellRenderer)new GotoFileCellRenderer(width)).setTitle(ExecutionBundle.message((String)"popup.title.choose.target.file", (Object[])new Object[0])).setItemChosenCallback(file2 -> this.open(file2.getVirtualFile(), originalEditor)).createPopup();
            if (hyperlinkLocationPoint != null) {
                popup2.show(hyperlinkLocationPoint);
            } else {
                popup2.showInFocusCenter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(@NotNull VirtualFile file2, Editor originalEditor) {
        if (file2 == null) {
            MultipleFilesHyperlinkInfo.$$$reportNull$$$0(5);
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        int offset2 = 0;
        if (document != null && this.myLineNumber >= 0 && this.myLineNumber < document.getLineCount()) {
            offset2 = document.getLineStartOffset(this.myLineNumber);
        }
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(this.myProject, file2, offset2);
        Editor editor2 = FileEditorManager.getInstance(this.myProject).openTextEditor(descriptor2, true);
        if (this.myAction != null && editor2 != null) {
            if (editor2 instanceof EditorEx) {
                ((EditorEx)editor2).setCaretEnabled(false);
                try {
                    this.myAction.onLinkFollowed(this.myProject, file2, editor2, originalEditor);
                }
                finally {
                    ((EditorEx)editor2).setCaretEnabled(true);
                }
            } else {
                this.myAction.onLinkFollowed(this.myProject, file2, editor2, originalEditor);
            }
        }
    }

    @Override
    @Nullable
    public OpenFileDescriptor getDescriptor() {
        VirtualFile file2 = this.getPreferredFile();
        return file2 != null ? new OpenFileDescriptor(this.myProject, file2, this.myLineNumber, 0) : null;
    }

    public List<? extends VirtualFile> getFilesVariants() {
        return this.myVirtualFiles;
    }

    @Nullable
    private VirtualFile getPreferredFile() {
        return ContainerUtil.getFirstItem(this.myVirtualFiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/filters/impl/MultipleFilesHyperlinkInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "navigate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "open";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

