/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.google.common.base.CharMatcher;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.navigation.IncrementalSearchHandler;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.execution.ConsoleFolding;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.ClearConsoleAction;
import com.intellij.execution.actions.ConsoleActionsPostProcessor;
import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.filters.HyperlinkWithPopupMenuInfo;
import com.intellij.execution.filters.InputFilter;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.impl.ConsoleState;
import com.intellij.execution.impl.ConsoleTokenUtil;
import com.intellij.execution.impl.ConsoleViewRunningState;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.impl.DisposedPsiManagerCheck;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.impl.MyDiffContainer;
import com.intellij.execution.impl.TokenBuffer;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.pom.Navigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ConsoleViewImpl
extends JPanel
implements ConsoleView,
ObservableConsoleView,
DataProvider,
OccurenceNavigator {
    @NonNls
    private static final String CONSOLE_VIEW_POPUP_MENU = "ConsoleView.PopupMenu";
    private static final Logger LOG = Logger.getInstance(ConsoleViewImpl.class);
    private static final int DEFAULT_FLUSH_DELAY = SystemProperties.getIntProperty("console.flush.delay.ms", 200);
    public static final Key<ConsoleViewImpl> CONSOLE_VIEW_IN_EDITOR_VIEW = Key.create("CONSOLE_VIEW_IN_EDITOR_VIEW");
    private static boolean ourTypedHandlerInitialized;
    private final Alarm myFlushUserInputAlarm;
    private static final CharMatcher NEW_LINE_MATCHER;
    private final CommandLineFolding myCommandLineFolding;
    private final DisposedPsiManagerCheck myPsiDisposedCheck;
    private final boolean myIsViewer;
    @NotNull
    private ConsoleState myState;
    private final Alarm mySpareTimeAlarm;
    @NotNull
    private final Alarm myHeavyAlarm;
    private volatile int myHeavyUpdateTicket;
    private final Collection<ObservableConsoleView.ChangeListener> myListeners;
    private final List<AnAction> customActions;
    private final TokenBuffer myDeferredBuffer;
    private boolean myUpdateFoldingsEnabled;
    private MyDiffContainer myJLayeredPane;
    private JPanel myMainPanel;
    private boolean myAllowHeavyFilters;
    private boolean myCancelStickToEnd;
    private final Alarm myFlushAlarm;
    private final Project myProject;
    private boolean myOutputPaused;
    private EditorEx myEditor;
    private final Object LOCK;
    private String myHelpId;
    private final GlobalSearchScope mySearchScope;
    private final List<Filter> myCustomFilters;
    @NotNull
    private final InputFilter myInputMessageFilter;
    private volatile List<Filter> myPredefinedFilters;
    private boolean keepSlashR;
    private static final Key<String> USED_FOLDING_FQN_KEY;
    private final FlushRunnable FLUSH;
    private final ClearRunnable CLEAR;

    public ConsoleViewImpl(@NotNull Project project2, boolean viewer) {
        if (project2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(0);
        }
        this(project2, GlobalSearchScope.allScope(project2), viewer, true);
    }

    public ConsoleViewImpl(@NotNull Project project2, @NotNull GlobalSearchScope searchScope2, boolean viewer, boolean usePredefinedMessageFilter) {
        if (project2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(1);
        }
        if (searchScope2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(2);
        }
        this(project2, searchScope2, viewer, new ConsoleState.NotStartedStated(){

            @Override
            @NotNull
            public ConsoleState attachTo(@NotNull ConsoleViewImpl console, @NotNull ProcessHandler processHandler) {
                if (console == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processHandler == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new ConsoleViewRunningState(console, processHandler, this, true, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "console";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "processHandler";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/impl/ConsoleViewImpl$1";
                objectArray[2] = "attachTo";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, usePredefinedMessageFilter);
    }

    protected ConsoleViewImpl(final @NotNull Project project2, @NotNull GlobalSearchScope searchScope2, boolean viewer, @NotNull ConsoleState initialState, boolean usePredefinedMessageFilter) {
        if (project2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(3);
        }
        if (searchScope2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(4);
        }
        if (initialState == null) {
            ConsoleViewImpl.$$$reportNull$$$0(5);
        }
        super(new BorderLayout());
        this.myFlushUserInputAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)((Object)this));
        this.myCommandLineFolding = new CommandLineFolding();
        this.mySpareTimeAlarm = new Alarm((Disposable)((Object)this));
        this.myHeavyAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)((Object)this));
        this.myListeners = new CopyOnWriteArraySet<ObservableConsoleView.ChangeListener>();
        this.customActions = new ArrayList<AnAction>();
        this.myDeferredBuffer = new TokenBuffer(ConsoleBuffer.useCycleBuffer() && ConsoleBuffer.getCycleBufferSize() > 0 ? ConsoleBuffer.getCycleBufferSize() : Integer.MAX_VALUE);
        this.myUpdateFoldingsEnabled = true;
        this.myFlushAlarm = new Alarm((Disposable)((Object)this));
        this.LOCK = ObjectUtils.sentinel("ConsoleView lock");
        this.myCustomFilters = new SmartList<Filter>();
        this.myPredefinedFilters = Collections.emptyList();
        this.keepSlashR = true;
        this.FLUSH = new FlushRunnable(false);
        this.CLEAR = new ClearRunnable();
        ConsoleViewImpl.initTypedHandler();
        this.myIsViewer = viewer;
        this.myState = initialState;
        this.myPsiDisposedCheck = new DisposedPsiManagerCheck(project2);
        this.myProject = project2;
        this.mySearchScope = searchScope2;
        this.myInputMessageFilter = ConsoleViewUtil.computeInputFilter((ConsoleView)this, (Project)project2, (GlobalSearchScope)searchScope2);
        project2.getMessageBus().connect((Disposable)((Object)this)).subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){
            private long myLastStamp;

            @Override
            public void enteredDumbMode() {
                Editor editor2 = ConsoleViewImpl.this.getEditor();
                if (editor2 == null) {
                    return;
                }
                this.myLastStamp = editor2.getDocument().getModificationStamp();
            }

            @Override
            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    Editor editor2 = ConsoleViewImpl.this.getEditor();
                    if (editor2 == null || project2.isDisposed() || DumbService.getInstance(project2).isDumb()) {
                        return;
                    }
                    Document document = editor2.getDocument();
                    if (this.myLastStamp != document.getModificationStamp()) {
                        ConsoleViewImpl.this.rehighlightHyperlinksAndFoldings();
                    }
                });
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)((Object)this)).subscribe(EditorColorsManager.TOPIC, __ -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.isDisposed()) {
                return;
            }
            ConsoleTokenUtil.updateAllTokenTextAttributes(this.getEditor(), project2);
        });
        if (usePredefinedMessageFilter) {
            this.addAncestorListener(new AncestorListenerAdapter(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    if (ConsoleViewImpl.this.myPredefinedFilters.isEmpty()) {
                        ConsoleViewImpl.this.updatePredefinedFiltersLater();
                    }
                }
            });
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)((Object)this)).subscribe(DynamicPluginListener.TOPIC, new DynamicPluginListener(){

                @Override
                public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                    if (pluginDescriptor == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    ConsoleViewImpl.this.updatePredefinedFiltersLater();
                }

                @Override
                public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                    if (pluginDescriptor == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    ConsoleViewImpl.this.updatePredefinedFiltersLater();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "pluginDescriptor";
                    objectArray2[1] = "com/intellij/execution/impl/ConsoleViewImpl$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "pluginLoaded";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "pluginUnloaded";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = super.getActionUpdateThread();
        if (actionUpdateThread == null) {
            ConsoleViewImpl.$$$reportNull$$$0(6);
        }
        return actionUpdateThread;
    }

    private void updatePredefinedFiltersLater() {
        ReadAction.nonBlocking(() -> ConsoleViewUtil.computeConsoleFilters((Project)this.myProject, (ConsoleView)this, (GlobalSearchScope)this.mySearchScope)).expireWith((Disposable)((Object)this)).finishOnUiThread(ModalityState.stateForComponent(this), filters -> {
            this.myPredefinedFilters = filters;
            this.rehighlightHyperlinksAndFoldings();
        }).submit(AppExecutorUtil.getAppExecutorService());
    }

    private static void initTypedHandler() {
        if (ourTypedHandlerInitialized) {
            return;
        }
        EditorActionManager.getInstance();
        TypedAction typedAction = TypedAction.getInstance();
        typedAction.setupHandler((TypedActionHandler)new MyTypedHandler(typedAction.getHandler()));
        ourTypedHandlerInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Editor getEditor() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myEditor;
        }
    }

    public EditorHyperlinkSupport getHyperlinks() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Editor editor2 = this.getEditor();
        return editor2 == null ? null : EditorHyperlinkSupport.get((Editor)editor2);
    }

    public void scrollToEnd() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            this.scrollToEnd(editor2);
        }
    }

    private void scrollToEnd(@NotNull Editor editor2) {
        if (editor2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorUtil.scrollToTheEnd((Editor)editor2, (boolean)true);
        this.myCancelStickToEnd = false;
    }

    public void foldImmediately() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myFlushAlarm.isEmpty()) {
            this.cancelAllFlushRequests();
            this.flushDeferredText();
        }
        Editor editor2 = this.getEditor();
        FoldingModel model2 = editor2.getFoldingModel();
        model2.runBatchFoldingOperation(() -> {
            for (FoldRegion region : model2.getAllFoldRegions()) {
                model2.removeFoldRegion(region);
            }
        });
        this.updateFoldings(0, editor2.getDocument().getLineCount() - 1);
    }

    public void attachToProcess(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            ConsoleViewImpl.$$$reportNull$$$0(8);
        }
        this.myState = this.myState.attachTo(this, processHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.getEditor() == null) {
                return;
            }
            this.myDeferredBuffer.clear();
        }
        if (!this.myFlushAlarm.isDisposed()) {
            this.cancelAllFlushRequests();
            this.addFlushRequest(0, this.CLEAR);
            this.cancelHeavyAlarm();
        }
    }

    public void scrollTo(final int offset2) {
        if (this.getEditor() == null) {
            return;
        }
        final class ScrollRunnable
        extends FlushRunnable {
            private ScrollRunnable() {
                super(true);
            }

            @Override
            public void doRun() {
                ConsoleViewImpl.this.flushDeferredText();
                Editor editor2 = ConsoleViewImpl.this.getEditor();
                if (editor2 == null) {
                    return;
                }
                int moveOffset = this.getEffectiveOffset(editor2);
                editor2.getCaretModel().moveToOffset(moveOffset);
                editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }

            private int getEffectiveOffset(@NotNull Editor editor2) {
                if (editor2 == null) {
                    ScrollRunnable.$$$reportNull$$$0(0);
                }
                int moveOffset = Math.min(offset2, editor2.getDocument().getTextLength());
                if (ConsoleBuffer.useCycleBuffer() && moveOffset >= editor2.getDocument().getTextLength()) {
                    moveOffset = 0;
                }
                return moveOffset;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/impl/ConsoleViewImpl$1ScrollRunnable", "getEffectiveOffset"));
            }
        }
        this.addFlushRequest(0, new ScrollRunnable());
    }

    public void requestScrollingToEnd() {
        if (this.getEditor() == null) {
            return;
        }
        this.addFlushRequest(0, new FlushRunnable(true){

            @Override
            public void doRun() {
                ConsoleViewImpl.this.flushDeferredText();
                Editor editor2 = ConsoleViewImpl.this.getEditor();
                if (editor2 != null && !ConsoleViewImpl.this.myFlushAlarm.isDisposed()) {
                    ConsoleViewImpl.this.scrollToEnd(editor2);
                }
            }
        });
    }

    private void addFlushRequest(int millis, @NotNull FlushRunnable flushRunnable) {
        if (flushRunnable == null) {
            ConsoleViewImpl.$$$reportNull$$$0(9);
        }
        flushRunnable.queue(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputPaused(boolean value) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myOutputPaused = value;
            if (!value && this.getEditor() != null) {
                this.requestFlushImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutputPaused() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myOutputPaused;
        }
    }

    public void setEmulateCarriageReturn(boolean emulate) {
        this.keepSlashR = emulate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDeferredOutput() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myDeferredBuffer.length() > 0;
        }
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable) {
        if (runnable == null) {
            ConsoleViewImpl.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.hasDeferredOutput()) {
            runnable.run();
            return;
        }
        if (this.mySpareTimeAlarm.isDisposed()) {
            return;
        }
        if (this.myJLayeredPane == null) {
            this.getComponent();
        }
        this.mySpareTimeAlarm.addRequest(() -> this.performWhenNoDeferredOutput(runnable), 100, ModalityState.stateForComponent((Component)this.myJLayeredPane));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public JComponent getComponent() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myMainPanel == null) {
            this.myMainPanel = new JPanel(new BorderLayout());
            this.myJLayeredPane = new MyDiffContainer((JComponent)this.myMainPanel, this.createCompositeFilter().getUpdateMessage());
            Disposer.register((Disposable)((Object)this), (Disposable)this.myJLayeredPane);
            this.add((Component)this.myJLayeredPane, "Center");
        }
        if (this.getEditor() == null) {
            EditorEx editor2 = this.initConsoleEditor();
            Object object = this.LOCK;
            synchronized (object) {
                this.myEditor = editor2;
            }
            this.requestFlushImmediately();
            this.myMainPanel.add((Component)this.createCenterComponent(), "Center");
        }
        ConsoleViewImpl consoleViewImpl = this;
        if (consoleViewImpl == null) {
            ConsoleViewImpl.$$$reportNull$$$0(11);
        }
        return consoleViewImpl;
    }

    @NotNull
    protected CompositeFilter createCompositeFilter() {
        CompositeFilter compositeFilter = new CompositeFilter(this.myProject, ContainerUtil.concat(this.myCustomFilters, this.myPredefinedFilters));
        compositeFilter.setForceUseAllFilters(true);
        CompositeFilter compositeFilter2 = compositeFilter;
        if (compositeFilter2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(12);
        }
        return compositeFilter2;
    }

    public final void addLayerToPane(@NotNull JComponent component2) {
        if (component2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.getComponent();
        component2.setOpaque(false);
        component2.setVisible(true);
        this.myJLayeredPane.add((Component)component2, null, 0);
    }

    @NotNull
    private EditorEx initConsoleEditor() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        final EditorEx editor2 = this.createConsoleEditor();
        this.registerConsoleEditorActions((Editor)editor2);
        editor2.getScrollPane().setBorder(IdeBorderFactory.createBorder((int)1));
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ConsoleViewImpl.this.updateStickToEndState(editor2, true);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ConsoleViewImpl.this.updateStickToEndState(editor2, false);
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.isShiftDown()) {
                    return;
                }
                ConsoleViewImpl.this.updateStickToEndState(editor2, false);
            }
        };
        editor2.getScrollPane().addMouseWheelListener(mouseListener);
        editor2.getScrollPane().getVerticalScrollBar().addMouseListener(mouseListener);
        editor2.getScrollPane().getVerticalScrollBar().addMouseMotionListener(mouseListener);
        editor2.getScrollingModel().addVisibleAreaListener(e -> {
            Rectangle oldR = e.getOldRectangle();
            if (oldR != null && oldR.height <= 0 && e.getNewRectangle().height > 0 && ConsoleViewImpl.isStickingToEnd((Editor)editor2)) {
                this.scrollToEnd((Editor)editor2);
            }
        });
        EditorEx editorEx = editor2;
        if (editorEx == null) {
            ConsoleViewImpl.$$$reportNull$$$0(14);
        }
        return editorEx;
    }

    private void updateStickToEndState(@NotNull EditorEx editor2, boolean useImmediatePosition) {
        if (editor2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        JScrollBar scrollBar = editor2.getScrollPane().getVerticalScrollBar();
        int scrollBarPosition = useImmediatePosition ? scrollBar.getValue() : editor2.getScrollingModel().getVisibleAreaOnScrollingFinished().y;
        boolean vScrollAtBottom = scrollBarPosition == scrollBar.getMaximum() - scrollBar.getVisibleAmount();
        boolean stickingToEnd = ConsoleViewImpl.isStickingToEnd((Editor)editor2);
        if (!vScrollAtBottom && stickingToEnd) {
            this.myCancelStickToEnd = true;
        } else if (vScrollAtBottom && !stickingToEnd) {
            this.scrollToEnd((Editor)editor2);
        }
    }

    @NotNull
    protected JComponent createCenterComponent() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        JComponent jComponent = this.getEditor().getComponent();
        if (jComponent == null) {
            ConsoleViewImpl.$$$reportNull$$$0(16);
        }
        return jComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.myState = this.myState.dispose();
        Arrays.stream(this.getAncestorListeners()).forEach(l -> this.removeAncestorListener((AncestorListener)l));
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            this.cancelAllFlushRequests();
            this.mySpareTimeAlarm.cancelAllRequests();
            this.disposeEditor();
            editor2.putUserData(CONSOLE_VIEW_IN_EDITOR_VIEW, null);
            Object object = this.LOCK;
            synchronized (object) {
                this.myDeferredBuffer.clear();
                this.myEditor = null;
            }
        }
    }

    private void cancelAllFlushRequests() {
        this.myFlushAlarm.cancelAllRequests();
        this.CLEAR.clearRequested();
        this.FLUSH.clearRequested();
    }

    @TestOnly
    public void waitAllRequests() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (ApplicationManager.getApplication().isUnitTestMode());
        Future<?> future = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            while (true) {
                try {
                    this.myFlushAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
                    this.myFlushUserInputAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
                    this.myFlushAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
                    this.myFlushUserInputAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
                    return;
                }
                catch (CancellationException cancellationException) {
                    continue;
                }
                break;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            while (true) {
                try {
                    future.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    UIUtil.dispatchAllInvocationEvents();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected void disposeEditor() {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            Editor editor2 = this.getEditor();
            if (!editor2.isDisposed()) {
                EditorFactory.getInstance().releaseEditor(editor2);
            }
        });
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        List<Pair<String, ConsoleViewContentType>> result2;
        if (text2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(17);
        }
        if (contentType == null) {
            ConsoleViewImpl.$$$reportNull$$$0(18);
        }
        if ((result2 = this.myInputMessageFilter.applyFilter(text2, contentType)) == null) {
            this.print(text2, contentType, null);
        } else {
            for (Pair<String, ConsoleViewContentType> pair : result2) {
                if (pair.first == null) continue;
                this.print((String)pair.first, pair.second == null ? contentType : (ConsoleViewContentType)pair.second, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType, @Nullable HyperlinkInfo info2) {
        if (text2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(19);
        }
        if (contentType == null) {
            ConsoleViewImpl.$$$reportNull$$$0(20);
        }
        text2 = Strings.convertLineSeparators(text2, this.keepSlashR);
        Object object = this.LOCK;
        synchronized (object) {
            boolean hasEditor = this.getEditor() != null;
            this.myDeferredBuffer.print(text2, contentType, info2);
            if (hasEditor) {
                if (contentType == ConsoleViewContentType.USER_INPUT) {
                    this.requestFlushImmediately();
                } else {
                    boolean shouldFlushNow = this.myDeferredBuffer.length() >= this.myDeferredBuffer.getCycleBufferSize();
                    this.addFlushRequest(shouldFlushNow ? 0 : DEFAULT_FLUSH_DELAY, this.FLUSH);
                }
            }
        }
    }

    private void sendUserInput(@NotNull CharSequence typedText) {
        CharSequence textToSend;
        if (typedText == null) {
            ConsoleViewImpl.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myState.isRunning() && NEW_LINE_MATCHER.indexIn(typedText) >= 0 && (textToSend = ConsoleTokenUtil.computeTextToSend(this.getEditor(), this.getProject())).length() != 0) {
            this.myFlushUserInputAlarm.addRequest(() -> {
                if (this.myState.isRunning()) {
                    try {
                        this.myState.sendUserInput(textToSend.toString());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }, 0);
        }
    }

    protected ModalityState getStateForUpdate() {
        return null;
    }

    private void requestFlushImmediately() {
        this.addFlushRequest(0, this.FLUSH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getContentSize() {
        Editor editor2;
        int length;
        Object object = this.LOCK;
        synchronized (object) {
            length = this.myDeferredBuffer.length();
            editor2 = this.getEditor();
        }
        return (editor2 == null || this.CLEAR.hasRequested() ? 0 : editor2.getDocument().getTextLength()) + length;
    }

    public boolean canPause() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDeferredText() {
        CharSequence addedText;
        List deferredTokens;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        Editor editor2 = this.getEditor();
        boolean shouldStickToEnd = !this.myCancelStickToEnd && ConsoleViewImpl.isStickingToEnd(editor2);
        this.myCancelStickToEnd = false;
        Document document = editor2.getDocument();
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myOutputPaused) {
                return;
            }
            deferredTokens = this.myDeferredBuffer.drain();
            if (deferredTokens.isEmpty()) {
                return;
            }
            this.cancelHeavyAlarm();
        }
        RangeMarker lastProcessedOutput = document.createRangeMarker(document.getTextLength(), document.getTextLength());
        if (!shouldStickToEnd) {
            ((ScrollingModelEx)editor2.getScrollingModel()).accumulateViewportChanges();
        }
        HashSet contentTypes = new HashSet();
        ArrayList contents = new ArrayList();
        try {
            int lineCount;
            ArrayList refinedTokens;
            int startIndex;
            int backspacePrefixLength;
            boolean startsWithCR;
            boolean bl = startsWithCR = deferredTokens.get(0) == TokenBuffer.CR_TOKEN;
            if (startsWithCR && document.getLineCount() != 0) {
                int lineStartOffset = document.getLineStartOffset(document.getLineCount() - 1);
                document.deleteString(lineStartOffset, document.getTextLength());
            }
            if ((backspacePrefixLength = ConsoleTokenUtil.evaluateBackspacesInTokens(deferredTokens, startIndex = startsWithCR ? 1 : 0, refinedTokens = new ArrayList(deferredTokens.size() - startIndex))) > 0 && (lineCount = document.getLineCount()) != 0) {
                int lineStartOffset = document.getLineStartOffset(lineCount - 1);
                document.deleteString(Math.max(lineStartOffset, document.getTextLength() - backspacePrefixLength), document.getTextLength());
            }
            addedText = TokenBuffer.getRawText(refinedTokens);
            document.insertString(document.getTextLength(), addedText);
            ConsoleTokenUtil.highlightTokenTextAttributes(this.getEditor(), this.getProject(), refinedTokens, this.getHyperlinks(), contentTypes, contents);
        }
        finally {
            if (!shouldStickToEnd) {
                ((ScrollingModelEx)editor2.getScrollingModel()).flushViewportChanges();
            }
        }
        if (!contentTypes.isEmpty()) {
            for (ObservableConsoleView.ChangeListener each : this.myListeners) {
                each.contentAdded(contentTypes);
            }
        }
        if (!contents.isEmpty()) {
            for (ObservableConsoleView.ChangeListener each : this.myListeners) {
                for (int i2 = contents.size() - 1; i2 >= 0; --i2) {
                    each.textAdded((String)((Pair)contents.get((int)i2)).first, (ConsoleViewContentType)((Pair)contents.get((int)i2)).second);
                }
            }
        }
        this.myPsiDisposedCheck.performCheck();
        int startLine = lastProcessedOutput.isValid() ? editor2.getDocument().getLineNumber(lastProcessedOutput.getEndOffset()) : 0;
        lastProcessedOutput.dispose();
        this.highlightHyperlinksAndFoldings(startLine);
        if (shouldStickToEnd) {
            this.scrollToEnd();
        }
        this.sendUserInput(addedText);
    }

    private boolean isDisposed() {
        Editor editor2 = this.getEditor();
        return this.myProject.isDisposed() || editor2 == null || editor2.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClear() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        Editor editor2 = this.getEditor();
        Document document = editor2.getDocument();
        int documentTextLength = document.getTextLength();
        if (documentTextLength > 0) {
            DocumentUtil.executeInBulk(document, () -> document.deleteString(0, documentTextLength));
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.clearHyperlinkAndFoldings();
        }
        MarkupModel model2 = DocumentMarkupModel.forDocument((Document)editor2.getDocument(), (Project)this.getProject(), (boolean)true);
        model2.removeAllHighlighters();
        editor2.getInlayModel().getInlineElementsInRange(0, 0).forEach(Disposer::dispose);
    }

    protected static boolean isStickingToEnd(@NotNull Editor editor2) {
        int caretOffset;
        Document document;
        if (editor2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(22);
        }
        return (document = editor2.getDocument()).getLineNumber(caretOffset = editor2.getCaretModel().getOffset()) >= document.getLineCount() - 1;
    }

    private void clearHyperlinkAndFoldings() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Editor editor2 = this.getEditor();
        for (RangeHighlighter highlighter : editor2.getMarkupModel().getAllHighlighters()) {
            if (highlighter.getUserData(ConsoleTokenUtil.MANUAL_HYPERLINK) != null) continue;
            editor2.getMarkupModel().removeHighlighter(highlighter);
        }
        editor2.getFoldingModel().runBatchFoldingOperation(() -> ((FoldingModelEx)editor2.getFoldingModel()).clearFoldRegions());
        editor2.getInlayModel().getInlineElementsInRange(0, editor2.getDocument().getTextLength()).forEach(inlay -> Disposer.dispose((Disposable)inlay));
        this.cancelHeavyAlarm();
    }

    private void cancelHeavyAlarm() {
        if (!this.myHeavyAlarm.isDisposed()) {
            this.myHeavyAlarm.cancelAllRequests();
            ++this.myHeavyUpdateTicket;
        }
    }

    public Object getData(@NotNull String dataId) {
        EditorEx editor2;
        if (dataId == null) {
            ConsoleViewImpl.$$$reportNull$$$0(23);
        }
        if ((editor2 = (EditorEx)this.getEditor()) == null) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            int offset2 = editor2.getCaretModel().getOffset();
            final HyperlinkInfo info2 = this.getHyperlinks().getHyperlinkAt(offset2);
            return info2 == null ? null : new Navigatable(){

                @Override
                public void navigate(boolean requestFocus) {
                    info2.navigate(ConsoleViewImpl.this.myProject);
                }

                @Override
                public boolean canNavigate() {
                    return true;
                }

                @Override
                public boolean canNavigateToSource() {
                    return true;
                }
            };
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return editor2;
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.CARET.is(dataId)) {
            return editor2.getCaretModel().getCurrentCaret();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return editor2.getCopyProvider();
        }
        return null;
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            ConsoleViewImpl.$$$reportNull$$$0(24);
        }
        this.myHelpId = helpId;
    }

    public void setUpdateFoldingsEnabled(boolean updateFoldingsEnabled) {
        this.myUpdateFoldingsEnabled = updateFoldingsEnabled;
    }

    public void addMessageFilter(@NotNull Filter filter2) {
        if (filter2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(25);
        }
        this.myCustomFilters.add(filter2);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info2) {
        if (hyperlinkText == null) {
            ConsoleViewImpl.$$$reportNull$$$0(26);
        }
        this.print(hyperlinkText, ConsoleViewContentType.NORMAL_OUTPUT, info2);
    }

    @NotNull
    private EditorEx createConsoleEditor() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorEx editor2 = this.doCreateConsoleEditor();
        LOG.assertTrue(UndoUtil.isUndoDisabledFor(editor2.getDocument()), "Undo must be disabled in console for performance reasons");
        LOG.assertTrue(!((DocumentImpl)editor2.getDocument()).isWriteThreadOnly(), "Console document must support background modifications, see e.g. ConsoleViewUtil.setupConsoleEditor() " + this.getClass());
        editor2.installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler(){

            public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    8.$$$reportNull$$$0(0);
                }
                return ConsoleViewImpl.this.getPopupGroup(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/ConsoleViewImpl$8", "getActionGroup"));
            }
        });
        int bufferSize = ConsoleBuffer.useCycleBuffer() ? ConsoleBuffer.getCycleBufferSize() : 0;
        editor2.getDocument().setCyclicBufferSize(bufferSize);
        editor2.putUserData(CONSOLE_VIEW_IN_EDITOR_VIEW, (Object)this);
        editor2.getSettings().setAllowSingleLogicalLineFolding(true);
        EditorEx editorEx = editor2;
        if (editorEx == null) {
            ConsoleViewImpl.$$$reportNull$$$0(27);
        }
        return editorEx;
    }

    @NotNull
    protected EditorEx doCreateConsoleEditor() {
        EditorEx editorEx = ConsoleViewUtil.setupConsoleEditor((Project)this.myProject, (boolean)true, (boolean)false);
        if (editorEx == null) {
            ConsoleViewImpl.$$$reportNull$$$0(28);
        }
        return editorEx;
    }

    private void registerConsoleEditorActions(@NotNull Editor editor2) {
        if (editor2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(29);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"GotoDeclaration").getShortcuts();
        CustomShortcutSet shortcutSet = new CustomShortcutSet(ArrayUtil.mergeArrays(shortcuts, CommonShortcuts.ENTER.getShortcuts()));
        new HyperlinkNavigationAction().registerCustomShortcutSet((ShortcutSet)shortcutSet, editor2.getContentComponent());
        if (!this.myIsViewer) {
            new EnterHandler().registerCustomShortcutSet(CommonShortcuts.ENTER, editor2.getContentComponent());
            ConsoleViewImpl.registerActionHandler(editor2, "EditorPaste", new PasteHandler());
            ConsoleViewImpl.registerActionHandler(editor2, "EditorBackSpace", new DeleteBackspaceHandler(-1, "EditorBackSpace"));
            ConsoleViewImpl.registerActionHandler(editor2, "EditorDelete", new DeleteBackspaceHandler(0, "EditorDelete"));
            ConsoleViewImpl.registerActionHandler(editor2, "EditorTab", new TabHandler());
            ConsoleViewImpl.registerActionHandler(editor2, "SendEOF");
        }
    }

    private static void registerActionHandler(@NotNull Editor editor2, @NotNull String actionId) {
        if (editor2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(30);
        }
        if (actionId == null) {
            ConsoleViewImpl.$$$reportNull$$$0(31);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        AnAction action2 = ActionManager.getInstance().getAction(actionId);
        action2.registerCustomShortcutSet(action2.getShortcutSet(), editor2.getContentComponent());
    }

    private static void registerActionHandler(@NotNull Editor editor2, @NotNull String actionId, @NotNull AnAction action2) {
        if (editor2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(32);
        }
        if (actionId == null) {
            ConsoleViewImpl.$$$reportNull$$$0(33);
        }
        if (action2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(34);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = keymap.getShortcuts(actionId);
        action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), editor2.getContentComponent());
    }

    @NotNull
    private ActionGroup getPopupGroup(@NotNull EditorMouseEvent event) {
        if (event == null) {
            ConsoleViewImpl.$$$reportNull$$$0(35);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ActionManager actionManager = ActionManager.getInstance();
        HyperlinkInfo info2 = this.getHyperlinks() != null ? this.getHyperlinks().getHyperlinkInfoByEvent(event) : null;
        ActionGroup group2 = null;
        if (info2 instanceof HyperlinkWithPopupMenuInfo) {
            group2 = ((HyperlinkWithPopupMenuInfo)info2).getPopupMenuGroup(event.getMouseEvent());
        }
        if (group2 == null) {
            group2 = (ActionGroup)actionManager.getAction(CONSOLE_VIEW_POPUP_MENU);
        }
        List<ConsoleActionsPostProcessor> postProcessors = ConsoleActionsPostProcessor.EP_NAME.getExtensionList();
        AnAction[] result2 = group2.getChildren(null);
        for (ConsoleActionsPostProcessor postProcessor : postProcessors) {
            result2 = postProcessor.postProcessPopupActions(this, result2);
        }
        return new DefaultActionGroup(result2);
    }

    private void highlightHyperlinksAndFoldings(int startLine) {
        boolean canHighlightHyperlinks;
        ApplicationManager.getApplication().assertIsDispatchThread();
        CompositeFilter compositeFilter = this.createCompositeFilter();
        boolean bl = canHighlightHyperlinks = !compositeFilter.isEmpty();
        if (!canHighlightHyperlinks && !this.myUpdateFoldingsEnabled) {
            return;
        }
        Document document = this.getEditor().getDocument();
        if (document.getTextLength() == 0) {
            return;
        }
        int endLine = Math.max(0, document.getLineCount() - 1);
        if (canHighlightHyperlinks) {
            this.getHyperlinks().highlightHyperlinks((Filter)compositeFilter, startLine, endLine);
        }
        if (this.myAllowHeavyFilters && compositeFilter.isAnyHeavy() && compositeFilter.shouldRunHeavy()) {
            this.runHeavyFilters(compositeFilter, startLine, endLine);
        }
        if (this.myUpdateFoldingsEnabled) {
            this.updateFoldings(startLine, endLine);
        }
    }

    public void rehighlightHyperlinksAndFoldings() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        this.clearHyperlinkAndFoldings();
        this.highlightHyperlinksAndFoldings(0);
    }

    private void runHeavyFilters(@NotNull CompositeFilter compositeFilter, int line1, int endLine) {
        if (compositeFilter == null) {
            ConsoleViewImpl.$$$reportNull$$$0(36);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int startLine = Math.max(0, line1);
        Document document = this.getEditor().getDocument();
        int startOffset = document.getLineStartOffset(startLine);
        String text2 = document.getText(new TextRange(startOffset, document.getLineEndOffset(endLine)));
        DocumentImpl documentCopy = new DocumentImpl(text2, true);
        documentCopy.setReadOnly(true);
        this.myJLayeredPane.startUpdating();
        final int currentValue = this.myHeavyUpdateTicket;
        this.myHeavyAlarm.addRequest(() -> {
            if (!compositeFilter.shouldRunHeavy()) {
                return;
            }
            try {
                compositeFilter.applyHeavyFilter(documentCopy, startOffset, startLine, additionalHighlight -> this.addFlushRequest(0, new FlushRunnable(true, (FilterMixin.AdditionalHighlight)((Object)((Object)additionalHighlight))){
                    final /* synthetic */ FilterMixin.AdditionalHighlight val$additionalHighlight;
                    {
                        this.val$additionalHighlight = additionalHighlight;
                        super(adHoc);
                    }

                    @Override
                    public void doRun() {
                        if (ConsoleViewImpl.this.myHeavyUpdateTicket != currentValue) {
                            return;
                        }
                        TextAttributes additionalAttributes = this.val$additionalHighlight.getTextAttributes(null);
                        if (additionalAttributes != null) {
                            Filter.ResultItem item = (Filter.ResultItem)this.val$additionalHighlight.getResultItems().get(0);
                            ConsoleViewImpl.this.getHyperlinks().addHighlighter(item.getHighlightStartOffset(), item.getHighlightEndOffset(), additionalAttributes);
                        } else {
                            ConsoleViewImpl.this.getHyperlinks().highlightHyperlinks((Filter.Result)this.val$additionalHighlight, 0);
                        }
                    }
                }));
            }
            catch (IndexNotReadyException indexNotReadyException) {
            }
            finally {
                if (this.myHeavyAlarm.getActiveRequestCount() <= 1) {
                    UIUtil.invokeLaterIfNeeded(() -> this.myJLayeredPane.finishUpdating());
                }
            }
        }, 0);
    }

    protected void updateFoldings(int startLine, int endLine) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Editor editor2 = this.getEditor();
        editor2.getFoldingModel().runBatchFoldingOperation(() -> {
            List<ConsoleFolding> extensions2;
            int prevLineStart;
            FoldRegion[] regions;
            Document document = editor2.getDocument();
            FoldRegion existingRegion = null;
            if (startLine > 0 && (regions = FoldingUtil.getFoldRegionsAtOffset((Editor)editor2, (int)(prevLineStart = document.getLineStartOffset(startLine - 1)))).length == 1) {
                existingRegion = regions[0];
            }
            ConsoleFolding lastFolding = existingRegion == null ? null : this.findFoldingByRegion(existingRegion);
            int lastStartLine = Integer.MAX_VALUE;
            if (lastFolding != null) {
                int offset2 = existingRegion.getStartOffset();
                if (offset2 == 0) {
                    lastStartLine = 0;
                } else {
                    lastStartLine = document.getLineNumber(offset2);
                    if (document.getLineStartOffset(lastStartLine) != offset2) {
                        ++lastStartLine;
                    }
                }
            }
            if ((extensions2 = ContainerUtil.filter(ConsoleFolding.EP_NAME.getExtensionList(), cf -> cf.isEnabledForConsole((ConsoleView)this))).isEmpty()) {
                return;
            }
            for (int line = startLine; line <= endLine; ++line) {
                ConsoleFolding next2;
                ConsoleFolding consoleFolding = next2 = line < endLine ? this.foldingForLine(extensions2, line, document) : null;
                if (next2 == lastFolding) continue;
                if (lastFolding != null) {
                    boolean isExpanded = false;
                    if (line > startLine && existingRegion != null && lastStartLine < startLine) {
                        isExpanded = existingRegion.isExpanded();
                        editor2.getFoldingModel().removeFoldRegion(existingRegion);
                    }
                    this.addFoldRegion(document, lastFolding, lastStartLine, line - 1, isExpanded);
                }
                lastFolding = next2;
                lastStartLine = line;
                existingRegion = null;
            }
        });
    }

    private void addFoldRegion(@NotNull Document document, @NotNull ConsoleFolding folding2, int startLine, int endLine, boolean isExpanded) {
        FoldRegion region;
        if (document == null) {
            ConsoleViewImpl.$$$reportNull$$$0(37);
        }
        if (folding2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(38);
        }
        ArrayList<String> toFold = new ArrayList<String>(endLine - startLine + 1);
        for (int i2 = startLine; i2 <= endLine; ++i2) {
            toFold.add(EditorHyperlinkSupport.getLineText((Document)document, (int)i2, (boolean)false));
        }
        int oStart = document.getLineStartOffset(startLine);
        if (oStart > 0 && folding2.shouldBeAttachedToThePreviousLine()) {
            --oStart;
        }
        int oEnd = CharArrayUtil.shiftBackward(document.getImmutableCharSequence(), document.getLineEndOffset(endLine) - 1, " \t") + 1;
        String placeholder = folding2.getPlaceholderText(this.getProject(), toFold);
        FoldRegion foldRegion = region = placeholder == null ? null : this.getEditor().getFoldingModel().addFoldRegion(oStart, oEnd, placeholder);
        if (region != null) {
            region.setExpanded(isExpanded);
            region.putUserData(USED_FOLDING_FQN_KEY, (Object)ConsoleViewImpl.getFoldingFqn(folding2));
        }
    }

    private ConsoleFolding findFoldingByRegion(@NotNull FoldRegion region) {
        String lastFoldingFqn;
        if (region == null) {
            ConsoleViewImpl.$$$reportNull$$$0(39);
        }
        if ((lastFoldingFqn = USED_FOLDING_FQN_KEY.get((UserDataHolder)region)) == null) {
            return null;
        }
        ConsoleFolding consoleFolding = ConsoleFolding.EP_NAME.getByKey(lastFoldingFqn, ConsoleViewImpl.class, ConsoleViewImpl::getFoldingFqn);
        return consoleFolding != null && consoleFolding.isEnabledForConsole((ConsoleView)this) ? consoleFolding : null;
    }

    @NotNull
    private static String getFoldingFqn(@NotNull ConsoleFolding consoleFolding) {
        if (consoleFolding == null) {
            ConsoleViewImpl.$$$reportNull$$$0(40);
        }
        String string2 = consoleFolding.getClass().getName();
        if (string2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(41);
        }
        return string2;
    }

    @Nullable
    private ConsoleFolding foldingForLine(@NotNull List<? extends ConsoleFolding> extensions2, int line, @NotNull Document document) {
        if (extensions2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(42);
        }
        if (document == null) {
            ConsoleViewImpl.$$$reportNull$$$0(43);
        }
        String lineText = EditorHyperlinkSupport.getLineText((Document)document, (int)line, (boolean)false);
        if (line == 0 && this.myCommandLineFolding.shouldFoldLine(this.myProject, lineText)) {
            return this.myCommandLineFolding;
        }
        for (ConsoleFolding consoleFolding : extensions2) {
            if (!consoleFolding.shouldFoldLine(this.myProject, lineText)) continue;
            return consoleFolding;
        }
        return null;
    }

    void type(@NotNull Editor editor2, @NotNull String text2) {
        int typeOffset;
        if (editor2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(44);
        }
        if (text2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(45);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.flushDeferredText();
        SelectionModel selectionModel = editor2.getSelectionModel();
        int lastOffset = selectionModel.hasSelection() ? selectionModel.getSelectionStart() : editor2.getCaretModel().getOffset() - 1;
        RangeMarker marker = ConsoleTokenUtil.findTokenMarker(this.getEditor(), this.getProject(), lastOffset);
        if (marker == null || ConsoleTokenUtil.getTokenType(marker) != ConsoleViewContentType.USER_INPUT) {
            this.print(text2, ConsoleViewContentType.USER_INPUT);
            ConsoleViewImpl.moveScrollRemoveSelection(editor2, editor2.getDocument().getTextLength());
            return;
        }
        String textToUse = StringUtil.convertLineSeparators(text2);
        Document document = editor2.getDocument();
        if (selectionModel.hasSelection()) {
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            document.deleteString(start, end);
            selectionModel.removeSelection();
            typeOffset = start;
            assert (typeOffset <= document.getTextLength()) : "typeOffset=" + typeOffset + "; document.getTextLength()=" + document.getTextLength() + "; sel start=" + start + "; sel end=" + end + "; document=" + document.getClass();
        } else {
            typeOffset = editor2.getCaretModel().getOffset();
            assert (typeOffset <= document.getTextLength()) : "typeOffset=" + typeOffset + "; document.getTextLength()=" + document.getTextLength() + "; caret model=" + editor2.getCaretModel();
        }
        this.insertUserText(typeOffset, textToUse);
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        this.getComponent();
        JComponent jComponent = this.getEditor().getContentComponent();
        if (jComponent == null) {
            ConsoleViewImpl.$$$reportNull$$$0(46);
        }
        return jComponent;
    }

    public boolean hasNextOccurence() {
        return this.calcNextOccurrence(1) != null;
    }

    public boolean hasPreviousOccurence() {
        return this.calcNextOccurrence(-1) != null;
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.calcNextOccurrence(1);
    }

    @Nullable
    protected OccurenceNavigator.OccurenceInfo calcNextOccurrence(int delta) {
        Editor editor2 = this.getEditor();
        if (this.isDisposed() || editor2 == null) {
            return null;
        }
        return EditorHyperlinkSupport.getNextOccurrence((Editor)editor2, (int)delta, next2 -> {
            int offset2 = next2.getStartOffset();
            this.scrollTo(offset2);
            HyperlinkInfo hyperlinkInfo = EditorHyperlinkSupport.getHyperlinkInfo((RangeHighlighter)next2);
            if (hyperlinkInfo instanceof BrowserHyperlinkInfo) {
                return;
            }
            if (hyperlinkInfo instanceof HyperlinkInfoBase) {
                VisualPosition position = editor2.offsetToVisualPosition(offset2);
                Point point = editor2.visualPositionToXY(new VisualPosition(position.getLine() + 1, position.getColumn()));
                ((HyperlinkInfoBase)hyperlinkInfo).navigate(this.myProject, new RelativePoint(editor2.getContentComponent(), point));
            } else if (hyperlinkInfo != null) {
                hyperlinkInfo.navigate(this.myProject);
            }
        });
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.calcNextOccurrence(-1);
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string2 = ExecutionBundle.message((String)"down.the.stack.trace", (Object[])new Object[0]);
        if (string2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(47);
        }
        return string2;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string2 = ExecutionBundle.message((String)"up.the.stack.trace", (Object[])new Object[0]);
        if (string2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(48);
        }
        return string2;
    }

    public void addCustomConsoleAction(@NotNull AnAction action2) {
        if (action2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(49);
        }
        this.customActions.add(action2);
    }

    public AnAction @NotNull [] createConsoleActions() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        AnAction prevAction = actionsManager.createPrevOccurenceAction((OccurenceNavigator)this);
        prevAction.getTemplatePresentation().setText(this.getPreviousOccurenceActionName());
        AnAction nextAction = actionsManager.createNextOccurenceAction((OccurenceNavigator)this);
        nextAction.getTemplatePresentation().setText(this.getNextOccurenceActionName());
        ToggleUseSoftWrapsToolbarAction switchSoftWrapsAction = new ToggleUseSoftWrapsToolbarAction(SoftWrapAppliancePlaces.CONSOLE){

            protected Editor getEditor(@NotNull AnActionEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$0(0);
                }
                return ConsoleViewImpl.this.getEditor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/impl/ConsoleViewImpl$10", "getEditor"));
            }
        };
        ScrollToTheEndToolbarAction autoScrollToTheEndAction = new ScrollToTheEndToolbarAction(this.getEditor());
        ArrayList<Object> consoleActions = new ArrayList<Object>();
        consoleActions.add(prevAction);
        consoleActions.add(nextAction);
        consoleActions.add(switchSoftWrapsAction);
        consoleActions.add(autoScrollToTheEndAction);
        consoleActions.add(ActionManager.getInstance().getAction("Print"));
        consoleActions.add((Object)new ClearThisConsoleAction(this));
        consoleActions.addAll(this.customActions);
        List<ConsoleActionsPostProcessor> postProcessors = ConsoleActionsPostProcessor.EP_NAME.getExtensionList();
        AnAction[] result2 = consoleActions.toArray(AnAction.EMPTY_ARRAY);
        for (ConsoleActionsPostProcessor postProcessor : postProcessors) {
            result2 = postProcessor.postProcess(this, result2);
        }
        if (result2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(50);
        }
        return result2;
    }

    public void allowHeavyFilters() {
        this.myAllowHeavyFilters = true;
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent2) {
        if (listener2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(51);
        }
        if (parent2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(52);
        }
        this.myListeners.add(listener2);
        Disposer.register(parent2, () -> this.myListeners.remove(listener2));
    }

    private void insertUserText(int offset2, @NotNull String text2) {
        if (text2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(53);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<Pair<String, ConsoleViewContentType>> result2 = this.myInputMessageFilter.applyFilter(text2, ConsoleViewContentType.USER_INPUT);
        if (result2 == null) {
            this.doInsertUserInput(offset2, text2);
        } else {
            for (Pair<String, ConsoleViewContentType> pair : result2) {
                String chunkText = pair.getFirst();
                ConsoleViewContentType chunkType = pair.getSecond();
                if (chunkType.equals(ConsoleViewContentType.USER_INPUT)) {
                    this.doInsertUserInput(offset2, chunkText);
                    offset2 += chunkText.length();
                    continue;
                }
                this.print(chunkText, chunkType, null);
            }
        }
    }

    private void doInsertUserInput(int offset2, @NotNull String text2) {
        if (text2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(54);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Editor editor2 = this.getEditor();
        Document document = editor2.getDocument();
        int oldDocLength = document.getTextLength();
        document.insertString(offset2, text2);
        int newStartOffset = Math.max(0, document.getTextLength() - oldDocLength + offset2 - text2.length());
        int newEndOffset = document.getTextLength() - oldDocLength + offset2;
        if (ConsoleTokenUtil.findTokenMarker(this.getEditor(), this.getProject(), newEndOffset) == null) {
            ConsoleTokenUtil.createTokenRangeHighlighter(this.getEditor(), this.getProject(), ConsoleViewContentType.USER_INPUT, newStartOffset, newEndOffset, !text2.equals("\n"));
        }
        ConsoleViewImpl.moveScrollRemoveSelection(editor2, newEndOffset);
        this.sendUserInput(text2);
    }

    private static void moveScrollRemoveSelection(@NotNull Editor editor2, int offset2) {
        if (editor2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(55);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        editor2.getCaretModel().moveToOffset(offset2);
        editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor2.getSelectionModel().removeSelection();
    }

    private void deleteUserText(int startOffset, int length) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Editor editor2 = this.getEditor();
        Document document = editor2.getDocument();
        RangeMarker marker = ConsoleTokenUtil.findTokenMarker(this.getEditor(), this.getProject(), startOffset);
        if (marker == null || ConsoleTokenUtil.getTokenType(marker) != ConsoleViewContentType.USER_INPUT) {
            return;
        }
        int endOffset = startOffset + length;
        if (startOffset >= 0 && endOffset >= 0 && endOffset > startOffset) {
            document.deleteString(startOffset, endOffset);
        }
        ConsoleViewImpl.moveScrollRemoveSelection(editor2, startOffset);
    }

    public boolean isRunning() {
        return this.myState.isRunning();
    }

    public void addNotificationComponent(@NotNull JComponent notificationComponent) {
        if (notificationComponent == null) {
            ConsoleViewImpl.$$$reportNull$$$0(56);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.add((Component)notificationComponent, "North");
    }

    @TestOnly
    @NotNull
    ConsoleState getState() {
        ConsoleState consoleState = this.myState;
        if (consoleState == null) {
            ConsoleViewImpl.$$$reportNull$$$0(57);
        }
        return consoleState;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(58);
        }
        return project2;
    }

    @NotNull
    public String getText() {
        String string2 = this.getEditor().getDocument().getText();
        if (string2 == null) {
            ConsoleViewImpl.$$$reportNull$$$0(59);
        }
        return string2;
    }

    static {
        NEW_LINE_MATCHER = CharMatcher.anyOf((CharSequence)"\n\r");
        USED_FOLDING_FQN_KEY = Key.create("USED_FOLDING_KEY");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 12, 14, 16, 27, 28, 41, 46, 47, 48, 50, 57, 58, 59 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialState";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 27: 
            case 28: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/ConsoleViewImpl";
                break;
            }
            case 7: 
            case 15: 
            case 22: 
            case 29: 
            case 30: 
            case 32: 
            case 44: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flushRunnable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 17: 
            case 19: 
            case 45: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedText";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 34: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeFilter";
                break;
            }
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folding";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleFolding";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/ConsoleViewImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeFilter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "initConsoleEditor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterComponent";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleEditor";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateConsoleEditor";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingFqn";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusableComponent";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 27: 
            case 28: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "scrollToEnd";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addFlushRequest";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addLayerToPane";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateStickToEndState";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sendUserInput";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isStickingToEnd";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "registerConsoleEditorActions";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "registerActionHandler";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPopupGroup";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "runHeavyFilters";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addFoldRegion";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findFoldingByRegion";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingFqn";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "foldingForLine";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addCustomConsoleAction";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "insertUserText";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "doInsertUserInput";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "moveScrollRemoveSelection";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addNotificationComponent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 11, 12, 14, 16, 27, 28, 41, 46, 47, 48, 50, 57, 58, 59 -> new IllegalStateException(string2);
        };
    }

    private class CommandLineFolding
    extends ConsoleFolding {
        private CommandLineFolding() {
        }

        public boolean shouldFoldLine(@NotNull Project project2, @NotNull String line) {
            if (project2 == null) {
                CommandLineFolding.$$$reportNull$$$0(0);
            }
            if (line == null) {
                CommandLineFolding.$$$reportNull$$$0(1);
            }
            return line.length() >= 1000 && ConsoleViewImpl.this.myState.isCommandLine(line);
        }

        public String getPlaceholderText(@NotNull Project project2, @NotNull List<String> lines2) {
            if (project2 == null) {
                CommandLineFolding.$$$reportNull$$$0(2);
            }
            if (lines2 == null) {
                CommandLineFolding.$$$reportNull$$$0(3);
            }
            String text2 = lines2.get(0);
            int index2 = 0;
            if (text2.charAt(0) == '\"') {
                index2 = text2.indexOf(34, 1) + 1;
            }
            if (index2 == 0) {
                boolean nonWhiteSpaceFound = false;
                while (index2 < text2.length()) {
                    char c2 = text2.charAt(index2);
                    if (c2 != ' ' && c2 != '\t') {
                        nonWhiteSpaceFound = true;
                    } else if (nonWhiteSpaceFound) break;
                    ++index2;
                }
            }
            assert (index2 <= text2.length());
            return text2.substring(0, index2) + " ...";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/impl/ConsoleViewImpl$CommandLineFolding";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldFoldLine";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPlaceholderText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class FlushRunnable
    implements Runnable {
        private final AtomicBoolean requested = new AtomicBoolean();
        private final boolean adHoc;

        private FlushRunnable(boolean adHoc) {
            this.adHoc = adHoc;
        }

        void queue(long delay) {
            if (ConsoleViewImpl.this.myFlushAlarm.isDisposed()) {
                return;
            }
            if (this.adHoc || this.requested.compareAndSet(false, true)) {
                ConsoleViewImpl.this.myFlushAlarm.addRequest((Runnable)this, delay, ConsoleViewImpl.this.getStateForUpdate());
            }
        }

        void clearRequested() {
            this.requested.set(false);
        }

        boolean hasRequested() {
            return this.requested.get();
        }

        @Override
        public final void run() {
            if (ConsoleViewImpl.this.isDisposed()) {
                return;
            }
            if (!StartupManagerEx.getInstanceEx((Project)ConsoleViewImpl.this.myProject).startupActivityPassed()) {
                ConsoleViewImpl.this.addFlushRequest(DEFAULT_FLUSH_DELAY, ConsoleViewImpl.this.FLUSH);
            }
            this.clearRequested();
            this.doRun();
        }

        protected void doRun() {
            ConsoleViewImpl.this.flushDeferredText();
        }
    }

    private final class ClearRunnable
    extends FlushRunnable {
        private ClearRunnable() {
            super(false);
        }

        @Override
        public void doRun() {
            ConsoleViewImpl.this.doClear();
        }
    }

    private static final class MyTypedHandler
    extends TypedActionHandlerBase {
        private MyTypedHandler(@NotNull TypedActionHandler originalAction) {
            if (originalAction == null) {
                MyTypedHandler.$$$reportNull$$$0(0);
            }
            super(originalAction);
        }

        public void execute(@NotNull Editor editor2, char charTyped, @NotNull DataContext dataContext2) {
            ConsoleViewImpl consoleView;
            if (editor2 == null) {
                MyTypedHandler.$$$reportNull$$$0(1);
            }
            if (dataContext2 == null) {
                MyTypedHandler.$$$reportNull$$$0(2);
            }
            if ((consoleView = (ConsoleViewImpl)editor2.getUserData(CONSOLE_VIEW_IN_EDITOR_VIEW)) == null || !consoleView.myState.isRunning() || consoleView.myIsViewer) {
                if (this.myOriginalHandler != null) {
                    this.myOriginalHandler.execute(editor2, charTyped, dataContext2);
                }
                return;
            }
            String text2 = String.valueOf(charTyped);
            consoleView.type(editor2, text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/impl/ConsoleViewImpl$MyTypedHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class HyperlinkNavigationAction
    extends DumbAwareAction {
        private HyperlinkNavigationAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                HyperlinkNavigationAction.$$$reportNull$$$0(0);
            }
            Runnable runnable = ConsoleViewImpl.this.getHyperlinks().getLinkNavigationRunnable(ConsoleViewImpl.this.getEditor().getCaretModel().getLogicalPosition());
            assert (runnable != null);
            runnable.run();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                HyperlinkNavigationAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(ConsoleViewImpl.this.getHyperlinks().getLinkNavigationRunnable(ConsoleViewImpl.this.getEditor().getCaretModel().getLogicalPosition()) != null);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                HyperlinkNavigationAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/ConsoleViewImpl$HyperlinkNavigationAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/ConsoleViewImpl$HyperlinkNavigationAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static class EnterHandler
    extends ConsoleAction {
        private EnterHandler() {
        }

        @Override
        public void execute(@NotNull ConsoleViewImpl consoleView, @NotNull DataContext context2) {
            if (consoleView == null) {
                EnterHandler.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                EnterHandler.$$$reportNull$$$0(1);
            }
            consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            consoleView.flushDeferredText();
            Editor editor2 = consoleView.getEditor();
            ConsoleViewImpl.moveScrollRemoveSelection(editor2, editor2.getDocument().getTextLength());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consoleView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/impl/ConsoleViewImpl$EnterHandler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PasteHandler
    extends ConsoleAction {
        private PasteHandler() {
        }

        @Override
        public void execute(@NotNull ConsoleViewImpl consoleView, @NotNull DataContext context2) {
            String text2;
            if (consoleView == null) {
                PasteHandler.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                PasteHandler.$$$reportNull$$$0(1);
            }
            if ((text2 = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)) == null) {
                return;
            }
            Editor editor2 = consoleView.getEditor();
            consoleView.type(editor2, text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consoleView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/impl/ConsoleViewImpl$PasteHandler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DeleteBackspaceHandler
    extends ConsoleAction {
        private final int myTextOffsetToDeleteRelativeToCaret;
        private final String myParentActionId;

        private DeleteBackspaceHandler(int textOffsetToDeleteRelativeToCaret, @NotNull String parentActionId) {
            if (parentActionId == null) {
                DeleteBackspaceHandler.$$$reportNull$$$0(0);
            }
            this.myTextOffsetToDeleteRelativeToCaret = textOffsetToDeleteRelativeToCaret;
            this.myParentActionId = parentActionId;
        }

        @Override
        public void execute(@NotNull ConsoleViewImpl consoleView, @NotNull DataContext context2) {
            Editor editor2;
            if (consoleView == null) {
                DeleteBackspaceHandler.$$$reportNull$$$0(1);
            }
            if (context2 == null) {
                DeleteBackspaceHandler.$$$reportNull$$$0(2);
            }
            if (IncrementalSearchHandler.isHintVisible(editor2 = consoleView.getEditor())) {
                DeleteBackspaceHandler.getDefaultActionHandler(this.myParentActionId).execute(editor2, null, context2);
                return;
            }
            consoleView.flushDeferredText();
            Document document = editor2.getDocument();
            int length = document.getTextLength();
            if (length == 0) {
                return;
            }
            SelectionModel selectionModel = editor2.getSelectionModel();
            if (selectionModel.hasSelection()) {
                consoleView.deleteUserText(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd() - selectionModel.getSelectionStart());
            } else {
                int offset2 = editor2.getCaretModel().getOffset() + this.myTextOffsetToDeleteRelativeToCaret;
                if (offset2 >= 0) {
                    consoleView.deleteUserText(offset2, 1);
                }
            }
        }

        @NotNull
        private static EditorActionHandler getDefaultActionHandler(@NotNull String actionId) {
            if (actionId == null) {
                DeleteBackspaceHandler.$$$reportNull$$$0(3);
            }
            EditorActionHandler editorActionHandler = EditorActionManager.getInstance().getActionHandler(actionId);
            if (editorActionHandler == null) {
                DeleteBackspaceHandler.$$$reportNull$$$0(4);
            }
            return editorActionHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentActionId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleView";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/ConsoleViewImpl$DeleteBackspaceHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/ConsoleViewImpl$DeleteBackspaceHandler";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultActionHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultActionHandler";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4 -> new IllegalStateException(string2);
            };
        }
    }

    private static class TabHandler
    extends ConsoleAction {
        private TabHandler() {
        }

        @Override
        protected void execute(@NotNull ConsoleViewImpl console, @NotNull DataContext context2) {
            if (console == null) {
                TabHandler.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                TabHandler.$$$reportNull$$$0(1);
            }
            console.type(console.getEditor(), "\t");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "console";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/impl/ConsoleViewImpl$TabHandler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClearThisConsoleAction
    extends ClearConsoleAction {
        private final ConsoleView myConsoleView;

        ClearThisConsoleAction(@NotNull ConsoleView consoleView) {
            if (consoleView == null) {
                ClearThisConsoleAction.$$$reportNull$$$0(0);
            }
            this.myConsoleView = consoleView;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearThisConsoleAction.$$$reportNull$$$0(1);
            }
            boolean enabled = this.myConsoleView.getContentSize() > 0;
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearThisConsoleAction.$$$reportNull$$$0(2);
            }
            this.myConsoleView.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleView";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/impl/ConsoleViewImpl$ClearThisConsoleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ConsoleAction
    extends AnAction
    implements DumbAware {
        private ConsoleAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ConsoleAction.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            DataContext context2 = e.getDataContext();
            ConsoleViewImpl console = ConsoleAction.getRunningConsole(context2);
            if (console != null) {
                this.execute(console, context2);
            }
        }

        protected abstract void execute(@NotNull ConsoleViewImpl var1, @NotNull DataContext var2);

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ConsoleAction.$$$reportNull$$$0(1);
            }
            ConsoleViewImpl console = ConsoleAction.getRunningConsole(e.getDataContext());
            e.getPresentation().setEnabled(console != null);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ConsoleAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        @Nullable
        private static ConsoleViewImpl getRunningConsole(@NotNull DataContext context2) {
            ConsoleViewImpl console;
            Editor editor2;
            if (context2 == null) {
                ConsoleAction.$$$reportNull$$$0(3);
            }
            if ((editor2 = (Editor)CommonDataKeys.EDITOR.getData(context2)) != null && (console = (ConsoleViewImpl)editor2.getUserData(CONSOLE_VIEW_IN_EDITOR_VIEW)) != null && console.myState.isRunning()) {
                return console;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/ConsoleViewImpl$ConsoleAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/ConsoleViewImpl$ConsoleAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getRunningConsole";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    @Deprecated(forRemoval=true)
    public static class ClearAllAction
    extends ClearConsoleAction {
    }
}

