/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class ServiceViewDeleteProvider
implements DeleteProvider {
    private final ServiceView myServiceView;

    ServiceViewDeleteProvider(@NotNull ServiceView serviceView) {
        if (serviceView == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(0);
        }
        this.myServiceView = serviceView;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void deleteElement(@NotNull DataContext dataContext2) {
        Project project2;
        if (dataContext2 == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(2);
        }
        if ((project2 = (Project)dataContext2.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        List<Pair> items2 = ContainerUtil.mapNotNull(this.myServiceView.getSelectedItems(), item -> {
            Runnable remover = item.getViewDescriptor().getRemover();
            return remover == null ? null : Pair.create(item, remover);
        });
        if ((items2 = ServiceViewDeleteProvider.filterChildren(items2)).isEmpty()) {
            return;
        }
        if (Messages.showYesNoDialog((Project)project2, (String)ExecutionBundle.message((String)"service.view.delete.confirmation", (Object[])new Object[]{ExecutionBundle.message((String)"service.view.items", (Object[])new Object[]{items2.size()})}), (String)CommonBundle.message((String)"button.delete", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        for (Pair item2 : items2) {
            ((Runnable)item2.second).run();
        }
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(3);
        }
        if (!ContainerUtil.exists(this.myServiceView.getSelectedItems(), item -> item.getViewDescriptor().getRemover() != null)) {
            return false;
        }
        JComponent detailsComponent = this.myServiceView.getUi().getDetailsComponent();
        return detailsComponent == null || !UIUtil.isAncestor(detailsComponent, (Component)dataContext2.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT));
    }

    @NotNull
    private static List<Pair<ServiceModel.ServiceViewItem, Runnable>> filterChildren(List<? extends Pair<ServiceModel.ServiceViewItem, Runnable>> items2) {
        List<Pair<ServiceModel.ServiceViewItem, Runnable>> list2 = ContainerUtil.filter(items2, item -> {
            for (ServiceModel.ServiceViewItem parent2 = ((ServiceModel.ServiceViewItem)item.first).getParent(); parent2 != null; parent2 = parent2.getParent()) {
                for (Pair pair : items2) {
                    if (!((ServiceModel.ServiceViewItem)pair.first).equals(parent2)) continue;
                    return false;
                }
            }
            return true;
        });
        if (list2 == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceView";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceViewDeleteProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceViewDeleteProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 4 -> new IllegalStateException(string2);
        };
    }
}

