/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDnDDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewManagerImpl;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ServiceViewDragHelper {
    ServiceViewDragHelper() {
    }

    static DnDSource createSource(@NotNull ServiceView serviceView) {
        if (serviceView == null) {
            ServiceViewDragHelper.$$$reportNull$$$0(0);
        }
        return new ServiceViewDnDSource(serviceView);
    }

    static DnDTarget createTarget(@NotNull JTree tree) {
        if (tree == null) {
            ServiceViewDragHelper.$$$reportNull$$$0(1);
        }
        return new ServiceViewDnDTarget(tree);
    }

    static void installDnDSupport(final @NotNull Project project2, final @NotNull InternalDecorator decorator, final @NotNull ContentManager contentManager) {
        if (project2 == null) {
            ServiceViewDragHelper.$$$reportNull$$$0(2);
        }
        if (decorator == null) {
            ServiceViewDragHelper.$$$reportNull$$$0(3);
        }
        if (contentManager == null) {
            ServiceViewDragHelper.$$$reportNull$$$0(4);
        }
        final Content dropTargetContent = ServiceViewDragHelper.createDropTargetContent();
        DnDSupport.createBuilder((JComponent)decorator).setTargetChecker(new DnDTargetChecker(){

            public boolean update(DnDEvent event) {
                Object o = event.getAttachedObject();
                boolean dropPossible = o instanceof ServiceViewDragBean && event.getPointOn((Component)decorator).y < decorator.getHeaderHeight();
                event.setDropPossible(dropPossible, "");
                if (dropPossible) {
                    ItemPresentation presentation2;
                    ServiceViewDragBean dragBean;
                    if (contentManager.getIndexOfContent(dropTargetContent) < 0) {
                        contentManager.addContent(dropTargetContent);
                    }
                    if ((dragBean = (ServiceViewDragBean)o).getItems().size() > 1 && dragBean.getContributor() != null) {
                        presentation2 = dragBean.getContributor().getViewDescriptor(project2).getPresentation();
                    } else {
                        ServiceModel.ServiceViewItem item = dragBean.getItems().get(0);
                        presentation2 = item.getViewDescriptor().getPresentation();
                        dropTargetContent.setTabColor(item.getColor());
                    }
                    dropTargetContent.setDisplayName(ServiceViewDragHelper.getDisplayName(presentation2));
                    dropTargetContent.setIcon(presentation2.getIcon(false));
                } else if (contentManager.getIndexOfContent(dropTargetContent) >= 0) {
                    contentManager.removeContent(dropTargetContent, false);
                }
                return true;
            }
        }).setCleanUpOnLeaveCallback(() -> {
            if (!contentManager.isDisposed() && contentManager.getIndexOfContent(dropTargetContent) >= 0) {
                contentManager.removeContent(dropTargetContent, false);
            }
        }).setDropHandler(new DnDDropHandler(){

            public void drop(DnDEvent event) {
                Object o = event.getAttachedObject();
                if (o instanceof ServiceViewDragBean) {
                    ((ServiceViewManagerImpl)ServiceViewManager.getInstance(project2)).extract((ServiceViewDragBean)o);
                }
            }
        }).install();
        decorator.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (contentManager.getIndexOfContent(dropTargetContent) >= 0) {
                    contentManager.removeContent(dropTargetContent, false);
                }
            }
        });
    }

    @NlsContexts.TabTitle
    static String getDisplayName(ItemPresentation presentation2) {
        @NlsSafe StringBuilder result2 = new StringBuilder();
        if (presentation2 instanceof PresentationData) {
            List fragments = ((PresentationData)presentation2).getColoredText();
            if (fragments.isEmpty() && presentation2.getPresentableText() != null) {
                result2.append(presentation2.getPresentableText());
            } else {
                for (PresentableNodeDescriptor.ColoredFragment fragment : fragments) {
                    result2.append(fragment.getText());
                }
            }
        } else if (presentation2.getPresentableText() != null) {
            result2.append(presentation2.getPresentableText());
        }
        return result2.toString();
    }

    @Nullable
    static ServiceViewContributor getTheOnlyRootContributor(List<? extends ServiceModel.ServiceViewItem> items2) {
        ServiceViewContributor<?> result2 = null;
        for (ServiceModel.ServiceViewItem serviceViewItem : items2) {
            if (result2 == null) {
                result2 = serviceViewItem.getRootContributor();
                continue;
            }
            if (result2 == serviceViewItem.getRootContributor()) continue;
            return null;
        }
        return result2;
    }

    private static Content createDropTargetContent() {
        Content content2 = ContentFactory.getInstance().createContent((JComponent)new JPanel(), null, false);
        content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        content2.setCloseable(true);
        return content2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/services/ServiceViewDragHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createTarget";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "installDnDSupport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ServiceViewDnDSource
    implements DnDSource {
        private final ServiceView myServiceView;

        ServiceViewDnDSource(@NotNull ServiceView serviceView) {
            if (serviceView == null) {
                ServiceViewDnDSource.$$$reportNull$$$0(0);
            }
            this.myServiceView = serviceView;
        }

        public boolean canStartDragging(DnDAction action2, @NotNull Point dragOrigin) {
            if (dragOrigin == null) {
                ServiceViewDnDSource.$$$reportNull$$$0(1);
            }
            return !this.myServiceView.getSelectedItems().isEmpty();
        }

        public DnDDragStartBean startDragging(DnDAction action2, @NotNull Point dragOrigin) {
            if (dragOrigin == null) {
                ServiceViewDnDSource.$$$reportNull$$$0(2);
            }
            return new DnDDragStartBean((Object)new ServiceViewDragBean(this.myServiceView, this.myServiceView.getSelectedItems()));
        }

        public Pair<Image, Point> createDraggedImage(DnDAction action2, Point dragOrigin, @NotNull DnDDragStartBean bean) {
            if (bean == null) {
                ServiceViewDnDSource.$$$reportNull$$$0(3);
            }
            ServiceViewDragBean dragBean = (ServiceViewDragBean)bean.getAttachedObject();
            int size = dragBean.getItems().size();
            ItemPresentation presentation2 = null;
            if (size == 1) {
                presentation2 = dragBean.getItems().get(0).getViewDescriptor().getPresentation();
            } else {
                ServiceViewContributor contributor = dragBean.getContributor();
                if (contributor != null) {
                    presentation2 = contributor.getViewDescriptor(this.myServiceView.getProject()).getPresentation();
                }
            }
            SimpleColoredComponent c2 = new SimpleColoredComponent();
            c2.setForeground(this.myServiceView.getForeground());
            c2.setBackground(this.myServiceView.getBackground());
            if (presentation2 != null) {
                c2.setIcon(presentation2.getIcon(false));
                c2.append(ServiceViewDragHelper.getDisplayName(presentation2));
            } else {
                String text2 = ExecutionBundle.message((String)"service.view.items", (Object[])new Object[]{size});
                c2.append(text2);
            }
            Dimension preferredSize = c2.getPreferredSize();
            c2.setSize(preferredSize);
            BufferedImage image = UIUtil.createImage((Component)c2, preferredSize.width, preferredSize.height, 2);
            c2.setOpaque(false);
            Graphics2D g = image.createGraphics();
            c2.paint((Graphics)g);
            g.dispose();
            return Pair.create(image, new Point(0, 0));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceView";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dragOrigin";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/services/ServiceViewDragHelper$ServiceViewDnDSource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canStartDragging";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startDragging";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createDraggedImage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ServiceViewDnDTarget
    implements DnDTarget {
        private final JTree myTree;

        ServiceViewDnDTarget(@NotNull JTree tree) {
            if (tree == null) {
                ServiceViewDnDTarget.$$$reportNull$$$0(0);
            }
            this.myTree = tree;
        }

        public void drop(DnDEvent event) {
            EventContext eventContext = this.getEventContext(event.getPoint());
            if (eventContext == null) {
                return;
            }
            if (eventContext.descriptor.canDrop(event, ServiceViewDnDDescriptor.Position.INTO)) {
                eventContext.descriptor.drop(event, ServiceViewDnDDescriptor.Position.INTO);
            } else {
                eventContext.descriptor.drop(event, eventContext.getPosition());
            }
            event.hideHighlighter();
        }

        public boolean update(DnDEvent event) {
            event.setDropPossible(false);
            EventContext eventContext = this.getEventContext(event.getPoint());
            if (eventContext == null) {
                return true;
            }
            if (eventContext.descriptor.canDrop(event, ServiceViewDnDDescriptor.Position.INTO)) {
                event.setDropPossible(true);
                RelativeRectangle rectangle = new RelativeRectangle(this.myTree, eventContext.cellBounds);
                event.setHighlighting(rectangle, 1);
                return false;
            }
            ServiceViewDnDDescriptor.Position position = eventContext.getPosition();
            if (eventContext.descriptor.canDrop(event, position)) {
                event.setDropPossible(true);
                Rectangle bounds = eventContext.cellBounds;
                bounds.y -= -1;
                bounds.height = 2;
                if (position != ServiceViewDnDDescriptor.Position.ABOVE) {
                    bounds.y += bounds.height;
                }
                RelativeRectangle rectangle = new RelativeRectangle(this.myTree, bounds);
                event.setHighlighting(rectangle, 2);
                return false;
            }
            event.hideHighlighter();
            return false;
        }

        private EventContext getEventContext(Point point) {
            Object object;
            TreePath path2 = this.myTree.getPathForLocation(point.x, point.y);
            if (path2 == null || !((object = path2.getLastPathComponent()) instanceof ServiceModel.ServiceViewItem)) {
                return null;
            }
            ServiceModel.ServiceViewItem item = (ServiceModel.ServiceViewItem)object;
            Rectangle cellBounds = this.myTree.getPathBounds(path2);
            if (cellBounds == null) {
                return null;
            }
            ServiceViewDescriptor viewDescriptor = item.getViewDescriptor();
            if (!(viewDescriptor instanceof ServiceViewDnDDescriptor)) {
                return null;
            }
            return new EventContext(point, cellBounds, (ServiceViewDnDDescriptor)((Object)viewDescriptor));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/execution/services/ServiceViewDragHelper$ServiceViewDnDTarget", "<init>"));
        }

        private static final class EventContext {
            final Point point;
            final Rectangle cellBounds;
            final ServiceViewDnDDescriptor descriptor;

            private EventContext(Point point, Rectangle cellBounds, ServiceViewDnDDescriptor descriptor2) {
                this.point = point;
                this.cellBounds = cellBounds;
                this.descriptor = descriptor2;
            }

            ServiceViewDnDDescriptor.Position getPosition() {
                return this.point.y < this.cellBounds.y + this.cellBounds.height / 2 ? ServiceViewDnDDescriptor.Position.ABOVE : ServiceViewDnDDescriptor.Position.BELOW;
            }
        }
    }

    static class ServiceViewDragBean
    implements DataProvider {
        private final ServiceView myServiceView;
        private final List<ServiceModel.ServiceViewItem> myItems;
        private final ServiceViewContributor myContributor;

        ServiceViewDragBean(@NotNull ServiceView serviceView, @NotNull List<ServiceModel.ServiceViewItem> items2) {
            if (serviceView == null) {
                ServiceViewDragBean.$$$reportNull$$$0(0);
            }
            if (items2 == null) {
                ServiceViewDragBean.$$$reportNull$$$0(1);
            }
            this.myServiceView = serviceView;
            this.myItems = ContainerUtil.filter(items2, item -> {
                for (ServiceModel.ServiceViewItem parent2 = item.getParent(); parent2 != null; parent2 = parent2.getParent()) {
                    if (!items2.contains(parent2)) continue;
                    return false;
                }
                return true;
            });
            this.myContributor = ServiceViewDragHelper.getTheOnlyRootContributor(this.myItems);
        }

        @NotNull
        ServiceView getServiceView() {
            ServiceView serviceView = this.myServiceView;
            if (serviceView == null) {
                ServiceViewDragBean.$$$reportNull$$$0(2);
            }
            return serviceView;
        }

        @NotNull
        List<ServiceModel.ServiceViewItem> getItems() {
            List<ServiceModel.ServiceViewItem> list2 = this.myItems;
            if (list2 == null) {
                ServiceViewDragBean.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Nullable
        ServiceViewContributor getContributor() {
            return this.myContributor;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                ServiceViewDragBean.$$$reportNull$$$0(4);
            }
            if (PlatformCoreDataKeys.SELECTED_ITEMS.is(dataId)) {
                return ContainerUtil.map2Array(this.myItems, ServiceModel.ServiceViewItem::getValue);
            }
            if (PlatformCoreDataKeys.SELECTED_ITEM.is(dataId)) {
                ServiceModel.ServiceViewItem item = ContainerUtil.getOnlyItem(this.myItems);
                return item != null ? item.getValue() : null;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceViewDragHelper$ServiceViewDragBean";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceViewDragHelper$ServiceViewDragBean";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServiceView";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }
}

