/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceModelFilter;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewState;
import com.intellij.openapi.Disposable;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ServiceViewModel
implements Disposable,
InvokerSupplier,
ServiceModel.ServiceModelEventListener {
    protected final ServiceModel myModel;
    protected final ServiceModelFilter myModelFilter;
    private final ServiceModelFilter.ServiceViewFilter myFilter;
    private final List<ServiceViewModelListener> myListeners;
    private volatile boolean myShowGroups;
    private volatile boolean myShowContributorRoots;

    protected ServiceViewModel(@NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, @NotNull ServiceModelFilter.ServiceViewFilter filter2) {
        if (model2 == null) {
            ServiceViewModel.$$$reportNull$$$0(0);
        }
        if (modelFilter == null) {
            ServiceViewModel.$$$reportNull$$$0(1);
        }
        if (filter2 == null) {
            ServiceViewModel.$$$reportNull$$$0(2);
        }
        this.myListeners = new CopyOnWriteArrayList<ServiceViewModelListener>();
        this.myModel = model2;
        this.myModelFilter = modelFilter;
        this.myFilter = filter2;
        this.myModel.addEventListener(this);
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> getRoots() {
        return this.getRoots(false);
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> getVisibleRoots() {
        return this.getRoots(true);
    }

    @NotNull
    private List<? extends ServiceModel.ServiceViewItem> getRoots(boolean visible) {
        List<ServiceModel.ServiceViewItem> roots2 = this.processGroups(this.doGetRoots(), visible);
        if (roots2.stream().anyMatch(ServiceModel.ContributorNode.class::isInstance)) {
            roots2 = this.myShowContributorRoots ? ContainerUtil.filter(roots2, item -> !(item instanceof ServiceModel.ContributorNode) || !this.getChildren((ServiceModel.ServiceViewItem)item, visible).isEmpty()) : roots2.stream().flatMap(item -> item instanceof ServiceModel.ContributorNode ? this.getChildren((ServiceModel.ServiceViewItem)item, visible).stream() : Stream.of(item)).collect(Collectors.toList());
        }
        List<? extends ServiceModel.ServiceViewItem> list2 = roots2;
        if (list2 == null) {
            ServiceViewModel.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    protected abstract List<? extends ServiceModel.ServiceViewItem> doGetRoots();

    void saveState(ServiceViewState viewState) {
        viewState.groupByServiceGroups = this.myShowGroups;
        viewState.groupByContributor = this.myShowContributorRoots;
    }

    void filtersChanged() {
        this.notifyListeners();
    }

    @NotNull
    ServiceModelFilter.ServiceViewFilter getFilter() {
        ServiceModelFilter.ServiceViewFilter serviceViewFilter = this.myFilter;
        if (serviceViewFilter == null) {
            ServiceViewModel.$$$reportNull$$$0(4);
        }
        return serviceViewFilter;
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> getChildren(@NotNull ServiceModel.ServiceViewItem parent2) {
        if (parent2 == null) {
            ServiceViewModel.$$$reportNull$$$0(5);
        }
        List<? extends ServiceModel.ServiceViewItem> list2 = this.getChildren(parent2, true);
        if (list2 == null) {
            ServiceViewModel.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    protected List<? extends ServiceModel.ServiceViewItem> getChildren(@NotNull ServiceModel.ServiceViewItem parent2, boolean visible) {
        if (parent2 == null) {
            ServiceViewModel.$$$reportNull$$$0(7);
        }
        return this.processGroups(this.myModelFilter.filter(parent2.getChildren(), this.myFilter), visible);
    }

    @Nullable
    protected ServiceModel.ServiceViewItem findItemSafe(@NotNull ServiceModel.ServiceViewItem item) {
        ServiceModel.ServiceViewItem updatedItem;
        if (item == null) {
            ServiceViewModel.$$$reportNull$$$0(8);
        }
        if ((updatedItem = ServiceViewModel.findItem(item, this.myModel.getRoots())) != null) {
            return updatedItem;
        }
        return this.myModel.findItemSafe(item.getValue(), item.getRootContributor().getClass());
    }

    void addModelListener(@NotNull ServiceViewModelListener listener2) {
        if (listener2 == null) {
            ServiceViewModel.$$$reportNull$$$0(9);
        }
        this.myListeners.add(listener2);
    }

    void removeModelListener(@NotNull ServiceViewModelListener listener2) {
        if (listener2 == null) {
            ServiceViewModel.$$$reportNull$$$0(10);
        }
        this.myListeners.remove(listener2);
    }

    boolean isGroupByServiceGroups() {
        return this.myShowGroups;
    }

    void setGroupByServiceGroups(boolean value) {
        if (this.myShowGroups != value) {
            this.myShowGroups = value;
            this.notifyListeners();
        }
    }

    boolean isGroupByContributor() {
        return this.myShowContributorRoots;
    }

    void setGroupByContributor(boolean value) {
        if (this.myShowContributorRoots != value) {
            this.myShowContributorRoots = value;
            this.notifyListeners();
        }
    }

    protected void notifyListeners(ServiceEventListener.ServiceEvent e) {
        for (ServiceViewModelListener listener2 : this.myListeners) {
            listener2.eventProcessed(e);
        }
    }

    protected void notifyListeners() {
        for (ServiceViewModelListener listener2 : this.myListeners) {
            listener2.structureChanged();
        }
    }

    @Override
    public void dispose() {
        this.myModel.removeEventListener(this);
    }

    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myModel.getInvoker();
        if (invoker == null) {
            ServiceViewModel.$$$reportNull$$$0(11);
        }
        return invoker;
    }

    public void initRootsIfNeeded() {
    }

    @NotNull
    private List<? extends ServiceModel.ServiceViewItem> processGroups(@NotNull List<? extends ServiceModel.ServiceViewItem> items2, boolean visible) {
        if (items2 == null) {
            ServiceViewModel.$$$reportNull$$$0(12);
        }
        if (visible) {
            items2 = ContainerUtil.filter(items2, item -> item.getViewDescriptor().isVisible());
        }
        if (this.myShowGroups) {
            return this.filterEmptyGroups(items2, visible);
        }
        List list2 = items2.stream().flatMap(item -> item instanceof ServiceModel.ServiceGroupNode ? this.getChildren((ServiceModel.ServiceViewItem)item, visible).stream() : Stream.of(item)).collect(Collectors.toList());
        if (list2 == null) {
            ServiceViewModel.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NotNull
    private List<? extends ServiceModel.ServiceViewItem> filterEmptyGroups(@NotNull List<? extends ServiceModel.ServiceViewItem> items2, boolean visible) {
        if (items2 == null) {
            ServiceViewModel.$$$reportNull$$$0(14);
        }
        List<ServiceModel.ServiceViewItem> list2 = ContainerUtil.filter(items2, item -> !(item instanceof ServiceModel.ServiceGroupNode) || !this.filterEmptyGroups(this.getChildren((ServiceModel.ServiceViewItem)item, visible), visible).isEmpty());
        if (list2 == null) {
            ServiceViewModel.$$$reportNull$$$0(15);
        }
        return list2;
    }

    static ServiceViewModel createModel(@NotNull List<ServiceModel.ServiceViewItem> items2, @Nullable ServiceViewContributor<?> contributor, @NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
        if (items2 == null) {
            ServiceViewModel.$$$reportNull$$$0(16);
        }
        if (model2 == null) {
            ServiceViewModel.$$$reportNull$$$0(17);
        }
        if (modelFilter == null) {
            ServiceViewModel.$$$reportNull$$$0(18);
        }
        if (contributor != null && items2.size() > 1) {
            ServiceModel.ServiceViewItem contributorRoot = null;
            for (ServiceModel.ServiceViewItem serviceViewItem : model2.getRoots()) {
                if (contributor != serviceViewItem.getContributor()) continue;
                contributorRoot = serviceViewItem;
                break;
            }
            if (contributorRoot != null && contributorRoot.getChildren().equals(items2)) {
                return new ContributorModel(model2, modelFilter, contributor, parentFilter);
            }
        }
        if (items2.size() == 1) {
            AtomicReference<ServiceModel.ServiceViewItem> ref;
            ServiceModel.ServiceViewItem item = items2.get(0);
            if (item instanceof ServiceModel.ContributorNode) {
                return new ContributorModel(model2, modelFilter, item.getContributor(), parentFilter);
            }
            if (item instanceof ServiceModel.ServiceGroupNode) {
                ref = new AtomicReference<ServiceModel.ServiceGroupNode>((ServiceModel.ServiceGroupNode)item);
                return new GroupModel(model2, modelFilter, ref, parentFilter);
            }
            if (ServiceViewModel.isSingleService(item)) {
                ref = new AtomicReference<ServiceModel.ServiceViewItem>(item);
                return new SingeServiceModel(model2, modelFilter, ref, parentFilter);
            }
        }
        return new ServiceListModel(model2, modelFilter, items2, parentFilter);
    }

    private static boolean isSingleService(ServiceModel.ServiceViewItem item) {
        ServiceModel.ServiceNode node2;
        if (!(!(item instanceof ServiceModel.ServiceNode) || (node2 = (ServiceModel.ServiceNode)item).isChildrenInitialized() && node2.isLoaded())) {
            return false;
        }
        return item.getChildren().isEmpty();
    }

    @Nullable
    static ServiceViewModel loadModel(@NotNull ServiceViewState viewState, @NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter, @NotNull Map<String, ServiceViewContributor<?>> contributors) {
        if (viewState == null) {
            ServiceViewModel.$$$reportNull$$$0(19);
        }
        if (model2 == null) {
            ServiceViewModel.$$$reportNull$$$0(20);
        }
        if (modelFilter == null) {
            ServiceViewModel.$$$reportNull$$$0(21);
        }
        if (contributors == null) {
            ServiceViewModel.$$$reportNull$$$0(22);
        }
        switch (viewState.viewType) {
            case "contributor": {
                ServiceViewState.ServiceState serviceState = ContainerUtil.getOnlyItem(viewState.roots);
                ServiceViewContributor<?> contributor = serviceState == null ? null : contributors.get(serviceState.contributor);
                return contributor == null ? null : new ContributorModel(model2, modelFilter, contributor, parentFilter);
            }
            case "group": {
                ServiceViewContributor<?> contributor;
                ServiceViewState.ServiceState serviceState = ContainerUtil.getOnlyItem(viewState.roots);
                ServiceViewContributor<?> serviceViewContributor = contributor = serviceState == null ? null : contributors.get(serviceState.contributor);
                if (contributor == null) {
                    return null;
                }
                ServiceModel.ServiceViewItem groupItem = model2.findItemById(serviceState.path, contributor);
                if (!(groupItem instanceof ServiceModel.ServiceGroupNode)) {
                    return null;
                }
                AtomicReference<ServiceModel.ServiceGroupNode> ref = new AtomicReference<ServiceModel.ServiceGroupNode>((ServiceModel.ServiceGroupNode)groupItem);
                return new GroupModel(model2, modelFilter, ref, parentFilter);
            }
            case "service": {
                ServiceViewContributor<?> contributor;
                ServiceViewState.ServiceState serviceState = ContainerUtil.getOnlyItem(viewState.roots);
                ServiceViewContributor<?> serviceViewContributor = contributor = serviceState == null ? null : contributors.get(serviceState.contributor);
                if (contributor == null) {
                    return null;
                }
                ServiceModel.ServiceViewItem serviceItem = model2.findItemById(serviceState.path, contributor);
                if (serviceItem == null) {
                    return null;
                }
                if (serviceItem.getChildren().isEmpty()) {
                    AtomicReference<ServiceModel.ServiceViewItem> ref = new AtomicReference<ServiceModel.ServiceViewItem>(serviceItem);
                    return new SingeServiceModel(model2, modelFilter, ref, parentFilter);
                }
                new ServiceListModel(model2, modelFilter, new SmartList<ServiceModel.ServiceViewItem>(serviceItem), parentFilter);
            }
            case "services": {
                ArrayList<ServiceModel.ServiceViewItem> items2 = new ArrayList<ServiceModel.ServiceViewItem>();
                for (ServiceViewState.ServiceState serviceState : viewState.roots) {
                    ServiceViewContributor<?> contributor = contributors.get(serviceState.contributor);
                    if (contributor == null) continue;
                    ContainerUtil.addIfNotNull(items2, model2.findItemById(serviceState.path, contributor));
                }
                return items2.isEmpty() ? null : new ServiceListModel(model2, modelFilter, items2, parentFilter);
            }
        }
        return null;
    }

    @Nullable
    protected static ServiceModel.ServiceViewItem findItem(ServiceModel.ServiceViewItem viewItem, List<? extends ServiceModel.ServiceViewItem> modelItems) {
        return ServiceViewModel.findItem(ServiceViewModel.getPath(viewItem), modelItems);
    }

    @Nullable
    private static ServiceModel.ServiceViewItem findItem(Deque<ServiceModel.ServiceViewItem> path2, List<? extends ServiceModel.ServiceViewItem> modelItems) {
        ServiceModel.ServiceViewItem node2 = path2.removeFirst();
        for (ServiceModel.ServiceViewItem serviceViewItem : modelItems) {
            if (!serviceViewItem.equals(node2)) continue;
            if (path2.isEmpty()) {
                return serviceViewItem;
            }
            return ServiceViewModel.findItem(path2, serviceViewItem.getChildren());
        }
        return null;
    }

    protected static Deque<ServiceModel.ServiceViewItem> getPath(ServiceModel.ServiceViewItem item) {
        LinkedList<ServiceModel.ServiceViewItem> path2 = new LinkedList<ServiceModel.ServiceViewItem>();
        do {
            path2.addFirst(item);
        } while ((item = item.getParent()) != null);
        return path2;
    }

    @Nullable
    private static List<String> getIdPath(@Nullable ServiceModel.ServiceViewItem item) {
        ArrayList<String> path2 = new ArrayList<String>();
        while (item != null) {
            String id = item.getViewDescriptor().getId();
            if (id == null) {
                return null;
            }
            path2.add(id);
            item = item.getParent();
        }
        Collections.reverse(path2);
        return path2;
    }

    @Nullable
    private static ServiceViewState.ServiceState getState(@Nullable ServiceModel.ServiceViewItem item) {
        if (item == null) {
            return null;
        }
        List<String> path2 = ServiceViewModel.getIdPath(item);
        if (path2 == null) {
            return null;
        }
        ServiceViewState.ServiceState serviceState = new ServiceViewState.ServiceState();
        serviceState.contributor = item.getRootContributor().getClass().getName();
        serviceState.path = path2;
        return serviceState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 11, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceViewModel";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewState";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceViewModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "processGroups";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findItemSafe";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addModelListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeModelListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processGroups";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyGroups";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadModel";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 6, 11, 13, 15 -> new IllegalStateException(string2);
        };
    }

    static interface ServiceViewModelListener {
        default public void eventProcessed(@NotNull ServiceEventListener.ServiceEvent e) {
            if (e == null) {
                ServiceViewModelListener.$$$reportNull$$$0(0);
            }
            this.structureChanged();
        }

        public void structureChanged();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/services/ServiceViewModel$ServiceViewModelListener", "eventProcessed"));
        }
    }

    static class ContributorModel
    extends ServiceViewModel {
        private static final String TYPE = "contributor";
        private final ServiceViewContributor<?> myContributor;

        ContributorModel(@NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, final @NotNull ServiceViewContributor<?> contributor, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            if (model2 == null) {
                ContributorModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                ContributorModel.$$$reportNull$$$0(1);
            }
            if (contributor == null) {
                ContributorModel.$$$reportNull$$$0(2);
            }
            super(model2, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                @Override
                public boolean value(ServiceModel.ServiceViewItem item) {
                    return contributor.equals(item.getContributor());
                }
            });
            this.myContributor = contributor;
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            List<? extends ServiceModel.ServiceViewItem> list2 = this.myModelFilter.filter(ContainerUtil.filter(this.myModel.getRoots(), this.getFilter()), this.getFilter());
            if (list2 == null) {
                ContributorModel.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            if (e.contributorClass.isInstance(this.myContributor)) {
                this.notifyListeners(e);
            }
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            ServiceViewState.ServiceState serviceState = new ServiceViewState.ServiceState();
            serviceState.contributor = this.myContributor.getClass().getName();
            viewState.roots = new SmartList<ServiceViewState.ServiceState>(serviceState);
        }

        ServiceViewContributor<?> getContributor() {
            return this.myContributor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = TYPE;
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceViewModel$ContributorModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceViewModel$ContributorModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }

    static class GroupModel
    extends ServiceViewModel {
        private static final String TYPE = "group";
        private final AtomicReference<ServiceModel.ServiceGroupNode> myGroupRef;

        GroupModel(@NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, final @NotNull AtomicReference<ServiceModel.ServiceGroupNode> groupRef, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            if (model2 == null) {
                GroupModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                GroupModel.$$$reportNull$$$0(1);
            }
            if (groupRef == null) {
                GroupModel.$$$reportNull$$$0(2);
            }
            super(model2, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                @Override
                public boolean value(ServiceModel.ServiceViewItem item) {
                    ServiceModel.ServiceGroupNode group2 = (ServiceModel.ServiceGroupNode)groupRef.get();
                    ServiceModel.ServiceViewItem parent2 = item.getParent();
                    return parent2 != null && group2 != null && ServiceViewModel.getPath(parent2).equals(ServiceViewModel.getPath(group2));
                }
            });
            this.myGroupRef = groupRef;
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            ServiceModel.ServiceGroupNode group2 = this.myGroupRef.get();
            List<Object> list2 = group2 == null ? Collections.emptyList() : this.getChildren(group2, false);
            if (list2 == null) {
                GroupModel.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            ServiceModel.ServiceGroupNode group2 = this.myGroupRef.get();
            if (group2 == null || !e.contributorClass.isInstance(group2.getRootContributor())) {
                return;
            }
            this.myGroupRef.set((ServiceModel.ServiceGroupNode)GroupModel.findItem(group2, this.myModel.getRoots()));
            this.notifyListeners(e);
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            ContainerUtil.addIfNotNull(viewState.roots, ServiceViewModel.getState(this.myGroupRef.get()));
        }

        ServiceModel.ServiceGroupNode getGroup() {
            return this.myGroupRef.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupRef";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceViewModel$GroupModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceViewModel$GroupModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }

    static class SingeServiceModel
    extends ServiceViewModel {
        private static final String TYPE = "service";
        private final AtomicReference<ServiceModel.ServiceViewItem> myServiceRef;

        SingeServiceModel(@NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, final @NotNull AtomicReference<ServiceModel.ServiceViewItem> serviceRef, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            if (model2 == null) {
                SingeServiceModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                SingeServiceModel.$$$reportNull$$$0(1);
            }
            if (serviceRef == null) {
                SingeServiceModel.$$$reportNull$$$0(2);
            }
            super(model2, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                @Override
                public boolean value(ServiceModel.ServiceViewItem item) {
                    return item.equals(serviceRef.get());
                }
            });
            this.myServiceRef = serviceRef;
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            ServiceModel.ServiceViewItem service2 = this.myServiceRef.get();
            List<Object> list2 = service2 == null ? Collections.emptyList() : Collections.singletonList(service2);
            if (list2 == null) {
                SingeServiceModel.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            ServiceModel.ServiceViewItem service2 = this.myServiceRef.get();
            if (service2 == null || !e.contributorClass.isInstance(service2.getRootContributor())) {
                return;
            }
            this.myServiceRef.set(this.findItemSafe(service2));
            this.notifyListeners(e);
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            ContainerUtil.addIfNotNull(viewState.roots, ServiceViewModel.getState(this.myServiceRef.get()));
        }

        ServiceModel.ServiceViewItem getService() {
            return this.myServiceRef.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceRef";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceViewModel$SingeServiceModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceViewModel$SingeServiceModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }

    static class ServiceListModel
    extends ServiceViewModel {
        private static final String TYPE = "services";
        private final List<ServiceModel.ServiceViewItem> myRoots;

        ServiceListModel(@NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, final @NotNull List<ServiceModel.ServiceViewItem> roots2, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            if (model2 == null) {
                ServiceListModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                ServiceListModel.$$$reportNull$$$0(1);
            }
            if (roots2 == null) {
                ServiceListModel.$$$reportNull$$$0(2);
            }
            super(model2, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                @Override
                public boolean value(ServiceModel.ServiceViewItem item) {
                    return roots2.contains(item);
                }
            });
            this.myRoots = new CopyOnWriteArrayList<ServiceModel.ServiceViewItem>(roots2);
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            List<? extends ServiceModel.ServiceViewItem> list2 = this.myModelFilter.filter(this.myRoots, this.getFilter());
            if (list2 == null) {
                ServiceListModel.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            boolean update2 = false;
            ArrayList<ServiceModel.ServiceViewItem> toRemove2 = new ArrayList<ServiceModel.ServiceViewItem>();
            for (int i2 = 0; i2 < this.myRoots.size(); ++i2) {
                ServiceModel.ServiceViewItem node2 = this.myRoots.get(i2);
                if (!e.contributorClass.isInstance(node2.getRootContributor())) continue;
                ServiceModel.ServiceViewItem updatedNode = this.findItemSafe(node2);
                if (updatedNode != null) {
                    this.myRoots.remove(i2);
                    this.myRoots.add(i2, updatedNode);
                } else {
                    toRemove2.add(node2);
                }
                update2 = true;
            }
            this.myRoots.removeAll(toRemove2);
            if (update2) {
                this.notifyListeners(e);
            }
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            for (ServiceModel.ServiceViewItem root : this.myRoots) {
                ContainerUtil.addIfNotNull(viewState.roots, ServiceViewModel.getState(root));
            }
        }

        List<ServiceModel.ServiceViewItem> getItems() {
            return this.myRoots;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceViewModel$ServiceListModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceViewModel$ServiceListModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }

    static class AllServicesModel
    extends ServiceViewModel {
        AllServicesModel(@NotNull ServiceModel model2, @NotNull ServiceModelFilter modelFilter, final @NotNull Collection<ServiceViewContributor<?>> contributors) {
            if (model2 == null) {
                AllServicesModel.$$$reportNull$$$0(0);
            }
            if (modelFilter == null) {
                AllServicesModel.$$$reportNull$$$0(1);
            }
            if (contributors == null) {
                AllServicesModel.$$$reportNull$$$0(2);
            }
            super(model2, modelFilter, new ServiceModelFilter.ServiceViewFilter(null){

                @Override
                public boolean value(ServiceModel.ServiceViewItem item) {
                    return contributors.contains(item.getRootContributor());
                }
            });
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            List<? extends ServiceModel.ServiceViewItem> list2 = this.myModelFilter.filter(ContainerUtil.filter(this.myModel.getRoots(), this.getFilter()), this.getFilter());
            if (list2 == null) {
                AllServicesModel.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            this.notifyListeners(e);
        }

        @Override
        public void initRootsIfNeeded() {
            this.myModel.initRoots();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributors";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceViewModel$AllServicesModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceViewModel$AllServicesModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }
}

