/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class CloseAction
extends AnAction
implements DumbAware {
    private RunContentDescriptor myContentDescriptor;
    private final Project myProject;
    private Executor myExecutor;

    public CloseAction(Executor executor, RunContentDescriptor contentDescriptor, Project project2) {
        this.myExecutor = executor;
        this.myContentDescriptor = contentDescriptor;
        this.myProject = project2;
        ActionUtil.copyFrom((AnAction)this, (String)"CloseContent");
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setIcon(AllIcons.Actions.Cancel);
        templatePresentation.setText(ExecutionBundle.messagePointer((String)"close.tab.action.name", (Object[])new Object[0]));
        templatePresentation.setDescription(Presentation.NULL_STRING);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CloseAction.$$$reportNull$$$0(0);
        }
        this.perform();
    }

    public void perform() {
        RunContentDescriptor contentDescriptor = this.getContentDescriptor();
        if (contentDescriptor == null) {
            return;
        }
        boolean removedOk = RunContentManager.getInstance((Project)this.myProject).removeRunContent(this.getExecutor(), contentDescriptor);
        if (removedOk) {
            this.myContentDescriptor = null;
            this.myExecutor = null;
        }
    }

    public RunContentDescriptor getContentDescriptor() {
        return this.myContentDescriptor;
    }

    public Executor getExecutor() {
        return this.myExecutor;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CloseAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(this.myContentDescriptor != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            CloseAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/actions/CloseAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/actions/CloseAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

