/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.content.Content;
import java.util.ArrayList;

public interface CellTransform {

    public static interface Facade {
        public void minimize(Content var1, Restore var2);
    }

    public static interface Restore {
        public ActionCallback restoreInGrid();

        public static class List
        implements Restore {
            private final ArrayList<Restore> myActions = new ArrayList();
            private boolean myRestoringNow;

            public void add(Restore restore) {
                this.myActions.add(restore);
            }

            @Override
            public ActionCallback restoreInGrid() {
                this.myRestoringNow = true;
                if (this.myActions.size() == 0) {
                    return ActionCallback.DONE;
                }
                ActionCallback topCallback = this.restore(0);
                return topCallback.doWhenDone(() -> {
                    this.myActions.clear();
                    this.myRestoringNow = false;
                });
            }

            private ActionCallback restore(int index2) {
                ActionCallback result2 = new ActionCallback();
                Restore action2 = this.myActions.get(index2);
                ActionCallback actionCalback = action2.restoreInGrid();
                actionCalback.doWhenDone(() -> {
                    if (index2 < this.myActions.size() - 1) {
                        this.restore(index2 + 1).notifyWhenDone(result2);
                    } else {
                        result2.setDone();
                    }
                });
                return result2;
            }

            public boolean isRestoringNow() {
                return this.myRestoringNow;
            }
        }
    }
}

