/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.execution.util.StringWithNewLinesCellEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvVariablesTable
extends ListTableWithButtons<EnvironmentVariable> {
    private CopyPasteProviderPanel myPanel;
    private boolean myPasteEnabled = false;

    public EnvVariablesTable() {
        AnAction pasteAction;
        this.getTableView().getEmptyText().setText(ExecutionBundle.message((String)"empty.text.no.variables", (Object[])new Object[0]));
        AnAction copyAction = ActionManager.getInstance().getAction("$Copy");
        if (copyAction != null) {
            copyAction.registerCustomShortcutSet(copyAction.getShortcutSet(), this.getTableView());
        }
        if ((pasteAction = ActionManager.getInstance().getAction("$Paste")) != null) {
            pasteAction.registerCustomShortcutSet(pasteAction.getShortcutSet(), this.getTableView());
        }
    }

    public void setPasteActionEnabled(boolean enabled) {
        this.myPasteEnabled = enabled;
    }

    @Override
    protected ListTableModel createListModel() {
        return new ListTableModel(new ColumnInfo[]{new NameColumnInfo(), new ValueColumnInfo()});
    }

    public void editVariableName(EnvironmentVariable environmentVariable) {
        ApplicationManager.getApplication().invokeLater(() -> {
            EnvironmentVariable actualEnvVar = (EnvironmentVariable)((Object)ContainerUtil.find(this.getElements(), item -> StringUtil.equals(environmentVariable.getName(), item.getName())));
            if (actualEnvVar == null) {
                return;
            }
            this.setSelection(actualEnvVar);
            if (actualEnvVar.getNameIsWriteable()) {
                this.editSelection(0);
            }
        });
    }

    @Override
    public void setValues(List<? extends EnvironmentVariable> list2) {
        list2.sort(Comparator.comparing(EnvironmentVariable::getName, NaturalComparator.INSTANCE));
        super.setValues(list2);
    }

    public List<EnvironmentVariable> getEnvironmentVariables() {
        return this.getElements();
    }

    @Override
    public JComponent getComponent() {
        if (this.myPanel == null) {
            this.myPanel = new CopyPasteProviderPanel(super.getComponent());
        }
        return this.myPanel;
    }

    @Override
    protected EnvironmentVariable createElement() {
        return new EnvironmentVariable("", "", false);
    }

    @Override
    protected boolean isEmpty(EnvironmentVariable element) {
        return element.getName().isEmpty() && element.getValue().isEmpty();
    }

    @Override
    protected EnvironmentVariable cloneElement(EnvironmentVariable envVariable) {
        return envVariable.clone();
    }

    @Override
    protected boolean canDeleteElement(EnvironmentVariable selection) {
        return !selection.getIsPredefined();
    }

    @Override
    protected AnActionButton @NotNull [] createExtraActions() {
        AnActionButton copyButton = new AnActionButton(ActionsBundle.message((String)"action.EditorCopy.text", (Object[])new Object[0]), AllIcons.Actions.Copy){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                EnvVariablesTable.this.myPanel.performCopy(e.getDataContext());
            }

            public boolean isEnabled() {
                return EnvVariablesTable.this.myPanel.isCopyEnabled(DataContext.EMPTY_CONTEXT);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/execution/util/EnvVariablesTable$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/execution/util/EnvVariablesTable$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        };
        AnActionButton pasteButton = new AnActionButton(ActionsBundle.message((String)"action.EditorPaste.text", (Object[])new Object[0]), AllIcons.Actions.MenuPaste){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                EnvVariablesTable.this.myPanel.performPaste(e.getDataContext());
            }

            public boolean isEnabled() {
                return EnvVariablesTable.this.myPanel.isPasteEnabled(DataContext.EMPTY_CONTEXT);
            }

            public boolean isVisible() {
                return EnvVariablesTable.this.myPanel.isPastePossible(DataContext.EMPTY_CONTEXT);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/execution/util/EnvVariablesTable$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/execution/util/EnvVariablesTable$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        };
        AnActionButton[] anActionButtonArray = new AnActionButton[]{copyButton, pasteButton};
        if (anActionButtonArray == null) {
            EnvVariablesTable.$$$reportNull$$$0(0);
        }
        return anActionButtonArray;
    }

    @NotNull
    public static Map<String, String> parseEnvsFromText(String content2) {
        LinkedHashMap<String, String> result2 = new LinkedHashMap<String, String>();
        if (content2 != null && content2.contains("=")) {
            List<String> pairs;
            boolean legacyFormat = content2.contains("\n");
            if (legacyFormat) {
                pairs = StringUtil.split(content2, "\n");
            } else {
                pairs = new ArrayList<String>();
                int start = 0;
                int end = content2.indexOf(";");
                while (end < content2.length()) {
                    if (end == -1) {
                        pairs.add(content2.substring(start).replace("\\;", ";"));
                        break;
                    }
                    if (end > 0 && content2.charAt(end - 1) != '\\') {
                        pairs.add(content2.substring(start, end).replace("\\;", ";"));
                        start = end + 1;
                    }
                    end = content2.indexOf(";", end + 1);
                }
            }
            for (String pair : pairs) {
                int pos = pair.indexOf(61);
                if (pos <= 0) continue;
                while (pos > 0 && pair.charAt(pos - 1) == '\\') {
                    pos = pair.indexOf(61, pos + 1);
                }
                if (pos <= 0) continue;
                pair = pair.replaceAll("[\\\\]", "\\\\\\\\");
                result2.put(StringUtil.unescapeStringCharacters(pair.substring(0, pos)).trim(), StringUtil.unescapeStringCharacters(pair.substring(pos + 1)));
            }
        }
        LinkedHashMap<String, String> linkedHashMap = result2;
        if (linkedHashMap == null) {
            EnvVariablesTable.$$$reportNull$$$0(1);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/util/EnvVariablesTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtraActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEnvsFromText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    protected class NameColumnInfo
    extends ListTableWithButtons.ElementsColumnInfoBase<EnvironmentVariable> {
        public NameColumnInfo() {
            super(ExecutionBundle.message((String)"env.variable.column.name.title", (Object[])new Object[0]));
        }

        public String valueOf(EnvironmentVariable environmentVariable) {
            return environmentVariable.getName();
        }

        public boolean isCellEditable(EnvironmentVariable environmentVariable) {
            return environmentVariable.getNameIsWriteable();
        }

        public void setValue(EnvironmentVariable environmentVariable, String s) {
            if (s.equals(this.valueOf(environmentVariable))) {
                return;
            }
            environmentVariable.setName(s);
            EnvVariablesTable.this.setModified();
        }

        @Override
        protected String getDescription(EnvironmentVariable environmentVariable) {
            return environmentVariable.getDescription();
        }

        @NotNull
        public TableCellEditor getEditor(EnvironmentVariable variable) {
            return new DefaultCellEditor(new JTextField());
        }
    }

    protected class ValueColumnInfo
    extends ListTableWithButtons.ElementsColumnInfoBase<EnvironmentVariable> {
        public ValueColumnInfo() {
            super(ExecutionBundle.message((String)"env.variable.column.value.title", (Object[])new Object[0]));
        }

        public String valueOf(EnvironmentVariable environmentVariable) {
            return environmentVariable.getValue();
        }

        public boolean isCellEditable(EnvironmentVariable environmentVariable) {
            return !environmentVariable.getIsPredefined();
        }

        public void setValue(EnvironmentVariable environmentVariable, String s) {
            if (s.equals(this.valueOf(environmentVariable))) {
                return;
            }
            environmentVariable.setValue(s);
            EnvVariablesTable.this.setModified();
        }

        @Override
        @Nullable
        protected String getDescription(EnvironmentVariable environmentVariable) {
            return environmentVariable.getDescription();
        }

        @NotNull
        public TableCellEditor getEditor(EnvironmentVariable variable) {
            return new StringWithNewLinesCellEditor();
        }
    }

    private final class CopyPasteProviderPanel
    extends JPanel
    implements DataProvider,
    CopyProvider,
    PasteProvider {
        CopyPasteProviderPanel(JComponent component2) {
            super(new GridLayout(1, 1));
            this.add(component2);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(1);
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
                return this;
            }
            return null;
        }

        public void performCopy(@NotNull DataContext dataContext2) {
            TableView view;
            if (dataContext2 == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(2);
            }
            if ((view = EnvVariablesTable.this.getTableView()).isEditing()) {
                int row = view.getEditingRow();
                int column = view.getEditingColumn();
                if (row < 0 || column < 0) {
                    row = view.getSelectedRow();
                    column = view.getSelectedColumn();
                }
                if (row >= 0 && column >= 0) {
                    Component component2 = ((DefaultCellEditor)view.getCellEditor()).getComponent();
                    String text2 = "";
                    if (component2 instanceof JTextField) {
                        text2 = ((JTextField)component2).getSelectedText();
                    } else if (component2 instanceof JComboBox) {
                        text2 = ((JTextField)((JComboBox)component2).getEditor().getEditorComponent()).getSelectedText();
                    } else {
                        Logger.getInstance(EnvVariablesTable.class).error("Unknown editor type: " + component2);
                    }
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text2));
                }
                return;
            }
            EnvVariablesTable.this.stopEditing();
            StringBuilder sb = new StringBuilder();
            List variables = EnvVariablesTable.this.getSelection();
            for (EnvironmentVariable environmentVariable : variables) {
                if (EnvVariablesTable.this.isEmpty(environmentVariable)) continue;
                if (sb.length() > 0) {
                    sb.append(';');
                }
                sb.append(StringUtil.escapeChars(environmentVariable.getName(), '=', ';')).append('=').append(StringUtil.escapeChars(environmentVariable.getValue(), '=', ';'));
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb.toString()));
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext2) {
            if (dataContext2 == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(3);
            }
            return !EnvVariablesTable.this.getSelection().isEmpty();
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext2) {
            if (dataContext2 == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(4);
            }
            return this.isCopyEnabled(dataContext2);
        }

        public void performPaste(@NotNull DataContext dataContext2) {
            String content2;
            if (dataContext2 == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(5);
            }
            if (StringUtil.isEmpty(content2 = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor))) {
                return;
            }
            Map<String, String> map2 = EnvVariablesTable.parseEnvsFromText(content2);
            TableView view = EnvVariablesTable.this.getTableView();
            if (view.isEditing() || map2.isEmpty()) {
                Component component2;
                TableCellEditor editor2;
                int row = view.getEditingRow();
                int column = view.getEditingColumn();
                if (row < 0 || column < 0) {
                    row = view.getSelectedRow();
                    column = view.getSelectedColumn();
                }
                if (row >= 0 && column >= 0 && (editor2 = view.getCellEditor()) != null && (component2 = ((DefaultCellEditor)editor2).getComponent()) instanceof JTextField) {
                    ((JTextField)component2).paste();
                }
                return;
            }
            EnvVariablesTable.this.stopEditing();
            ArrayList<EnvironmentVariable> parsed = new ArrayList<EnvironmentVariable>();
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                parsed.add(new EnvironmentVariable(entry.getKey(), entry.getValue(), false));
            }
            List<EnvironmentVariable> variables = new ArrayList<EnvironmentVariable>(EnvVariablesTable.this.getEnvironmentVariables());
            variables.addAll(parsed);
            variables = ContainerUtil.filter(variables, variable -> !StringUtil.isEmpty(variable.getName()) || !StringUtil.isEmpty(variable.getValue()));
            EnvVariablesTable.this.setValues((List<? extends EnvironmentVariable>)variables);
        }

        public boolean isPastePossible(@NotNull DataContext dataContext2) {
            if (dataContext2 == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(6);
            }
            return EnvVariablesTable.this.myPasteEnabled;
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext2) {
            if (dataContext2 == null) {
                CopyPasteProviderPanel.$$$reportNull$$$0(7);
            }
            return EnvVariablesTable.this.myPasteEnabled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/util/EnvVariablesTable$CopyPasteProviderPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/util/EnvVariablesTable$CopyPasteProviderPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "performCopy";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isCopyEnabled";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isCopyVisible";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "performPaste";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isPastePossible";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isPasteEnabled";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string2);
            };
        }
    }
}

