/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.impl.FacetEventsPublisher;
import com.intellij.facet.impl.FacetLoadingErrorDescription;
import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.invalid.InvalidFacetConfiguration;
import com.intellij.facet.impl.invalid.InvalidFacetManager;
import com.intellij.facet.impl.invalid.InvalidFacetType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@ApiStatus.Internal
public abstract class FacetManagerBase
extends FacetManager {
    private static final Logger LOG = Logger.getInstance(FacetManagerBase.class);
    public static final String FEATURE_TYPE = "com.intellij.facetType";

    @NotNull
    public <F extends Facet<?>, C extends FacetConfiguration> F createFacet(@NotNull FacetType<F, C> type, @NotNull String name, @NotNull C configuration, @Nullable Facet<?> underlying) {
        if (type == null) {
            FacetManagerBase.$$$reportNull$$$0(0);
        }
        if (name == null) {
            FacetManagerBase.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            FacetManagerBase.$$$reportNull$$$0(2);
        }
        return FacetManagerBase.createFacet(this.getModule(), type, name, configuration, underlying);
    }

    @ApiStatus.Internal
    public static void setFacetName(Facet<?> facet, String newName2) {
        facet.setName(newName2);
    }

    @NotNull
    protected static <F extends Facet<?>, C extends FacetConfiguration> F createFacet(@NotNull Module module2, @NotNull FacetType<F, C> type, @NotNull String name, @NotNull C configuration, @Nullable Facet<?> underlying) {
        Facet facet;
        if (module2 == null) {
            FacetManagerBase.$$$reportNull$$$0(3);
        }
        if (type == null) {
            FacetManagerBase.$$$reportNull$$$0(4);
        }
        if (name == null) {
            FacetManagerBase.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            FacetManagerBase.$$$reportNull$$$0(6);
        }
        FacetManagerBase.assertTrue((facet = type.createFacet(module2, name, configuration, underlying)).getModule() == module2, facet, "module");
        FacetManagerBase.assertTrue(facet.getConfiguration() == configuration, facet, "configuration");
        FacetManagerBase.assertTrue(Objects.equals(facet.getName(), name), facet, "name");
        FacetManagerBase.assertTrue(facet.getUnderlyingFacet() == underlying, facet, "underlyingFacet");
        Facet facet2 = facet;
        if (facet2 == null) {
            FacetManagerBase.$$$reportNull$$$0(7);
        }
        return (F)facet2;
    }

    @NotNull
    public <F extends Facet<?>, C extends FacetConfiguration> F createFacet(@NotNull FacetType<F, C> type, @NotNull String name, @Nullable Facet<?> underlying) {
        if (type == null) {
            FacetManagerBase.$$$reportNull$$$0(8);
        }
        if (name == null) {
            FacetManagerBase.$$$reportNull$$$0(9);
        }
        C configuration = ProjectFacetManager.getInstance(this.getModule().getProject()).createDefaultConfiguration(type);
        F f = this.createFacet(type, name, configuration, underlying);
        if (f == null) {
            FacetManagerBase.$$$reportNull$$$0(10);
        }
        return f;
    }

    @NotNull
    public <F extends Facet<?>, C extends FacetConfiguration> F addFacet(@NotNull FacetType<F, C> type, @NotNull String name, @Nullable Facet<?> underlying) {
        if (type == null) {
            FacetManagerBase.$$$reportNull$$$0(11);
        }
        if (name == null) {
            FacetManagerBase.$$$reportNull$$$0(12);
        }
        ModifiableFacetModel model2 = this.createModifiableModel();
        F facet = this.createFacet(type, name, underlying);
        model2.addFacet(facet);
        model2.commit();
        F f = facet;
        if (f == null) {
            FacetManagerBase.$$$reportNull$$$0(13);
        }
        return f;
    }

    public void facetConfigurationChanged(@NotNull Facet<?> facet) {
        if (facet == null) {
            FacetManagerBase.$$$reportNull$$$0(14);
        }
        FacetEventsPublisher.getInstance(facet.getModule().getProject()).fireFacetConfigurationChanged(facet);
    }

    public Facet<?> @NotNull [] getAllFacets() {
        Facet[] facetArray = this.getModel().getAllFacets();
        if (facetArray == null) {
            FacetManagerBase.$$$reportNull$$$0(15);
        }
        return facetArray;
    }

    @Nullable
    public <F extends Facet<?>> F getFacetByType(FacetTypeId<F> typeId) {
        return (F)this.getModel().getFacetByType(typeId);
    }

    protected abstract FacetModel getModel();

    @Nullable
    public <F extends Facet<?>> F findFacet(FacetTypeId<F> type, String name) {
        return (F)this.getModel().findFacet(type, name);
    }

    @Nullable
    public <F extends Facet<?>> F getFacetByType(@NotNull Facet<?> underlyingFacet, FacetTypeId<F> typeId) {
        if (underlyingFacet == null) {
            FacetManagerBase.$$$reportNull$$$0(16);
        }
        return (F)this.getModel().getFacetByType(underlyingFacet, typeId);
    }

    @NotNull
    public <F extends Facet<?>> Collection<F> getFacetsByType(@NotNull Facet<?> underlyingFacet, FacetTypeId<F> typeId) {
        if (underlyingFacet == null) {
            FacetManagerBase.$$$reportNull$$$0(17);
        }
        Collection collection = this.getModel().getFacetsByType(underlyingFacet, typeId);
        if (collection == null) {
            FacetManagerBase.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @NotNull
    public <F extends Facet<?>> Collection<F> getFacetsByType(FacetTypeId<F> typeId) {
        Collection collection = this.getModel().getFacetsByType(typeId);
        if (collection == null) {
            FacetManagerBase.$$$reportNull$$$0(19);
        }
        return collection;
    }

    public Facet<?> @NotNull [] getSortedFacets() {
        Facet[] facetArray = this.getModel().getSortedFacets();
        if (facetArray == null) {
            FacetManagerBase.$$$reportNull$$$0(20);
        }
        return facetArray;
    }

    @NotNull
    public String getFacetName(@NotNull Facet<?> facet) {
        if (facet == null) {
            FacetManagerBase.$$$reportNull$$$0(21);
        }
        String string2 = this.getModel().getFacetName(facet);
        if (string2 == null) {
            FacetManagerBase.$$$reportNull$$$0(22);
        }
        return string2;
    }

    protected abstract Module getModule();

    @ApiStatus.Internal
    @NotNull
    public static InvalidFacet createInvalidFacet(@NotNull Module module2, @NotNull FacetState state, @Nullable Facet<?> underlyingFacet, @NotNull @NlsContexts.DialogMessage String errorMessage, boolean unknownType, boolean reportError) {
        InvalidFacetManager invalidFacetManager;
        if (module2 == null) {
            FacetManagerBase.$$$reportNull$$$0(23);
        }
        if (state == null) {
            FacetManagerBase.$$$reportNull$$$0(24);
        }
        if (errorMessage == null) {
            FacetManagerBase.$$$reportNull$$$0(25);
        }
        Project project2 = module2.getProject();
        InvalidFacetType type = InvalidFacetType.getInstance();
        InvalidFacetConfiguration configuration = new InvalidFacetConfiguration(state, errorMessage);
        InvalidFacet facet = FacetManagerBase.createFacet(module2, type, StringUtil.notNullize(state.getName()), configuration, underlyingFacet);
        if (reportError && !(invalidFacetManager = InvalidFacetManager.getInstance(project2)).isIgnored(facet)) {
            FacetLoadingErrorDescription description = new FacetLoadingErrorDescription(facet);
            ProjectLoadingErrorsNotifier.getInstance(project2).registerError(description);
            if (unknownType) {
                UnknownFeaturesCollector.getInstance((Project)project2).registerUnknownFeature(new UnknownFeature(description.getErrorType().getFeatureType(), ProjectBundle.message((String)"plugins.advertiser.feature.facet", (Object[])new Object[0]), state.getFacetType()));
            }
        }
        InvalidFacet invalidFacet = facet;
        if (invalidFacet == null) {
            FacetManagerBase.$$$reportNull$$$0(26);
        }
        return invalidFacet;
    }

    private static void assertTrue(boolean value, Facet<?> facet, String parameter) {
        if (!value) {
            LOG.error("Facet type " + facet.getType().getClass().getName() + " violates the contract of FacetType.createFacet method about '" + parameter + "' parameter");
        }
    }

    @TestOnly
    public void checkConsistency() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 13, 15, 18, 19, 20, 22, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/FacetManagerBase";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingFacet";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/FacetManagerBase";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacet";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addFacet";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFacets";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetsByType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedFacets";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createInvalidFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFacet";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 26: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addFacet";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "facetConfigurationChanged";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFacetByType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFacetsByType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFacetName";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createInvalidFacet";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 10, 13, 15, 18, 19, 20, 22, 26 -> new IllegalStateException(string2);
        };
    }
}

