/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.invalid.InvalidFacetManager;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ConfigurationErrorType;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class FacetLoadingErrorDescription
extends ConfigurationErrorDescription {
    private final InvalidFacet myFacet;

    public FacetLoadingErrorDescription(InvalidFacet facet) {
        super(facet.getName() + " (" + facet.getModule().getName() + ")", facet.getErrorMessage());
        this.myFacet = facet;
    }

    @Override
    @NotNull
    public String getIgnoreConfirmationMessage() {
        String string2 = ProjectBundle.message((String)"confirmation.message.would.you.like.to.ignore.facet", (Object[])new Object[]{this.myFacet.getName(), this.myFacet.getModule().getName()});
        if (string2 == null) {
            FacetLoadingErrorDescription.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    public void ignoreInvalidElement() {
        InvalidFacetManager.getInstance(this.myFacet.getModule().getProject()).setIgnored(this.myFacet, true);
    }

    @Override
    public boolean isValid() {
        return !this.myFacet.isDisposed();
    }

    @Override
    @NonNls
    @NotNull
    public String getImplementationName() {
        String string2 = this.myFacet.getName();
        if (string2 == null) {
            FacetLoadingErrorDescription.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    @NotNull
    public FacetErrorType getErrorType() {
        FacetErrorType facetErrorType = FacetErrorType.INSTANCE;
        if (facetErrorType == null) {
            FacetLoadingErrorDescription.$$$reportNull$$$0(2);
        }
        return facetErrorType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/facet/impl/FacetLoadingErrorDescription";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoreConfirmationMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementationName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static final class FacetErrorType
    extends ConfigurationErrorType {
        private static final FacetErrorType INSTANCE = new FacetErrorType();

        private FacetErrorType() {
            super(true);
        }

        @Override
        @NotNull
        public String getFeatureType() {
            return "com.intellij.facetType";
        }

        @Override
        @Nls
        @NotNull
        public String getErrorText(int errorCount, @NlsSafe String firstElementName) {
            String string2 = ProjectBundle.message((String)"facet.configuration.problem.text", (Object[])new Object[]{errorCount, firstElementName});
            if (string2 == null) {
                FacetErrorType.$$$reportNull$$$0(0);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetLoadingErrorDescription$FacetErrorType", "getErrorText"));
        }
    }
}

