/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerBase;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.invalid.InvalidFacetConfiguration;
import com.intellij.facet.impl.invalid.InvalidFacetManager;
import com.intellij.facet.impl.invalid.InvalidFacetType;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.workspaceModel.ide.impl.legacyBridge.facet.FacetManagerBridge;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\bH\u0002J@\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00140\b\"\u0010\b\u0000\u0010\u0013*\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010\u0015\"\n\b\u0001\u0010\u0014*\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0007H\u0016J\u001a\u0010\u0012\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\nH\u0016J\u0017\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010\u001c\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u001aH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001b\u0010\u001e\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u001aH\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001f\u001a\u00020\u000eH\u0002J \u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\bH\u0002J\u0018\u0010!\u001a\u00020\u000e2\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\bH\u0002J>\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00152 \u0010&\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150(0'H\u0002J:\u0010)\u001a\u0004\u0018\u00010*2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00152\"\u0010&\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150(0'H\u0002J\u0018\u0010+\u001a\u00020\u000e2\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/facet/impl/FacetTypeRegistryImpl;", "Lcom/intellij/facet/FacetTypeRegistry;", "()V", "myExtensionsLoaded", "", "myFacetTypes", "", "Lcom/intellij/facet/FacetTypeId;", "Lcom/intellij/facet/FacetType;", "myTypeIds", "", "myTypeRegistrationLock", "Ljava/lang/Object;", "convertFacetsToInvalid", "", "project", "Lcom/intellij/openapi/project/Project;", "facetType", "findFacetType", "F", "C", "Lcom/intellij/facet/Facet;", "Lcom/intellij/facet/FacetConfiguration;", "typeId", "id", "getFacetTypeIds", "", "()[Lcom/intellij/facet/FacetTypeId;", "getFacetTypes", "()[Lcom/intellij/facet/FacetType;", "getSortedFacetTypes", "loadExtensions", "loadInvalidFacetsOfType", "registerFacetType", "removeAllSubFacets", "model", "Lcom/intellij/facet/ModifiableFacetModel;", "facet", "subFacets", "", "", "saveFacetWithSubFacets", "Lorg/jetbrains/jps/model/serialization/facet/FacetState;", "unregisterFacetType", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nFacetTypeRegistryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetTypeRegistryImpl.kt\ncom/intellij/facet/impl/FacetTypeRegistryImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,181:1\n766#2:182\n857#2,2:183\n1620#2,3:185\n766#2:188\n857#2,2:189\n1620#2,3:193\n1611#2:211\n1855#2:212\n1856#2:214\n1612#2:215\n13579#3,2:191\n10783#3:196\n11008#3,3:197\n11011#3,3:207\n361#4,7:200\n1#5:210\n1#5:213\n37#6,2:216\n37#6,2:218\n*S KotlinDebug\n*F\n+ 1 FacetTypeRegistryImpl.kt\ncom/intellij/facet/impl/FacetTypeRegistryImpl\n*L\n40#1:182\n40#1:183,2\n41#1:185,3\n44#1:188\n44#1:189,2\n69#1:193,3\n102#1:211\n102#1:212\n102#1:214\n102#1:215\n63#1:191,2\n72#1:196\n72#1:197,3\n72#1:207,3\n72#1:200,7\n102#1:213\n109#1:216,2\n115#1:218,2\n*E\n"})
public final class FacetTypeRegistryImpl
extends FacetTypeRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, FacetTypeId<?>> myTypeIds = new HashMap();
    @NotNull
    private final Map<FacetTypeId<?>, FacetType<?, ?>> myFacetTypes = new HashMap();
    private volatile boolean myExtensionsLoaded;
    @NotNull
    private final Object myTypeRegistrationLock = new Object();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Comparator<FacetType<?, ?>> FACET_TYPE_COMPARATOR;

    private final synchronized void registerFacetType(FacetType<?, ?> facetType) {
        FacetTypeId facetTypeId = facetType.getId();
        Intrinsics.checkNotNullExpressionValue((Object)facetTypeId, (String)"facetType.id");
        FacetTypeId typeId = facetTypeId;
        String string2 = facetType.getStringId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"facetType.stringId");
        String id = string2;
        LOG.assertTrue(!StringsKt.contains$default((CharSequence)id, (CharSequence)"/", (boolean)false, (int)2, null), "Facet type id '" + id + "' contains illegal character '/'");
        LOG.assertTrue(!this.myFacetTypes.containsKey(typeId), "Facet type '" + id + "' is already registered");
        this.myFacetTypes.put(typeId, facetType);
        LOG.assertTrue(!this.myTypeIds.containsKey(id), "Facet type id '" + id + "' is already registered");
        this.myTypeIds.put(id, typeId);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadInvalidFacetsOfType(Project project2, FacetType<?, ?> facetType) {
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List<InvalidFacet> list2 = InvalidFacetManager.getInstance(project2).getInvalidFacets();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance(project).invalidFacets");
        Iterable iterable = list2;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            InvalidFacet it = (InvalidFacet)((Object)element$iv$iv);
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((InvalidFacetConfiguration)it.getConfiguration()).getFacetState().getFacetType(), (Object)facetType.getStringId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Object object = (InvalidFacet)((Object)item$iv);
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getModule());
        }
        HashSet modulesWithFacets = (HashSet)destination$iv;
        for (Module module2 : modulesWithFacets) {
            void $this$filterTo$iv$iv2;
            ModifiableFacetModel model2;
            Intrinsics.checkNotNullExpressionValue((Object)FacetManager.getInstance((Module)module2).createModifiableModel(), (String)"getInstance(module).createModifiableModel()");
            Collection collection = model2.getFacetsByType(InvalidFacetType.TYPE_ID);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"model.getFacetsByType(InvalidFacetType.TYPE_ID)");
            Iterable $this$filter$iv2 = collection;
            boolean $i$f$filter2 = false;
            Iterable bl = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                InvalidFacet it = (InvalidFacet)((Object)element$iv$iv);
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)((InvalidFacetConfiguration)it.getConfiguration()).getFacetState().getFacetType(), (Object)facetType.getStringId())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List invalidFacets = (List)destination$iv$iv2;
            for (InvalidFacet invalidFacet : invalidFacets) {
                Facet<?> newFacet = FacetUtil.createFacetFromStateRawJ(module2, facetType, invalidFacet);
                model2.replaceFacet((Facet)invalidFacet, newFacet);
                for (FacetState subFacet : ((InvalidFacetConfiguration)invalidFacet.getConfiguration()).getFacetState().subFacets) {
                    model2.addFacet((Facet)FacetManagerBase.createInvalidFacet(module2, subFacet, newFacet, ((InvalidFacetConfiguration)invalidFacet.getConfiguration()).getErrorMessage(), false, false));
                }
            }
            model2.commit();
        }
    }

    private final synchronized void unregisterFacetType(FacetType<?, ?> facetType) {
        FacetTypeId facetTypeId = facetType.getId();
        Intrinsics.checkNotNullExpressionValue((Object)facetTypeId, (String)"facetType.id");
        FacetTypeId id = facetTypeId;
        String string2 = facetType.getStringId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"facetType.stringId");
        String stringId = string2;
        LOG.assertTrue(this.myFacetTypes.remove(id) != null, "Facet type '" + stringId + "' is not registered");
        this.myFacetTypes.remove(id);
        this.myTypeIds.remove(stringId);
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getInstance().openProjects");
        Object[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project it = (Project)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.convertFacetsToInvalid(it, facetType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void convertFacetsToInvalid(Project project2, FacetType<?, ?> facetType) {
        void $this$mapTo$iv;
        List list2 = ProjectFacetManager.getInstance(project2).getFacets(facetType.getId());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance(project).getFacets(facetType.id)");
        Iterable iterable = list2;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Facet facet = (Facet)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getModule());
        }
        HashSet modulesWithFacets = (HashSet)destination$iv;
        for (Module module2 : modulesWithFacets) {
            Collection facets;
            void $this$groupByTo$iv$iv;
            ModifiableFacetModel model2;
            Intrinsics.checkNotNullExpressionValue((Object)FacetManager.getInstance((Module)module2).createModifiableModel(), (String)"getInstance(module).createModifiableModel()");
            Facet[] facetArray = model2.getAllFacets();
            Intrinsics.checkNotNullExpressionValue((Object)facetArray, (String)"model.allFacets");
            Object[] $this$groupBy$iv = facetArray;
            boolean $i$f$groupBy = false;
            Object[] bl = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object[] element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                Facet it = (Facet)element$iv$iv;
                boolean bl2 = false;
                Facet key$iv$iv = it.getUnderlyingFacet();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map subFacets = destination$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)model2.getFacetsByType(facetType.getId()), (String)"model.getFacetsByType(facetType.id)");
            for (Facet facet : facets) {
                InvalidFacet invalidFacet;
                String errorMessage;
                FacetState facetState;
                Object object;
                Object[] element$iv$iv;
                block11: {
                    block10: {
                        Intrinsics.checkNotNullExpressionValue((Object)facet, (String)"facet");
                        if (this.saveFacetWithSubFacets(facet, subFacets) == null) continue;
                        object = facetType.getPluginDescriptor();
                        if (object == null || (object = object.getName()) == null) break block10;
                        Object it = object;
                        boolean bl4 = false;
                        String string2 = " '" + (String)it + "'";
                        object = string2;
                        if (string2 != null) break block11;
                    }
                    object = "";
                }
                Object pluginName = object;
                element$iv$iv = new Object[]{pluginName, facetType.getPresentableName()};
                Intrinsics.checkNotNullExpressionValue((Object)ProjectBundle.message((String)"error.message.plugin.for.facets.unloaded", (Object[])element$iv$iv), (String)"message(\"error.message.p\u2026acetType.presentableName)");
                boolean reportError = !ApplicationManager.getApplication().isUnitTestMode();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)FacetManagerBase.createInvalidFacet(module2, facetState, facet.getUnderlyingFacet(), errorMessage, true, reportError)), (String)"createInvalidFacet(modul\u2026ssage, true, reportError)");
                this.removeAllSubFacets(model2, facet, subFacets);
                model2.replaceFacet(facet, (Facet)invalidFacet);
            }
            model2.commit();
        }
        if (!((Collection)modulesWithFacets).isEmpty()) {
            ProjectRootManagerEx.getInstanceEx(project2).makeRootsChange(FacetTypeRegistryImpl::convertFacetsToInvalid$lambda$7, RootsChangeRescanningInfo.NO_RESCAN_NEEDED);
        }
    }

    private final void removeAllSubFacets(ModifiableFacetModel model2, Facet<?> facet, Map<Facet<?>, ? extends List<? extends Facet<?>>> subFacets) {
        List<Facet<?>> list2 = subFacets.get(facet);
        if (list2 == null) {
            return;
        }
        List<Facet<?>> toRemove2 = list2;
        for (Facet<?> subFacet : toRemove2) {
            this.removeAllSubFacets(model2, subFacet, subFacets);
            model2.removeFacet(subFacet);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FacetState saveFacetWithSubFacets(Facet<?> facet, Map<Facet<FacetConfiguration>, ? extends List<? extends Facet<?>>> subFacets) {
        void $this$mapNotNullTo$iv;
        FacetState facetState = FacetManagerBridge.Companion.saveFacetConfiguration$intellij_platform_lang_impl(facet);
        if (facetState == null) {
            return null;
        }
        FacetState state = facetState;
        List list2 = subFacets.get(facet);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable iterable = list2;
        Collection destination$iv = state.subFacets;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FacetState it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Facet it = (Facet)element$iv;
            boolean bl2 = false;
            if (this.saveFacetWithSubFacets(it, subFacets) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return state;
    }

    @Override
    @NotNull
    public synchronized FacetTypeId<?>[] getFacetTypeIds() {
        this.loadExtensions();
        Collection $this$toTypedArray$iv = this.myFacetTypes.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FacetTypeId[0]);
    }

    @Override
    @NotNull
    public synchronized FacetType<?, ?>[] getFacetTypes() {
        this.loadExtensions();
        Collection<FacetType<?, ?>> $this$toTypedArray$iv = this.myFacetTypes.values();
        boolean $i$f$toTypedArray = false;
        Collection<FacetType<?, ?>> thisCollection$iv = $this$toTypedArray$iv;
        FacetType[] facetTypes = thisCollection$iv.toArray(new FacetType[0]);
        Arrays.sort(facetTypes, FACET_TYPE_COMPARATOR);
        return facetTypes;
    }

    @Override
    @NotNull
    public FacetType<?, ?>[] getSortedFacetTypes() {
        FacetType<?, ?>[] types = this.getFacetTypes();
        Arrays.sort(types, FACET_TYPE_COMPARATOR);
        return types;
    }

    @Nullable
    public synchronized FacetType<?, ?> findFacetType(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.loadExtensions();
        FacetTypeId<?> facetTypeId = this.myTypeIds.get(id);
        if (facetTypeId == null) {
            return null;
        }
        FacetTypeId<?> typeId = facetTypeId;
        return this.myFacetTypes.get(typeId);
    }

    @Override
    @NotNull
    public synchronized <F extends Facet<C>, C extends FacetConfiguration> FacetType<F, C> findFacetType(@NotNull FacetTypeId<F> typeId) {
        Intrinsics.checkNotNullParameter(typeId, (String)"typeId");
        this.loadExtensions();
        FacetType<?, ?> type = this.myFacetTypes.get(typeId);
        LOG.assertTrue(type != null, "Cannot find facet by id '" + typeId + "'");
        FacetType<?, ?> facetType = type;
        Intrinsics.checkNotNull(facetType);
        return facetType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadExtensions() {
        if (this.myExtensionsLoaded) {
            return;
        }
        Object object = this.myTypeRegistrationLock;
        synchronized (object) {
            boolean bl = false;
            if (this.myExtensionsLoaded) {
                return;
            }
            for (FacetType type : (FacetType[])FacetType.EP_NAME.getExtensions()) {
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
                this.registerFacetType(type);
            }
            FacetType.EP_NAME.addExtensionPointListener(new ExtensionPointListener<FacetType<?, ?>>(this){
                final /* synthetic */ FacetTypeRegistryImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public void extensionAdded(@NotNull FacetType<?, ?> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter(extension2, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    FacetTypeRegistryImpl.access$registerFacetType(this.this$0, extension2);
                    ActionsKt.runWriteAction((Function0)new Function0<Unit>(this.this$0, extension2){
                        final /* synthetic */ FacetTypeRegistryImpl this$0;
                        final /* synthetic */ FacetType<?, ?> $extension;
                        {
                            this.this$0 = $receiver;
                            this.$extension = $extension;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            void $this$forEach$iv;
                            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getInstance().openProjects");
                            Object[] objectArray = projectArray;
                            FacetTypeRegistryImpl facetTypeRegistryImpl = this.this$0;
                            FacetType<?, ?> facetType = this.$extension;
                            boolean $i$f$forEach = false;
                            for (void element$iv : $this$forEach$iv) {
                                Project it = (Project)element$iv;
                                boolean bl = false;
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                FacetTypeRegistryImpl.access$loadInvalidFacetsOfType(facetTypeRegistryImpl, it, facetType);
                            }
                        }
                    });
                }

                public void extensionRemoved(@NotNull FacetType<?, ?> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter(extension2, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    FacetTypeRegistryImpl.access$unregisterFacetType(this.this$0, extension2);
                }
            }, null);
            this.myExtensionsLoaded = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void convertFacetsToInvalid$lambda$7() {
    }

    private static final int FACET_TYPE_COMPARATOR$lambda$10(FacetType o1, FacetType o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        String string2 = o1.getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"o1.presentableName");
        String string3 = o2.getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"o2.presentableName");
        return StringsKt.compareTo((String)string2, (String)string3, (boolean)true);
    }

    public static final /* synthetic */ void access$registerFacetType(FacetTypeRegistryImpl $this, FacetType facetType) {
        $this.registerFacetType(facetType);
    }

    public static final /* synthetic */ void access$loadInvalidFacetsOfType(FacetTypeRegistryImpl $this, Project project2, FacetType facetType) {
        $this.loadInvalidFacetsOfType(project2, facetType);
    }

    public static final /* synthetic */ void access$unregisterFacetType(FacetTypeRegistryImpl $this, FacetType facetType) {
        $this.unregisterFacetType(facetType);
    }

    static {
        Logger logger = Logger.getInstance(FacetTypeRegistryImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(FacetTypeRegistryImpl::class.java)");
        LOG = logger;
        FACET_TYPE_COMPARATOR = FacetTypeRegistryImpl::FACET_TYPE_COMPARATOR$lambda$10;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R,\u0010\u0003\u001a \u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u0006*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/facet/impl/FacetTypeRegistryImpl$Companion;", "", "()V", "FACET_TYPE_COMPARATOR", "Ljava/util/Comparator;", "Lcom/intellij/facet/FacetType;", "kotlin.jvm.PlatformType", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

