/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.ProjectFacetManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectFacetManager")
public final class ProjectFacetManagerImpl
extends ProjectFacetManagerEx
implements PersistentStateComponent<ProjectFacetManagerState> {
    @NonNls
    public static final String COMPONENT_NAME = "ProjectFacetManager";
    private static final Logger LOG = Logger.getInstance(ProjectFacetManagerImpl.class);
    private ProjectFacetManagerState myState = new ProjectFacetManagerState();
    private final Project myProject;
    private volatile MultiMap<FacetTypeId<?>, Module> myIndex;

    public ProjectFacetManagerImpl(Project project2) {
        this.myProject = project2;
        ProjectWideFacetListenersRegistry.getInstance(project2).registerListener((ProjectWideFacetListener<Facet>)new ProjectWideFacetAdapter<Facet>(){

            @Override
            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProjectFacetManagerImpl.this.myIndex = null;
            }

            @Override
            public void facetRemoved(@NotNull Facet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(1);
                }
                ProjectFacetManagerImpl.this.myIndex = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "com/intellij/facet/impl/ProjectFacetManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, project2);
        project2.getMessageBus().connect().subscribe(ProjectTopics.MODULES, new ModuleListener(){

            @Override
            public void modulesAdded(@NotNull Project project2, @NotNull List<? extends Module> modules2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (modules2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                ProjectFacetManagerImpl.this.myIndex = null;
            }

            @Override
            public void moduleRemoved(@NotNull Project project2, @NotNull Module module2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (module2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                ProjectFacetManagerImpl.this.myIndex = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modules";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/facet/impl/ProjectFacetManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modulesAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public ProjectFacetManagerState getState() {
        return this.myState;
    }

    @Override
    public void loadState(@NotNull ProjectFacetManagerState state) {
        if (state == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    @NotNull
    private MultiMap<FacetTypeId<?>, Module> getIndex() {
        MultiMap<Object, Object> index2;
        MultiMap<Object, Object> multiMap = index2 = null == this.myIndex ? MultiMap.createLinkedSet() : this.myIndex;
        if (this.myIndex == null) {
            for (Module module2 : ModuleManager.getInstance(this.myProject).getModules()) {
                Arrays.stream(FacetManager.getInstance((Module)module2).getAllFacets()).map(facet -> facet.getTypeId()).distinct().forEach(facetTypeId -> index2.putValue(facetTypeId, module2));
            }
            this.myIndex = index2;
        }
        MultiMap<FacetTypeId<?>, Module> multiMap2 = this.myIndex;
        if (multiMap2 == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(1);
        }
        return multiMap2;
    }

    @Override
    @NotNull
    public <F extends Facet<?>> List<F> getFacets(@NotNull FacetTypeId<F> typeId) {
        if (typeId == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(2);
        }
        List list2 = ContainerUtil.concat(this.getIndex().get(typeId), module2 -> FacetManager.getInstance((Module)module2).getFacetsByType(typeId));
        if (list2 == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Module> getModulesWithFacet(@NotNull FacetTypeId<?> typeId) {
        if (typeId == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(4);
        }
        List<Module> list2 = this.getIndex().get(typeId).stream().toList();
        if (list2 == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Override
    public boolean hasFacets(@NotNull FacetTypeId<?> typeId) {
        if (typeId == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(6);
        }
        return this.getIndex().containsKey(typeId);
    }

    @Override
    public <F extends Facet<?>> List<F> getFacets(@NotNull FacetTypeId<F> typeId, Module[] modules2) {
        if (typeId == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(7);
        }
        ArrayList result2 = new ArrayList();
        for (Module module2 : modules2) {
            result2.addAll(FacetManager.getInstance((Module)module2).getFacetsByType(typeId));
        }
        return result2;
    }

    @Override
    public <C extends FacetConfiguration> C createDefaultConfiguration(@NotNull FacetType<?, C> facetType) {
        if (facetType == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(8);
        }
        FacetConfiguration configuration = facetType.createDefaultConfiguration();
        DefaultFacetConfigurationState state = this.myState.getDefaultConfigurations().get(facetType.getStringId());
        if (state != null) {
            Element defaultConfiguration = state.getDefaultConfiguration();
            try {
                FacetUtil.loadFacetConfiguration(configuration, defaultConfiguration);
            }
            catch (InvalidDataException e) {
                LOG.info(e);
            }
        }
        return (C)configuration;
    }

    @Override
    public <C extends FacetConfiguration> void setDefaultConfiguration(@NotNull FacetType<?, C> facetType, @NotNull C configuration) {
        Map<String, DefaultFacetConfigurationState> defaultConfigurations;
        DefaultFacetConfigurationState state;
        if (facetType == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(9);
        }
        if (configuration == null) {
            ProjectFacetManagerImpl.$$$reportNull$$$0(10);
        }
        if ((state = (defaultConfigurations = this.myState.getDefaultConfigurations()).get(facetType.getStringId())) == null) {
            state = new DefaultFacetConfigurationState();
            defaultConfigurations.put(facetType.getStringId(), state);
        }
        try {
            Element element = FacetUtil.saveFacetConfiguration(configuration);
            state.setDefaultConfiguration(element);
        }
        catch (WriteExternalException e) {
            LOG.info(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/ProjectFacetManagerImpl";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/ProjectFacetManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacets";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesWithFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFacets";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModulesWithFacet";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasFacets";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultConfiguration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultConfiguration";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3, 5 -> new IllegalStateException(string2);
        };
    }

    public static class ProjectFacetManagerState {
        private Map<String, DefaultFacetConfigurationState> myDefaultConfigurations = new HashMap<String, DefaultFacetConfigurationState>();

        @Tag(value="default-configurations")
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, keyAttributeName="facet-type")
        public Map<String, DefaultFacetConfigurationState> getDefaultConfigurations() {
            return this.myDefaultConfigurations;
        }

        public void setDefaultConfigurations(Map<String, DefaultFacetConfigurationState> defaultConfigurations) {
            this.myDefaultConfigurations = defaultConfigurations;
        }
    }

    @Tag(value="default-facet-configuration")
    public static class DefaultFacetConfigurationState {
        private Element myDefaultConfiguration;

        @Tag(value="configuration")
        public Element getDefaultConfiguration() {
            return this.myDefaultConfiguration;
        }

        public void setDefaultConfiguration(Element defaultConfiguration) {
            this.myDefaultConfiguration = defaultConfiguration;
        }
    }
}

